/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankTransUpBillCollection;
import com.kingdee.eas.fm.be.BankTransUpBillEntryCollection;
import com.kingdee.eas.fm.be.BankTransUpBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransUpBillFactory;
import com.kingdee.eas.fm.be.BankTransUpBillInfo;
import com.kingdee.eas.fm.be.app.AbstractBankTransUpBillEntryControllerBean;
import com.kingdee.eas.fm.be.app.service.BusinessTollUtil;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.TransUpBillEntryCollection;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankTransUpBillEntryControllerBean
extends AbstractBankTransUpBillEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankTransUpBillEntryControllerBean");

    @Override
    protected Map _updateState(Context ctx, Set idSet, BankPayingBillStateEnum state) throws BOSException, EASBizException {
        Map resultMap = ConvertUtils.JSMAP((Object[])new Object[0]);
        if (idSet == null || idSet.isEmpty()) {
            return resultMap;
        }
        if (state.getValue() != 6 && state.getValue() != 5) {
            throw new BEException(BEException.UPDATESTATEERROR2);
        }
        HashSet<String> bankTransUpBillIds = new HashSet<String>();
        FilterInfo entryFilter = new FilterInfo();
        entryFilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo entryView = new EntityViewInfo();
        entryView.setFilter(entryFilter);
        entryView.getSelector().add("*");
        entryView.getSelector().add("unitAcctBank.bankAccountNumber");
        entryView.getSelector().add("parent.id");
        entryView.getSelector().add("parent.sourcebillid");
        BankTransUpBillEntryCollection coll = this.getBankTransUpBillEntryCollection(ctx, entryView);
        HashMap<String, BankTransUpBillEntryCollection> updateMap = new HashMap<String, BankTransUpBillEntryCollection>();
        for (int i = 0; i < coll.size(); ++i) {
            BankPayResult result = new BankPayResult();
            BankTransUpBillEntryInfo entryInfo = coll.get(i);
            if (!entryInfo.getState().equals((Object)BankPayingBillStateEnum.NC)) {
                result.setErrorDetail("\u72b6\u6001\u4e0d\u4e3a\u3010\u4ea4\u6613\u672a\u786e\u8ba4\u3011");
            } else {
                BankTransUpBillEntryCollection needUpdate2EBGCol;
                String bankTransUpBillId = entryInfo.getParent().getId().toString();
                bankTransUpBillIds.add(bankTransUpBillId);
                if (updateMap.containsKey(bankTransUpBillId)) {
                    needUpdate2EBGCol = (BankTransUpBillEntryCollection)((Object)updateMap.get(bankTransUpBillId));
                    needUpdate2EBGCol.add(entryInfo);
                } else {
                    needUpdate2EBGCol = new BankTransUpBillEntryCollection();
                    needUpdate2EBGCol.add(entryInfo);
                    updateMap.put(bankTransUpBillId, needUpdate2EBGCol);
                }
            }
            result.setId(entryInfo.getId().toString());
            result.setState(entryInfo.getState());
            result.setSubmitToBe(false);
            resultMap.put(entryInfo.getId().toString(), result);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bankTransUpBillIds, CompareType.INCLUDE));
        evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("entrys.*");
        evi.getSelector().add("company.name");
        evi.getSelector().add("motherAcctBank.bankAccountNumber");
        evi.getSelector().add("*");
        BankTransUpBillCollection billColl = BankTransUpBillFactory.getLocalInstance(ctx).getBankTransUpBillCollection(evi);
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean isNeedConfirm = false;
        HashMap<BOSUuid, Boolean> paramMap = new HashMap<BOSUuid, Boolean>();
        BusinessTollUtil util = new BusinessTollUtil();
        for (int i = 0; i < billColl.size(); ++i) {
            HashSet<String> bankTransUpEntryIds = new HashSet<String>();
            HashSet<String> transUpBillEntryIds = new HashSet<String>();
            BankTransUpBillInfo info = billColl.get(i);
            if (paramMap.containsKey(info.getCompany().getId())) {
                isNeedConfirm = (Boolean)paramMap.get(info.getCompany().getId());
            } else {
                isNeedConfirm = localInstance.getBooleanParam("TM019", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
                paramMap.put(info.getCompany().getId(), isNeedConfirm);
            }
            BankTransUpBillEntryCollection updateEntry = (BankTransUpBillEntryCollection)((Object)updateMap.get(info.getId().toString()));
            Map ret = util.updateTransUpState2EBS(ctx, info, updateEntry, state);
            for (int t = 0; t < updateEntry.size(); ++t) {
                BankTransUpBillEntryInfo entryInfo = updateEntry.get(t);
                Map entry = (Map)ret.get(ConvertUtils.IDSTR((Object)entryInfo));
                BankPayResult result = (BankPayResult)resultMap.get(ConvertUtils.IDSTR((Object)entryInfo));
                result.setSubmitToBe(ConvertUtils.BOOL(entry.get("submit2EBS")));
                result.setErrorDetail(ConvertUtils.STR(entry.get("errorMsg")));
                result.setNumber(info.getNumber());
                if (!CheckUtils.same((Object)"SUCCESS", entry.get("result"))) continue;
                bankTransUpEntryIds.add(entryInfo.getId().toString());
                transUpBillEntryIds.add(entryInfo.getSrcBillNumber());
            }
            String sql = "Update T_BE_BankTransUpBillEntry set FState = ? where FId in " + FMHelper.setTran2String(bankTransUpEntryIds);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{state.getValue()});
            String srcSql = "UPDATE T_FS_TransUpBillEntry Set FBankState=?, FIsSuccessed = ? WHERE FID in " + FMHelper.setTran2String(transUpBillEntryIds);
            String upState = state.getValue() == 6 ? "1" : "0";
            DbUtil.execute((Context)ctx, (String)srcSql, (Object[])new Object[]{state.getValue(), upState});
            Iterator iter = bankTransUpEntryIds.iterator();
            while (iter.hasNext()) {
                String number = info.getNumber() + "_" + (String)iter.next();
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)number, (String)"fs_bankTransupbill_UpdateState");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
            if (!isNeedConfirm) continue;
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                selector.add("entrys.*");
                TransUpBillInfo tranUpBillInfo = TransUpBillFactory.getLocalInstance((Context)ctx).getTransUpBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()), selector);
                if (tranUpBillInfo.getState() == TransUpBillStateEnum.CONFIRMED) continue;
                int successCount = 0;
                int failCount = 0;
                BigDecimal amt = BigDecimal.ZERO;
                BigDecimal localAmt = BigDecimal.ZERO;
                TransUpBillEntryCollection entrys = tranUpBillInfo.getEntrys();
                for (int j = 0; j < entrys.size(); ++j) {
                    TransUpBillEntryInfo entry = entrys.get(j);
                    if (entry.getBankState() == BankPayingBillStateEnum.TS) {
                        ++successCount;
                        amt = amt.add(entry.getAmount());
                        localAmt = localAmt.add(entry.getLocalAmt());
                        continue;
                    }
                    if (entry.getBankState() != BankPayingBillStateEnum.TF) continue;
                    ++failCount;
                }
                if (successCount <= 0 || successCount + failCount != entrys.size()) continue;
                tranUpBillInfo.setConfirmedAmt(amt);
                tranUpBillInfo.setConfirmedCounts(successCount);
                tranUpBillInfo.setConfirmedLocalAmt(localAmt);
                TransUpBillFacadeFactory.getLocalInstance((Context)ctx).confirm(tranUpBillInfo);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("confirm failed\uff01" + e));
            }
        }
        return ConvertUtils.JSMAP((Object[])new Object[]{"resultList", ConvertUtils.LIST((Object)resultMap)});
    }
}

