/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.IBEBank;
import com.kingdee.eas.fm.be.app.AbstractBeBankWebFacadeControllerBean;
import com.kingdee.eas.fm.be.vo.BeBankVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BeBankWebFacadeControllerBean
extends AbstractBeBankWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BeBankWebFacadeControllerBean");
    private static String PERMITEM_BEBANK_DELETE = "beBank_delete";
    private static String PERMITEM_BEBANK_EDIT = "beBank_edit";
    private static String PERMITEM_BEBANK_VIEW = "beBank_view";
    public static final String strResource = "com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteFail_ByNumber";
    public static final String commonResource = "com.kingdee.eas.common.CommonResource";

    @Override
    protected Map _saveBeBank(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        BeBankVO dateVO = (BeBankVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BeBankVO.class);
        if (dateVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputDataExption"));
        }
        BEBankInfo beBankInfo = this.VOToInfo(ctx, dateVO);
        IBEBank iBeBank = BEBankFactory.getLocalInstance((Context)ctx);
        IObjectPK rstID = null;
        try {
            boolean isPermission;
            boolean bl = isPermission = CASWebHelper.getAuthorizedOrg((Context)ctx, (String)PERMITEM_BEBANK_EDIT, (boolean)false).size() > 0;
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
            }
            IObjectPK[] objectPkList = iBeBank.getPKList();
            IObjectPK reduplicatedIObjectPK = null;
            String id = dateVO.getId();
            if (objectPkList != null && id != null) {
                reduplicatedIObjectPK = BeBankWebFacadeControllerBean.checkIObjectPKDup(dateVO.getId(), objectPkList);
            }
            if (reduplicatedIObjectPK == null) {
                rstID = iBeBank.save((CoreBaseInfo)beBankInfo);
            } else {
                iBeBank.update(reduplicatedIObjectPK, (CoreBaseInfo)beBankInfo);
                rstID = reduplicatedIObjectPK;
            }
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
        if (rstID != null) {
            rstData.put("MsgStr", CASWebHelper.getCASMsg((Context)ctx, (String)"SAVE_Successfully"));
            rstData.put("OPStatus", "success");
            rstData.put("IdAfterSave", (String)rstID);
        }
        return rstData;
    }

    @Override
    protected Map _deleteBeBank(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, Object> rstData = new HashMap<String, Object>();
        BeBankVO dataVO = (BeBankVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BeBankVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputDataExption"));
            return rstData;
        }
        if (dataVO.getDeleteIDs() == null || dataVO.getDeleteIDs().length <= 0) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"PleSelectedDeleteRow"));
            return rstData;
        }
        IBEBank iBeBank = BEBankFactory.getLocalInstance((Context)ctx);
        try {
            boolean isPermission;
            boolean bl = isPermission = CASWebHelper.getAuthorizedOrg((Context)ctx, (String)PERMITEM_BEBANK_DELETE, (boolean)false).size() > 0;
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
            }
            int lens = dataVO.getDeleteIDs().length;
            ArrayList<ObjectUuidPK> sucPKList = new ArrayList<ObjectUuidPK>();
            StringBuffer errorMsg = new StringBuffer();
            ArrayList<String> errorMsgList = new ArrayList<String>();
            ObjectUuidPK delPK = null;
            for (int idx = 0; idx < lens; ++idx) {
                delPK = new ObjectUuidPK(dataVO.getDeleteIDs()[idx]);
                IObjectPK[] pkArray = new IObjectPK[]{delPK};
                try {
                    this.isReferenced((IDataBase)iBeBank, pkArray, ctx);
                    sucPKList.add(delPK);
                    continue;
                }
                catch (EASBizException ee) {
                    errorMsg.append(ee.getMessage(ctx.getLocale()));
                    errorMsgList.add(ee.getMessage(ctx.getLocale()));
                }
            }
            int sucDelCount = sucPKList.size();
            if (sucDelCount > 0) {
                ObjectUuidPK[] sucDelPKArray = new ObjectUuidPK[sucDelCount];
                for (int idx = 0; idx < sucDelCount; ++idx) {
                    sucDelPKArray[idx] = (IObjectPK)sucPKList.get(idx);
                }
                iBeBank.deleteBatchData((IObjectPK[])sucDelPKArray);
            }
            if (errorMsg.length() > 0) {
                String[] args = new String[]{String.valueOf(sucDelCount), String.valueOf(lens - sucDelCount)};
                String opHeadMsg = CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])args);
                rstData.put("MsgStr", opHeadMsg);
                rstData.put("MsgDetail", errorMsg.toString());
                rstData.put("OPStatus", "success");
                rstData.put("DeleteSuccessCount", sucDelCount);
                rstData.put("errorMsgList", errorMsgList);
                return rstData;
            }
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
        rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"DeletedOK"));
        rstData.put("OPStatus", "success");
        return rstData;
    }

    public BEBankInfo VOToInfo(Context ctx, BeBankVO vo) {
        BEBankInfo info = new BEBankInfo();
        if (vo == null) {
            return info;
        }
        if (vo.getId() != null) {
            try {
                info = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectUuidPK(vo.getId()));
                if (info == null) {
                    info = new BEBankInfo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (vo.getNumber() != null) {
            info.setNumber(vo.getNumber());
        }
        if (vo.getName_l1() != null) {
            info.setName(vo.getName_l1(), LocaleUtils.getLocale((String)"l1"));
        }
        if (vo.getName_l2() != null) {
            info.setName(vo.getName_l2(), LocaleUtils.getLocale((String)"l2"));
        }
        if (vo.getName_l3() != null) {
            info.setName(vo.getName_l3(), LocaleUtils.getLocale((String)"l3"));
        }
        info.setBeProvince(vo.getBeProvince());
        info.setBeCity(vo.getBeCity());
        info.setAdress(vo.getAdress());
        info.setDescription(vo.getDescription_l1(), LocaleUtils.getLocale((String)"l1"));
        info.setDescription(vo.getDescription_l2(), LocaleUtils.getLocale((String)"l2"));
        info.setDescription(vo.getDescription_l3(), LocaleUtils.getLocale((String)"l3"));
        return info;
    }

    public void isReferenced(IDataBase idataBase, IObjectPK[] pkArray, Context ctx) throws EASBizException {
        HashMap<IObjectPK, Exception> exceptionMap = new HashMap<IObjectPK, Exception>();
        HashMap<IObjectPK, String> numberMap = new HashMap<IObjectPK, String>();
        for (int idx = 0; idx < pkArray.length; ++idx) {
            IObjectPK curPKID = pkArray[idx];
            try {
                if (!idataBase.exists(curPKID)) continue;
                DataBaseInfo baseInfo = idataBase.getDataBaseInfo(curPKID);
                numberMap.put(curPKID, baseInfo.getNumber());
                idataBase.isReferenced(curPKID);
                continue;
            }
            catch (Exception ex) {
                exceptionMap.put(curPKID, ex);
            }
        }
        String numbetMsg = EASCommonResource.getString((String)strResource, (Locale)ctx.getLocale());
        StringBuffer errorMsg = new StringBuffer();
        Set key = exceptionMap.keySet();
        for (IObjectPK idPK : key) {
            Exception exception = (Exception)exceptionMap.get(idPK);
            errorMsg.append(MessageFormat.format(numbetMsg, numberMap.get(idPK)));
            errorMsg.append(",").append(BeBankWebFacadeControllerBean.getMessage(exception, ctx)).append("\n");
        }
        if (errorMsg.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("cas100", errorMsg.toString()));
        }
    }

    public static String getMessage(Throwable exc, Context ctx) {
        if (exc instanceof ObjectReferedException) {
            StringBuffer msg = new StringBuffer();
            BizReference ref = (BizReference)((ObjectReferedException)exc).getReferingObject();
            if (ref != null) {
                Object[] objects = new Object[1];
                String locale = ctx.getLocale().toString();
                objects[0] = ref.getRefEntityAlias(new Locale(locale));
                String template = CASWebUtil.getResource((Context)ctx, (String)commonResource, (String)"isReferedError");
                msg.append(MessageFormat.format(template, objects));
            } else {
                msg.append(exc.getMessage());
            }
            return msg.toString();
        }
        if (exc instanceof MissMatchParticipantException) {
            return CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MissMatchParticipant");
        }
        if (exc instanceof AlreadyInProcessQueueException) {
            return CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AlreadyInProcessQueue");
        }
        if (exc instanceof MatchAssignmentException) {
            return CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFMatch");
        }
        return exc.getMessage();
    }

    public static IObjectPK checkIObjectPKDup(String id, IObjectPK[] iObjectPkList) {
        for (IObjectPK iObjectPk : iObjectPkList) {
            if (!iObjectPk.toString().equals(id)) continue;
            return iObjectPk;
        }
        return null;
    }
}

