/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.ErrCodeHelper;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.IBankPayingBill;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class CommitToBeService {
    private static Logger logger = Logger.getLogger((String)CommitToBeService.class.getName());
    protected final Map<String, BankPayResult> bankPayResultMap = new HashMap<String, BankPayResult>();
    protected boolean isFromWF = false;

    public void setFromWF(boolean isFromWF) {
        this.isFromWF = isFromWF;
    }

    protected final String getBEResource(String resName) {
        return EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)resName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<BankPayResult> payToBEBatch(Context ctx, Set<String> bizBillIdSet) throws BOSException, EASBizException {
        logger.info((Object)"********commitToBeNewBatch begin********");
        logger.info((Object)("\u63d0\u4ea4\u5230\u540e\u53f0\u7684\u4e1a\u52a1\u5355\u636e\u4e2a\u6570\u4e3a\uff1a " + bizBillIdSet.size() + " ; id\u5206\u522b\u4e3a\uff1a" + bizBillIdSet.toString()));
        bizBillIdSet = FmBeHelper.getPing(ctx, bizBillIdSet, this.bankPayResultMap);
        if (bizBillIdSet.size() != 0 && bizBillIdSet != null) {
            logger.info((Object)("\u771f\u6b63\u63d0\u4ea4\u5230\u540e\u53f0\u7684\u4e1a\u52a1\u5355\u636e\u4e2a\u6570\u4e3a\uff1a " + bizBillIdSet.size() + " ; id\u5206\u522b\u4e3a\uff1a" + bizBillIdSet.toString()));
            IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            ArrayList<String> appliedList = new ArrayList<String>();
            try {
                IObjectCollection bizBillColls = this.checkMutex(ctx, bizBillIdSet, iMutexServiceControl, appliedList);
                Set<String> bankPayBillIdSet = new LinkedHashSet<String>();
                bankPayBillIdSet = this.createNeedToBeBankPayingBillIdSet(ctx, bizBillColls, bankPayBillIdSet);
                this.bankPayingbillToBank(ctx, bankPayBillIdSet);
            }
            finally {
                if (appliedList.size() > 0) {
                    iMutexServiceControl.batchReleaseObjIDForUpdate(appliedList);
                }
            }
            logger.info((Object)"********commitToBeNewBatch end********");
        }
        return new ArrayList<BankPayResult>(this.bankPayResultMap.values());
    }

    private IObjectCollection checkMutex(Context ctx, Set<String> bizBillIdSet, IMutexServiceControl iMutexServiceControl, List<String> appliedList) throws BOSException, EASBizException {
        IObjectCollection bizBillColls = this.getBizBillCollection(ctx, bizBillIdSet);
        List bizBillIdList = FMHelper.set2List(bizBillIdSet);
        Map requestResult = iMutexServiceControl.batchRequestObjIDForUpdate(bizBillIdList);
        for (int index = bizBillColls.size() - 1; index >= 0; --index) {
            IObjectValue bizBillInfo = bizBillColls.getObject(index);
            String id = bizBillInfo.getString("id");
            Boolean boolDetail = (Boolean)requestResult.get(id);
            if (boolDetail.booleanValue()) {
                appliedList.add(id);
                continue;
            }
            BankPayResult resultInfo = new BankPayResult(id, bizBillInfo.getString("number"), null, null);
            this.updateBankPayResult(resultInfo, BankPayingBillStateEnum.OF, "\u5355\u636e\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u94f6\u4f01\u3002", null, "\u5355\u636e\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u94f6\u4f01\u3002");
            this.bankPayResultMap.put(id, resultInfo);
            bizBillColls.removeObject(bizBillInfo);
            if (!this.isFromWF) continue;
            String lockMsg = "";
            try {
                ObjectUpdateLock objectUpdateLock = iMutexServiceControl.getObjectUpdateLock(id);
                if (objectUpdateLock != null) {
                    String userName = objectUpdateLock.getUserName();
                    String createdTime = objectUpdateLock.getCreatedTime() != null ? objectUpdateLock.getCreatedTime().toString() : "";
                    lockMsg = "\u5f53\u524d\u5355\u636e\u9501\u5b9a\u4eba\uff1a" + userName + ",\u5f00\u59cb\u9501\u5b9a\u65f6\u95f4\uff1a" + createdTime;
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u83b7\u53d6\u5f53\u524d\u9501\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            }
            throw new BOSException("\u5355\u636e[" + bizBillInfo.getString("number") + "]\u5df2\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u94f6\u4f01\u3002" + lockMsg);
        }
        return bizBillColls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<BankPayResult> bankToBEBatch(Context ctx, Set<String> bankPayBillIdSet) throws BOSException, EASBizException {
        logger.info((Object)"********bankToBeBatch begin********");
        logger.info((Object)("\u63d0\u4ea4\u5230\u540e\u53f0\u7684\u94f6\u884c\u4ed8\u6b3e\u5355\u4e2a\u6570\u4e3a\uff1a " + bankPayBillIdSet.size() + " ; id\u5206\u522b\u4e3a\uff1a" + bankPayBillIdSet.toString()));
        bankPayBillIdSet = FmBeHelper.getPing(ctx, bankPayBillIdSet, this.bankPayResultMap);
        if (bankPayBillIdSet.size() != 0 && bankPayBillIdSet != null) {
            ArrayList<String> appliedList = new ArrayList<String>();
            IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            try {
                IObjectCollection bizBillColls = this.checkMutex(ctx, bankPayBillIdSet, iMutexServiceControl, appliedList);
                Set<String> bankToBeIdSet = new LinkedHashSet<String>();
                bankToBeIdSet = this.checkBankPayingBill(ctx, bizBillColls, bankToBeIdSet);
                this.bankPayingbillToBank(ctx, bankToBeIdSet);
            }
            finally {
                if (appliedList.size() > 0) {
                    Iterator iterator = appliedList.iterator();
                    while (iterator.hasNext()) {
                        ctx.remove((Object)((String)iterator.next() + "submitbe"));
                    }
                    iMutexServiceControl.batchReleaseObjIDForUpdate(appliedList);
                }
            }
        }
        logger.info((Object)"********bankToBeBatch end********");
        return new ArrayList<BankPayResult>(this.bankPayResultMap.values());
    }

    private Set<String> checkBankPayingBill(Context ctx, IObjectCollection bizBillColls, Set<String> bankToBeIdSet) throws EASBizException, BOSException {
        logger.info((Object)"********checkBankPayingBill begin********");
        String hintTitle = this.getBEResource("submit") + this.getBEResource("bankPayBill");
        int size = bizBillColls.size();
        for (int i = 0; i < size; ++i) {
            BillBaseInfo bizBillInfo = (BillBaseInfo)bizBillColls.getObject(i);
            String id = bizBillInfo.getId().toString();
            String key = id + "submitbe";
            BankPayResult resultInfo = new BankPayResult(bizBillInfo.getId().toString(), bizBillInfo.getNumber(), null, null);
            try {
                if (ctx.get((Object)key) != null) {
                    throw new EASBizException(new NumericExceptionSubItem("", "\u63d0\u4ea4\u94f6\u4f01\u5e73\u53f0\u524d\uff0c\u94f6\u884c\u4ed8\u6b3e\u5355: " + bizBillInfo.getNumber() + " \u6821\u9a8c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5df2\u7ecf\u88ab\u5176\u4ed6\u7ebf\u7a0b\u63d0\u4ea4\u8fc7\uff0c\u4e0d\u80fd\u518d\u63d0\u4ea4\uff01"));
                }
                ctx.put((Object)key, (Object)id);
                this.executeBankPayingBill(ctx, bizBillInfo, true);
                this.updateBankPayResult(resultInfo, BankPayingBillStateEnum.OP, hintTitle + this.getBEResource("success"), null, null);
                bankToBeIdSet.add(id);
                this.bankPayResultMap.put(id, resultInfo);
                logger.info((Object)("\u7b2c" + i + 1 + "\u4e2a\u94f6\u884c\u4ed8\u6b3e\u5355 : " + bizBillInfo.getNumber() + " \u63d0\u4ea4\u94f6\u4f01\u524d\u6821\u9a8c\u6210\u529f\u3002"));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("\u7b2c" + i + 1 + "\u4e2a\u94f6\u884c\u4ed8\u6b3e\u5355 : " + bizBillInfo.getNumber() + " \u63d0\u4ea4\u94f6\u4f01\u524d\u6821\u9a8c\u5931\u8d25\u3002"), (Throwable)e);
                this.updateBankPayResult(resultInfo, BankPayingBillStateEnum.OF, hintTitle + this.getBEResource("failure"), null, ErrCodeHelper.getResourceByErrCode("BE3001", e.getMessage()));
                this.bankPayResultMap.put(bizBillInfo.getId().toString(), resultInfo);
                if (!this.isFromWF) continue;
                throw new BOSException((Throwable)e);
            }
        }
        logger.info((Object)"********checkBankPayingBill end********");
        return bankToBeIdSet;
    }

    protected boolean isNeedCommitToBank(Context ctx, BillBaseInfo info) throws BOSException, EASBizException {
        String strValue = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("TM018", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        return strValue == null || "0".equals(strValue);
    }

    protected final BankPayingBillCollection getBankPayingBillCollection(Context ctx, Set<String> bankPayingBillIdSet, SelectorItemCollection selector) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bankPayingBillIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        if (selector != null) {
            view.setSelector(selector);
        }
        return BankPayingBillFactory.getLocalInstance(ctx).getBankPayingBillCollection(view);
    }

    protected void updateBankPayResult(BankPayResult bankPayResult, BankPayingBillStateEnum state, String bankResult, String returnMsg, String bankDetail) {
        if (bankPayResult == null) {
            return;
        }
        bankPayResult.setBankResult(bankResult);
        bankPayResult.setErrorDetail(bankDetail);
        bankPayResult.setReturnMsg(returnMsg);
        bankPayResult.setState(state);
    }

    protected Set<String> createNeedToBeBankPayingBillIdSet(Context ctx, IObjectCollection bizBillColls, Set<String> bankPayBillIdSet) throws BOSException, EASBizException {
        logger.info((Object)"********CreateBankPayingBill begin********");
        String hintTitle = this.getBEResource("submit") + this.getBEResource("bankPayBill");
        int size = bizBillColls.size();
        for (int i = 0; i < size; ++i) {
            BillBaseInfo bizBillInfo = (BillBaseInfo)bizBillColls.getObject(i);
            BankPayResult resultInfo = new BankPayResult(bizBillInfo.getId().toString(), bizBillInfo.getNumber(), null, null);
            resultInfo.setSrcId(bizBillInfo.getId().toString());
            try {
                boolean isNeedCommitToBank = this.isNeedCommitToBank(ctx, bizBillInfo);
                String bankPayingbillId = this.executeBankPayingBill(ctx, bizBillInfo, isNeedCommitToBank).toString();
                if (isNeedCommitToBank) {
                    this.updateBankPayResult(resultInfo, BankPayingBillStateEnum.OP, hintTitle + this.getBEResource("success"), null, null);
                    bankPayBillIdSet.add(bankPayingbillId);
                } else {
                    this.updateBankPayResultNew(resultInfo, BankPayingBillStateEnum.OP, hintTitle + this.getBEResource("success"), null, null);
                }
                this.bankPayResultMap.put(bankPayingbillId, resultInfo);
                logger.info((Object)("\u7b2c " + i + 1 + "\u4e2a\u4e1a\u52a1\u5355\u636e : " + bizBillInfo.getNumber() + " \u751f\u6210\u94f6\u884c\u4ed8\u6b3e\u5355\u6210\u529f!"));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("\u7b2c" + i + 1 + "\u4e2a\u4e1a\u52a1\u5355\u636e : " + bizBillInfo.getNumber() + " \u751f\u6210\u94f6\u884c\u4ed8\u6b3e\u5355\u5931\u8d25\u3002"), (Throwable)e);
                this.updateBankPayResult(resultInfo, BankPayingBillStateEnum.OF, hintTitle + this.getBEResource("failure"), null, ErrCodeHelper.getResourceByErrCode("BE3001", e.getMessage()));
                this.bankPayResultMap.put(bizBillInfo.getId().toString(), resultInfo);
                if (!this.isFromWF) continue;
                throw new BOSException((Throwable)e);
            }
        }
        logger.info((Object)"********CreateBankPayingBill end********");
        return bankPayBillIdSet;
    }

    protected void updateBankPayResultNew(BankPayResult bankPayResult, BankPayingBillStateEnum state, String bankResult, String returnMsg, String bankDetail) {
        if (bankPayResult == null) {
            return;
        }
        bankPayResult.setBankResult(bankResult);
        bankPayResult.setErrorDetail(bankDetail);
        bankPayResult.setReturnMsg(returnMsg);
        bankPayResult.setState(state);
        bankPayResult.setSubmitToBe(true);
    }

    protected void bankPayingbillToBank(Context ctx, Set<String> bankPayBillIdSet) throws BOSException, EASBizException, BEException {
        if (EmptyUtil.isEmpty(bankPayBillIdSet)) {
            return;
        }
        logger.info((Object)"********bankPayingBillToBank begin********");
        IBankPayingBill iBankPayingBill = BankPayingBillFactory.getLocalInstance(ctx);
        List<BankPayResult> bankPayResults = this.submitToBe(ctx, bankPayBillIdSet);
        int size = bankPayResults.size();
        block7: for (int i = 0; i < size; ++i) {
            BankPayResult bankPayResult = bankPayResults.get(i);
            String bankPayBillId = bankPayResult.getId();
            BankPayResult resultInfo = this.bankPayResultMap.get(bankPayBillId);
            this.updateBankPayResult(resultInfo, bankPayResult.getState(), bankPayResult.getBankResult(), bankPayResult.getReturnMsg(), bankPayResult.getErrorDetail());
            resultInfo.setSubmitToBe(bankPayResult.isSubmitToBe());
            int state = resultInfo.getState().getValue();
            if (resultInfo.isSubmitToBe()) {
                try {
                    this.updateBillStateAndReturnMsg(ctx, bankPayBillId, state, resultInfo.getReturnMsg());
                }
                catch (Exception e) {
                    logger.error((Object)("\u94f6\u884c\u4ed8\u6b3e\u5355" + bankPayResult.getNumber() + "\u63d0\u4ea4\u94f6\u4f01\u5e73\u53f0\u6210\u529f\uff0c\u4f46\u7cfb\u7edf\u5728\u66f4\u65b0\u4e1a\u52a1\u5355\u636e\u94f6\u4f01\u72b6\u6001\u548c\u94f6\u4f01\u8fd4\u56de\u4fe1\u606f\u65f6\u5931\u8d25\u3002"), (Throwable)e);
                    String errorDetail = ErrCodeHelper.getResourceByErrCode("BE7003", e.getMessage()) + bankPayResult.getErrorDetail();
                    bankPayResult.setErrorDetail(errorDetail);
                }
            }
            switch (state) {
                case 2: 
                case 6: {
                    resultInfo.setBankResult(this.getBEResource("SummitSucess"));
                    continue block7;
                }
                case 3: {
                    this.doForBeException(ctx, this.getBankPayingBillInfo(iBankPayingBill, bankPayBillId), resultInfo);
                    if (!this.isFromWF) continue block7;
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{resultInfo.getErrorDetail()});
                }
                case 4: {
                    this.doForException(ctx, this.getBankPayingBillInfo(iBankPayingBill, bankPayBillId), resultInfo);
                    continue block7;
                }
            }
        }
        logger.info((Object)"********bankPayingBillToBank end********");
    }

    private void doForBeException(Context ctx, BankPayingBillInfo info, BankPayResult bankPayResult) {
        String billId = info.getId().toString();
        String bankResult = this.getBEResource("submit") + this.getBEResource("bankPayBill") + this.getBEResource("failure");
        this.updateBankPayResult(bankPayResult, BankPayingBillStateEnum.OF, bankResult, bankPayResult.getReturnMsg(), bankPayResult.getErrorDetail());
        try {
            this.reserveForBeException(ctx, billId, bankPayResult.getNumber());
        }
        catch (Exception e1) {
            logger.error((Object)("\u94f6\u884c\u4ed8\u6b3e\u5355\uff1a" + info.getNumber() + "\u63d0\u4ea4\u94f6\u4f01\u5e73\u53f0\u5931\u8d25\uff0c\u7cfb\u7edf\u5728\u5bf9\u4e1a\u52a1\u5355\u636e\u56de\u9000\u5904\u7406\u65f6\u5931\u8d25\u3002"), (Throwable)e1);
            bankPayResult.setBankResult(this.getBEResource("submitFailForBeException"));
            String errorDetail = ErrCodeHelper.getResourceByErrCode("BE7001", e1.getMessage()) + bankPayResult.getErrorDetail();
            bankPayResult.setErrorDetail(errorDetail);
        }
    }

    private void doForException(Context ctx, BankPayingBillInfo info, BankPayResult bankPayResult) {
        String returnMsg = bankPayResult.getReturnMsg();
        this.updateBankPayResult(bankPayResult, BankPayingBillStateEnum.NC, this.getBEResource("submitUnChecked"), returnMsg, bankPayResult.getErrorDetail());
        try {
            this.reserveForOtherException(ctx, info, returnMsg);
        }
        catch (Exception ex1) {
            logger.error((Object)("\u94f6\u884c\u4ed8\u6b3e\u5355\uff1a" + info.getNumber() + "\u63d0\u4ea4\u94f6\u4f01\u5e73\u53f0\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u7cfb\u7edf\u5728\u53cd\u5199\u4e1a\u52a1\u5355\u636e\u94f6\u4f01\u72b6\u6001\u4e0e\u94f6\u4f01\u8fd4\u56de\u4fe1\u606f\u65f6\u5931\u8d25\u3002"), (Throwable)ex1);
            bankPayResult.setBankResult(this.getBEResource("submitFailForOtherException"));
            String errorDetail = ErrCodeHelper.getResourceByErrCode("BE7002", ex1.getMessage()) + bankPayResult.getErrorDetail();
            bankPayResult.setErrorDetail(errorDetail);
        }
    }

    private BankPayingBillInfo getBankPayingBillInfo(IBankPayingBill iBankPayingBill, String bankPayBillId) throws EASBizException, BOSException {
        return iBankPayingBill.getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(bankPayBillId));
    }

    protected abstract void updateBillStateAndReturnMsg(Context var1, String var2, int var3, String var4) throws EASBizException, BOSException;

    protected abstract IObjectPK executeBankPayingBill(Context var1, BillBaseInfo var2, boolean var3) throws BOSException, EASBizException;

    protected abstract IObjectCollection getBizBillCollection(Context var1, Set<String> var2) throws BOSException, EASBizException;

    protected abstract List<BankPayResult> submitToBe(Context var1, Set<String> var2) throws BOSException, EASBizException;

    protected abstract void reserveForBeException(Context var1, String var2, String var3) throws EASBizException, BOSException;

    protected abstract void reserveForOtherException(Context var1, BankPayingBillInfo var2, String var3) throws EASBizException, BOSException;
}

