/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.be.AccountBankBalanceCollection;
import com.kingdee.eas.fm.be.AccountBankBalanceFactory;
import com.kingdee.eas.fm.be.DetailIntegralityCollection;
import com.kingdee.eas.fm.be.DetailIntegralityCondition;
import com.kingdee.eas.fm.be.DetailIntegralityFactory;
import com.kingdee.eas.fm.be.DetailIntegralityInfo;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.app.AbstractDetailIntegralityControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import org.apache.log4j.Logger;

public class DetailIntegralityControllerBean
extends AbstractDetailIntegralityControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.DetailIntegralityControllerBean");

    @Override
    protected void _genDetailIntegralityResult(Context ctx, Set conditions) throws EASBizException, BOSException {
        if (conditions.size() > 0) {
            CoreBaseCollection colls = new CoreBaseCollection();
            for (DetailIntegralityCondition condition : conditions) {
                DetailIntegralityInfo info = this.genDetailIntegrality(ctx, condition);
                colls.add((CoreBaseInfo)info);
            }
            if (colls.size() > 0) {
                DetailIntegralityFactory.getLocalInstance(ctx).addnewBatchData(colls);
            }
        }
    }

    private DetailIntegralityInfo genDetailIntegrality(Context ctx, DetailIntegralityCondition condition) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)condition.getBankId()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyId()));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)condition.getBizDate()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)condition.getCompanyInfo().getId().toString()));
        DetailIntegralityCollection colls = DetailIntegralityFactory.getLocalInstance(ctx).getDetailIntegralityCollection(view);
        if (colls.size() > 0) {
            DetailIntegralityFactory.getLocalInstance(ctx).delete(filter);
        }
        DetailIntegralityInfo info = new DetailIntegralityInfo();
        info.setCompany(condition.getCompanyInfo());
        info.setBankAccount(condition.getBankAccount());
        info.setCurrency(condition.getCurrency());
        info.setBizDate(condition.getBizDate());
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("bizTime"));
        sorter.add(new SorterItemInfo("sortedID"));
        view.setSorter(sorter);
        TransDetailCollection currentBizDateDetailColl = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(view);
        BigDecimal totalPayAmt = SysConstant.BIGZERO;
        BigDecimal totalRecAmt = SysConstant.BIGZERO;
        for (int i = 0; i < currentBizDateDetailColl.size(); ++i) {
            if (currentBizDateDetailColl.get(i).getDebitAmount() != null) {
                totalPayAmt = totalPayAmt.add(currentBizDateDetailColl.get(i).getDebitAmount());
            }
            if (currentBizDateDetailColl.get(i).getCreditAmount() == null) continue;
            totalRecAmt = totalRecAmt.add(currentBizDateDetailColl.get(i).getCreditAmount());
        }
        info.setTransCount(currentBizDateDetailColl.size());
        info.setTotalPayAmount(totalPayAmt);
        info.setTotalRecAmount(totalRecAmt);
        EntityViewInfo balView = new EntityViewInfo();
        FilterInfo balFilter = new FilterInfo();
        balView.setFilter(balFilter);
        balFilter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)condition.getBankId()));
        balFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyId()));
        balFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)condition.getCompanyInfo().getId().toString()));
        balFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)condition.getBizDate(), CompareType.LESS_EQUALS));
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(condition.getBizDate());
        ((Calendar)cal).add(5, -1);
        Date beforeDate = cal.getTime();
        balFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beforeDate, CompareType.GREATER_EQUALS));
        SorterItemCollection balSorter = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("bizDate");
        sort.setSortType(SortType.DESCEND);
        balSorter.add(sort);
        balView.setSorter(balSorter);
        AccountBankBalanceCollection bankBalanceCollection = AccountBankBalanceFactory.getLocalInstance(ctx).getAccountBankBalanceCollection(balView);
        if (bankBalanceCollection.size() > 0) {
            if (bankBalanceCollection.get(0).getBizDate().compareTo(condition.getBizDate()) == 0) {
                BigDecimal lstBalance = bankBalanceCollection.get(0).getLstBalance();
                if (lstBalance != null) {
                    info.setLstBalance(lstBalance);
                    info.setLstBalLastUpdateTime(new Timestamp(bankBalanceCollection.get(0).getAccurateBizDate().getTime()));
                    info.setLstBalanceSource("\u94f6\u4f01\u8d26\u6237\u4f59\u989d");
                } else if (bankBalanceCollection.size() >= 2 && bankBalanceCollection.get(1).getBizDate().compareTo(beforeDate) == 0) {
                    BigDecimal balance = bankBalanceCollection.get(1).getBalance();
                    if (balance != null) {
                        info.setLstBalance(balance);
                        info.setLstBalanceSource("\u94f6\u4f01\u8d26\u6237\u4f59\u989d");
                        info.setLstBalLastUpdateTime(new Timestamp(bankBalanceCollection.get(1).getAccurateBizDate().getTime()));
                    } else {
                        EntityViewInfo traView = new EntityViewInfo();
                        FilterInfo traFilter = new FilterInfo();
                        traView.setFilter(traFilter);
                        traFilter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)condition.getBankId()));
                        traFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyId()));
                        traFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beforeDate));
                        traFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)condition.getCompanyInfo().getId().toString()));
                        traView.setSorter(sorter);
                        TransDetailCollection beforeDayDetailColl = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(traView);
                        if (beforeDayDetailColl.size() > 0) {
                            TransDetailInfo transDetailInfo = beforeDayDetailColl.get(beforeDayDetailColl.size() - 1);
                            info.setLstBalance(transDetailInfo.getTransBalance());
                            if (transDetailInfo.getTransBalance() != null) {
                                info.setLstBalanceSource("\u4ea4\u6613\u660e\u7ec6\u4f59\u989d");
                                info.setLstBalLastUpdateTime(transDetailInfo.getBizTime());
                            }
                        }
                    }
                } else {
                    EntityViewInfo traView = new EntityViewInfo();
                    FilterInfo traFilter = new FilterInfo();
                    traView.setFilter(traFilter);
                    traFilter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)condition.getBankId()));
                    traFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyId()));
                    traFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beforeDate));
                    traFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)condition.getCompanyInfo().getId().toString()));
                    traView.setSorter(sorter);
                    TransDetailCollection beforeDayDetailColl = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(traView);
                    if (beforeDayDetailColl.size() > 0) {
                        TransDetailInfo transDetailInfo = beforeDayDetailColl.get(beforeDayDetailColl.size() - 1);
                        info.setLstBalance(transDetailInfo.getTransBalance());
                        if (transDetailInfo.getTransBalance() != null) {
                            info.setLstBalanceSource("\u4ea4\u6613\u660e\u7ec6\u4f59\u989d");
                            info.setLstBalLastUpdateTime(transDetailInfo.getBizTime());
                        }
                    }
                }
            } else if (bankBalanceCollection.get(0).getBizDate().compareTo(beforeDate) == 0) {
                BigDecimal balance = bankBalanceCollection.get(0).getBalance();
                if (balance != null) {
                    info.setLstBalance(balance);
                    info.setLstBalanceSource("\u94f6\u4f01\u8d26\u6237\u4f59\u989d");
                    info.setLstBalLastUpdateTime(new Timestamp(bankBalanceCollection.get(0).getAccurateBizDate().getTime()));
                } else {
                    EntityViewInfo traView = new EntityViewInfo();
                    FilterInfo traFilter = new FilterInfo();
                    traView.setFilter(traFilter);
                    traFilter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)condition.getBankId()));
                    traFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyId()));
                    traFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beforeDate));
                    traFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)condition.getCompanyInfo().getId().toString()));
                    traView.setSorter(sorter);
                    TransDetailCollection beforeDayDetailColl = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(traView);
                    if (beforeDayDetailColl.size() > 0) {
                        TransDetailInfo transDetailInfo = beforeDayDetailColl.get(beforeDayDetailColl.size() - 1);
                        info.setLstBalance(transDetailInfo.getTransBalance());
                        if (transDetailInfo.getTransBalance() != null) {
                            info.setLstBalanceSource("\u4ea4\u6613\u660e\u7ec6\u4f59\u989d");
                            info.setLstBalLastUpdateTime(transDetailInfo.getBizTime());
                        }
                    }
                }
            }
        } else {
            EntityViewInfo traView = new EntityViewInfo();
            FilterInfo traFilter = new FilterInfo();
            traView.setFilter(traFilter);
            traFilter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)condition.getBankId()));
            traFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyId()));
            traFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beforeDate));
            traFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)condition.getCompanyInfo().getId().toString()));
            traView.setSorter(sorter);
            TransDetailCollection beforeDayDetailColl = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(traView);
            if (beforeDayDetailColl.size() > 0) {
                TransDetailInfo transDetailInfo = beforeDayDetailColl.get(beforeDayDetailColl.size() - 1);
                info.setLstBalance(transDetailInfo.getTransBalance());
                if (info.getLstBalance() != null) {
                    info.setLstBalanceSource("\u4ea4\u6613\u660e\u7ec6\u4f59\u989d");
                    info.setLstBalLastUpdateTime(transDetailInfo.getBizTime());
                }
            }
        }
        if (info.getLstBalance() != null) {
            info.setCalculateBalance(info.getLstBalance().subtract(info.getTotalPayAmount()).add(info.getTotalRecAmount()));
        }
        if (currentBizDateDetailColl.size() > 0) {
            if (currentBizDateDetailColl.get(currentBizDateDetailColl.size() - 1).getTransBalance() != null) {
                info.setBalance(currentBizDateDetailColl.get(currentBizDateDetailColl.size() - 1).getTransBalance());
                info.setBalanceSource("\u4ea4\u6613\u660e\u7ec6\u4f59\u989d");
                info.setBalanceLastUpdateTime(currentBizDateDetailColl.get(currentBizDateDetailColl.size() - 1).getBizTime());
            } else if (bankBalanceCollection.size() > 0 && bankBalanceCollection.get(0).getBizDate().compareTo(condition.getBizDate()) == 0 && bankBalanceCollection.get(0).getBalance() != null) {
                info.setBalance(bankBalanceCollection.get(0).getBalance());
                info.setBalanceSource("\u94f6\u4f01\u8d26\u6237\u4f59\u989d");
                info.setBalanceLastUpdateTime(new Timestamp(bankBalanceCollection.get(0).getAccurateBizDate().getTime()));
            }
            info.setDetailLastUpdateTime(currentBizDateDetailColl.get(currentBizDateDetailColl.size() - 1).getBizTime());
        } else if (bankBalanceCollection.size() > 0 && bankBalanceCollection.get(0).getBizDate().compareTo(condition.getBizDate()) == 0 && bankBalanceCollection.get(0).getBalance() != null) {
            info.setBalance(bankBalanceCollection.get(0).getBalance());
            info.setBalanceSource("\u94f6\u4f01\u8d26\u6237\u4f59\u989d");
            info.setBalanceLastUpdateTime(new Timestamp(bankBalanceCollection.get(0).getAccurateBizDate().getTime()));
        }
        if (info.getBalance() != null && info.getCalculateBalance() != null) {
            info.setBalanceDif(info.getBalance().subtract(info.getCalculateBalance()));
        }
        if (info.getLstBalance() == null) {
            info.setVerifyResult("\u4e0d\u5b8c\u6574-\u7f3a\u5c11\u4e0a\u65e5\u4f59\u989d");
        } else if (info.getBalance() == null) {
            info.setVerifyResult("\u4e0d\u5b8c\u6574-\u7f3a\u5c11\u5f53\u524d\u4f59\u989d");
        } else if (info.getBalanceDif().compareTo(SysConstant.BIGZERO) == 0) {
            info.setVerifyResult("\u5b8c\u6574");
        } else {
            info.setVerifyResult("\u4e0d\u5b8c\u6574");
        }
        return info;
    }
}

