/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.app.util.KingDeeCloundDriveApiUtils;
import com.kingdee.eas.util.ResourceBase;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EReceiptCloundDriveUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.EReceiptCloundDriveUtils");

    public static String uploadFileToDrive(Context ctx, EReceiptInfo eReceiptInfo, String orgAccessToken, String uid, Map<String, String> folderIdMap) throws BOSException {
        String fileId = null;
        try {
            SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy");
            SimpleDateFormat sdfMonth = new SimpleDateFormat("MM");
            SimpleDateFormat sdfDay = new SimpleDateFormat("dd");
            Date transDate = eReceiptInfo.getTransDate();
            String transYear = sdfYear.format(transDate);
            String transMonth = sdfMonth.format(transDate);
            String transDay = sdfDay.format(transDate);
            String yearFolderId = folderIdMap.get(transYear);
            if (yearFolderId == null) {
                yearFolderId = EReceiptCloundDriveUtils.createFolder(ctx, transYear, null, orgAccessToken, uid);
                folderIdMap.put(transYear, yearFolderId);
            }
            if (yearFolderId == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"607_EReceiptCloundDriveUtils", (Locale)ctx.getLocale()));
            }
            String monthFolderId = folderIdMap.get(transYear + transMonth);
            if (monthFolderId == null) {
                monthFolderId = EReceiptCloundDriveUtils.createFolder(ctx, transMonth, yearFolderId, orgAccessToken, uid);
                folderIdMap.put(transYear + transMonth, monthFolderId);
            }
            if (monthFolderId == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"607_EReceiptCloundDriveUtils", (Locale)ctx.getLocale()));
            }
            String dayFolderId = folderIdMap.get(transYear + transMonth + transDay);
            if (dayFolderId == null) {
                dayFolderId = EReceiptCloundDriveUtils.createFolder(ctx, transDay, monthFolderId, orgAccessToken, uid);
                folderIdMap.put(transYear + transMonth + transDay, dayFolderId);
            }
            if (dayFolderId == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"607_EReceiptCloundDriveUtils", (Locale)ctx.getLocale()));
            }
            Map<String, String> fileMap = KingDeeCloundDriveApiUtils.uploadFileToOrgDrive(ctx, orgAccessToken, eReceiptInfo.getFileValue(), eReceiptInfo.getFileName(), dayFolderId, uid);
            String errcode = fileMap.get("errcode");
            if (!errcode.equals("0")) {
                String exMsg = KingDeeCloundDriveApiUtils.getExMsg(ctx, fileMap);
                throw new Exception(exMsg);
            }
            fileId = fileMap.get("file_id");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return fileId;
    }

    public static String createFolder(Context ctx, String folderName, String parentFolderId, String orgAccessToken, String uid) throws Exception {
        String folderId = null;
        Map<String, String> folderMap = KingDeeCloundDriveApiUtils.isExistFolder(ctx, folderName, parentFolderId, orgAccessToken, uid);
        String errcode = folderMap.get("errcode");
        if (errcode.equals("0")) {
            folderId = folderMap.get("folder_id");
        } else if (errcode.equals("2002")) {
            logger.error((Object)("\u6587\u4ef6\u5939\u3010" + folderName + "\u3011\u4e0d\u5b58\u5728,\u6240\u5c5e\u7236\u6587\u4ef6\u5939Id:" + parentFolderId));
            folderMap = KingDeeCloundDriveApiUtils.createFolder(ctx, folderName, parentFolderId, orgAccessToken, uid);
            errcode = folderMap.get("errcode");
            if (errcode.equals("0")) {
                folderId = folderMap.get("folder_id");
            }
            logger.error((Object)("\u521b\u5efa\u6587\u4ef6\u5939\u3010" + folderName + "\u3011OK,\u6240\u5c5e\u7236\u6587\u4ef6\u5939Id:" + parentFolderId));
        }
        if (!errcode.equals("0")) {
            String exMsg = KingDeeCloundDriveApiUtils.getExMsg(ctx, folderMap);
            throw new Exception(exMsg);
        }
        return folderId;
    }
}

