/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.be.EReceiptLogTypeEnum;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.IEReceipt;
import com.kingdee.eas.fm.be.LevelEnum;
import com.kingdee.eas.fm.be.StorageSettingInstance;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.app.EReceiptLogUtils;
import com.kingdee.eas.fm.be.app.util.EReceiptJDBC;
import com.kingdee.eas.fm.be.vo.EReceiptVO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileOutputStream;
import org.apache.log4j.Logger;

public class EReceiptDBUtils {
    private IEReceipt iEReceipt = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.EReceiptDBUtils");
    private EReceiptLogUtils eReceiptLogUtils = new EReceiptLogUtils();
    public static final String TRANSDETAILID = "transDetailId";
    public static final String SRCBILLNUMBER = "srcBillNumber";
    public static final String SRCBILLBIZTYPE = "srcBillBizType";
    public static final String COMPANYID = "companyId";

    protected EReceiptCollection getNoMatchEReceiptCollection(Context ctx, int topNum) throws BOSException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("id"));
        eReceiptSic.add(new SelectorItemInfo("detailNo"));
        eReceiptSic.add(new SelectorItemInfo("transDate"));
        eReceiptSic.add(new SelectorItemInfo("bankAccount"));
        eReceiptSic.add(new SelectorItemInfo("bankNumber"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo(TRANSDETAILID, null));
        eReceiptView.setFilter(eReceiptFilter);
        eReceiptView.setTopCount(topNum);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("transDate");
        sorterItem.setSortType(SortType.DESCEND);
        sorter.add(sorterItem);
        eReceiptView.setSorter(sorter);
        EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(eReceiptView);
        return coll;
    }

    protected EReceiptCollection getEReceiptCollectionById(Context ctx, String billID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("bankAccount.*"));
        view.setSelector(selectorItemCollection);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billID, CompareType.EQUALS));
        view.setFilter(filter);
        EReceiptCollection colls = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(view);
        return colls;
    }

    protected EReceiptCollection getEReceiptCollectionByEvi(Context ctx, EntityViewInfo view) throws BOSException {
        EReceiptCollection colls = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(view);
        return colls;
    }

    protected EReceiptCollection getNoPDFEreceiptCollection(Context ctx, int topNum) throws BOSException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("id"));
        eReceiptSic.add(new SelectorItemInfo("filePath"));
        eReceiptSic.add(new SelectorItemInfo("fileName"));
        eReceiptSic.add(new SelectorItemInfo("detailNo"));
        eReceiptSic.add(new SelectorItemInfo("bankNumber"));
        eReceiptSic.add(new SelectorItemInfo("transDate"));
        eReceiptSic.add(new SelectorItemInfo("ip"));
        eReceiptSic.add(new SelectorItemInfo("password"));
        eReceiptSic.add(new SelectorItemInfo("port"));
        eReceiptSic.add(new SelectorItemInfo("proxy"));
        eReceiptSic.add(new SelectorItemInfo("username"));
        eReceiptSic.add(new SelectorItemInfo("bankAccount.*"));
        eReceiptSic.add(new SelectorItemInfo("isMatch"));
        eReceiptSic.add(new SelectorItemInfo("fileFlag"));
        eReceiptSic.add(new SelectorItemInfo("receiptStampPath"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileSource", (Object)"3"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileFlag", (Object)"1"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileFlag", (Object)"0"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("isMatch", (Object)"1"));
        eReceiptFilter.setMaskString("#0 AND (#1 OR (#2 ANd #3))");
        eReceiptView.setFilter(eReceiptFilter);
        eReceiptView.setTopCount(topNum);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("transDate");
        sorterItem.setSortType(SortType.DESCEND);
        sorter.add(sorterItem);
        eReceiptView.setSorter(sorter);
        EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(eReceiptView);
        return coll;
    }

    public EReceiptCollection getEReceiptCollectionByDetailNoAndAccNumber(Context ctx, String detailNo, String fbankAccountNumber, java.util.Date transDate) throws BOSException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("id"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("detailNo", (Object)detailNo));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("bankNumber", (Object)fbankAccountNumber));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)transDate));
        eReceiptView.setFilter(eReceiptFilter);
        EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(eReceiptView);
        return coll;
    }

    public boolean isExistEreceiptByDate(Context ctx, String fbankAccountNumber, java.util.Date transDate) throws BOSException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("id"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("bankNumber", (Object)fbankAccountNumber));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)transDate));
        eReceiptView.setFilter(eReceiptFilter);
        EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(eReceiptView);
        return coll != null && coll.size() > 0;
    }

    public EReceiptInfo getEReceiptyByIdAndSelector(Context ctx, String eReceiptId, SelectorItemCollection sic) throws EASBizException, BOSException {
        EReceiptInfo eReceiptInfo = EReceiptFactory.getLocalInstance(ctx).getEReceiptInfo((IObjectPK)new ObjectUuidPK(eReceiptId), sic);
        return eReceiptInfo;
    }

    public void addnewBatchData(Context ctx, CoreBaseCollection eReceiptInfoCollection) throws BOSException, EASBizException {
        if (this.iEReceipt == null) {
            this.iEReceipt = EReceiptFactory.getLocalInstance(ctx);
        }
        this.iEReceipt.addnewBatchData(eReceiptInfoCollection);
    }

    public void cancelJoinTransDetailById(Context ctx, String eReceiptId) throws BOSException {
        String sql = "Update T_BE_EReceipt set  FAmount = null ,FCurrencyID = null ,FBankID = null,FOppUnit = null ,FTransDetailId = null ,FOppBankNumber = null,FOppBank = null ,FIsMatch = ? ,FNumber = null ,FUse = null where FId= ? ";
        Object[] params = new Object[]{"0", eReceiptId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    protected void batchUpdateEReceipt(Context ctx, EReceiptCollection eReceiptInfoCollection, Connection conn) throws BOSException, EASBizException {
        PreparedStatement stmtUpdate = null;
        try {
            String sql = "Update T_BE_EReceipt set FCompanyID =?, FAmount =? ,FCurrencyID = ? ,FBankAccountID=?,FBankID=?,FOppUnit=?,FTransDetailId =? ,FTransDate = ? ,FOppBankNumber = ?,FOppBank = ? ,FIsMatch = ? ,FNumber = ? , FDescription = ? , FDebitAmount = ? ,FCreditAmount = ? ,FCreditDebitFlag = ?,FEXPLANATION = ?   where FId= ? ";
            stmtUpdate = conn.prepareStatement(sql);
            for (int i = 0; i < eReceiptInfoCollection.size(); ++i) {
                EReceiptInfo eReceiptInfo = eReceiptInfoCollection.get(i);
                if (eReceiptInfo.getTransDetailId() == null || eReceiptInfo.getTransDetailId().equals("")) continue;
                stmtUpdate.setString(1, eReceiptInfo.getCompany().getId().toString());
                stmtUpdate.setBigDecimal(2, eReceiptInfo.getAmount());
                stmtUpdate.setString(3, eReceiptInfo.getCurrency().getId().toString());
                stmtUpdate.setString(4, eReceiptInfo.getBankAccount().getId().toString());
                stmtUpdate.setString(5, eReceiptInfo.getBank().getId().toString());
                stmtUpdate.setString(6, eReceiptInfo.getOppUnit());
                stmtUpdate.setString(7, eReceiptInfo.getTransDetailId());
                java.util.Date utilDate = eReceiptInfo.getTransDate();
                Date sqlDate = new Date(utilDate.getTime());
                stmtUpdate.setDate(8, sqlDate);
                stmtUpdate.setString(9, eReceiptInfo.getOppBankNumber());
                stmtUpdate.setString(10, eReceiptInfo.getOppBank());
                stmtUpdate.setString(11, "1");
                stmtUpdate.setString(12, eReceiptInfo.getNumber());
                stmtUpdate.setString(13, eReceiptInfo.getDescription());
                stmtUpdate.setBigDecimal(14, eReceiptInfo.getDebitAmount());
                stmtUpdate.setBigDecimal(15, eReceiptInfo.getCreditAmount());
                stmtUpdate.setString(16, eReceiptInfo.getCreditDebitFlag());
                stmtUpdate.setString(17, eReceiptInfo.getDescription());
                DbUtil.prepareVarcharParam((PreparedStatement)stmtUpdate, (int)18, (String)eReceiptInfo.getId().toString());
                stmtUpdate.addBatch();
            }
            stmtUpdate.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"\u6279\u91cf\u66f4\u65b0 \u5339\u914d\u4ea4\u6613\u660e\u7ec6\u7684\u7535\u5b50\u56de\u5355\u5931\u8d25");
                this.eReceiptLogUtils.addReceiptLog(ctx, null, null, ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"767_EReceiptDBUtils", (Locale)ctx.getLocale()) + e.getMessage(), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"768_EReceiptDBUtils", (Locale)ctx.getLocale()), this.eReceiptLogUtils.getStackTrace(e), EReceiptLogTypeEnum.JOINTRANSDETAIL, LevelEnum.ERROR);
                e.printStackTrace();
                throw new BEException(null);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtUpdate);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtUpdate);
    }

    public void cleanEASPDFBefore10Days(Context ctx, Connection conn) throws BOSException {
        java.util.Date daysAgoDate = this.get10DaysAgoDate();
        PreparedStatement stmtUpdate = null;
        String sql = "Update T_BE_EReceipt set FFileSource = '1' ,FFileValue = null where FFileSource ='0' and FTransDate <=?";
        try {
            StorageSettingInstance storageSetting = StorageSettingInstance.getInstance(ctx);
            if (storageSetting.getStorageSettingInfo() != null) {
                int storageType = storageSetting.getStorageSettingInfo().getStorageType().getValue();
                if (storageType == 2) {
                    sql = "Update T_BE_EReceipt set FFileSource = '2' ,FFileValue = null where FFileSource ='0' and FTransDate <=?";
                } else if (storageType == 3) {
                    sql = "Update T_BE_EReceipt set FFileSource = '4' ,FFileValue = null where FFileSource ='0' and FTransDate <=?";
                }
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"744_EReceiptControllerBean", (Locale)ctx.getLocale()));
            }
            stmtUpdate = conn.prepareStatement(sql);
            Date sqlDate = new Date(daysAgoDate.getTime());
            stmtUpdate.setDate(1, sqlDate);
            stmtUpdate.executeUpdate();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"\u3010\u66f4\u65b0\u5931\u8d25\u3011  \u66f4\u65b015\u5929\u4e4b\u524d\u6570\u636e,\u628aPDF\u6587\u4ef6\u4eceEAS\u5e93\u6e05\u7a7a,\u4f7f\u7528MYSQL\u6570\u636e");
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtUpdate);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtUpdate);
    }

    protected void inValidEreceiptBefore10Days(Context ctx) throws BOSException {
        java.util.Date daysAgoDate = this.get10DaysAgoDate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sql = "Update T_BE_EReceipt set FHasEffected = 0 where FTransDate <= {ts'" + sdf.format(daysAgoDate) + "'} ";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public void updateEASEreceiptPDF(Context ctx, EReceiptInfo eReceiptInfo, Connection conn) throws BOSException {
        PreparedStatement stmtUpdate = null;
        String updateSql = "Update T_BE_EReceipt set FIsDownPdf = 1, FFileSource = ? ,FFileValue = ? where FId= ? ";
        try {
            stmtUpdate = conn.prepareStatement(updateSql);
            stmtUpdate.setString(1, "0");
            logger.error((Object)"\u8f6c\u6362byte\u6d41");
            ByteArrayInputStream input = new ByteArrayInputStream(eReceiptInfo.getFileValue());
            logger.error((Object)"\u8f6c\u6362\u5b8c\u6210");
            stmtUpdate.setBinaryStream(2, (InputStream)input, ((InputStream)input).available());
            DbUtil.prepareVarcharParam((PreparedStatement)stmtUpdate, (int)3, (String)eReceiptInfo.getId().toString());
            logger.error((Object)"\u5f00\u59cb\u66f4\u65b0PDF\u5230EAS\u5e93");
            stmtUpdate.executeUpdate();
            logger.error((Object)"\u66f4\u65b0PDF\u5230EAS\u5e93\u5b8c\u6210");
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0EAS\u5e93PDF\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmtUpdate);
        }
    }

    public void insertMySqlEreceiptPDF(Context ctx, EReceiptInfo eReceiptInfo) throws BOSException, EASBizException {
        EReceiptJDBC eReceiptJDBCTool = new EReceiptJDBC();
        EReceiptVO eReceiptVO = new EReceiptVO();
        eReceiptVO.setFID(eReceiptInfo.getId().toString());
        eReceiptVO.setEASID(eReceiptInfo.getId().toString());
        eReceiptVO.setFILENAME(eReceiptInfo.getFileName());
        eReceiptVO.setDETAILNO(eReceiptInfo.getDetailNo());
        eReceiptVO.setBANKNUMBER(eReceiptInfo.getBankNumber());
        eReceiptVO.setTRANSDATE(eReceiptInfo.getTransDate());
        ByteArrayInputStream input = new ByteArrayInputStream(eReceiptInfo.getFileValue());
        eReceiptVO.setFILEVALUE(input);
        try {
            eReceiptJDBCTool.insert(eReceiptVO);
        }
        catch (Exception e) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"775_EReceiptDBUtils", (Locale)ctx.getLocale()) + e.getMessage();
            logger.error((Object)exMsg);
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected java.util.Date get10DaysAgoDate() {
        java.util.Date beginDate = new java.util.Date();
        Calendar date = Calendar.getInstance();
        date.setTime(beginDate);
        date.set(5, date.get(5) - 10);
        java.util.Date endDate = new java.util.Date();
        SimpleDateFormat dft = new SimpleDateFormat("yyyyMMdd");
        try {
            endDate = dft.parse(dft.format(date.getTime()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return endDate;
    }

    public void updateEReceipt(Context ctx, String payerBankName, String payeeBankName, String payerAccName, String payeeAccName, String eReceiptId, Connection conn) throws BOSException {
        PreparedStatement stmtUpdate = null;
        StringBuffer sqlBuff = new StringBuffer("Update T_BE_EReceipt set  ");
        boolean isFirst = true;
        if (payerBankName != null) {
            if (isFirst) {
                sqlBuff.append(" fpayerBankName = ?");
                isFirst = false;
            } else {
                sqlBuff.append(" , fpayerBankName = ?");
            }
        }
        if (payeeBankName != null) {
            if (isFirst) {
                sqlBuff.append(" fpayeeBankName = ?");
                isFirst = false;
            } else {
                sqlBuff.append(" , fpayeeBankName = ?");
            }
        }
        if (payerAccName != null) {
            if (isFirst) {
                sqlBuff.append(" FPayerAcntName = ?");
                isFirst = false;
            } else {
                sqlBuff.append(" , FPayerAcntName = ?");
            }
        }
        if (payeeAccName != null) {
            if (isFirst) {
                sqlBuff.append(" FPayeeAcntName = ?");
                isFirst = false;
            } else {
                sqlBuff.append(" , FPayeeAcntName = ?");
            }
        }
        sqlBuff.append("  where fid=?");
        try {
            stmtUpdate = conn.prepareStatement(sqlBuff.toString());
            int i = 1;
            if (payerBankName != null) {
                stmtUpdate.setString(i, payerBankName);
                ++i;
            }
            if (payeeBankName != null) {
                stmtUpdate.setString(i, payeeBankName);
                ++i;
            }
            if (payerAccName != null) {
                stmtUpdate.setString(i, payerAccName);
                ++i;
            }
            if (payeeAccName != null) {
                stmtUpdate.setString(i, payeeAccName);
                ++i;
            }
            stmtUpdate.setString(i, eReceiptId);
            stmtUpdate.executeUpdate();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtUpdate);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtUpdate);
    }

    public void insertEReceiptPDFToDB(Context ctx, EReceiptInfo eReceiptInfo, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws BOSException, EASBizException {
        EReceiptJDBC eReceiptJDBCTool = new EReceiptJDBC();
        EReceiptVO eReceiptVO = new EReceiptVO();
        eReceiptVO.setFID(eReceiptInfo.getId().toString());
        eReceiptVO.setEASID(eReceiptInfo.getId().toString());
        eReceiptVO.setFILENAME(eReceiptInfo.getFileName());
        eReceiptVO.setDETAILNO(eReceiptInfo.getDetailNo());
        eReceiptVO.setBANKNUMBER(eReceiptInfo.getBankNumber());
        eReceiptVO.setTRANSDATE(eReceiptInfo.getTransDate());
        ByteArrayInputStream input = new ByteArrayInputStream(eReceiptInfo.getFileValue());
        eReceiptVO.setFILEVALUE(input);
        try {
            logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u6570\u636e\u5e93  start");
            eReceiptJDBCTool.insertEReceipt(eReceiptVO, eReceiptStorageSettingInfo);
            logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u6570\u636e\u5e93  OK");
        }
        catch (Exception e) {
            String exMsg = "\u4fdd\u5b58PDF\u5230\u56de\u5355\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4PDF\u5e93\u8fde\u63a5\u662f\u5426\u6b63\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage();
            logger.error((Object)exMsg);
            this.eReceiptLogUtils.addReceiptLog(ctx, eReceiptInfo.getBankNumber(), eReceiptInfo.getTransDate(), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"779_EReceiptDBUtils", (Locale)ctx.getLocale()) + e.getMessage(), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"780_EReceiptDBUtils", (Locale)ctx.getLocale()), this.eReceiptLogUtils.getStackTrace(e), EReceiptLogTypeEnum.DOWNPDF, LevelEnum.ERROR);
            e.printStackTrace();
            throw new BEException(null);
        }
    }

    public void updateEReceiptFileId(Context ctx, String eReceiptId, String fileId, Connection conn) throws BOSException {
        String sql = "Update T_BE_EReceipt set FFileId = ? where fid = ?";
        PreparedStatement stmtUpdate = null;
        try {
            stmtUpdate = conn.prepareStatement(sql);
            stmtUpdate.setString(1, fileId);
            stmtUpdate.setString(2, eReceiptId);
            stmtUpdate.executeUpdate();
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0 \u4e91\u76d8\u6587\u4ef6id\u5230\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmtUpdate);
        }
    }

    public void insertEReceiptPDFToLocal(Context ctx, EReceiptInfo eReceiptInfo, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws BOSException, EASBizException {
        String storePath = null;
        String fileName = eReceiptInfo.getFileName();
        String filePath = eReceiptInfo.getReceiptStampPath();
        byte[] fileValue = eReceiptInfo.getFileValue();
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            Object dir;
            logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u672c\u5730  start");
            if (eReceiptStorageSettingInfo.isUseMapping()) {
                storePath = eReceiptStorageSettingInfo.getMappingFinalPath();
                dir = new SmbFile(storePath);
                if (!dir.exists() || !dir.isDirectory()) {
                    String errMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"783_EReceiptDBUtils", (Locale)ctx.getLocale());
                    logger.error((Object)errMsg);
                    throw new BOSException(errMsg);
                }
                SmbFile file = new SmbFile(filePath);
                if (!file.exists() && !file.isDirectory()) {
                    file.mkdirs();
                }
                filePath = filePath + "/" + fileName;
                file = new SmbFile(filePath);
                SmbFileOutputStream sfos = new SmbFileOutputStream(file);
                bos = new BufferedOutputStream((OutputStream)sfos);
                bos.write(fileValue);
                logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u672c\u5730  end");
            } else {
                storePath = eReceiptStorageSettingInfo.getLocalPath();
                dir = new File(storePath);
                if (!((File)dir).exists() || !((File)dir).isDirectory()) {
                    String errMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"783_EReceiptDBUtils", (Locale)ctx.getLocale());
                    logger.error((Object)errMsg);
                    throw new BOSException(errMsg);
                }
                File file = new File(filePath);
                if (!file.exists() && !file.isDirectory()) {
                    file.mkdirs();
                }
                filePath = filePath + "/" + fileName;
                file = new File(filePath);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(fileValue);
                logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u672c\u5730  end");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"783_EReceiptDBUtils", (Locale)ctx.getLocale()));
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected EReceiptCollection getNoMatchEReceiptCollectionByBankNumber(Context ctx, int topNum, String bankNumber) throws BOSException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("*"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo(TRANSDETAILID, null));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("isMatch", (Object)"0", CompareType.EQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("bankNumber", (Object)bankNumber, CompareType.EQUALS));
        eReceiptView.setFilter(eReceiptFilter);
        eReceiptView.setTopCount(topNum);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("transDate");
        sorterItem.setSortType(SortType.DESCEND);
        sorter.add(sorterItem);
        eReceiptView.setSorter(sorter);
        EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(eReceiptView);
        return coll;
    }

    protected HashMap<String, TransDetailCollection> getTransDetailCollInTransDateSet(Context ctx, String bankNumber, java.util.Date transDate) throws BOSException {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String companyId = companyInfo.getId().toString();
        int days = 0;
        days = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("EREC003", (IObjectPK)new ObjectUuidPK(companyId));
        if (days > 10) {
            days = 10;
        }
        EntityViewInfo transDetailView = new EntityViewInfo();
        SelectorItemCollection transDetailSic = new SelectorItemCollection();
        transDetailSic.add(new SelectorItemInfo("*"));
        transDetailSic.add(new SelectorItemInfo("currency.*"));
        transDetailSic.add(new SelectorItemInfo("bankAccount.*"));
        transDetailSic.add(new SelectorItemInfo("bankAccount.bank.*"));
        transDetailSic.add(new SelectorItemInfo("conmpay.*"));
        transDetailView.setSelector(transDetailSic);
        FilterInfo transDetailFilter = new FilterInfo();
        transDetailFilter.getFilterItems().add(new FilterItemInfo("isMatchEReceipt", (Object)0, CompareType.EQUALS));
        if (days == 0) {
            transDetailFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)transDate, CompareType.EQUALS));
        } else {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(transDate);
            ((Calendar)cal).add(5, -days);
            java.util.Date beginDate = cal.getTime();
            cal.setTime(transDate);
            ((Calendar)cal).add(5, days);
            java.util.Date endDate = cal.getTime();
            transDetailFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beginDate, CompareType.GREATER_EQUALS));
            transDetailFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)endDate, CompareType.LESS_EQUALS));
        }
        transDetailFilter.getFilterItems().add(new FilterItemInfo("bankAccount.bankAccountNumber", (Object)bankNumber, CompareType.EQUALS));
        transDetailView.setFilter(transDetailFilter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("bizDate");
        sorter.add(sorterItem);
        transDetailView.setSorter(sorter);
        TransDetailCollection coll = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(transDetailView);
        TransDetailInfo info = null;
        HashMap<String, TransDetailCollection> transDetailMap = new HashMap<String, TransDetailCollection>();
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            info = coll.get(i);
            if (EmptyUtil.isEmpty((String)info.getReceiptNo())) continue;
            TransDetailCollection tempTransDetailColls = transDetailMap.get(info.getReceiptNo());
            if (tempTransDetailColls != null) {
                tempTransDetailColls.add(info);
                continue;
            }
            tempTransDetailColls = new TransDetailCollection();
            tempTransDetailColls.add(info);
            transDetailMap.put(info.getReceiptNo(), tempTransDetailColls);
        }
        return transDetailMap;
    }

    protected AccountBankCollection getBankNumberHasInterFace(Context ctx) throws BOSException {
        EntityViewInfo bankView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        FilterInfo bankFilter = new FilterInfo();
        bankFilter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)true));
        bankView.setFilter(bankFilter);
        bankView.setSelector(sic);
        AccountBankCollection bankColls = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(bankView);
        return bankColls;
    }

    public String fixAccNoTo15Or19(String accNo) {
        String retAccNo = null;
        if (null != accNo) {
            String str2 = accNo.trim();
            retAccNo = str2.length() == 19 ? accNo : (str2.length() == 21 ? str2.substring(2) : this.getLastNString(str2, 15));
        }
        logger.info((Object)("SrcAcnt:" + accNo + ", RetAcnt:" + retAccNo));
        return retAccNo;
    }

    private String getLastNString(String str, int len) {
        return str.substring(str.length() - len);
    }

    protected EReceiptCollection getNoPDFEreceiptCollection(Context ctx, int topNum, java.util.Date startDate, java.util.Date endDate, Set<String> bankNumber) throws BOSException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("id"));
        eReceiptSic.add(new SelectorItemInfo("filePath"));
        eReceiptSic.add(new SelectorItemInfo("fileName"));
        eReceiptSic.add(new SelectorItemInfo("detailNo"));
        eReceiptSic.add(new SelectorItemInfo("bankNumber"));
        eReceiptSic.add(new SelectorItemInfo("transDate"));
        eReceiptSic.add(new SelectorItemInfo("ip"));
        eReceiptSic.add(new SelectorItemInfo("password"));
        eReceiptSic.add(new SelectorItemInfo("port"));
        eReceiptSic.add(new SelectorItemInfo("proxy"));
        eReceiptSic.add(new SelectorItemInfo("username"));
        eReceiptSic.add(new SelectorItemInfo("bankAccount.*"));
        eReceiptSic.add(new SelectorItemInfo("isMatch"));
        eReceiptSic.add(new SelectorItemInfo("fileFlag"));
        eReceiptSic.add(new SelectorItemInfo("receiptStampPath"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileSource", (Object)"3"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileFlag", (Object)"1"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileFlag", (Object)"0"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("isMatch", (Object)"1"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("bankNumber", bankNumber, CompareType.INCLUDE));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)startDate, CompareType.GREATER_EQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)endDate, CompareType.LESS_EQUALS));
        eReceiptFilter.setMaskString("#0 AND (#1 OR (#2 ANd #3)) AND #4 AND #5 AND #6");
        eReceiptView.setFilter(eReceiptFilter);
        eReceiptView.setTopCount(topNum);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("transDate");
        sorterItem.setSortType(SortType.DESCEND);
        sorter.add(sorterItem);
        eReceiptView.setSorter(sorter);
        EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(eReceiptView);
        return coll;
    }

    protected EReceiptCollection getNoMatchEReceiptCollectionByBankNumber(Context ctx, int topNum, String bankNumber, java.util.Date startDate, java.util.Date endDate) throws BOSException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("*"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo(TRANSDETAILID, null));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("isMatch", (Object)"1", CompareType.NOTEQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("bankNumber", (Object)bankNumber, CompareType.EQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)startDate, CompareType.GREATER_EQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)endDate, CompareType.LESS_EQUALS));
        eReceiptView.setFilter(eReceiptFilter);
        eReceiptView.setTopCount(topNum);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("transDate");
        sorterItem.setSortType(SortType.DESCEND);
        sorter.add(sorterItem);
        eReceiptView.setSorter(sorter);
        EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(eReceiptView);
        return coll;
    }

    protected EReceiptCollection getNoPDFEreceiptCollection(Context ctx, int topNum, Set bankType) throws BOSException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("id"));
        eReceiptSic.add(new SelectorItemInfo("filePath"));
        eReceiptSic.add(new SelectorItemInfo("fileName"));
        eReceiptSic.add(new SelectorItemInfo("detailNo"));
        eReceiptSic.add(new SelectorItemInfo("bankNumber"));
        eReceiptSic.add(new SelectorItemInfo("transDate"));
        eReceiptSic.add(new SelectorItemInfo("ip"));
        eReceiptSic.add(new SelectorItemInfo("password"));
        eReceiptSic.add(new SelectorItemInfo("port"));
        eReceiptSic.add(new SelectorItemInfo("proxy"));
        eReceiptSic.add(new SelectorItemInfo("username"));
        eReceiptSic.add(new SelectorItemInfo("bankAccountId"));
        eReceiptSic.add(new SelectorItemInfo("bankAccount.*"));
        eReceiptSic.add(new SelectorItemInfo("receiptStampPath"));
        eReceiptSic.add(new SelectorItemInfo("isMatch"));
        eReceiptSic.add(new SelectorItemInfo("fileFlag"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileSource", (Object)"3"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileFlag", (Object)"1"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileFlag", (Object)"0"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("isMatch", (Object)"1"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("bankNumber", (Object)bankType, CompareType.INCLUDE));
        eReceiptFilter.setMaskString("#0 AND (#1 OR (#2 ANd #3)) AND #4");
        eReceiptView.setFilter(eReceiptFilter);
        eReceiptView.setTopCount(topNum);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortertransDate = new SorterItemInfo("transDate");
        sortertransDate.setSortType(SortType.DESCEND);
        SorterItemInfo sorterBank = new SorterItemInfo("bank");
        sorterBank.setSortType(SortType.DESCEND);
        sorter.add(sortertransDate);
        sorter.add(sorterBank);
        eReceiptView.setSorter(sorter);
        EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(eReceiptView);
        return coll;
    }

    protected EReceiptCollection getMatchEReceiptCollectionByIds(Context ctx, Set ids) throws BOSException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("*"));
        eReceiptSic.add(new SelectorItemInfo("company.id"));
        eReceiptSic.add(new SelectorItemInfo("company.name"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        eReceiptView.setFilter(eReceiptFilter);
        EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(eReceiptView);
        return coll;
    }

    public void disposeSrounceBill(Context ctx, Map<String, String> matchBillMap) throws BOSException {
        String transDetailId = matchBillMap.get(TRANSDETAILID);
        String srcBillNumber = matchBillMap.get(SRCBILLNUMBER);
        String srcBillBizType = matchBillMap.get(SRCBILLBIZTYPE);
        String companyId = matchBillMap.get(COMPANYID);
        if (!EmptyUtil.isEmpty((String)transDetailId)) {
            String updateSql = "Update T_BE_TransDetail set FIsMatchEReceipt = 0 where FId= ? ";
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{transDetailId});
        }
        if (!(EmptyUtil.isEmpty((String)srcBillNumber) || EmptyUtil.isEmpty((String)srcBillBizType) || EmptyUtil.isEmpty((String)companyId))) {
            String[] strArray = srcBillNumber.split(";");
            for (int i = 0; i < strArray.length; ++i) {
                if (srcBillBizType.equals("\u4ed8\u6b3e\u5355") && !strArray[i].endsWith("...")) {
                    String paymentSql = "UPDATE T_CAS_PaymentBill SET FHasEReceipt = 0 WHERE Fnumber = ? and fcompanyid = ? ";
                    DbUtil.execute((Context)ctx, (String)paymentSql, (Object[])new Object[]{strArray[i], companyId});
                    continue;
                }
                if (!srcBillBizType.equals("\u6536\u6b3e\u5355") || strArray[i].endsWith("...")) continue;
                String receivingSql = "UPDATE T_CAS_ReceivingBill SET FHasEReceipt = 0 WHERE Fnumber = ? and fcompanyid = ? ";
                DbUtil.execute((Context)ctx, (String)receivingSql, (Object[])new Object[]{strArray[i], companyId});
            }
        }
    }

    protected Map<String, String> updateUnMatchEReceipt(Context ctx, EReceiptInfo eReceiptInfo, IEReceipt iEReceipt) throws EASBizException, BOSException {
        HashMap<String, String> matchBillMap = new HashMap<String, String>();
        matchBillMap.put(TRANSDETAILID, eReceiptInfo.getTransDetailId());
        matchBillMap.put(SRCBILLNUMBER, eReceiptInfo.getBillNumber());
        matchBillMap.put(SRCBILLBIZTYPE, eReceiptInfo.getBizType());
        matchBillMap.put(COMPANYID, eReceiptInfo.getCompany().getId().toString());
        eReceiptInfo.setBank(null);
        eReceiptInfo.setDebitAmount(null);
        eReceiptInfo.setCreditAmount(null);
        eReceiptInfo.setCreditDebitFlag(null);
        eReceiptInfo.setAmount(null);
        eReceiptInfo.setDescription(null);
        eReceiptInfo.setExplanation(null);
        eReceiptInfo.setOppUnit(null);
        eReceiptInfo.setOppBankNumber(null);
        eReceiptInfo.setOppBank(null);
        eReceiptInfo.setNumber(null);
        eReceiptInfo.setPayerBankName(null);
        eReceiptInfo.setPayeeAcntNo(null);
        eReceiptInfo.setPayeeAcntName(null);
        eReceiptInfo.setPayeeBankName(null);
        eReceiptInfo.setBizType(null);
        eReceiptInfo.setBillNumber(null);
        eReceiptInfo.setTransDetailId(null);
        eReceiptInfo.setIsMatchBiz(false);
        eReceiptInfo.setIsMatch(EReceiptIsMatchEnum.UnMatch);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("bank"));
        selector.add(new SelectorItemInfo("debitAmount"));
        selector.add(new SelectorItemInfo("creditAmount"));
        selector.add(new SelectorItemInfo("creditDebitFlag"));
        selector.add(new SelectorItemInfo("amount"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("explanation"));
        selector.add(new SelectorItemInfo("oppUnit"));
        selector.add(new SelectorItemInfo("oppBankNumber"));
        selector.add(new SelectorItemInfo("oppBank"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("payerBankName"));
        selector.add(new SelectorItemInfo("payeeAcntNo"));
        selector.add(new SelectorItemInfo("payeeAcntName"));
        selector.add(new SelectorItemInfo("payeeBankName"));
        selector.add(new SelectorItemInfo("bizType"));
        selector.add(new SelectorItemInfo("billNumber"));
        selector.add(new SelectorItemInfo(TRANSDETAILID));
        selector.add(new SelectorItemInfo("isMatchBiz"));
        selector.add(new SelectorItemInfo("isMatch"));
        iEReceipt.updatePartial((CoreBaseInfo)eReceiptInfo, selector);
        logger.error((Object)"\u53cd\u5339\u914d\u7ed3\u675f");
        return matchBillMap;
    }
}

