/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EReceiptDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)EReceiptDataImport.class.getName());
    private Map companyMap = new HashMap();
    private Map currencyMap = new HashMap();
    private Map bankMap = new HashMap();

    private String getBEAutoGenerateResource(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)resName, (Locale)ctx.getLocale());
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        boolean isUsedParam;
        EReceiptInfo info = new EReceiptInfo();
        info.setIsInnerEReceipt(false);
        this.parseData(hsData, info, ctx);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
            view.setFilter(fi);
            EReceiptCollection coll = null;
            try {
                coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(view);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll != null && coll.size() > 0) {
                info.setId(coll.get(0).getId());
            }
        } else if (EmptyUtil.isEmpty((CoreBaseInfo)info) && (isUsedParam = DataImportUtils.getImportParam((Context)ctx))) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                if (iCodingRuleManager.isExist((IObjectValue)info, info.getCompany().getId().toString())) {
                    info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, info.getCompany().getId().toString()));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return info;
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoreBaseInfo parseData(Hashtable hsData, EReceiptInfo info, Context ctx) throws TaskExternalException {
        FilterInfo filter;
        EntityViewInfo view;
        Object data = null;
        String companyid = null;
        CurrencyInfo currency = new CurrencyInfo();
        data = this.getData(hsData, "FCompany_number");
        if (data != null && data.toString().trim().length() > 0) {
            if (this.companyMap.containsKey(data.toString().trim())) {
                info.setCompany((CompanyOrgUnitInfo)this.companyMap.get(data.toString().trim()));
                companyid = ((CompanyOrgUnitInfo)this.companyMap.get(data.toString().trim())).getId().toString();
            } else {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
                view.setFilter(filter);
                CompanyOrgUnitCollection companyCol = null;
                try {
                    companyCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (companyCol == null || companyCol.size() < 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"342_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"343_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyCol.get(0).getId().toString()), (String)"transDetail_12import");
                    if (!isPermission) {
                        throw new TaskExternalException(data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"762_EReceiptDataImport", (Locale)ctx.getLocale()));
                    }
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                this.companyMap.put(data.toString().trim(), companyCol.get(0));
                info.setCompany(companyCol.get(0));
                companyid = companyCol.get(0).getId().toString();
            }
        }
        if ((data = this.getData(hsData, "FBankNumber")) == null || data.toString().trim().length() <= 0) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"351_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        if (this.bankMap.containsKey(data.toString().trim())) {
            AccountBankInfo accountBankInfo = (AccountBankInfo)this.bankMap.get(data.toString().trim());
            info.setBankAccount(accountBankInfo);
            if (companyid == null) {
                companyid = accountBankInfo.getCompany().getId().toString();
                info.setCompany(accountBankInfo.getCompany());
                if (!EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getCurrency())) {
                    currency = accountBankInfo.getCurrency();
                    info.setCurrency(accountBankInfo.getCurrency());
                }
            } else if (!EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getCurrency())) {
                currency = accountBankInfo.getCurrency();
                info.setCurrency(accountBankInfo.getCurrency());
            }
        } else {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)data.toString().trim()));
            if (companyid != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
            }
            view.setFilter(filter);
            AccountBankCollection AccountBankCol = new AccountBankCollection();
            try {
                AccountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (AccountBankCol == null || AccountBankCol.size() < 1) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"344_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"345_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
            }
            if (AccountBankCol.get(0).isIsClosed()) {
                throw new TaskExternalException(MessageFormat.format(this.getBEAutoGenerateResource(ctx, "264_TransDetailDataImport"), data));
            }
            AccountBankInfo accountBankInfo = AccountBankCol.get(0);
            if (companyid != null && accountBankInfo.getShareType() != null && accountBankInfo.getShareType().getValue() == 2) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"347_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"348_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"349_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
            }
            this.bankMap.put(data.toString().trim(), AccountBankCol.get(0));
            info.setBankAccount(AccountBankCol.get(0));
            if (companyid == null) {
                info.setCompany(accountBankInfo.getCompany());
                companyid = accountBankInfo.getCompany().getId().toString();
                if (EmptyUtil.isEmpty((CoreBaseInfo)AccountBankCol.get(0).getCurrency())) {
                    if (EmptyUtil.isEmpty((CoreBaseInfo)currency)) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"344_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"350_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                    info.setCurrency(currency);
                } else {
                    currency = accountBankInfo.getCurrency();
                    info.setCurrency(currency);
                }
            } else if (!EmptyUtil.isEmpty((CoreBaseInfo)AccountBankCol.get(0).getCurrency())) {
                currency = accountBankInfo.getCurrency();
                info.setCurrency(currency);
            }
        }
        data = this.getData(hsData, "FCurrency_number");
        if (data != null && data.toString().trim().length() > 0 && EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
            if (this.currencyMap.containsKey(data.toString().trim())) {
                currency = (CurrencyInfo)this.currencyMap.get(data.toString().trim());
                info.setCurrency(currency);
            } else {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
                view.setFilter(filter);
                CurrencyCollection currencyCol = null;
                try {
                    currencyCol = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (currencyCol == null || currencyCol.size() < 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"357_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"343_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                currency = currencyCol.get(0);
                this.currencyMap.put(data.toString().trim(), currency);
                info.setCurrency(currency);
            }
        }
        if (companyid == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"352_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"358_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FTransDate");
        if (data == null || data.toString().trim().length() <= 0) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"763_EReceiptDataImport", (Locale)ctx.getLocale()));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
        try {
            sdf.parse(data.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        info.setTransDate(DateTimeUtils.truncateDate((Date)TypeConversionUtils.objToDate((Object)data)));
        data = this.getData(hsData, "FPassword");
        if (data != null && data.toString().trim().length() > 0) {
            info.setPassword(data.toString());
        }
        if ((data = this.getData(hsData, "FUse")) != null && data.toString().trim().length() > 0) {
            info.setUse(data.toString());
        }
        if ((data = this.getData(hsData, "FDetailNo")) != null && data.toString().trim().length() > 0) {
            info.setDetailNo(data.toString());
        }
        if ((data = this.getData(hsData, "FSerialNo")) != null && data.toString().trim().length() > 0) {
            info.setSerialNo(data.toString());
        }
        if ((data = this.getData(hsData, "FPayerAcntNo")) != null && data.toString().trim().length() > 0) {
            info.setPayerAcntNo(data.toString());
        }
        if ((data = this.getData(hsData, "FPayerAcntName")) != null && data.toString().trim().length() > 0) {
            info.setPayerAcntName(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeAcntNo")) != null && data.toString().trim().length() > 0) {
            info.setPayeeAcntName(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeAcntName")) != null && data.toString().trim().length() > 0) {
            info.setPayeeAcntName(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeBankName")) != null && data.toString().trim().length() > 0) {
            info.setPayeeBankName(data.toString());
        }
        if ((data = this.getData(hsData, "FOppBankNumber")) != null && data.toString().trim().length() > 0) {
            info.setOppBankNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FOppBank")) != null && data.toString().trim().length() > 0) {
            info.setOppBank(data.toString());
        }
        if ((data = this.getData(hsData, "FExplanation")) != null && data.toString().trim().length() > 0) {
            info.setExplanation(data.toString());
        }
        if ((data = this.getData(hsData, "FRemark")) != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FTransTellno")) != null && data.toString().trim().length() > 0) {
            info.setTransTellno(data.toString());
        }
        if ((data = this.getData(hsData, "FBusiType")) != null && data.toString().trim().length() > 0) {
            info.setBusiType(data.toString());
        }
        if ((data = this.getData(hsData, "FFileName")) != null && data.toString().trim().length() > 0) {
            info.setFileName(data.toString());
        }
        if ((data = this.getData(hsData, "FFilePath")) != null && data.toString().trim().length() > 0) {
            info.setFilePath(data.toString());
        }
        if ((data = this.getData(hsData, "FIp")) != null && data.toString().trim().length() > 0) {
            info.setIp(data.toString());
        }
        if ((data = this.getData(hsData, "FMessageType")) != null && data.toString().trim().length() > 0) {
            info.setMessageType(data.toString());
        }
        BigDecimal debitAmount = BigDecimal.ZERO;
        data = this.getData(hsData, "FDebitAmount");
        if (data != null && data.toString().trim().length() > 0) {
            debitAmount = TypeConversionUtils.objToBigDecimal((Object)data);
            info.setDebitAmount(debitAmount);
        }
        if (this.checkIsAllLike(ctx, info)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"764_EReceiptDataImport", (Locale)ctx.getLocale()));
        }
        info.setFileFlag("1");
        info.setFileSource("0");
        info.setIsMatch(EReceiptIsMatchEnum.UnMatch);
        return info;
    }

    private boolean checkIsAllLike(Context ctx, EReceiptInfo info) {
        if (info.getDetailNo() != null && info.getDetailNo().length() > 0) {
            EReceiptCollection coll = null;
            try {
                coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection("where detailNo ='" + info.getDetailNo() + "'");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll != null && coll.size() > 0) {
                return true;
            }
        }
        return false;
    }

    protected ICoreBase getController(Context context) throws TaskExternalException {
        try {
            return EReceiptFactory.getLocalInstance(context);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        EReceiptInfo eReceiptInfo = (EReceiptInfo)coreBaseInfo;
        try {
            eReceiptInfo.setFileValue(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.submit(coreBaseInfo, ctx);
    }

    private byte[] toByteArray(InputStream fis) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = fis.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();
    }
}

