/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptLogCollection;
import com.kingdee.eas.fm.be.EReceiptLogFactory;
import com.kingdee.eas.fm.be.EReceiptLogInfo;
import com.kingdee.eas.fm.be.EReceiptLogTypeEnum;
import com.kingdee.eas.fm.be.LevelEnum;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;

public class EReceiptLogUtils {
    public void addReceiptLog(Context ctx, String bankNumber, Date transDate, String errorMsg, String message, String logDetail, EReceiptLogTypeEnum logType, LevelEnum level) throws BOSException, EASBizException {
        EReceiptLogInfo eReceiptLogInfo = new EReceiptLogInfo();
        eReceiptLogInfo.setBankNumber(bankNumber);
        eReceiptLogInfo.setTransDate(transDate);
        if (errorMsg.length() > 200) {
            errorMsg = errorMsg.substring(0, 200);
        }
        eReceiptLogInfo.setErrorMessage(errorMsg);
        eReceiptLogInfo.setMessage(message);
        eReceiptLogInfo.setLogDetail(logDetail);
        eReceiptLogInfo.setLogType(logType);
        eReceiptLogInfo.setLevel(level);
        EReceiptFactory.getLocalInstance(ctx).insertReceiptLog(eReceiptLogInfo);
    }

    public void saveReceiptLog(Context ctx, String bankNumber, Date transDate, String errorMsg, String message, String logDetail, EReceiptLogTypeEnum logType, LevelEnum level) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("transDate", (Object)transDate, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bankNumber", (Object)bankNumber, CompareType.EQUALS));
        view.setFilter(filter);
        EReceiptLogCollection colls = EReceiptLogFactory.getLocalInstance(ctx).getEReceiptLogCollection(view);
        if (errorMsg.length() > 200) {
            errorMsg = errorMsg.substring(0, 200);
        }
        if (colls != null && colls.size() > 0) {
            EReceiptLogInfo eReceiptLogInfo = colls.get(0);
            eReceiptLogInfo.setErrorMessage(errorMsg);
            eReceiptLogInfo.setMessage(message);
            eReceiptLogInfo.setLogDetail(logDetail);
            eReceiptLogInfo.setLogType(logType);
            eReceiptLogInfo.setLevel(level);
            EReceiptLogFactory.getLocalInstance(ctx).updateEReceiptLog(eReceiptLogInfo);
        } else {
            EReceiptLogInfo eReceiptLogInfo = new EReceiptLogInfo();
            eReceiptLogInfo.setBankNumber(bankNumber);
            eReceiptLogInfo.setTransDate(transDate);
            eReceiptLogInfo.setErrorMessage(errorMsg);
            eReceiptLogInfo.setMessage(message);
            eReceiptLogInfo.setLogDetail(logDetail);
            eReceiptLogInfo.setLogType(logType);
            eReceiptLogInfo.setLevel(level);
            EReceiptFactory.getLocalInstance(ctx).insertReceiptLog(eReceiptLogInfo);
        }
    }

    public void deleteEReceiptLog(Context ctx) throws BOSException, EASBizException {
        Date today = new Date();
        Calendar date = Calendar.getInstance();
        date.setTime(today);
        date.set(5, date.get(5) - 90);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)date.getTime(), CompareType.LESS));
        EReceiptLogFactory.getLocalInstance(ctx).delete(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
    }
}

