/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.IContextProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.KDNoteWebServerHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.be.EReceiptLogTypeEnum;
import com.kingdee.eas.fm.be.EReceiptTemplateCollection;
import com.kingdee.eas.fm.be.EReceiptTemplateFactory;
import com.kingdee.eas.fm.be.EReceiptTemplateInfo;
import com.kingdee.eas.fm.be.ISFTPServiceAdd;
import com.kingdee.eas.fm.be.LevelEnum;
import com.kingdee.eas.fm.be.SFTPServiceAddCollection;
import com.kingdee.eas.fm.be.SFTPServiceAddFactory;
import com.kingdee.eas.fm.be.SFTPServiceAddInfo;
import com.kingdee.eas.fm.be.app.EReceiptDBUtils;
import com.kingdee.eas.fm.be.app.EReceiptDataProvider;
import com.kingdee.eas.fm.be.app.EReceiptLogUtils;
import com.kingdee.eas.fm.be.app.util.EReceiptSFtpUtil;
import com.kingdee.eas.fm.be.vo.FtpVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EReceiptPDFUtils {
    private EReceiptSFtpUtil eReceiptFtpUtil = new EReceiptSFtpUtil();
    private EReceiptLogUtils eReceiptLogUtils = new EReceiptLogUtils();
    private Logger logger = Logger.getLogger(EReceiptPDFUtils.class);
    private SimpleDateFormat dft = new SimpleDateFormat("yyyyMMdd");
    private Map<String, String> templateMap = new HashMap<String, String>();

    public byte[] getPDFByteAarry(Context ctx, EReceiptInfo eReceiptInfo) throws BOSException, EASBizException {
        byte[] fileValue = null;
        String msg = "\u94f6\u884c\u8d26\u53f7\uff1a" + eReceiptInfo.getBankNumber() + " \u4ea4\u6613\u65e5\u671f\uff1a" + this.dft.format(eReceiptInfo.getTransDate()) + " detailNO:" + eReceiptInfo.getDetailNo();
        if (eReceiptInfo.getFileFlag().equals("1")) {
            FtpVO ftpVO;
            ISFTPServiceAdd iSFTPServiceAdd = SFTPServiceAddFactory.getLocalInstance(ctx);
            SFTPServiceAddCollection sftpColl = iSFTPServiceAdd.getSFTPServiceAddCollection();
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)sftpColl)) {
                ftpVO = new FtpVO(sftpColl.get(0));
            } else {
                if (EmptyUtil.isEmpty((String)eReceiptInfo.getIp())) {
                    throw new BEException(BEException.SFTP_NOT_CONFIG);
                }
                ftpVO = new FtpVO(eReceiptInfo);
                SFTPServiceAddInfo sftpInfo = new SFTPServiceAddInfo();
                sftpInfo.setSFTPServiceAddress(eReceiptInfo.getIp());
                sftpInfo.setSFTPPort(eReceiptInfo.getPort());
                sftpInfo.setSFTPUser(eReceiptInfo.getUsername());
                sftpInfo.setSFTPUserPassword(eReceiptInfo.getPassword());
                iSFTPServiceAdd.save((CoreBaseInfo)sftpInfo);
            }
            this.logger.error((Object)("\u5f00\u59cb\u4e0b\u8f7d\u7535\u5b50\u56de\u5355PDF\uff0c" + msg));
            String remotePath = eReceiptInfo.getFilePath();
            fileValue = this.downloadFileFromFTP(ctx, ftpVO, remotePath, eReceiptInfo.getBankNumber(), eReceiptInfo.getTransDate());
            this.logger.error((Object)("\u7ed3\u675f\u4e0b\u8f7d\u7535\u5b50\u56de\u5355PDF\uff0c" + msg));
        } else if (eReceiptInfo.getIsMatch() == EReceiptIsMatchEnum.AutoMatic) {
            this.logger.error((Object)("\u5f00\u59cb\u8f6c\u6362\u7535\u5b50\u56de\u5355PDF\uff0c" + msg));
            try {
                fileValue = this.parsePDFByTDTemplate(ctx, eReceiptInfo.getId());
            }
            catch (Exception e) {
                this.eReceiptLogUtils.addReceiptLog(ctx, eReceiptInfo.getBankNumber(), eReceiptInfo.getTransDate(), "\u3010\u975ePDF\u683c\u5f0f\u56de\u5355\u8f6c\u6362\u5f02\u5e38\uff01\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage(), "\u8bf7\u73b0\u573a\u5728 web\u9875\u9762\u3010\u683c\u5f0f\u8bbe\u7f6e\u3011 \u68c0\u67e5 \u662f\u5426\u6709\u8be5\u94f6\u884c\u5bf9\u5e94\u7684\u7535\u5b50\u56de\u5355\u5957\u6253\u6a21\u677f  \u6216 \u8054\u7cfb\u73b0\u573a\u5b9e\u65bd\uff01", this.eReceiptLogUtils.getStackTrace(e), EReceiptLogTypeEnum.DOWNPDF, LevelEnum.ERROR);
                e.printStackTrace();
                throw new BEException(null);
            }
            this.logger.error((Object)("\u7ed3\u675f\u8f6c\u6362\u7535\u5b50\u56de\u5355PDF\uff0c" + msg));
        } else {
            this.eReceiptLogUtils.addReceiptLog(ctx, eReceiptInfo.getBankNumber(), eReceiptInfo.getTransDate(), "\u8be5\u7535\u5b50\u56de\u5355\u672a\u5339\u914d\u4ea4\u6613\u660e\u7ec6\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\uff01", "\u8bf7\u6267\u884c\u7535\u5b50\u56de\u5355\u5339\u914d\u4e8b\u52a1\uff01", null, EReceiptLogTypeEnum.DOWNPDF, LevelEnum.ERROR);
            throw new BEException(null);
        }
        return fileValue;
    }

    protected byte[] downloadFileFromFTP(Context ctx, FtpVO ftpVO, String remotePath, String bankNumber, Date transDate) throws BOSException, EASBizException {
        byte[] fileValue = null;
        String msg = "";
        try {
            try {
                this.eReceiptFtpUtil.getConnect(ftpVO);
            }
            catch (Exception e1) {
                this.eReceiptLogUtils.addReceiptLog(ctx, bankNumber, transDate, "\u3010\u8fde\u63a5\u56de\u5355FTP\u670d\u52a1\u5668\u5931\u8d25\u3011" + msg, "\u8bf7\u73b0\u573a\u6839\u636e \u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u7684IP\u3001\u7aef\u53e3\u3001\u7528\u6237\u540d \u548c \u5bc6\u7801\uff0c\u68c0\u67e5FTP\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6b63\u5e38\uff01", this.eReceiptLogUtils.getStackTrace(e1), EReceiptLogTypeEnum.DOWNPDF, LevelEnum.ERROR);
                e1.printStackTrace();
                throw new BEException(null);
            }
            try {
                fileValue = this.eReceiptFtpUtil.downloadFile(remotePath);
            }
            catch (Exception e2) {
                this.eReceiptLogUtils.addReceiptLog(ctx, bankNumber, transDate, "\u3010\u4e0b\u8f7d\u56de\u5355PDF\u6587\u4ef6\u5931\u8d25\u3011" + msg, "\u8bf7\u73b0\u573a\u6839\u636e \u4e0b\u8f7d\u56de\u5355\u7684ip\u7aef\u53e3\u7b49\u4fe1\u606f\uff0c\u68c0\u67e5FTP\u670d\u52a1\u5668\u662f\u5426\u5b58\u5728\u8be5\u56de\u5355PDF\u6587\u4ef6  \u6216 \u8054\u7cfb\u73b0\u573a\u5b9e\u65bd\uff01", this.eReceiptLogUtils.getStackTrace(e2), EReceiptLogTypeEnum.DOWNPDF, LevelEnum.ERROR);
                e2.printStackTrace();
                throw new BEException(null);
            }
            this.logger.error((Object)(" \u6210\u529f  " + msg));
        }
        catch (Exception e) {
            try {
                this.eReceiptFtpUtil.closeChannel();
            }
            catch (Exception e1) {
                this.logger.error((Object)"\u5173\u95edFTP\u8fde\u63a5\u5931\u8d25");
                e1.printStackTrace();
            }
            if (e instanceof BEException) {
                throw new BEException(null);
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                this.eReceiptFtpUtil.closeChannel();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)"\u5173\u95edFTP\u8fde\u63a5\u5931\u8d25");
            }
        }
        return fileValue;
    }

    protected byte[] parsePDFByTDTemplate(Context ctx, BOSUuid eReceiptId) throws EASBizException, BOSException {
        ArrayList<BOSUuid> billIDList = new ArrayList<BOSUuid>();
        billIDList.add(eReceiptId);
        String templatePath = this.getTemplatePath(ctx, eReceiptId.toString());
        this.logger.error((Object)("\u83b7\u53d6\u5230\u5957\u6253\u6a21\u677f\u8def\u5f84\uff1a" + templatePath));
        String type = "PDF";
        MetaDataPK tdQuery = new MetaDataPK("com.kingdee.eas.fm.be.app.EReceiptTDQuery");
        ByteArrayOutputStream bospdf = new ByteArrayOutputStream();
        EReceiptDataProvider provider = new EReceiptDataProvider(ctx, billIDList, (IMetaDataPK)tdQuery);
        KDNoteWebServerHelper webHelper = new KDNoteWebServerHelper();
        final Context ctxTd = ctx;
        webHelper.setContextProvider(new IContextProvider(){

            public IBizContext getBizContext(Context bosCtx) {
                IBizContext ctx = null;
                try {
                    ctx = KDNoteHelper.makeContext((Context)ctxTd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                return ctx;
            }
        });
        webHelper.exportPDF(templatePath, (Object)provider, (OutputStream)bospdf);
        this.logger.error((Object)"\u8f6c\u6362PDF\u5b8c\u6210");
        byte[] fileValue = bospdf.toByteArray();
        return fileValue;
    }

    protected String getTemplatePath(Context ctx, String billID) throws EASBizException, BOSException {
        String templatePath = "/FM/BE/ERECEIPT/";
        EReceiptDBUtils eReceiptDBUtils = new EReceiptDBUtils();
        EReceiptCollection colls = eReceiptDBUtils.getEReceiptCollectionById(ctx, billID);
        if (colls.size() > 0) {
            EReceiptInfo eReceiptInfo = colls.get(0);
            AccountBankInfo accountBankInfo = eReceiptInfo.getBankAccount();
            String bankInterFaceID = accountBankInfo.getBankInterFaceID();
            String BankInterFace = accountBankInfo.getBankInterFace();
            templatePath = templatePath + this.getEReceiptTemplate(ctx, bankInterFaceID, BankInterFace);
        }
        return templatePath;
    }

    protected String getEReceiptTemplate(Context ctx, String bankInterFaceID, String BankInterFace) throws EASBizException, BOSException {
        String templateName = "";
        String templateNameMap = this.templateMap.get(bankInterFaceID);
        if (templateNameMap != null) {
            templateName = templateNameMap;
            return templateName;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("templateID"));
        view.setSelector(selectorItemCollection);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankinterfaceId", (Object)bankInterFaceID, CompareType.EQUALS));
        view.setFilter(filter);
        EReceiptTemplateCollection colls = EReceiptTemplateFactory.getLocalInstance(ctx).getEReceiptTemplateCollection(view);
        if (colls.size() <= 0) {
            throw new BOSException("\u8bf7\u914d\u7f6e\u3010" + BankInterFace + "\u3011  \u7535\u5b50\u56de\u5355\u5957\u6253\u6a21\u677f\uff01");
        }
        EReceiptTemplateInfo templateInfo = colls.get(0);
        templateName = templateInfo.getTemplateID();
        return templateName;
    }
}

