/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.EReceiptPrintEnum;
import com.kingdee.eas.fm.be.EReceiptReprintCollection;
import com.kingdee.eas.fm.be.EReceiptReprintEntryCollection;
import com.kingdee.eas.fm.be.EReceiptReprintEntryInfo;
import com.kingdee.eas.fm.be.EReceiptReprintFactory;
import com.kingdee.eas.fm.be.EReceiptReprintInfo;
import com.kingdee.eas.fm.be.FmBeEReceiptException;
import com.kingdee.eas.fm.be.app.AbstractEReceiptReprintControllerBean;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class EReceiptReprintControllerBean
extends AbstractEReceiptReprintControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.EReceiptReprintControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String permissionName = "fm_be_eReceiptReprint_03Audit";
        if (!this.exists(ctx, pk)) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        EReceiptReprintInfo billInfo = this.getEReceiptReprintInfo(ctx, pk);
        if (billInfo.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
            throw new FmBeEReceiptException(FmBeEReceiptException.AUDITED, new Object[]{billInfo.getNumber()});
        }
        boolean isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId().toString()), permissionName);
        if (!isPermission) {
            throw new FmBeEReceiptException(FmBeEReceiptException.NO_REPRINTAUDIT_PRMITITEM, new Object[]{billInfo.getNumber()});
        }
        billInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        this.update(ctx, pk, (CoreBaseInfo)billInfo);
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String permissionName = "fm_be_eReceiptReprint_04UnAudit";
        if (!this.exists(ctx, pk)) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        EReceiptReprintInfo billInfo = this.getEReceiptReprintInfo(ctx, pk);
        if (billInfo.getCheckedStatus() == CheckedStatusEnum.UNAUDITED) {
            throw new FmBeEReceiptException(FmBeEReceiptException.UNAUDITED, new Object[]{billInfo.getNumber()});
        }
        if (billInfo.getPrintStatus() == EReceiptPrintEnum.Printed) {
            throw new FmBeEReceiptException(FmBeEReceiptException.UNAUDITED, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
        }
        boolean isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId().toString()), permissionName);
        if (!isPermission) {
            throw new FmBeEReceiptException(FmBeEReceiptException.NO_REPRINTUNAUDIT_PRMITITEM, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
        }
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        this.update(ctx, pk, (CoreBaseInfo)billInfo);
    }

    @Override
    protected List _getEReceiptIdList(Context ctx, String id) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("printStatus"));
        sic.add(new SelectorItemInfo("entrys.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        view.setFilter(filter);
        EReceiptReprintCollection coll = EReceiptReprintFactory.getLocalInstance(ctx).getEReceiptReprintCollection(view);
        EReceiptReprintInfo info = coll.get(0);
        EReceiptReprintEntryCollection entryCollection = info.getEntrys();
        if (!info.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED) || info.getPrintStatus().equals((Object)EReceiptPrintEnum.Printed)) {
            throw new FmBeEReceiptException(FmBeEReceiptException.NO_AUDIT);
        }
        StringBuffer rePrintID = new StringBuffer("");
        EReceiptReprintEntryInfo entryInfo = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            entryInfo = entryCollection.get(i);
            result.add(entryInfo.getEreceiptId());
        }
        return result;
    }
}

