/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.TransDownBillEntryFactory;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillEntryFactory;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class EReceiptServerHelper {
    static HashMap<String, String> hashMap = new HashMap();

    public static void setMap() {
        hashMap.put("transDetail", new TransDetailInfo().getBOSType().toString());
        hashMap.put("paymentBill", new PaymentBillInfo().getBOSType().toString());
        hashMap.put("receivingBill", new ReceivingBillInfo().getBOSType().toString());
        hashMap.put("transUpBill", new TransUpBillInfo().getBOSType().toString());
        hashMap.put("transDownBill", new TransDownBillInfo().getBOSType().toString());
        hashMap.put("settlementBill", new SettlementBillInfo().getBOSType().toString());
        hashMap.put("bizAccountBill", new BizAccountBillInfo().getBOSType().toString());
        hashMap.put("dailyLoanBill", new DailyLoanBillInfo().getBOSType().toString());
        hashMap.put("dailyPurchaseAccountBill", new DailyPurchaseAccountBillInfo().getBOSType().toString());
        hashMap.put("travelAccountBill", new TravelAccountBillInfo().getBOSType().toString());
        hashMap.put("evectionLoanBill", new EvectionLoanBillInfo().getBOSType().toString());
        hashMap.put("bizAccountOutBill", new BizAccountOutBillInfo().getBOSType().toString());
    }

    public static EReceiptCollection getEReceiptInfo(Context ctx, String voucherId) throws BOSException {
        String bosType;
        String id;
        int i;
        EReceiptCollection ereceiptColl = new EReceiptCollection();
        EReceiptServerHelper.setMap();
        List<String> BillId = EReceiptServerHelper.getRelateBills(ctx, voucherId);
        ArrayList<String> BillColl = new ArrayList<String>();
        if (BillId.size() >= 1) {
            for (i = 0; i < BillId.size(); ++i) {
                id = BillId.get(i);
                bosType = BOSUuid.read((String)id).getType().toString();
                if (bosType.equals(hashMap.get("bizAccountBill")) || bosType.equals(hashMap.get("dailyLoanBill")) || bosType.equals(hashMap.get("dailyPurchaseAccountBill")) || bosType.equals(hashMap.get("travelAccountBill")) || bosType.equals(hashMap.get("evectionLoanBill")) || bosType.equals(hashMap.get("bizAccountOutBill"))) {
                    try {
                        Vector<String> paymentBill = EReceiptServerHelper.getRelateBills2(ctx, "srcObjectID", "destObjectID", id);
                        if (paymentBill.size() < 1) continue;
                        BillColl.addAll(paymentBill);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                BillColl.add(id);
            }
        }
        if (BillColl.size() >= 1) {
            for (i = 0; i < BillColl.size(); ++i) {
                EReceiptInfo info;
                id = (String)BillColl.get(i);
                bosType = BOSUuid.read((String)id).getType().toString();
                if (!bosType.equals(hashMap.get("paymentBill")) && !bosType.equals(hashMap.get("settlementBill")) && !bosType.equals(hashMap.get("transDownBill")) && !bosType.equals(hashMap.get("transUpBill")) && !bosType.equals(hashMap.get("receivingBill")) || EmptyUtil.isEmpty((CoreBaseInfo)(info = EReceiptServerHelper.getEReceiptByBillId(ctx, id)))) continue;
                ereceiptColl.add(info);
            }
        }
        return ereceiptColl;
    }

    public static EReceiptInfo getEReceiptByBillId(Context ctx, String billId) throws BOSException {
        if (hashMap.size() == 0) {
            EReceiptServerHelper.setMap();
        }
        String bosType = BOSUuid.read((String)billId).getType().toString();
        EReceiptInfo info = new EReceiptInfo();
        List<String> transDetailIdSet = EReceiptServerHelper.getRelateBills(ctx, billId);
        String transDetailId = "";
        if (transDetailIdSet.size() >= 1) {
            for (int m = 0; m < transDetailIdSet.size(); ++m) {
                String detailBosType = BOSUuid.read((String)transDetailIdSet.get(m)).getType().toString();
                if (!detailBosType.equals(hashMap.get("transDetail"))) continue;
                transDetailId = transDetailIdSet.get(m);
            }
        }
        if (EmptyUtil.isEmpty((String)transDetailId)) {
            String bankCheckFlag;
            if (bosType.equals(hashMap.get("paymentBill"))) {
                PaymentBillInfo paymentBillInfo;
                String bankCheckFlag2;
                EntityViewInfo paymentBillView = new EntityViewInfo();
                SelectorItemCollection paymentBillSic = new SelectorItemCollection();
                paymentBillSic.add(new SelectorItemInfo("bankCheckFlag"));
                paymentBillView.setSelector(paymentBillSic);
                FilterInfo paymentBillFilter = new FilterInfo();
                paymentBillFilter.getFilterItems().add(new FilterItemInfo("id", (Object)billId, CompareType.EQUALS));
                paymentBillView.setFilter(paymentBillFilter);
                PaymentBillCollection paymentBillCollection = new PaymentBillCollection();
                paymentBillCollection = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(paymentBillView);
                if (paymentBillCollection.size() > 0 && (bankCheckFlag2 = (paymentBillInfo = paymentBillCollection.get(0)).getBankCheckFlag()) != null) {
                    transDetailId = EReceiptServerHelper.getTransDetailId(ctx, bankCheckFlag2);
                }
            } else if (bosType.equals(hashMap.get("settlementBill"))) {
                SettlementBillInfo bill;
                CoreBaseCollection baseCollection = new CoreBaseCollection();
                baseCollection = SettlementBillFactory.getLocalInstance((Context)ctx).getCollection(EReceiptServerHelper.getViewInfo(billId));
                if (baseCollection.size() > 0 && (bankCheckFlag = (bill = (SettlementBillInfo)baseCollection.get(0)).getReqSeqNo()) != null) {
                    transDetailId = EReceiptServerHelper.getTransDetailId(ctx, bankCheckFlag);
                }
            } else if (bosType.equals(hashMap.get("transDownBill"))) {
                TransDownBillEntryInfo transDownBillEntryInfo;
                CoreBaseCollection transDownEntryCollection = new CoreBaseCollection();
                transDownEntryCollection = TransDownBillEntryFactory.getLocalInstance((Context)ctx).getCollection(EReceiptServerHelper.getViewInfo(billId));
                if (transDownEntryCollection.size() > 0 && (bankCheckFlag = (transDownBillEntryInfo = (TransDownBillEntryInfo)transDownEntryCollection.get(0)).getReqSeqNo()) != null) {
                    transDetailId = EReceiptServerHelper.getTransDetailId(ctx, bankCheckFlag);
                }
            } else if (bosType.equals(hashMap.get("transUpBill"))) {
                TransUpBillEntryInfo transUpEntryInfo;
                CoreBaseCollection transUpEntryCollection = new CoreBaseCollection();
                transUpEntryCollection = TransUpBillEntryFactory.getLocalInstance((Context)ctx).getCollection(EReceiptServerHelper.getViewInfo(billId));
                if (transUpEntryCollection.size() > 0 && (bankCheckFlag = (transUpEntryInfo = (TransUpBillEntryInfo)transUpEntryCollection.get(0)).getReqSeqNo()) != null) {
                    transDetailId = EReceiptServerHelper.getTransDetailId(ctx, bankCheckFlag);
                }
            }
        }
        if (!EmptyUtil.isEmpty((String)transDetailId)) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            selectorItemCollection.add(new SelectorItemInfo("recedBillType"));
            selectorItemCollection.add(new SelectorItemInfo("recedBillNumber"));
            selectorItemCollection.add(new SelectorItemInfo("bankCheckFlag"));
            selectorItemCollection.add(new SelectorItemInfo("fileSource"));
            view.setSelector(selectorItemCollection);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("transDetailId", (Object)transDetailId, CompareType.EQUALS));
            view.setFilter(filter);
            EReceiptCollection colls = new EReceiptCollection();
            colls = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(view);
            if (colls.size() > 0) {
                info = colls.get(0);
            }
        }
        return info;
    }

    public static EntityViewInfo getViewInfo(String billId) {
        EntityViewInfo billView = new EntityViewInfo();
        SelectorItemCollection billSic = new SelectorItemCollection();
        billSic.add(new SelectorItemInfo("reqSeqNo"));
        billView.setSelector(billSic);
        FilterInfo billFilter = new FilterInfo();
        billFilter.getFilterItems().add(new FilterItemInfo("id", (Object)billId, CompareType.EQUALS));
        billView.setFilter(billFilter);
        return billView;
    }

    public static String getTransDetailId(Context ctx, String bankCheckFlag) throws BOSException {
        String tid = "";
        EntityViewInfo transDetailView = new EntityViewInfo();
        SelectorItemCollection transDetailSic = new SelectorItemCollection();
        transDetailSic.add(new SelectorItemInfo("bankCheckFlag"));
        transDetailSic.add(new SelectorItemInfo("id"));
        transDetailView.setSelector(transDetailSic);
        FilterInfo transDetailFilter = new FilterInfo();
        transDetailFilter.getFilterItems().add(new FilterItemInfo("bankCheckFlag", (Object)bankCheckFlag, CompareType.EQUALS));
        transDetailView.setFilter(transDetailFilter);
        TransDetailCollection transDetailColl = new TransDetailCollection();
        transDetailColl = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(transDetailView);
        if (transDetailColl.size() > 0) {
            String transId;
            TransDetailInfo transDetailInfo = transDetailColl.get(0);
            tid = transId = transDetailInfo.getId().toString();
        }
        return tid;
    }

    public static List<String> getRelateBills(Context ctx, String billInfoID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)billInfoID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        ArrayList<String> relateBills = new ArrayList<String>();
        IQueryExecutor exec = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        try {
            IRowSet rs = exec.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    relateBills.add(rs.getString("srcObjectID"));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return relateBills;
    }

    public static List getEreceiptIdByTransDetailId(Context ctx, Set transdetailIds) throws EASBizException, BOSException {
        ArrayList<String> result = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        view.setSelector(selectorItemCollection);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("transDetailId", (Object)transdetailIds, CompareType.INCLUDE));
        view.setFilter(filter);
        EReceiptCollection colls = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            result.add(colls.get(i).getId().toString());
        }
        return result;
    }

    public static Vector<String> getRelateBills2(Context ctx, String filterName, String resultName, String billInfoID) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(filterName, (Object)billInfoID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        Vector<String> relateBills = new Vector<String>();
        IQueryExecutor exec = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        try {
            IRowSet rs = exec.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    relateBills.add(rs.getString(resultName));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return relateBills;
    }

    public static List getTransDetailByEreceiptId(Context ctx, String ereceiptId) throws BOSException, EASBizException {
        ArrayList<TransDetailInfo> result = new ArrayList<TransDetailInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("detailNo"));
        sic.add(new SelectorItemInfo("transDetailId"));
        EReceiptInfo ereceiptInfo = EReceiptFactory.getLocalInstance(ctx).getEReceiptInfo((IObjectPK)new ObjectUuidPK(ereceiptId), sic);
        if (!EmptyUtil.isEmpty((String)ereceiptInfo.getTransDetailId())) {
            result.add(TransDetailFactory.getLocalInstance(ctx).getTransDetailInfo((IObjectPK)new ObjectUuidPK(ereceiptInfo.getTransDetailId())));
        }
        return result;
    }

    public static EReceiptCollection getEReceiptByVoucherId(Context ctx, String voucherId) throws BOSException {
        String bosType;
        String id;
        int i;
        EReceiptCollection ereceiptColl = new EReceiptCollection();
        EReceiptServerHelper.setMap();
        List<String> BillId = EReceiptServerHelper.getRelateBills(ctx, voucherId);
        ArrayList<String> BillColl = new ArrayList<String>();
        if (BillId.size() >= 1) {
            for (i = 0; i < BillId.size(); ++i) {
                id = BillId.get(i);
                bosType = BOSUuid.read((String)id).getType().toString();
                if (bosType.equals(hashMap.get("bizAccountBill")) || bosType.equals(hashMap.get("dailyLoanBill")) || bosType.equals(hashMap.get("dailyPurchaseAccountBill")) || bosType.equals(hashMap.get("travelAccountBill")) || bosType.equals(hashMap.get("evectionLoanBill")) || bosType.equals(hashMap.get("bizAccountOutBill"))) {
                    try {
                        Vector<String> paymentBill = EReceiptServerHelper.getRelateBills2(ctx, "srcObjectID", "destObjectID", id);
                        if (paymentBill.size() < 1) continue;
                        BillColl.addAll(paymentBill);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                BillColl.add(id);
            }
        }
        if (BillColl.size() >= 1) {
            for (i = 0; i < BillColl.size(); ++i) {
                EReceiptInfo info;
                id = (String)BillColl.get(i);
                bosType = BOSUuid.read((String)id).getType().toString();
                if (!bosType.equals(hashMap.get("paymentBill")) && !bosType.equals(hashMap.get("settlementBill")) && !bosType.equals(hashMap.get("transDownBill")) && !bosType.equals(hashMap.get("transUpBill")) && !bosType.equals(hashMap.get("receivingBill")) || EmptyUtil.isEmpty((CoreBaseInfo)(info = EReceiptServerHelper.getEReceiptByBillId(ctx, id)))) continue;
                ereceiptColl.add(info);
            }
        }
        return ereceiptColl;
    }
}

