/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.be.EReceiptLogTypeEnum;
import com.kingdee.eas.fm.be.EReceiptPrintEnum;
import com.kingdee.eas.fm.be.EReceiptReprintCollection;
import com.kingdee.eas.fm.be.EReceiptReprintEntryCollection;
import com.kingdee.eas.fm.be.EReceiptReprintEntryInfo;
import com.kingdee.eas.fm.be.EReceiptReprintFactory;
import com.kingdee.eas.fm.be.EReceiptReprintInfo;
import com.kingdee.eas.fm.be.FmBeEReceiptException;
import com.kingdee.eas.fm.be.IEReceipt;
import com.kingdee.eas.fm.be.IEReceiptReprint;
import com.kingdee.eas.fm.be.LevelEnum;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.app.AbstractEReceiptWebFacadeControllerBean;
import com.kingdee.eas.fm.be.app.EReceiptDBUtils;
import com.kingdee.eas.fm.be.app.EReceiptLogUtils;
import com.kingdee.eas.fm.be.app.EReceiptServerHelper;
import com.kingdee.eas.fm.be.util.BatchBillProcessResult;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.erec.EreceiptLinkHelper;
import com.kingdee.eas.fm.erec.app.service.VoucherEreceiptService;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EReceiptWebFacadeControllerBean
extends AbstractEReceiptWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.EReceiptWebFacadeControllerBean");
    private static final String resourcePath = "com.kingdee.eas.fm.be.FmBeEReceiptRescource";
    private EReceiptDBUtils eReceiptDBUtils = new EReceiptDBUtils();
    private final String EAS_HOME = System.getProperty("EAS_HOME");
    private final String EAS_WEB_TMP_PATH = this.EAS_HOME + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear" + File.separator + "tmp";

    @Override
    protected Map _getTransDetailUIDefaultValue(Context ctx, boolean isShare, String prmitItems, Set idSet) throws BOSException, EASBizException {
        int i;
        HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        CompanyOrgUnitInfo validCompanyInfo = null;
        ArrayList companyIdList = new ArrayList(idSet);
        if (companyIdList.contains(companyInfo.getId().toString())) {
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
            if (companyInfo.isIsBizUnit()) {
                validCompanyInfo = companyInfo;
            } else {
                for (i = 0; i < companyIdList.size(); ++i) {
                    companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK((String)companyIdList.get(i)));
                    if (!companyInfo.isIsBizUnit()) continue;
                    validCompanyInfo = companyInfo;
                    break;
                }
            }
        } else {
            for (i = 0; i < companyIdList.size(); ++i) {
                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK((String)companyIdList.get(i)));
                if (!companyInfo.isIsBizUnit()) continue;
                validCompanyInfo = companyInfo;
                break;
            }
        }
        if (validCompanyInfo == null) {
            throw new FmBeEReceiptException(FmBeEReceiptException.NO_ERECEIPTVIEW_PRMITITEM);
        }
        defaultValueMap.put("DEFAULT_COMPANY", validCompanyInfo);
        if (companyIdList != null && companyIdList.size() > 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("unit.id", (Object)idSet, CompareType.INCLUDE));
            defaultValueMap.put("VALID_COMPANYIDS", fi.toString());
        }
        return defaultValueMap;
    }

    @Override
    protected String _getAuthorizedOrgFilter_F7Special(Context ctx, String prmitItems, boolean includeVirtual, String unitFiled, String treeFiled) throws BOSException, EASBizException {
        String filter = CASWebHelper.getAuthorizedOrgFilter_F7Special((Context)ctx, (String)prmitItems, (boolean)includeVirtual, (String)unitFiled, (String)treeFiled);
        return filter;
    }

    @Override
    protected Map _choseEReceipt(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap mapResult = new HashMap();
        ArrayList<Map<String, Object>> loadData = new ArrayList<Map<String, Object>>();
        EReceiptCollection eReceiptCollection = new EReceiptCollection();
        String newSelectedIdSetString = paramMap.get("newSelectedIdSetString").toString();
        String eReceiptInEdit = paramMap.get("curcardIDsInCurrentDispatchBillEdit").toString();
        String[] eReceiptIdAfterMerge = new String[]{};
        for (String newSelectedId : eReceiptIdAfterMerge = this.getStringIntersection(newSelectedIdSetString, eReceiptInEdit)) {
            EReceiptInfo eReceiptInfo = this.getEreceiptinfo(newSelectedId, ctx);
            Map<String, Object> row = this.convtDisEntryBillToRow(ctx, eReceiptInfo);
            loadData.add(row);
        }
        mapResult.put("onloadData", loadData);
        return mapResult;
    }

    private Map<String, Object> convtDisEntryBillToRow(Context ctx, EReceiptInfo eReceiptInfo) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        row.put("companyName", eReceiptInfo.getCompany() == null ? companyInfo.getName() : eReceiptInfo.getCompany().getName());
        row.put("transDate", eReceiptInfo.getTransDate() == null ? "" : eReceiptInfo.getTransDate());
        row.put("bankAddress", eReceiptInfo.getBank() == null ? "" : eReceiptInfo.getBank().getName());
        row.put("bankAccountNumber", eReceiptInfo.getBankAccount() == null ? "" : eReceiptInfo.getBankAccount().getNumber());
        row.put("accountNumber", eReceiptInfo.getBankAccount() == null ? "" : eReceiptInfo.getBankAccount().getBankAccountNumber());
        row.put("bankAccountName", eReceiptInfo.getBankAccount() == null ? "" : eReceiptInfo.getBankAccount().getName());
        row.put("currencyName", eReceiptInfo.getCurrency() == null ? "" : eReceiptInfo.getCurrency().getName());
        row.put("ereceiptId", eReceiptInfo.getId().toString());
        row.put("fileName", eReceiptInfo.getFileName());
        return row;
    }

    private String[] getStringIntersection(String newSelectedIdSetString, String ereceiptIDsInCurrentBillEdit) {
        String[] ereceiptIdAfterMerge;
        if (!ereceiptIDsInCurrentBillEdit.equals("")) {
            String notRepeatIdStrInNewSelectedCard = "";
            String[] newSelectedIdSetStringArray = newSelectedIdSetString.split(",");
            String[] ereceiptIDsInCurrentDispatchBillEditArray = ereceiptIDsInCurrentBillEdit.split(",");
            for (String newSelectedId : newSelectedIdSetStringArray) {
                boolean isSame = false;
                for (String ereceiptIDInCurrentBill : ereceiptIDsInCurrentDispatchBillEditArray) {
                    if (!newSelectedId.equals(ereceiptIDInCurrentBill)) continue;
                    isSame = true;
                }
                if (isSame) continue;
                notRepeatIdStrInNewSelectedCard = notRepeatIdStrInNewSelectedCard + newSelectedId + ",";
            }
            ereceiptIdAfterMerge = (notRepeatIdStrInNewSelectedCard + ereceiptIDsInCurrentBillEdit).split(",");
        } else {
            ereceiptIdAfterMerge = newSelectedIdSetString.split(",");
        }
        return ereceiptIdAfterMerge;
    }

    private EReceiptInfo getEreceiptinfo(String ereceiptID, Context ctx) throws EASBizException, BOSException {
        EReceiptInfo eReceiptInfo = new EReceiptInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("transDate"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("bankAccount.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("fileName"));
        eReceiptInfo = this.eReceiptDBUtils.getEReceiptyByIdAndSelector(ctx, ereceiptID, sic);
        return eReceiptInfo;
    }

    @Override
    protected String _reprintsubmit(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        HashMap<String, String> resultList = new HashMap<String, String>();
        IObjectPK objectPK = null;
        EReceiptReprintInfo eReceiptReprintInfo = (EReceiptReprintInfo)dataObject;
        CompanyOrgUnitInfo company = eReceiptReprintInfo.getCompany();
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        String param = pc.getParamValue((IObjectPK)new ObjectUuidPK(company.getId()), "EREC001");
        if (param != null && !"true".equals(param)) {
            throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"818_EReceiptWebFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        try {
            EReceiptReprintEntryCollection collection = eReceiptReprintInfo.getEntrys();
            StringBuffer fileName = new StringBuffer("");
            for (int i = 0; i < collection.size(); ++i) {
                EReceiptReprintEntryInfo entryInfo = collection.get(i);
                if (i != collection.size() - 1) {
                    fileName.append(entryInfo.getFileName() + ";");
                    continue;
                }
                fileName.append(entryInfo.getFileName());
            }
            String receiptName = fileName.toString();
            if (receiptName.length() > 800) {
                receiptName = receiptName.substring(0, 200);
            }
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            eReceiptReprintInfo.setReceiptName(receiptName);
            eReceiptReprintInfo.setApplicant(userInfo);
            Date bizDate = new Date();
            SimpleDateFormat dfts = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            bizDate = dfts.parse(dfts.format(bizDate.getTime()));
            eReceiptReprintInfo.setApplicationTime(bizDate);
            eReceiptReprintInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            eReceiptReprintInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            eReceiptReprintInfo.setPrintStatus(EReceiptPrintEnum.NoPrint);
            EReceiptReprintInfo model = eReceiptReprintInfo;
            IEReceiptReprint iEReceiptReprint = EReceiptReprintFactory.getLocalInstance(ctx);
            objectPK = this.getSubmitPkByReprintInfo(ctx, iEReceiptReprint, (CoreBaseInfo)model);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            resultList.put("summaryMsg", e.getMessage());
            resultList.put("detailMsg", e.toString());
            throw new BOSException((Throwable)e);
        }
        return objectPK.toString();
    }

    private IObjectPK getSubmitPkByReprintInfo(Context ctx, IEReceiptReprint iEReceiptReprint, CoreBaseInfo info) throws Exception {
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection btpRelationCollection = EReceiptWebFacadeControllerBean.getBOTRelationColFromExtendProperty(ctx, (IObjectValue)info);
        if (info.get("id") != null) {
            if (btpRelationCollection == null || btpRelationCollection.size() == 0) {
                btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
            }
            objectPK = btpRelationCollection != null && btpRelationCollection.size() > 0 ? iBTPManager.submitRelations((CoreBillBaseInfo)info, btpRelationCollection) : iEReceiptReprint.submit(info);
        } else {
            objectPK = iEReceiptReprint.submit(info);
        }
        return objectPK;
    }

    public static BOTRelationCollection getBOTRelationColFromExtendProperty(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        BOTRelationCollection botCol = new BOTRelationCollection();
        if (model.getExtendedProperty("botrelation") != null) {
            Object o;
            String botrelationStr = model.getExtendedProperty("botrelation");
            ArrayList list = (ArrayList)JSONUtils.convertJsonToObject((Context)ctx, (String)botrelationStr, ArrayList.class);
            for (int i = 0; i < list.size(); ++i) {
                LinkedTreeMap map = (LinkedTreeMap)list.get(i);
                Iterator iterator = map.keySet().iterator();
                BOTRelationInfo info = new BOTRelationInfo();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    if (map.get((Object)key) == null || "date".equals(key)) continue;
                    if ("isEffected".equals(key)) {
                        info.setIsEffected(false);
                        continue;
                    }
                    if ("relationEntries".equals(key)) {
                        info.put(key, (Object)EReceiptWebFacadeControllerBean.getBOTEntryRelation((ArrayList)map.get((Object)key), info));
                        continue;
                    }
                    info.put(key, map.get((Object)key));
                }
                botCol.add(info);
            }
            if (model.containsKey("relationColl") && !EmptyUtil.isEmpty((Object)(o = model.get("relationColl"))) && o instanceof String) {
                model.put("relationColl", (Object)botCol);
            }
            return botCol;
        }
        return null;
    }

    private static BOTRelationEntryCollection getBOTEntryRelation(ArrayList list, BOTRelationInfo relationinfo) {
        if (list == null || list.size() == 0) {
            return null;
        }
        BOTRelationEntryCollection botCol = new BOTRelationEntryCollection();
        for (int i = 0; i < list.size(); ++i) {
            LinkedTreeMap map = (LinkedTreeMap)list.get(i);
            Iterator iterator = map.keySet().iterator();
            BOTRelationEntryInfo info = new BOTRelationEntryInfo();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                if (map.get((Object)key) == null) continue;
                info.put(key, map.get((Object)key));
            }
            info.put("relation", (Object)relationinfo);
            botCol.add(info);
        }
        return botCol;
    }

    @Override
    protected Map _banchDeleteRePrintBill(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        IEReceiptReprint billBase = EReceiptReprintFactory.getLocalInstance(ctx);
        String permissionName = "fm_be_eReceiptReprint_06Delete";
        HashMap permissionMap = new HashMap();
        int success = 0;
        for (int i = 0; i < pks.length; ++i) {
            String pk = pks[i];
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)new ObjectUuidPK(pk))) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                EReceiptReprintInfo billInfo = (EReceiptReprintInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getPermissionSelctor());
                if (billInfo.getEffectedStatus() != EffectedStatusEnum.EFFECTED) {
                    throw new FmBeEReceiptException(FmBeEReceiptException.EFFECTED, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
                }
                if (billInfo.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                    throw new FmBeEReceiptException(FmBeEReceiptException.DELETED, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
                }
                if (permissionMap.get(billInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(billInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        String companyName = (String)map.get("companyName");
                        String number = (String)map.get("number");
                        throw new FmBeEReceiptException(FmBeEReceiptException.NO_REPRINTDEL_PRMITITEM, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", billInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", billInfo.getNumber());
                    permissionMap.put(billInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        throw new FmBeEReceiptException(FmBeEReceiptException.NO_REPRINTDEL_PRMITITEM, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
                    }
                }
                billBase.delete((IObjectPK)new ObjectUuidPK(pk));
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.error((Object)e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            String msg = EASResource.getString((String)resourcePath, (String)"rePrint_delAll");
            resultList.setSummaryMsg(msg);
        } else {
            String msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"rePrint_delPortion"), success, pks.length - success);
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    @Override
    protected Map _banchAuditRePrintBill(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        IEReceiptReprint billBase = EReceiptReprintFactory.getLocalInstance(ctx);
        String permissionName = "fm_be_eReceiptReprint_03Audit";
        HashMap permissionMap = new HashMap();
        int success = 0;
        for (int i = 0; i < pks.length; ++i) {
            String pk = pks[i];
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)new ObjectUuidPK(pk))) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                EReceiptReprintInfo billInfo = (EReceiptReprintInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getPermissionSelctor());
                if (billInfo.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                    throw new FmBeEReceiptException(FmBeEReceiptException.AUDITED, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
                }
                if (permissionMap.get(billInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(billInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        throw new FmBeEReceiptException(FmBeEReceiptException.NO_REPRINTAUDIT_PRMITITEM, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", billInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", billInfo.getNumber());
                    permissionMap.put(billInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        throw new FmBeEReceiptException(FmBeEReceiptException.NO_REPRINTAUDIT_PRMITITEM, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
                    }
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("checkedStatus"));
                billInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
                billBase.updatePartial((CoreBaseInfo)billInfo, sic);
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.error((Object)e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            String msg = EASResource.getString((String)resourcePath, (String)"rePrint_auditAll");
            resultList.setSummaryMsg(msg);
        } else {
            String msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"rePrint_auditPortion"), success, pks.length - success);
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    @Override
    protected Map _banchUnAuditRePrintBill(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        IEReceiptReprint billBase = EReceiptReprintFactory.getLocalInstance(ctx);
        String permissionName = "fm_be_eReceiptReprint_04UnAudit";
        HashMap permissionMap = new HashMap();
        int success = 0;
        for (int i = 0; i < pks.length; ++i) {
            String pk = pks[i];
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)new ObjectUuidPK(pk))) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                EReceiptReprintInfo billInfo = (EReceiptReprintInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getPermissionSelctor());
                if (billInfo.getCheckedStatus() == CheckedStatusEnum.UNAUDITED) {
                    throw new FmBeEReceiptException(FmBeEReceiptException.UNAUDITED, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
                }
                if (billInfo.getPrintStatus() == EReceiptPrintEnum.Printed) {
                    throw new FmBeEReceiptException(FmBeEReceiptException.UNAUDITED, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
                }
                if (permissionMap.get(billInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(billInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        String companyName = (String)map.get("companyName");
                        String number = (String)map.get("number");
                        throw new FmBeEReceiptException(FmBeEReceiptException.NO_REPRINTUNAUDIT_PRMITITEM, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", billInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", billInfo.getNumber());
                    permissionMap.put(billInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        throw new FmBeEReceiptException(FmBeEReceiptException.NO_REPRINTUNAUDIT_PRMITITEM, new Object[]{billInfo.getNumber() + billInfo.getCompany().getName()});
                    }
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("checkedStatus"));
                billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                billBase.updatePartial((CoreBaseInfo)billInfo, sic);
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.error((Object)e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            String msg = EASResource.getString((String)resourcePath, (String)"rePrint_unAuditAll");
            resultList.setSummaryMsg(msg);
        } else {
            String msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"rePrint_unAuditPortion"), success, pks.length - success);
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    protected SelectorItemCollection getPermissionSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("fileName"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _matchEReceipt(Context ctx, String eReceiptId, String transDetailId) throws BOSException, EASBizException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("id"));
        eReceiptSic.add(new SelectorItemInfo("isMatch"));
        eReceiptSic.add(new SelectorItemInfo("company.*"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("id", (Object)eReceiptId));
        eReceiptView.setFilter(eReceiptFilter);
        EReceiptCollection coll = this.eReceiptDBUtils.getEReceiptCollectionByEvi(ctx, eReceiptView);
        EntityViewInfo transDetailView = new EntityViewInfo();
        SelectorItemCollection transDetailSic = new SelectorItemCollection();
        transDetailSic.add(new SelectorItemInfo("*"));
        transDetailSic.add(new SelectorItemInfo("currency.*"));
        transDetailSic.add(new SelectorItemInfo("bankAccount.*"));
        transDetailSic.add(new SelectorItemInfo("bankAccount.bank.*"));
        transDetailSic.add(new SelectorItemInfo("conmpay.*"));
        transDetailView.setSelector(transDetailSic);
        FilterInfo transDetailFilter = new FilterInfo();
        transDetailFilter.getFilterItems().add(new FilterItemInfo("id", (Object)transDetailId));
        transDetailView.setFilter(transDetailFilter);
        TransDetailCollection transDetailColl = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(transDetailView);
        TransDetailInfo transDetailInfo = null;
        if (transDetailColl.size() <= 0) {
            logger.error((Object)("\u4e0d\u5b58\u5728\u8be5\u4ea4\u6613\u660e\u7ec6\uff0c\u4ea4\u6613\u660e\u7ec6id\uff1a" + transDetailId));
            throw new FmBeEReceiptException(FmBeEReceiptException.NOTRANSDETAILCOLL);
        }
        transDetailInfo = transDetailColl.get(0);
        EReceiptInfo eReceiptInfo = null;
        if (coll.size() > 0) {
            eReceiptInfo = coll.get(0);
            String permissionName = "eReceipt_04Match";
            boolean isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(transDetailInfo.getCompany().getId().toString()), permissionName);
            if (!isPermission) {
                logger.error((Object)"\u60a8\u6ca1\u6709\u8be5\u5355\u636e\u7684\u5339\u914d\u64cd\u4f5c\u6743\u9650");
                throw new FmBeEReceiptException(FmBeEReceiptException.NO_MATCH_PRMITITEM);
            }
            EReceiptIsMatchEnum eReceiptIsMatchEnum = eReceiptInfo.getIsMatch();
            if (!eReceiptIsMatchEnum.getValue().equals(EReceiptIsMatchEnum.UnMatch.getValue())) {
                logger.error((Object)("\u8be5\u7535\u5b50\u56de\u5355\u5df2\u7ecf\u5339\u914d\u4ea4\u6613\u660e\u7ec6\uff0c\u7535\u5b50\u56de\u5355id:" + eReceiptId));
                throw new FmBeEReceiptException(FmBeEReceiptException.MATCHERECEIPT);
            }
        } else {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        this.setEreceiptByTransDetail(eReceiptInfo, transDetailInfo);
        EReceiptLogUtils eReceiptLogUtils = new EReceiptLogUtils();
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            con.setAutoCommit(false);
            this.eReceiptDBUtils.batchUpdateEReceipt(ctx, coll, con);
            con.commit();
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            eReceiptLogUtils.addReceiptLog(ctx, null, null, ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"822_EReceiptWebFacadeControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"823_EReceiptWebFacadeControllerBean", (Locale)ctx.getLocale()), e.getMessage(), EReceiptLogTypeEnum.JOINTRANSDETAIL, LevelEnum.ERROR);
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return null;
    }

    private void setEreceiptByTransDetail(EReceiptInfo eReceiptInfo, TransDetailInfo transDetailInfo) {
        eReceiptInfo.setCompany(transDetailInfo.getCompany());
        BigDecimal amout = Constants.ZERO;
        if (transDetailInfo.getDebitAmount() != null && transDetailInfo.getDebitAmount().compareTo(Constants.ZERO) != 0) {
            eReceiptInfo.setDebitAmount(transDetailInfo.getDebitAmount());
            amout = transDetailInfo.getDebitAmount();
        } else if (transDetailInfo.getCreditAmount() != null && transDetailInfo.getCreditAmount().compareTo(Constants.ZERO) != 0) {
            eReceiptInfo.setCreditAmount(transDetailInfo.getCreditAmount());
            amout = transDetailInfo.getCreditAmount();
        }
        eReceiptInfo.setAmount(amout);
        if (eReceiptInfo.getCurrency() == null) {
            eReceiptInfo.setCurrency(transDetailInfo.getCurrency());
        }
        eReceiptInfo.setTransDate(transDetailInfo.getBizTime());
        eReceiptInfo.setDescription(transDetailInfo.getDescription());
        eReceiptInfo.setBankAccount(transDetailInfo.getBankAccount());
        eReceiptInfo.setBank(transDetailInfo.getBankAccount().getBank());
        eReceiptInfo.setOppUnit(transDetailInfo.getOppUnit());
        eReceiptInfo.setTransDetailId(transDetailInfo.getId().toString());
        eReceiptInfo.setOppBankNumber(transDetailInfo.getOppBankNumber());
        eReceiptInfo.setOppBank(transDetailInfo.getOppBank());
        eReceiptInfo.setNumber(transDetailInfo.getNumber());
        eReceiptInfo.setUse(transDetailInfo.getDescription());
    }

    @Override
    protected Map _unMatchEReceipt(Context ctx, String eReceiptId) throws BOSException, EASBizException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("id"));
        eReceiptSic.add(new SelectorItemInfo("isMatch"));
        eReceiptSic.add(new SelectorItemInfo("company.*"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("id", (Object)eReceiptId));
        eReceiptView.setFilter(eReceiptFilter);
        EReceiptCollection coll = this.eReceiptDBUtils.getEReceiptCollectionByEvi(ctx, eReceiptView);
        EReceiptInfo eReceiptInfo = null;
        if (coll.size() > 0) {
            eReceiptInfo = coll.get(0);
            String permissionName = "eReceipt_05UnMatch";
            boolean isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(eReceiptInfo.getCompany().getId().toString()), permissionName);
            if (!isPermission) {
                logger.error((Object)"\u60a8\u6ca1\u6709\u8be5\u5355\u636e\u7684\u53cd\u5339\u914d\u64cd\u4f5c\u6743\u9650");
                throw new FmBeEReceiptException(FmBeEReceiptException.NO_UNMATCH_PRMITITEM);
            }
            EReceiptIsMatchEnum eReceiptIsMatchEnum = eReceiptInfo.getIsMatch();
            if (eReceiptIsMatchEnum.getValue().equals(EReceiptIsMatchEnum.UnMatch.getValue())) {
                logger.error((Object)"\u8be5\u7535\u5b50\u56de\u5355\u6ca1\u6709\u5339\u914d\u4ea4\u6613\u660e\u7ec6\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5339\u914d\u64cd\u4f5c");
                throw new FmBeEReceiptException(FmBeEReceiptException.NOJOIN_TRANSDETAIL_019);
            }
        } else {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        this.eReceiptDBUtils.cancelJoinTransDetailById(ctx, eReceiptInfo.getId().toString());
        logger.error((Object)("\u53d6\u6d88\u4e0e\u4ea4\u6613\u660e\u7ec6\u5173\u8054\uff0c\u7535\u5b50\u56de\u5355id\uff1a" + eReceiptInfo.getId().toString()));
        return null;
    }

    @Override
    protected Map _isPermission(Context ctx, String pk, String permissionName) throws BOSException, EASBizException {
        HashMap<String, StringBuffer> map = new HashMap<String, StringBuffer>();
        IEReceipt billBase = EReceiptFactory.getLocalInstance(ctx);
        String[] pks = pk.split(",");
        StringBuffer noPermission = new StringBuffer("");
        StringBuffer billIds = new StringBuffer("");
        for (int i = 0; i < pks.length; ++i) {
            String billId = pks[i];
            EntityViewInfo eReceiptView = new EntityViewInfo();
            SelectorItemCollection eReceiptSic = new SelectorItemCollection();
            eReceiptSic.add(new SelectorItemInfo("id"));
            eReceiptSic.add(new SelectorItemInfo("fileName"));
            eReceiptSic.add(new SelectorItemInfo("company.id"));
            eReceiptView.setSelector(eReceiptSic);
            FilterInfo eReceiptFilter = new FilterInfo();
            eReceiptFilter.getFilterItems().add(new FilterItemInfo("id", (Object)billId, CompareType.EQUALS));
            eReceiptView.setFilter(eReceiptFilter);
            EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(eReceiptView);
            if (coll.size() <= 0) {
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            EReceiptInfo billInfo = coll.get(0);
            boolean isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId().toString()), permissionName);
            if (i == 0) {
                if (!isPermission) {
                    noPermission.append(billInfo.getFileName() + ";");
                    continue;
                }
                billIds.append(billId);
                continue;
            }
            if (!isPermission) {
                noPermission.append(billInfo.getFileName() + ";");
                continue;
            }
            billIds.append("," + billId);
        }
        map.put("billIds", billIds);
        map.put("noPermission", noPermission);
        return map;
    }

    @Override
    protected Map _isPrint(Context ctx, String pk) throws BOSException, EASBizException {
        HashMap<String, StringBuffer> map = new HashMap<String, StringBuffer>();
        IEReceipt billBase = EReceiptFactory.getLocalInstance(ctx);
        String[] pks = pk.split(",");
        StringBuffer isPrint = new StringBuffer("");
        StringBuffer billIds = new StringBuffer("");
        for (int i = 0; i < pks.length; ++i) {
            String billId = pks[i];
            EntityViewInfo eReceiptView = new EntityViewInfo();
            SelectorItemCollection eReceiptSic = new SelectorItemCollection();
            eReceiptSic.add(new SelectorItemInfo("id"));
            eReceiptSic.add(new SelectorItemInfo("printCount"));
            eReceiptSic.add(new SelectorItemInfo("fileName"));
            eReceiptSic.add(new SelectorItemInfo("company.id"));
            eReceiptView.setSelector(eReceiptSic);
            FilterInfo eReceiptFilter = new FilterInfo();
            eReceiptFilter.getFilterItems().add(new FilterItemInfo("id", (Object)billId, CompareType.EQUALS));
            eReceiptView.setFilter(eReceiptFilter);
            EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(eReceiptView);
            if (coll.size() <= 0) {
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            EReceiptInfo billInfo = coll.get(0);
            if (i == 0) {
                if (billInfo.getPrintCount() != 0) {
                    isPrint.append(billInfo.getFileName() + ";");
                    continue;
                }
                billIds.append(billId);
                continue;
            }
            if (billInfo.getPrintCount() != 0) {
                isPrint.append(billInfo.getFileName() + ";");
                continue;
            }
            billIds.append("," + billId);
        }
        map.put("billIds", billIds);
        map.put("isPrint", isPrint);
        return map;
    }

    @Override
    protected Map _isRePrint(Context ctx, String pk) throws BOSException, EASBizException {
        HashMap<String, StringBuffer> map = new HashMap<String, StringBuffer>();
        IEReceiptReprint billBase = EReceiptReprintFactory.getLocalInstance(ctx);
        String[] pks = pk.split(",");
        StringBuffer isPrint = new StringBuffer("");
        StringBuffer billIds = new StringBuffer("");
        for (int i = 0; i < pks.length; ++i) {
            String billId = pks[i];
            if (!billBase.exists((IObjectPK)new ObjectUuidPK(billId))) {
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            EntityViewInfo eReceiptReprintView = new EntityViewInfo();
            SelectorItemCollection eReceiptSic = new SelectorItemCollection();
            eReceiptSic.add(new SelectorItemInfo("id"));
            eReceiptSic.add(new SelectorItemInfo("printStatus"));
            eReceiptSic.add(new SelectorItemInfo("number"));
            eReceiptReprintView.setSelector(eReceiptSic);
            FilterInfo eReceiptFilter = new FilterInfo();
            eReceiptFilter.getFilterItems().add(new FilterItemInfo("id", (Object)billId, CompareType.EQUALS));
            eReceiptReprintView.setFilter(eReceiptFilter);
            EReceiptReprintCollection coll = EReceiptReprintFactory.getLocalInstance(ctx).getEReceiptReprintCollection(eReceiptReprintView);
            if (coll.size() <= 0) {
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            EReceiptReprintInfo billInfo = coll.get(0);
            if (i == 0) {
                if (billInfo.getPrintStatus().equals((Object)EReceiptPrintEnum.Printed)) {
                    isPrint.append(billInfo.getNumber() + ";");
                    continue;
                }
                billIds.append(billId);
                continue;
            }
            if (billInfo.getPrintStatus().equals((Object)EReceiptPrintEnum.Printed)) {
                isPrint.append(billInfo.getNumber() + ";");
                continue;
            }
            billIds.append("," + billId);
        }
        map.put("billIds", billIds);
        map.put("isPrint", isPrint);
        return map;
    }

    @Override
    protected List<byte[]> _getEReceiptPDFByteValues(Context ctx, List pks) throws BOSException {
        ArrayList<byte[]> fileValues = new ArrayList();
        try {
            fileValues = EreceiptLinkHelper.getPDFListByErecIds((Context)ctx, (List)pks);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        logger.error((Object)"\u7535\u5b50\u56de\u5355\u53d6PDF\u6570\u636e\u5b8c\u6210");
        return fileValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertImageToPdf(String payNumber, byte[] imageData) {
        logger.error((Object)"**********convertImageToPdf start **********");
        String pdfFilePath = this.assemblePDFFile(payNumber);
        logger.error((Object)("**********pdfFilePath is :" + pdfFilePath));
        Document document = new Document(PageSize.A4.rotate());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(pdfFilePath);
            PdfWriter.getInstance((Document)document, (OutputStream)fileOutputStream);
            document.open();
            Image image = Image.getInstance((byte[])imageData);
            document.add((Element)image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            document.close();
        }
        logger.error((Object)"**********convertImageToPdf end **********");
        return pdfFilePath;
    }

    private byte[] convertImageToPdfByte(String payNumber, byte[] imageData) {
        logger.error((Object)"**********convertImageToPdfByte start **********");
        String pdfFilePath = this.convertImageToPdf(payNumber, imageData);
        File file = new File(pdfFilePath);
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] b = new byte[1024];
            int len = -1;
            while ((len = fis.read(b)) != -1) {
                bos.write(b, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.error((Object)"**********convertImageToPdfByte end **********");
        return bos.toByteArray();
    }

    private String assemblePDFFile(String payNumber) {
        String pattern = "{0}{1}{2}";
        return MessageFormat.format(pattern, this.getTempFilePath(), payNumber, ".pdf");
    }

    private String getTempFilePath() {
        return this.EAS_WEB_TMP_PATH;
    }

    @Override
    protected List _getEReceiptPDFByVoucherID(Context ctx, String voucherId) throws BOSException, EASBizException {
        List result = new ArrayList();
        List idList = new ArrayList();
        try {
            idList = this.getEReceiptIdListByVoucherId(ctx, voucherId);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!EmptyUtil.isEmpty(idList)) {
            result = this.getEReceiptPDFByteValues(ctx, idList);
        }
        return result;
    }

    @Override
    protected List _getEReceiptIdListByVoucherId(Context ctx, String voucherId) throws BOSException, EASBizException {
        ArrayList<String> voucherList = new ArrayList<String>();
        voucherList.add(voucherId);
        ArrayList idList = new ArrayList();
        VoucherEreceiptService iService = new VoucherEreceiptService();
        Map ereceiptIdMap = new HashMap();
        try {
            ereceiptIdMap = EreceiptLinkHelper.getErecIdsByBillIds((Context)ctx, voucherList);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < voucherList.size(); ++i) {
            if (EmptyUtil.isEmpty((Collection)((Collection)ereceiptIdMap.get(voucherList.get(i))))) continue;
            idList.addAll((Collection)ereceiptIdMap.get(voucherList.get(i)));
        }
        return idList;
    }

    @Override
    protected List _getEReceiptIdListByBillIdList(Context ctx, List billIdList) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        HashMap ereceiptIdMap = new HashMap();
        try {
            EreceiptLinkHelper.getErecIdsByBillIds((Context)ctx, (List)billIdList);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < billIdList.size(); ++i) {
            if (EmptyUtil.isEmpty((Collection)((Collection)ereceiptIdMap.get(billIdList.get(i))))) continue;
            list.addAll((Collection)ereceiptIdMap.get(billIdList.get(i)));
        }
        return list;
    }

    @Override
    protected Map _getBillByEReceiptIdList(Context ctx, List ereceiptIdList) throws BOSException, EASBizException {
        HashMap<String, List> result = new HashMap<String, List>();
        for (int i = 0; i < ereceiptIdList.size(); ++i) {
            List transList = EReceiptServerHelper.getTransDetailByEreceiptId(ctx, ereceiptIdList.get(i).toString());
            for (int j = 0; j < transList.size(); ++j) {
                CoreBaseCollection AgentPayBillCollection;
                String bosType;
                TransDetailInfo transInfo = (TransDetailInfo)transList.get(j);
                String transDetailId = transInfo.getId().toString();
                Vector<String> destBills = EReceiptServerHelper.getRelateBills2(ctx, "srcObjectID", "destObjectID", transDetailId);
                HashMap map = new HashMap();
                if (destBills.size() >= 1) {
                    for (int t = 0; t < destBills.size(); ++t) {
                        String billId = destBills.get(t);
                        String bosType2 = BOSUuid.read((String)billId).getType().toString();
                        this.putKeyList(result, billId, bosType2);
                    }
                    continue;
                }
                if (transInfo.getRecedBillType() == null) continue;
                String recedbilltype = transInfo.getRecedBillType().getValue();
                String recedbillnumber = transInfo.getRecedBillNumber();
                EntityViewInfo EntityViewInfo2 = new EntityViewInfo();
                SelectorItemCollection Sic = new SelectorItemCollection();
                Sic.add(new SelectorItemInfo("id"));
                Sic.add(new SelectorItemInfo("parent"));
                EntityViewInfo2.setSelector(Sic);
                FilterInfo Info = new FilterInfo();
                Info.getFilterItems().add(new FilterItemInfo("number", (Object)recedbillnumber, CompareType.EQUALS));
                EntityViewInfo2.setFilter(Info);
                if (recedbilltype.equals("6E41E17C")) {
                    SettlementBillCollection settleColls = SettlementBillFactory.getLocalInstance((Context)ctx).getSettlementBillCollection(EntityViewInfo2);
                    if (settleColls.size() <= 0) continue;
                    SettlementBillInfo settleBillInfo = settleColls.get(0);
                    bosType = BOSUuid.read((String)settleBillInfo.getId().toString()).getType().toString();
                    this.putKeyList(result, settleBillInfo.getId().toString(), bosType);
                    continue;
                }
                if (recedbilltype.equals("FA44FD5B")) {
                    ReceivingBillCollection receivingBillColls = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillCollection(EntityViewInfo2);
                    if (receivingBillColls.size() <= 0) continue;
                    ReceivingBillInfo ReceivingInfo = receivingBillColls.get(0);
                    bosType = BOSUuid.read((String)ReceivingInfo.getId().toString()).getType().toString();
                    this.putKeyList(result, ReceivingInfo.getId().toString(), bosType);
                    continue;
                }
                if (recedbilltype.equals("40284E81")) {
                    PaymentBillCollection PaymentColls = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(EntityViewInfo2);
                    if (PaymentColls.size() <= 0) continue;
                    PaymentBillInfo PaymentInfo2 = PaymentColls.get(0);
                    bosType = BOSUuid.read((String)PaymentInfo2.getId().toString()).getType().toString();
                    this.putKeyList(result, PaymentInfo2.getId().toString(), bosType);
                    continue;
                }
                if (recedbilltype.equals("D125C4DE")) {
                    CoreBaseCollection transUpCollection = TransUpBillFactory.getLocalInstance((Context)ctx).getCollection(EntityViewInfo2);
                    if (transUpCollection.size() <= 0) continue;
                    TransUpBillInfo transUpBillInfo = (TransUpBillInfo)transUpCollection.get(0);
                    bosType = BOSUuid.read((String)transUpBillInfo.getId().toString()).getType().toString();
                    this.putKeyList(result, transUpBillInfo.getId().toString(), bosType);
                    continue;
                }
                if (recedbilltype.equals("5E920865")) {
                    CoreBaseCollection transDownCollection = TransDownBillFactory.getLocalInstance((Context)ctx).getCollection(EntityViewInfo2);
                    if (transDownCollection.size() <= 0) continue;
                    TransDownBillInfo transDownBillInfo = (TransDownBillInfo)transDownCollection.get(0);
                    bosType = BOSUuid.read((String)transDownBillInfo.getId().toString()).getType().toString();
                    this.putKeyList(result, transDownBillInfo.getId().toString(), bosType);
                    continue;
                }
                if (!recedbilltype.equals("131C7D36") || (AgentPayBillCollection = AgentPayBillFactory.getLocalInstance((Context)ctx).getCollection(EntityViewInfo2)).size() <= 0) continue;
                AgentPayBillInfo agentPayBillInfo = (AgentPayBillInfo)AgentPayBillCollection.get(0);
                bosType = BOSUuid.read((String)agentPayBillInfo.getId().toString()).getType().toString();
                this.putKeyList(result, agentPayBillInfo.getId().toString(), bosType);
            }
        }
        return result;
    }

    private void putKeyList(Map<String, List> result, String billId, String bosType) {
        if (result.containsKey(bosType)) {
            List keyList = result.get(bosType);
            keyList.add(billId);
        } else {
            ArrayList<String> keyList = new ArrayList<String>();
            keyList.add(billId);
            result.put(bosType, keyList);
        }
    }

    @Override
    protected List _getTransDetailByEReceiptIdList(Context ctx, List ereceiptIdList) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < ereceiptIdList.size(); ++i) {
            List transList = EReceiptServerHelper.getTransDetailByEreceiptId(ctx, ereceiptIdList.get(i).toString());
            for (int j = 0; j < transList.size(); ++j) {
                result.add(((TransDetailInfo)transList.get(j)).getId().toString());
            }
        }
        return result;
    }

    @Override
    protected List _getEReceiptByTransDetailIdList(Context ctx, List transDetailIdList) throws BOSException, EASBizException {
        HashSet transDetailIdSet = new HashSet(transDetailIdList);
        return EReceiptServerHelper.getEreceiptIdByTransDetailId(ctx, transDetailIdSet);
    }
}

