/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.cipher.util.encoders.Base64;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.QueryReceiptResponseBody;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.ElStatementBillAccountBankListCollection;
import com.kingdee.eas.fm.be.ElStatementBillAccountBankListInfo;
import com.kingdee.eas.fm.be.ElStatementBillCollection;
import com.kingdee.eas.fm.be.ElStatementBillFactory;
import com.kingdee.eas.fm.be.ElStatementBillFilePathFactory;
import com.kingdee.eas.fm.be.ElStatementBillFilePathInfo;
import com.kingdee.eas.fm.be.ElStatementBillInfo;
import com.kingdee.eas.fm.be.ElStatementBillInterruptInfo;
import com.kingdee.eas.fm.be.ElStatementBillLogFactory;
import com.kingdee.eas.fm.be.ElStatementBillLogInfo;
import com.kingdee.eas.fm.be.ElStatementBillTypeEnum;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.IElStatementBill;
import com.kingdee.eas.fm.be.IElStatementBillFilePath;
import com.kingdee.eas.fm.be.IElStatementBillLog;
import com.kingdee.eas.fm.be.LevelEnum;
import com.kingdee.eas.fm.be.StorageSettingInstance;
import com.kingdee.eas.fm.be.app.AbstractElStatementBillControllerBean;
import com.kingdee.eas.fm.be.app.ElStatementBillAccountBankListDBUtils;
import com.kingdee.eas.fm.be.app.ElStatementBillInterruptDBUtils;
import com.kingdee.eas.fm.be.app.ElStatementBillLogUtils;
import com.kingdee.eas.fm.be.app.service.ElStatementBillService;
import com.kingdee.eas.fm.be.app.service.ElStatementDBUtils;
import com.kingdee.eas.fm.be.app.service.ElStatementEBGServiceUtil;
import com.kingdee.eas.fm.be.app.service.ElStatementFilesUtils;
import com.kingdee.eas.fm.be.app.util.ElStatementJDBC;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ElStatementBillControllerBean
extends AbstractElStatementBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.ElStatementBillControllerBean");
    private static final String yyyyMMdd = "yyyyMMdd";
    private static final String yyyy_MM_dd = "yyyy-MM-dd";
    private SimpleDateFormat dft = new SimpleDateFormat("yyyyMM");
    private ElStatementBillService elStatementBillService = new ElStatementBillService();
    private ElStatementDBUtils elStateDBUtils = new ElStatementDBUtils();
    private ElStatementBillLogUtils elStatementBillLogUtils = new ElStatementBillLogUtils();
    public boolean importPdf = true;
    private ElStatementBillAccountBankListDBUtils elStatementBillAccBankListUtil = new ElStatementBillAccountBankListDBUtils();

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            ElStatementBillInfo info = this.getElStatementBillInfo(ctx, pk);
            UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "elstatement_04delete");
            StorageSettingInstance storageSetting = StorageSettingInstance.getInstance(ctx);
            EReceiptStorageSettingInfo eReceiptStorageSettingInfo = storageSetting.getStorageSettingInfo();
            if (eReceiptStorageSettingInfo == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"561_ElStatementBatchService", (Locale)ctx.getLocale()));
            }
            if (!info.getFileSource().equals("3")) {
                String fileSource = info.getFileSource();
                if (fileSource.equals("0") || fileSource.equals("1")) {
                    ElStatementJDBC elStatementTool = new ElStatementJDBC();
                    if (eReceiptStorageSettingInfo.getStorageType().getValue() == 3) {
                        logger.error((Object)"\u7535\u5b50\u5bf9\u8d26\u5355\u6570\u636e\u5b58\u653e\u5728\u672c\u5730\u8def\u5f84\u4e2d ");
                        elStatementTool.deleteEReceipt(ctx, info.getId().toString(), CompareType.EQUALS, eReceiptStorageSettingInfo);
                    } else {
                        logger.error((Object)"\u7535\u5b50\u5bf9\u8d26\u5355\u6570\u636e\u5b58\u653e\u5728PDF\u6570\u636e\u5e93\u4e2d ");
                        elStatementTool.deleteEReceipt(info.getId().toString(), CompareType.EQUALS, eReceiptStorageSettingInfo);
                    }
                } else if (fileSource.equals("2")) {
                    logger.error((Object)"\u7535\u5b50\u5bf9\u8d26\u5355\u6570\u636e 2\u4e3a\u6570\u636e\u5b58\u653e\u5728\u91d1\u8776\u4e91\u76d8 (\u6682\u4e0d\u5904\u7406)");
                } else if (fileSource.equals("4")) {
                    ElStatementJDBC elStatementTool = new ElStatementJDBC();
                    logger.error((Object)"\u7535\u5b50\u5bf9\u8d26\u5355\u6570\u636e\u5b58\u653e\u5728\u672c\u5730\u8def\u5f84\u4e2d ");
                    elStatementTool.deleteEReceipt(ctx, info.getId().toString(), CompareType.EQUALS, eReceiptStorageSettingInfo);
                }
                logger.error((Object)"\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u5220\u9664\u6210\u529f");
            }
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("elStatementBillId", (Object)pk.toString()));
            ElStatementBillFilePathFactory.getLocalInstance(ctx).delete(fi);
            super._delete(ctx, pk);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _downloadStructFormatByManual(Context ctx, Set bankAcctIds, Date startDate, Date endDate) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        AccountBankCollection bankAcct = this.getBankAccountCol(ctx, bankAcctIds);
        int total = 0;
        try {
            this.checkDate(ctx, startDate, endDate);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)bankAcct)) {
                StringBuffer msg = new StringBuffer();
                for (int i = 0; i < bankAcct.size(); ++i) {
                    result.put("count", total += this.downloadElStatementBillByDate(ctx, bankAcct.get(i), startDate, endDate, msg, false));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("count", total);
            result.put("errMsg", e.getMessage());
            return result;
        }
        return result;
    }

    private int downloadElStatementBillByDate(Context ctx, AccountBankInfo bankAcctInfo, Date beginDate, Date endDate, StringBuffer msg, boolean isTransactionDown) throws EASBizException, BOSException {
        String downElStatementBillMsg = "\u4e0b\u8f7d\u94f6\u884c\u8d26\u6237\uff1a" + bankAcctInfo.getBankAccountNumber() + " \u5f00\u59cb\u65e5\u671f\uff1a" + this.dft.format(beginDate) + " \u7ed3\u675f\u65e5\u671f\uff1a" + this.dft.format(endDate) + " \u7684\u987a\u5e8f\u8868\u7684\u7535\u5b50\u5bf9\u8d26\u5355";
        logger.error((Object)(downElStatementBillMsg + "  Start"));
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        int total = 0;
        start.setTime(beginDate);
        end.setTime(endDate);
        end.add(2, 1);
        while (start.before(end)) {
            try {
                String downEReceiptMsg = "\u4e0b\u8f7d\u94f6\u884c\u8d26\u6237\uff1a" + bankAcctInfo.getBankAccountNumber() + " \u4ea4\u6613\u65e5\u671f\uff1a" + this.dft.format(start.getTime()) + " \u7684\u7535\u5b50\u5bf9\u8d26\u5355";
                logger.error((Object)downEReceiptMsg);
                int count = ElStatementBillFactory.getLocalInstance(ctx).downLoadElStatementBillByBankNumberAndDate(bankAcctInfo.getBankAccountNumber(), start.getTime(), msg, isTransactionDown);
                start.add(2, 1);
                String downEreceiptNumMsg = "\u94f6\u884c\u8d26\u53f7\uff1a" + bankAcctInfo.getBankAccountNumber() + " \u4ea4\u6613\u65e5\u671f\uff1a" + this.dft.format(start.getTime()) + "\u5171\u4e0b\u8f7d\u5230\u7535\u5b50\u5bf9\u8d26\u5355\uff1a" + (total += count) + " \u6761";
                logger.error((Object)downEreceiptNumMsg);
            }
            catch (Exception e) {
                String commonMsg = "\u94f6\u884c\u8d26\u53f7\uff1a" + bankAcctInfo.getBankAccountNumber() + " \u4ea4\u6613\u65e5\u671f\uff1a" + this.dft.format(start.getTime()) + "\u4e0b\u8f7d\u5f02\u5e38";
                logger.error((Object)commonMsg, (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)(downElStatementBillMsg + "  End \u6570\u91cf\u4e3a\uff1a" + total));
        return total;
    }

    private AccountBankCollection getBankAccountCol(Context ctx, Set bankAcctIds) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bankAcctIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isElStatement", (Object)new Integer(1)));
        AccountBankCollection bankAcct = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        return bankAcct;
    }

    @Override
    protected Map _downloadFileByManual(Context ctx, Set bankAcctIds, Date startDate, Date endDate) throws BOSException, EASBizException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int total = 0;
        ElStatementBillCollection elStatementCol = this.getElStatementBillCol(ctx, bankAcctIds, startDate, endDate, 0);
        IElStatementBill iElStatementBill = ElStatementBillFactory.getLocalInstance(ctx);
        for (int i = 0; i < elStatementCol.size(); ++i) {
            try {
                ElStatementBillInfo info = elStatementCol.get(i);
                Map map = iElStatementBill.downloadFileValues(info);
                if (map == null || map.get("count") == null) continue;
                total += Integer.parseInt(map.get("count").toString());
                continue;
            }
            catch (Exception e) {
                String exMsg = "\u4e0b\u8f7d\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
                logger.error((Object)exMsg);
            }
        }
        result.put("count", total);
        return result;
    }

    private ElStatementBillCollection getElStatementBillCol(Context ctx, Set bankAcctIds, Date startDate, Date endDate, int topNum) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)bankAcctIds, CompareType.INCLUDE));
        if (startDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("transDate", (Object)startDate, CompareType.GREATER_EQUALS));
        }
        if (endDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("transDate", (Object)endDate, CompareType.LESS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isDownPdf", (Object)Boolean.FALSE, CompareType.EQUALS));
        if (topNum > 3000) {
            view.setTopCount(3000);
        }
        ElStatementBillCollection elStatementCol = ElStatementBillFactory.getLocalInstance(ctx).getElStatementBillCollection(view);
        return elStatementCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int _downLoadElStatementBillByBankNumberAndDate(Context ctx, String bankAccountNumber, Date transDate, StringBuffer msg, boolean isTransactionDown) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int count = 0;
        String lockId = bankAccountNumber + "elStatementBill" + transDate.toGMTString();
        if (!iMutex.requestObjIDForUpdate(lockId)) {
            String exMsg = "\u94f6\u884c\u8d26\u53f7\uff1a" + bankAccountNumber + "\t\u4e0b\u8f7d\u65e5\u671f\u4e3a\uff1a" + this.dft.format(transDate) + " \u7684\u7535\u5b50\u5bf9\u8d26\u5355\u7ed3\u6784\u5316\u6570\u636e\u65f6\uff0c\u672a\u80fd\u7533\u8bf7\u5230\u4e92\u65a5\u9501\uff01";
            logger.error((Object)exMsg);
            return count;
        }
        ElStatementBillInterruptDBUtils elStatementBillInterruptDBUtils = new ElStatementBillInterruptDBUtils();
        try {
            ElStatementEBGServiceUtil elEBGServiceUtil = new ElStatementEBGServiceUtil();
            QueryReceiptResponseBody responseBody = elEBGServiceUtil.getReceiptResponseBody(ctx, bankAccountNumber, transDate);
            if (responseBody.getReceiptInfos() != null && responseBody.getReceiptInfos().length != 0 && responseBody.getReserveds() != null && responseBody.getReserveds().length != 0) {
                ElStatementBillCollection col = this.elStateDBUtils.getElStatementBillByBankAndDate(ctx, bankAccountNumber, transDate);
                IElStatementBillFilePath iElStatementBillFilePath = ElStatementBillFilePathFactory.getLocalInstance(ctx);
                IElStatementBill iElStatementBill = ElStatementBillFactory.getLocalInstance(ctx);
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)col)) {
                    if (responseBody.getReceiptInfos().length == col.get(0).getEntry().size()) {
                        int Oldinfo = count;
                        return Oldinfo;
                    }
                    ElStatementBillInfo Oldinfo = col.get(0);
                    iElStatementBill.delete((IObjectPK)new ObjectUuidPK(Oldinfo.getId().toString()));
                    ElStatementBillInfo info = this.elStatementBillService.parseElStatementInfoByResponse(ctx, responseBody, bankAccountNumber, transDate);
                    info.setId(Oldinfo.getId());
                    CoreBaseCollection filePathCol = new CoreBaseCollection();
                    HashSet<String> fileSet = new HashSet<String>();
                    for (int i = 0; i < responseBody.getReceiptInfos().length; ++i) {
                        if (fileSet.contains(responseBody.getReceiptInfos()[i].getFilePath())) continue;
                        fileSet.add(responseBody.getReceiptInfos()[i].getFilePath());
                        ElStatementBillFilePathInfo elStatementBillFilePathInfo = new ElStatementBillFilePathInfo();
                        elStatementBillFilePathInfo.setElStatementBillId(info.getId().toString());
                        elStatementBillFilePathInfo.setFilePath(responseBody.getReceiptInfos()[i].getFilePath());
                        elStatementBillFilePathInfo.setSeq(new Integer(i).toString());
                        filePathCol.add((CoreBaseInfo)elStatementBillFilePathInfo);
                    }
                    if (info != null) {
                        iElStatementBill.addnew(info);
                        iElStatementBillFilePath.addnewBatchData(filePathCol);
                        count = 1;
                    }
                } else {
                    ElStatementBillInfo info = this.elStatementBillService.parseElStatementInfoByResponse(ctx, responseBody, bankAccountNumber, transDate);
                    CoreBaseCollection filePathCol = new CoreBaseCollection();
                    HashSet<String> fileSet = new HashSet<String>();
                    for (int i = 0; i < responseBody.getReceiptInfos().length; ++i) {
                        if (fileSet.contains(responseBody.getReceiptInfos()[i].getFilePath())) continue;
                        fileSet.add(responseBody.getReceiptInfos()[i].getFilePath());
                        ElStatementBillFilePathInfo elStatementBillFilePathInfo = new ElStatementBillFilePathInfo();
                        elStatementBillFilePathInfo.setElStatementBillId(info.getId().toString());
                        elStatementBillFilePathInfo.setFilePath(responseBody.getReceiptInfos()[i].getFilePath());
                        elStatementBillFilePathInfo.setSeq(new Integer(i).toString());
                        filePathCol.add((CoreBaseInfo)elStatementBillFilePathInfo);
                    }
                    if (info != null) {
                        iElStatementBill.addnew(info);
                        iElStatementBillFilePath.addnewBatchData(filePathCol);
                        count = 1;
                    }
                }
                if (isTransactionDown) {
                    ElStatementBillAccountBankListInfo acInfo;
                    ElStatementBillAccountBankListCollection elAcList = this.elStatementBillAccBankListUtil.getElStatementBillAccountBankListCollection(ctx, bankAccountNumber);
                    if (elAcList.size() > 0 && (acInfo = elAcList.get(0)).getTransDate().before(transDate)) {
                        this.elStatementBillService.updateElStatementBillAccBankListByAccNum(ctx, bankAccountNumber, transDate);
                    }
                } else {
                    elStatementBillInterruptDBUtils.deleteElStatementBillInterByBankNumberAndDate(ctx, bankAccountNumber, transDate);
                }
            }
            String logMsg = "\u94f6\u884c\u8d26\u53f7\uff1a" + bankAccountNumber + " \u4ea4\u6613\u65e5\u671f\uff1a" + this.dft.format(transDate) + " \u4e0b\u8f7d\u5230\u7535\u5b50\u5bf9\u8d26\u5355\u6570\u4e3a\uff1a" + count;
            logger.error((Object)logMsg);
            this.elStatementBillLogUtils.saveElStatementBillLog(ctx, bankAccountNumber, transDate, ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"585_ElStatementBillControllerBean", (Locale)ctx.getLocale()) + logMsg, null, null, ElStatementBillTypeEnum.DOWNElStructFormat, LevelEnum.NORMAL);
        }
        catch (Exception e) {
            if (isTransactionDown) {
                ElStatementBillAccountBankListInfo acInfo;
                ElStatementBillAccountBankListCollection elAcList = this.elStatementBillAccBankListUtil.getElStatementBillAccountBankListCollection(ctx, bankAccountNumber);
                if (elAcList.size() > 0 && ((acInfo = elAcList.get(0)).getTransDate() == null || acInfo.getTransDate().before(transDate))) {
                    this.elStatementBillService.updateElStatementBillAccBankListByAccNum(ctx, bankAccountNumber, transDate);
                }
                elStatementBillInterruptDBUtils.insertElStatementBillInterByBankNumberAndDate(ctx, bankAccountNumber, transDate);
            }
            String exMsg = "\u94f6\u884c\u8d26\u53f7\uff1a" + bankAccountNumber + " \u4ea4\u6613\u65e5\u671f\uff1a" + this.dft.format(transDate) + " \u4e0b\u8f7d\u7535\u5b50\u5bf9\u8d26\u5355\u5f02\u5e38";
            logger.error((Object)exMsg);
            if (!(e instanceof BEException)) {
                e.printStackTrace();
                this.elStatementBillLogUtils.saveElStatementBillLog(ctx, bankAccountNumber, transDate, ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"587_ElStatementBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage(), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"588_ElStatementBillControllerBean", (Locale)ctx.getLocale()), this.elStatementBillLogUtils.getStackTrace(e), ElStatementBillTypeEnum.DOWNElStructFormat, LevelEnum.ERROR);
            }
        }
        finally {
            iMutex.releaseObjIDForUpdate(lockId);
        }
        String logMsg = "\u94f6\u884c\u8d26\u53f7\uff1a" + bankAccountNumber + " \u4e0b\u8f7d\u65e5\u671f\u4e3a\uff1a" + this.dft.format(transDate) + " \u4e0b\u8f7d\u5230\u7535\u5b50\u5bf9\u8d26\u5355\u6570\u4e3a\uff1a" + count;
        logger.error((Object)logMsg);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _downloadFileValues(Context ctx, ElStatementBillInfo elStatementInfo) throws BOSException, EASBizException {
        String msg = "\u94f6\u884c\u8d26\u53f7\uff1a" + elStatementInfo.getBankAccount().getBankAccountNumber() + " \u4ea4\u6613\u671f\u95f4\uff1a" + this.dft.format(elStatementInfo.getTransDate()) + " detailNO:";
        Connection con = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            con = this.getConnection(ctx);
            con.setAutoCommit(false);
            ElStatementFilesUtils elStateFileUtils = new ElStatementFilesUtils();
            byte[] fileValue = elStateFileUtils.getFilesByteAarry(ctx, elStatementInfo);
            if (fileValue == null || fileValue.length == 0) {
                throw new BEException(null);
            }
            elStatementInfo.setFileValue(fileValue);
            elStatementInfo.setIsDownPdf(true);
            logger.error((Object)("\u5f00\u59cb\u4fdd\u5b58\u6587\u4ef6\u5230\u6570\u636e\u5e93\uff1a" + msg));
            this.elStateDBUtils.saveFilesValues(ctx, elStatementInfo, con);
            logger.error((Object)"\u4fdd\u5b58\u6587\u4ef6\u5230\u6570\u636e\u5e93\u6210\u529f");
            con.commit();
            map.put("count", 1);
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (!(e instanceof BEException)) {
                String exMsg = "\u4e0b\u8f7d\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u5f02\u5e38\uff1a" + msg + "  \u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
                logger.error((Object)exMsg, (Throwable)e);
                e.printStackTrace();
            }
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return map;
    }

    @Override
    protected boolean _importElStatementBill(Context ctx, ElStatementBillInfo info) throws BOSException, EASBizException {
        try {
            StorageSettingInstance.init(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BEException(BEException.COMMON, new String[]{e.getMessage()});
        }
        info.setFileSource("3");
        info.setIsImport(true);
        if (!EmptyUtil.isEmpty((Object)info.getFileValue())) {
            info.setIsDownPdf(true);
            info.setFileSource("0");
        }
        IObjectPK pk = this.addnew(ctx, info);
        this.saveFilesValues(ctx, info);
        if (!this.importPdf) {
            this.delete(ctx, pk);
        }
        return this.importPdf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFilesValues(Context ctx, ElStatementBillInfo info) {
        String msg = "\u94f6\u884c\u8d26\u53f7\uff1a" + info.getBankAccount().getBankAccountNumber() + " \u4ea4\u6613\u671f\u95f4\uff1a" + this.dft.format(info.getTransDate()) + " detailNO:";
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            con.setAutoCommit(false);
            logger.error((Object)("\u5f00\u59cb\u4fdd\u5b58\u6587\u4ef6\u5230\u6570\u636e\u5e93\uff1a" + msg));
            this.elStateDBUtils.saveFilesValues(ctx, info, con);
            logger.error((Object)"\u4fdd\u5b58\u6587\u4ef6\u5230\u6570\u636e\u5e93\u6210\u529f");
            con.commit();
        }
        catch (Exception e) {
            try {
                con.rollback();
                this.importPdf = false;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (!(e instanceof BEException)) {
                String exMsg = "\u4e0b\u8f7d\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u5f02\u5e38\uff1a" + msg + "  \u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
                logger.error((Object)exMsg, (Throwable)e);
                e.printStackTrace();
            }
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    @Override
    protected void _updatePrintCount(Context ctx, List idList, String id) throws BOSException, EASBizException {
    }

    private void checkDate(Context ctx, Date startDate, Date endDate) throws ParseException, BOSException {
        if (startDate == null || endDate == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"596_ElStatementBillControllerBean", (Locale)ctx.getLocale()));
        }
        String sDate = this.dft.format(startDate);
        String eDate = this.dft.format(endDate);
        if (startDate.after(endDate)) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"597_ElStatementBillControllerBean", (Locale)ctx.getLocale()) + sDate + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"598_ElStatementBillControllerBean", (Locale)ctx.getLocale()) + eDate;
            logger.error((Object)exMsg);
            throw new BOSException(exMsg);
        }
        Date monthFirstDate = this.getMonthFirstDate(new Date());
        if (monthFirstDate.before(endDate)) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"599_ElStatementBillControllerBean", (Locale)ctx.getLocale()) + sDate + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"598_ElStatementBillControllerBean", (Locale)ctx.getLocale()) + eDate;
            logger.error((Object)exMsg);
            throw new BOSException(exMsg);
        }
        Date difDate = this.getLastYearDate(endDate);
        if (startDate.before(difDate)) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"600_ElStatementBillControllerBean", (Locale)ctx.getLocale()) + sDate + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"598_ElStatementBillControllerBean", (Locale)ctx.getLocale()) + eDate;
            logger.error((Object)exMsg);
            throw new BOSException(exMsg);
        }
    }

    protected Date getRelativeDate(Date baseDate, int days, int type) throws BOSException {
        Date returnDate = null;
        if (baseDate == null) {
            baseDate = new Date();
        }
        Calendar date = Calendar.getInstance();
        date.setTime(baseDate);
        if (type == 0) {
            date.set(5, date.get(5) - days);
        } else {
            date.set(5, date.get(5) + days);
        }
        SimpleDateFormat dft = new SimpleDateFormat(yyyyMMdd);
        try {
            returnDate = dft.parse(dft.format(date.getTime()));
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        return returnDate;
    }

    protected Date getMonthFirstDate(Date date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    protected Date getLastMonthFirstDate(Date date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    protected Date getLastMonthEndDate(Date date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    protected Date getCurMonthEndDate(Date date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    protected Date getLastYearDate(Date date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, -1);
        return calendar.getTime();
    }

    @Override
    protected void _insertElStatementBillLog(Context ctx, ElStatementBillLogInfo elStatementBillLogInfo) throws BOSException, EASBizException {
        try {
            IElStatementBillLog elStatementBillLog = ElStatementBillLogFactory.getLocalInstance(ctx);
            Date bizDate = new Date();
            SimpleDateFormat dfts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            bizDate = dfts.parse(dfts.format(bizDate.getTime()));
            if (elStatementBillLogInfo.getId() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(elStatementBillLogInfo.getId().toString());
                if (elStatementBillLog.exists((IObjectPK)pk)) {
                    elStatementBillLog.update((IObjectPK)pk, elStatementBillLogInfo);
                } else {
                    elStatementBillLog.addnew(elStatementBillLogInfo);
                }
            } else {
                elStatementBillLogInfo.setBizDate(bizDate);
                elStatementBillLog.addnew(elStatementBillLogInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private Date formatStrToDate(String date, String formatStr) throws ParseException {
        if (EmptyUtil.isEmpty((String)formatStr)) {
            formatStr = yyyyMMdd;
        }
        SimpleDateFormat dfts = new SimpleDateFormat(formatStr);
        return dfts.parse(date);
    }

    @Override
    protected void _rundownElStructDataByBankType(Context ctx, String bankType, String start, String end) throws BOSException, EASBizException {
        String fBankAccountNumber = "";
        try {
            Date eDate;
            Date sDate;
            if (EmptyUtil.isEmpty((String)start) || EmptyUtil.isEmpty((String)end)) {
                sDate = this.getLastMonthFirstDate(new Date());
                eDate = this.getLastMonthEndDate(new Date());
            } else {
                sDate = this.formatStrToDate(start + "-01", yyyy_MM_dd);
                Date endDate = this.formatStrToDate(end + "-01", yyyy_MM_dd);
                eDate = this.getCurMonthEndDate(endDate);
            }
            this.checkDate(ctx, sDate, eDate);
            IRowSet rowSet = this.getAccountBanksByBankType(ctx, bankType);
            HashSet<String> bankAccountIds = new HashSet<String>();
            while (rowSet.next()) {
                bankAccountIds.add(rowSet.getString("FID"));
            }
            AccountBankCollection bankAcct = this.getBankAccountCol(ctx, bankAccountIds);
            StringBuffer msg = new StringBuffer();
            for (int i = 0; i < bankAcct.size(); ++i) {
                fBankAccountNumber = bankAcct.get(i).getBankAccountNumber();
                this.downElStatementBillInterruptByBankNumberAndDate(ctx, fBankAccountNumber, sDate, eDate);
                this.downloadElStatementBillByDate(ctx, bankAcct.get(i), sDate, eDate, msg, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String commonMsg = "\u4e0b\u8f7d\u3010" + bankType + "\u3011 \u7535\u5b50\u5bf9\u8d26\u5355\u7ed3\u6784\u6027\u6570\u636e\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
            logger.error((Object)commonMsg);
            this.elStatementBillLogUtils.addElStatementBillLog(ctx, null, new Date(), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"603_ElStatementBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage(), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"604_ElStatementBillControllerBean", (Locale)ctx.getLocale()), this.elStatementBillLogUtils.getStackTrace(e), ElStatementBillTypeEnum.DOWNElStructFormat, LevelEnum.ERROR);
            throw new BOSException((Throwable)e);
        }
    }

    protected int downElStatementBillInterruptByBankNumberAndDate(Context ctx, String fBankAccountNumber, Date startDate, Date endDate) throws EASBizException, BOSException {
        int total = 0;
        ElStatementBillInterruptDBUtils elStateInterruptDBUtils = new ElStatementBillInterruptDBUtils();
        CoreBaseCollection colls = elStateInterruptDBUtils.getElStatementBillInterruptCollsByBankNumberAndDate(ctx, fBankAccountNumber, startDate, endDate);
        for (int i = 0; i < colls.size(); ++i) {
            ElStatementBillInterruptInfo elStateInterruptInfo = (ElStatementBillInterruptInfo)colls.get(i);
            int count = this.downElStatementBillInterrupt(ctx, elStateInterruptInfo.getBankNumber(), elStateInterruptInfo.getTransDate());
            total += count;
        }
        String downEreceiptNumMsg = "\u4e0b\u8f7d\u95f4\u65ad\u8bb0\u5f55\uff0c\u94f6\u884c\u8d26\u53f7\uff1a" + fBankAccountNumber + "\u4ea4\u6613\u65e5\u671f\uff1a" + this.dft.format(startDate) + "\u81f3" + this.dft.format(endDate) + "\u5171\u4e0b\u8f7d\u5230\u7535\u5b50\u5bf9\u8d26\u5355\uff1a" + total + " \u6761";
        logger.error((Object)downEreceiptNumMsg);
        return total;
    }

    @Override
    protected void _rundownElOfdByBankType(Context ctx, String bankType) throws BOSException, EASBizException {
        try {
            IRowSet rowSet = this.getAccountBanksByBankType(ctx, bankType);
            HashSet<String> bankAccountIds = new HashSet<String>();
            while (rowSet.next()) {
                bankAccountIds.add(rowSet.getString("FID"));
            }
            ElStatementBillCollection elStatementCol = this.getElStatementBillCol(ctx, bankAccountIds, null, null, 3000);
            IElStatementBill iElStatementBill = ElStatementBillFactory.getLocalInstance(ctx);
            for (int i = 0; i < elStatementCol.size(); ++i) {
                ElStatementBillInfo info = elStatementCol.get(i);
                iElStatementBill.downloadFileValues(info);
            }
        }
        catch (Exception e) {
            String exMsg = "\u4e0b\u8f7d\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
            logger.error((Object)exMsg);
        }
    }

    private IRowSet getAccountBanksByBankType(Context ctx, String bankType) throws BOSException {
        String filters = new String();
        if (!EmptyUtil.isEmpty((String)bankType)) {
            FilterInfo filter = new FilterInfo();
            IBankFacade iBankFacade = BankFacadeFactory.getLocalInstance(ctx);
            String[] banktypes = bankType.split(",");
            HashSet<String> banktypeSet = new HashSet<String>();
            int length = banktypes.length;
            for (int i = 0; i < length; ++i) {
                try {
                    Object[] bankCert = iBankFacade.getBankCert(banktypes[i], "");
                    if (EmptyUtil.isEmpty((Object[])bankCert)) continue;
                    int count = bankCert.length;
                    for (int j = 0; j < count; ++j) {
                        banktypeSet.add(((BankInterface)bankCert[j]).getName());
                    }
                    continue;
                }
                catch (Exception e) {
                    if (!(e instanceof EBGException)) continue;
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
            }
            if (!EmptyUtil.isEmpty(banktypeSet)) {
                filter.getFilterItems().add(new FilterItemInfo("bank.FbankInterFace", banktypeSet, CompareType.INCLUDE));
                filters = filter.toString();
            }
        }
        StringBuffer sqlStr = new StringBuffer("SELECT");
        sqlStr.append(" distinct FID, FBankAccountNumber,FName_L2 ,FAcctName,  FBankInterFace from T_BD_AccountBanks bank where " + filters + "and bank.FIsClosed = 0 and bank.FIsSetBankInterface = 1 and bank.FIsElStatement = 1 order by bank.FBankInterFace");
        logger.error((Object)("\u83b7\u53d6\u5f00\u901a\u8be5\u94f6\u4f01\u63a5\u53e3\u7684\u94f6\u884c\u8d26\u6237\u7ed3\u679c\u96c6SQL:" + sqlStr));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        return rowSet;
    }

    @Override
    protected int _downElStatementBillInterrupt(Context ctx, String fBankNumber, Date transDate) throws BOSException, EASBizException {
        int count = 0;
        StringBuffer msg = new StringBuffer();
        count = this.downLoadElStatementBillByBankNumberAndDate(ctx, fBankNumber, transDate, msg, false);
        return count;
    }

    @Override
    protected String _downPDFValuesByRPA(Context ctx, ElStatementBillInfo elStatementBillInfo) throws BOSException, EASBizException {
        String result = "";
        logger.error((Object)"---------------------------------------------------------------------------\u5bfc\u5165\u7535\u5b50\u5bf9\u8d26\u5355\u5f00\u59cb-----------------------------------------------------------");
        if (elStatementBillInfo != null) {
            try {
                logger.error((Object)("\u7535\u5b50\u5bf9\u8d26\u5355\u6570\u636e\uff1a" + elStatementBillInfo));
                String bankAccountNumber = elStatementBillInfo.getBankAcctName();
                if (bankAccountNumber != null && bankAccountNumber.trim().length() > 0) {
                    byte[] base64;
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)bankAccountNumber.trim()));
                    filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
                    view.setFilter(filter);
                    AccountBankCollection accountBankCol = new AccountBankCollection();
                    accountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                    if (accountBankCol == null || accountBankCol.size() < 1) {
                        throw new BOSException("\u94f6\u884c\u8d26\u53f7:" + bankAccountNumber + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    if (accountBankCol.get(0).isIsClosed()) {
                        throw new BOSException("\u94f6\u884c\u8d26\u53f7:" + bankAccountNumber + "\u4e3a\u5df2\u9500\u6237\u8d26\u6237\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    elStatementBillInfo.setBankAccount(accountBankCol.get(0));
                    elStatementBillInfo.setBankAcctName(accountBankCol.get(0).getName());
                    elStatementBillInfo.setCompany(accountBankCol.get(0).getCompany());
                    if (EmptyUtil.isEmpty((Object)elStatementBillInfo.getTransDate())) {
                        throw new BOSException("\u94f6\u884c\u8d26\u53f7:" + bankAccountNumber + "\u4ea4\u6613\u65e5\u671f\u6ca1\u6709\u503c\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    String fileValue = elStatementBillInfo.getDescription();
                    logger.error((Object)("\u6587\u4ef6\u5185\u5bb9\uff1a" + fileValue));
                    if (fileValue != null && fileValue.toString().trim().length() > 0) {
                        fileValue = URLEncoder.encode(fileValue);
                        base64 = null;
                        try {
                            base64 = Base64.decode((String)URLDecoder.decode(fileValue, "utf-8"));
                        }
                        catch (UnsupportedEncodingException e2) {
                            e2.printStackTrace();
                        }
                    } else {
                        throw new BOSException("\u94f6\u884c\u8d26\u53f7:" + bankAccountNumber + "PDF\u6587\u4ef6\u6ca1\u6709\u503c\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    elStatementBillInfo.setFileValue(base64);
                    elStatementBillInfo.setDescription(null);
                    if (EmptyUtil.isEmpty((Object)elStatementBillInfo.getDebitAmount()) && EmptyUtil.isEmpty((Object)elStatementBillInfo.getCreditAmount())) {
                        throw new BOSException("\u94f6\u884c\u8d26\u53f7:" + bankAccountNumber + "\u4ed8\u6b3e\u91d1\u989d\u548c\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u6ca1\u503c\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                } else {
                    throw new BOSException("\u94f6\u884c\u8d26\u53f7\u6ca1\u6709\u503c\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                logger.error((Object)"\u5f00\u59cb\u4fdd\u5b58\u7535\u5b50\u5bf9\u8d26\u5355");
                this.importElStatementBill(ctx, elStatementBillInfo);
                logger.error((Object)"\u4fdd\u5b58\u7535\u5b50\u5bf9\u8d26\u5355\u6210\u529f");
                result = "\u5bfc\u5165\u7535\u5b50\u5bf9\u8d26\u5355\u6210\u529f\uff01";
            }
            catch (Exception e) {
                result = "\u5bfc\u5165\u7535\u5b50\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage() + "; ";
                logger.error((Object)("\u5bfc\u5165\u7535\u5b50\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage()));
                e.printStackTrace();
            }
        } else {
            result = "\u5bfc\u5165\u7535\u5b50\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\u3002";
            logger.error((Object)"\u5bfc\u5165\u7535\u5b50\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        logger.error((Object)"---------------------------------------------------------------------------\u5bfc\u5165\u7535\u5b50\u5bf9\u8d26\u5355\u5f00\u59cb-----------------------------------------------------------");
        return result;
    }
}

