/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.ElStatementBillFactory;
import com.kingdee.eas.fm.be.ElStatementBillLogCollection;
import com.kingdee.eas.fm.be.ElStatementBillLogFactory;
import com.kingdee.eas.fm.be.ElStatementBillLogInfo;
import com.kingdee.eas.fm.be.ElStatementBillTypeEnum;
import com.kingdee.eas.fm.be.LevelEnum;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;

public class ElStatementBillLogUtils {
    public void addElStatementBillLog(Context ctx, String bankNumber, Date transDate, String errorMsg, String message, String logDetail, ElStatementBillTypeEnum logType, LevelEnum level) throws BOSException, EASBizException {
        ElStatementBillLogInfo elStatementBillLog = new ElStatementBillLogInfo();
        elStatementBillLog.setBankNumber(bankNumber);
        elStatementBillLog.setTransDate(transDate);
        if (errorMsg.length() > 200) {
            errorMsg = errorMsg.substring(0, 200);
        }
        elStatementBillLog.setErrorMessage(errorMsg);
        elStatementBillLog.setMessage(message);
        elStatementBillLog.setLogDetail(logDetail);
        elStatementBillLog.setLogType(logType);
        elStatementBillLog.setLevel(level);
        ElStatementBillFactory.getLocalInstance(ctx).insertElStatementBillLog(elStatementBillLog);
    }

    public void saveElStatementBillLog(Context ctx, String bankNumber, Date transDate, String errorMsg, String message, String logDetail, ElStatementBillTypeEnum logType, LevelEnum level) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("transDate", (Object)transDate, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bankNumber", (Object)bankNumber, CompareType.EQUALS));
        view.setFilter(filter);
        ElStatementBillLogCollection colls = ElStatementBillLogFactory.getLocalInstance(ctx).getElStatementBillLogCollection(view);
        if (errorMsg.length() > 200) {
            errorMsg = errorMsg.substring(0, 200);
        }
        if (colls != null && colls.size() > 0) {
            ElStatementBillLogInfo elStatementBillLogInfo = colls.get(0);
            elStatementBillLogInfo.setErrorMessage(errorMsg);
            elStatementBillLogInfo.setMessage(message);
            elStatementBillLogInfo.setLogDetail(logDetail);
            elStatementBillLogInfo.setLogType(logType);
            elStatementBillLogInfo.setLevel(level);
            ElStatementBillLogFactory.getLocalInstance(ctx).updateElStatementBillLog(elStatementBillLogInfo);
        } else {
            ElStatementBillLogInfo elStatementBillLogInfo = new ElStatementBillLogInfo();
            elStatementBillLogInfo.setBankNumber(bankNumber);
            elStatementBillLogInfo.setTransDate(transDate);
            elStatementBillLogInfo.setErrorMessage(errorMsg);
            elStatementBillLogInfo.setMessage(message);
            elStatementBillLogInfo.setLogDetail(logDetail);
            elStatementBillLogInfo.setLogType(logType);
            elStatementBillLogInfo.setLevel(level);
            ElStatementBillFactory.getLocalInstance(ctx).insertElStatementBillLog(elStatementBillLogInfo);
        }
    }

    public void deleteElStatementBillLog(Context ctx) throws BOSException, EASBizException {
        Date today = new Date();
        Calendar date = Calendar.getInstance();
        date.setTime(today);
        date.set(5, date.get(5) - 90);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)date.getTime(), CompareType.LESS));
        ElStatementBillLogFactory.getLocalInstance(ctx).delete(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
    }
}

