/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.FixedMutualBusinessTypeEnum;
import com.kingdee.eas.fm.be.FixedMutualCollection;
import com.kingdee.eas.fm.be.FixedMutualInfo;
import com.kingdee.eas.fm.be.FixedMutualStatusEnum;
import com.kingdee.eas.fm.be.app.AbstractFixedMutualControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.td.ApplyBillStatusEnum;
import com.kingdee.eas.fm.td.ITimeDepositApply;
import com.kingdee.eas.fm.td.IUnTimeDepositApplyBill;
import com.kingdee.eas.fm.td.TimeDepositApplyFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyInfo;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class FixedMutualControllerBean
extends AbstractFixedMutualControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.FixedMutualControllerBean");

    @Override
    protected void _bitBack(Context ctx, IObjectPK[] ids) throws BOSException, EASBizException {
        ArrayList<IObjectPK> list = new ArrayList<IObjectPK>();
        for (int i = 0; i < ids.length; ++i) {
            list.add(ids[i]);
        }
        FixedMutualCollection coll = this.getColl4BitBack(ctx, list);
        if (FMHelper.isEmpty((AbstractObjectCollection)coll)) {
            throw new BEException(BEException.NOSUITRECORD);
        }
        for (int i = 0; i < coll.size(); ++i) {
            FixedMutualInfo info = coll.get(i);
            String sbillId = info.getSourceBillId();
            if (!FMHelper.isEmpty((String)sbillId)) {
                if (info.getBusinessType().equals((Object)FixedMutualBusinessTypeEnum.DP)) {
                    this.rever0Remove(ctx, sbillId);
                } else {
                    this.rever1Remove(ctx, sbillId);
                }
            }
            info.setFightBack(true);
            super.save(ctx, (CoreBaseInfo)info);
        }
    }

    private FixedMutualCollection getColl4BitBack(Context ctx, List ids) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        ev.setFilter(filter);
        FixedMutualCollection coll = this.getFixedMutualCollection(ctx, ev);
        return coll;
    }

    @Override
    protected void _reserveForBE(Context ctx, String FixedbillId, FixedMutualStatusEnum status) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _updateState(Context ctx, IObjectPK[] pks, BankPayingBillStateEnum status) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0) {
            return false;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < pks.length; ++i) {
            idSet.add(pks[i].toString());
        }
        if (status.getValue() != 6 && status.getValue() != 5) {
            throw new BEException(BEException.UPDATESTATEERROR2);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        String sql = "UPDATE T_BE_FixedMutual Set FStatus = ? WHERE FID = ? ";
        FixedMutualCollection coll = this.getFixedMutualCollection(ctx, evi);
        FixedMutualInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getStatus().equals((Object)BankPayingBillStateEnum.NC)) {
                throw new BEException(BEException.UPDATESTATEERROR1);
            }
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status.getValue()), info.getId().toString()});
            info.setStatus(status);
            this.reverseSourceBillState(ctx, info);
        }
        return true;
    }

    private void reverseSourceBillState(Context ctx, FixedMutualInfo info) throws BOSException, EASBizException {
        String sourceBill = info.getSourceBillId();
        BankPayingBillStateEnum state = info.getStatus();
        String numbers = info.getNumber();
        if (FMHelper.isEmpty((String)sourceBill)) {
            return;
        }
        String tableName = "";
        BOSUuid sbid = BOSUuid.read((String)sourceBill);
        if (sbid.getType().equals((Object)new TimeDepositApplyInfo().getBOSType())) {
            tableName = "T_TD_TimeDepositApply";
        }
        if (sbid.getType().equals((Object)new UnTimeDepositApplyBillInfo().getBOSType())) {
            tableName = "T_TD_UnTimeDepositApplyBill";
        }
        String sql = "Update " + tableName + " set FStatus =?  where fid  = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, state.getValue());
            pstmt.setString(2, sourceBill);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BEException(BEException.WRITESTATEFAILURE);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _commit2Bank(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _commit2BankDepoit(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _commit2BankFixed(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
    }

    private void rever0Remove(Context ctx, String sbillId) throws BOSException, EASBizException {
        BOSUuid id = BOSUuid.read((String)sbillId);
        ITimeDepositApply itimeDepositApply = TimeDepositApplyFactory.getLocalInstance((Context)ctx);
        TimeDepositApplyInfo timedepositapplyInfo = itimeDepositApply.getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(id));
        timedepositapplyInfo.setStatus(BankPayingBillStateEnum.OP);
        timedepositapplyInfo.setBillState(ApplyBillStatusEnum.SAVE);
        itimeDepositApply.save((CoreBaseInfo)timedepositapplyInfo);
    }

    private void rever1Remove(Context ctx, String sbillId) throws BOSException, EASBizException {
        BOSUuid id = BOSUuid.read((String)sbillId);
        IUnTimeDepositApplyBill iuntimeDepositApplyBill = UnTimeDepositApplyBillFactory.getLocalInstance((Context)ctx);
        UnTimeDepositApplyBillInfo untimeDepositApplyBillInfo = iuntimeDepositApplyBill.getUnTimeDepositApplyBillInfo((IObjectPK)new ObjectUuidPK(id));
        untimeDepositApplyBillInfo.setStatus(BankPayingBillStateEnum.OP);
        untimeDepositApplyBillInfo.setBillState(ApplyBillStatusEnum.SAVE);
        iuntimeDepositApplyBill.save((CoreBaseInfo)untimeDepositApplyBillInfo);
    }
}

