/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.IRateParser;
import com.kingdee.eas.fm.common.jsoup.Connection;
import com.kingdee.eas.fm.common.jsoup.Jsoup;
import com.kingdee.eas.fm.common.jsoup.nodes.Document;
import com.kingdee.eas.fm.common.jsoup.nodes.Element;
import com.kingdee.eas.fm.common.jsoup.select.Elements;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JsoupParserForBOC
implements IRateParser {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.JsoupParserForBOC");
    public static String URL = "https://www.boc.cn/sourcedb/whpj/index.html";
    private String address;

    JsoupParserForBOC(String address) {
        this.address = address;
    }

    @Override
    public Map<String, BigDecimal> getRateMap() throws Exception {
        if (!EmptyUtil.isEmpty((String)this.address)) {
            URL = "https://" + this.address + "/sourcedb/whpj/index.html";
        }
        Connection conn = Jsoup.connect((String)URL);
        logger.error((Object)("\u540c\u6b65\u4e2d\u56fd\u94f6\u884c\u6c47\u7387URL\uff1a" + URL));
        Document doc = conn.timeout(100000).get();
        logger.error((Object)doc);
        return this.parseContent(doc);
    }

    private Map<String, BigDecimal> parseContent(Document doc) {
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        Elements divElements = doc.select("div.publish table");
        if (divElements != null && divElements.size() > 1) {
            Element rateTableEle = divElements.get(1);
            Elements trElements = rateTableEle.getElementsByTag("tr");
            for (int i = 1; i < trElements.size(); ++i) {
                Element rateEle = trElements.get(i);
                Elements tdElements = rateEle.getElementsByTag("td");
                String currencyName = tdElements.get(0).html();
                BigDecimal convertAmt = new BigDecimal(tdElements.get(5).html()).divide(new BigDecimal(100));
                logger.error((Object)("\u5e01\u522b\uff1a" + currencyName + " \u4e2d\u95f4\u6298\u7b97\u4ef7\uff1a" + convertAmt));
                rateMap.put(currencyName, convertAmt);
            }
        }
        return rateMap;
    }

    public static void main(String[] args) {
        JsoupParserForBOC bocParser = new JsoupParserForBOC("");
        try {
            bocParser.getRateMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

