/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.eas.fm.be.IRateParser;
import com.kingdee.eas.fm.common.jsoup.Connection;
import com.kingdee.eas.fm.common.jsoup.Jsoup;
import com.kingdee.eas.fm.common.jsoup.nodes.Document;
import com.kingdee.eas.fm.common.jsoup.nodes.Element;
import com.kingdee.eas.fm.common.jsoup.select.Elements;
import com.kingdee.eas.mobile.convert.util.EmptyUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JsoupParserForHLW
implements IRateParser {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.JsoupParserForBOC");
    public String URL = "http://www.huilv.cc/renminyinhanghuilv.html";
    private String address;

    public JsoupParserForHLW(String address) {
        this.address = address;
    }

    @Override
    public Map<String, BigDecimal> getRateMap() throws Exception {
        if (!EmptyUtil.isEmpty((String)this.address)) {
            this.URL = "http://" + this.address + "/renminyinhanghuilv.html";
        }
        Connection conn = Jsoup.connect((String)this.URL);
        logger.error((Object)("\u6c47\u7387\u7f51\uff0d\uff0d\u4e2d\u56fd\u4eba\u6c11\u94f6\u884c\u4eba\u6c11\u5e01\u6c47\u7387\u4e2d\u95f4\u4ef7\uff1a" + this.URL));
        Document doc = conn.timeout(100000).get();
        logger.error((Object)doc);
        return this.parseContent(doc);
    }

    private Map<String, BigDecimal> parseContent(Document doc) {
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        Elements divElements = doc.select(".data-table");
        if (divElements != null && divElements.size() > 0) {
            Element rateTableEle = divElements.get(0);
            Elements trElements = rateTableEle.getElementsByTag("tr");
            for (int i = 1; i < trElements.size(); ++i) {
                Element rateEle = trElements.get(i);
                Elements tdElements = rateEle.getElementsByTag("td");
                String currencyName = tdElements.get(0).html();
                if (currencyName.contains("(")) {
                    currencyName = currencyName.substring(currencyName.indexOf("(") + 1, currencyName.length() - 1);
                }
                String unitValue = tdElements.get(1).getElementsByTag("span").get(0).html();
                String BOEConversionRate = tdElements.get(6).getElementsByTag("span").get(0).html();
                BigDecimal convertAmt = new BigDecimal(BOEConversionRate).divide(new BigDecimal(unitValue));
                logger.error((Object)("\u5e01\u522b\uff1a" + currencyName + " \u4e2d\u884c\u6298\u7b97\u4ef7\uff1a" + convertAmt));
                rateMap.put(currencyName, convertAmt);
            }
        }
        return rateMap;
    }

    public static void main(String[] args) {
        JsoupParserForHLW hlwParser = new JsoupParserForHLW("");
        try {
            hlwParser.getRateMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

