/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.eas.fm.be.IRateParser;
import com.kingdee.eas.fm.common.jsoup.Connection;
import com.kingdee.eas.fm.common.jsoup.Jsoup;
import com.kingdee.eas.fm.common.jsoup.nodes.Document;
import com.kingdee.eas.fm.common.jsoup.nodes.Element;
import com.kingdee.eas.fm.common.jsoup.select.Elements;
import com.kingdee.eas.mobile.convert.util.EmptyUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class JsoupParserForPBOC
implements IRateParser {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.JsoupParserForPBOC");
    private String HOSTNAME = "http://www.pbc.gov.cn";
    private String URL = this.HOSTNAME + "/zhengcehuobisi/125207/125217/125925/index.html";
    private String address;
    private static final String COOKIEVALUE = "0370ae848422553017149a6e3b6f229b; _gscu_1042262807=84448023be7w3y42; _gscs_1042262807=84448023n5265z42|pv:2; _gscbrs_1042262807=1; wzwsconfirm=917219b8350736bc3342fad767eea27b; wzwsvtime=1484448804; wzwstemplate=NA==; wzwschallenge=V1pXU19DT05GSVJNX1BSRUZJWF9MQUJFTDQxMzI0MDc=";

    JsoupParserForPBOC(String address) {
        this.address = address;
    }

    public Document getResultByURL(String url) throws Exception {
        Connection conn = Jsoup.connect((String)url).cookie("ccpassport", COOKIEVALUE);
        return conn.timeout(100000).get();
    }

    public Map<String, BigDecimal> parseContent(String result) throws Exception {
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        String subRateText = result.substring(result.indexOf("\uff1a") + 1, result.length() - 1);
        subRateText = subRateText.replace("\uff0c", ",");
        String[] rateArray = subRateText.split(",");
        for (int i = 0; i < rateArray.length; ++i) {
            this.parseOneRate(rateMap, rateArray[i]);
        }
        return rateMap;
    }

    @Override
    public Map<String, BigDecimal> getRateMap() throws Exception {
        Map<String, BigDecimal> rateMap = null;
        if (!EmptyUtil.isEmpty((String)this.address)) {
            this.URL = "http://" + this.address + "/zhengcehuobisi/125207/125217/125925/index.html";
        }
        logger.error((Object)("URL:" + this.URL));
        logger.error((Object)"\u83b7\u53d6doc--------------------------------------------------------------------------------------------------------------------");
        Document doc = this.getResultByURL(this.URL);
        logger.error((Object)doc);
        logger.error((Object)"\u83b7\u53d6DOC\u5b8c\u6210-----------------------------------------------------------------------------------------------------------------");
        Element rDiv = doc.getElementById("r_con");
        logger.error((Object)rDiv);
        logger.error((Object)"\u83b7\u53d6rDiv\u5b8c\u6210-----------------------------------------------------------------------------------------------------------------");
        Elements aElements = rDiv.select("a[title]");
        if (aElements.size() > 0) {
            Element lastRateAElement = aElements.get(0);
            String href = lastRateAElement.attr("href");
            String title = lastRateAElement.attr("title");
            logger.error((Object)("\u94fe\u63a5\u5730\u5740\u4e3a\uff1a" + href));
            logger.error((Object)("title\u4e3a\uff1a" + title));
            String destURL = "http://www.pbc.gov.cn" + href;
            Document destDoc = this.getResultByURL(destURL);
            Element rateElement = destDoc.getElementById("zoom");
            Elements pElements = rateElement.getElementsByTag("p");
            if (pElements.size() > 0) {
                String rateText = pElements.get(0).html();
                logger.error((Object)"\u83b7\u53d6\u5230\u6c47\u7387\u516c\u544a\u4e3a\uff1a");
                logger.error((Object)rateText);
                rateMap = this.parseContent(rateText);
            }
        }
        return rateMap;
    }

    private void parseOneRate(Map<String, BigDecimal> rateMap, String rateString) {
        String currencyName = null;
        BigDecimal rate = null;
        if (rateString.startsWith("1")) {
            String rateStr = rateString.substring(rateString.indexOf("\u5e01") + 1, rateString.length() - 1);
            rate = new BigDecimal(rateStr);
            if (rateString.contains("\u65e5\u5143")) {
                currencyName = "\u65e5\u5143";
                String unit = rateString.substring(0, rateString.indexOf("\u65e5"));
                rate = rate.divide(new BigDecimal(unit));
            } else {
                currencyName = rateString.substring(1, rateString.indexOf("\u5bf9"));
            }
        } else {
            rateString = rateString.substring(rateString.indexOf("\u5bf9") + 1);
            Pattern pattern = Pattern.compile("\\d+.+\\d+");
            Matcher matcher = pattern.matcher(rateString);
            while (matcher.find()) {
                String rateValue = matcher.group(0);
                rate = new BigDecimal(rateValue);
                rateString = rateString.replaceAll(rateValue, "");
            }
            currencyName = rateString;
        }
        rateMap.put(currencyName, rate);
        logger.error((Object)("\u5e01\u522b\uff1a" + currencyName + "  \u6c47\u7387\uff1a" + rate));
    }

    public static void main(String[] args) {
        try {
            String aa = "http://www.pbc.gov.cn/zhengcehuobisi/125207/125217/125925/index.html";
            Object cookies = null;
            Connection conn = Jsoup.connect((String)aa).cookie("ccpassport", COOKIEVALUE);
            Document doc = conn.timeout(100000).get();
            System.out.println(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

