/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.IRateParser;
import com.kingdee.eas.fm.be.app.util.CloundDriveUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class JuHeParser
implements IRateParser {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.JuHeParser");
    private String APPKEY = "64fedace2ee1a7f9decde6d38f15eada";
    private String RATEURL = "https://op.juhe.cn/onebox/exchange/query";
    private String address;

    public JuHeParser(String address) {
        this.address = address;
    }

    public String getResultByURL(String url) throws Exception {
        return CloundDriveUtils.sendGetRequest(url);
    }

    public Map<String, BigDecimal> parseContent(String result) throws Exception {
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        JSONObject rsJson = new JSONObject(result);
        JSONObject rsObj = rsJson.getJSONObject("result");
        JSONArray rateArrays = rsObj.getJSONArray("list");
        for (int i = 0; i < rateArrays.length(); ++i) {
            JSONArray rateAarry = (JSONArray)rateArrays.get(i);
            String currencyName = rateAarry.getString(0);
            BigDecimal unit = new BigDecimal(rateAarry.getString(1));
            BigDecimal convertByBankAmt = new BigDecimal(rateAarry.getString(5));
            BigDecimal convertAmt = convertByBankAmt.divide(unit);
            rateMap.put(currencyName, convertAmt);
        }
        return rateMap;
    }

    @Override
    public Map<String, BigDecimal> getRateMap() throws Exception {
        if (!EmptyUtil.isEmpty((String)this.address)) {
            this.RATEURL = "https://" + this.address + "/onebox/exchange/query";
        }
        String url = this.RATEURL + "?key=" + this.APPKEY;
        logger.error((Object)("\u805a\u5408URL=" + url));
        String result = this.getResultByURL(url);
        System.out.println("\u805a\u5408\u8fd4\u56de\u6570\u636e\uff1a" + result);
        logger.error((Object)("\u805a\u5408\u8fd4\u56de\u6570\u636e\uff1a" + result));
        JSONObject rsJson = new JSONObject(result);
        String errcode = rsJson.getString("error_code");
        Map<String, BigDecimal> rateMap = null;
        if (errcode.equals("0")) {
            rateMap = this.parseContent(result);
        } else {
            logger.error((Object)("\u83b7\u53d6\u6c47\u7387\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u6c47\u7387\u4fe1\u606f\uff01" + result));
        }
        return rateMap;
    }

    public static void main(String[] args) {
        JuHeParser jh = new JuHeParser("");
        try {
            jh.getRateMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

