/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.datatask.AbstractDataImport;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.IOpenArea;
import com.kingdee.eas.fm.be.OpenAreaCollection;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class OpenAreaDataImport
extends AbstractDataImport {
    protected ICoreBase _getController(Context ctx) throws BOSException, EASBizException {
        return OpenAreaFactory.getLocalInstance((Context)ctx);
    }

    private String getBEAutoGenerateResource(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)resName, (Locale)ctx.getLocale());
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        String number;
        OpenAreaInfo openAreaInfo = new OpenAreaInfo();
        this.prepareImport(ctx, (IObjectValue)openAreaInfo, hsData);
        if (!this.isOverrideImport()) {
            OpenAreaCollection coll = this.getOpenAreaCollection(ctx, openAreaInfo.getBankInterfaceName(), openAreaInfo.getNumber(), openAreaInfo.getProvince(), openAreaInfo.getName());
            if (coll.size() > 0) {
                throw new BOSException(this.getBEAutoGenerateResource(ctx, "342_OpenAreaEditUI"));
            }
        } else {
            OpenAreaCollection coll = this.getOpenAreaCollection(ctx, openAreaInfo.getBankInterfaceName(), openAreaInfo.getNumber(), null, null);
            if (coll.size() > 1) {
                throw new BOSException(this.getBEAutoGenerateResource(ctx, "343_OpenAreaDataImport"));
            }
            if (coll.size() > 0) {
                OpenAreaInfo openAreaInfoInDB = coll.get(0);
                this.updateField(openAreaInfo, openAreaInfoInDB);
                return openAreaInfoInDB;
            }
        }
        if (EmptyUtil.isEmpty((String)(number = this.getBankCertMap(ctx).get(this.fixedName(openAreaInfo.getBankInterfaceName()))))) {
            throw new BOSException(this.getBEAutoGenerateResource(ctx, "344_OpenAreaDataImport"));
        }
        openAreaInfo.setBankInterFaceid(number);
        return openAreaInfo;
    }

    private OpenAreaCollection getOpenAreaCollection(Context ctx, String bankInterfaceName, String number, String province, String city) throws BOSException {
        EntityViewInfo view = this.getEntityViewInfo(bankInterfaceName, number, province, city);
        OpenAreaCollection coll = OpenAreaFactory.getLocalInstance((Context)ctx).getOpenAreaCollection(view);
        return coll;
    }

    private EntityViewInfo getEntityViewInfo(String bankInterfaceName, String number, String province, String city) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (!EmptyUtil.isEmpty((String)bankInterfaceName)) {
            fi.getFilterItems().add(new FilterItemInfo("bankInterfaceName", (Object)this.fixedName(bankInterfaceName)));
        }
        if (!EmptyUtil.isEmpty((String)number)) {
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        }
        if (!EmptyUtil.isEmpty((String)province)) {
            fi.getFilterItems().add(new FilterItemInfo("province", (Object)province));
        }
        if (!EmptyUtil.isEmpty((String)city)) {
            fi.getFilterItems().add(new FilterItemInfo("name", (Object)city));
        }
        view.setFilter(fi);
        return view;
    }

    private String fixedName(String name) {
        if (name.indexOf("-") >= 0) {
            return name.substring(0, name.indexOf("-"));
        }
        return name;
    }

    private boolean isOverrideImport() {
        int dataTaskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        return dataTaskMode == 16;
    }

    private void updateField(OpenAreaInfo sourceOpenAreaInfo, OpenAreaInfo destOpenAreaInfo) {
        destOpenAreaInfo.setProvince(sourceOpenAreaInfo.getProvince());
        destOpenAreaInfo.setName(sourceOpenAreaInfo.getName());
        destOpenAreaInfo.setDeptID(sourceOpenAreaInfo.getDeptID());
    }

    private Map<String, String> getBankCertMap(Context ctx) throws BOSException, EASBizException {
        Object[] bankCert = BankFacadeFactory.getLocalInstance(ctx).getBankCert("", "");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (int i = 0; i < bankCert.length; ++i) {
            BankInterface info = (BankInterface)bankCert[i];
            resultMap.put(this.fixedName(info.getName()), info.getNumber());
        }
        return resultMap;
    }

    protected void _submit(CoreBaseInfo info, Context ctx) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        IOpenArea iOpenArea = (IOpenArea)this._getController(ctx);
        if (info.getId() == null || !iOpenArea.exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            iOpenArea.addnew(info);
        } else {
            iOpenArea.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
        }
    }
}

