/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.IOpenArea;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.fm.be.app.AbstractOpenAreaWebFacadeControllerBean;
import com.kingdee.eas.fm.be.util.OpenAreaHelper;
import com.kingdee.eas.fm.be.vo.OpenAreaVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OpenAreaWebFacadeControllerBean
extends AbstractOpenAreaWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.OpenAreaWebFacadeControllerBean");
    private static final String DELETEPERITEM = "openArea_03delete";
    private static final String VIEWPERITEM = "openArea_04view";
    private static final String EDITPERITEM = "openArea_02edit";
    private static final String ADDPERITEM = "openArea_01addnew";

    @Override
    protected Map _deleteOpenArea(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, Object> rstData = new HashMap<String, Object>();
        OpenAreaVO dataVO = (OpenAreaVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, OpenAreaVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputDataExption"));
            return rstData;
        }
        if (dataVO.getDeleteIDs() == null || dataVO.getDeleteIDs().length <= 0) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"PleSelectedDeleteRow"));
            return rstData;
        }
        IOpenArea iOpenArea = OpenAreaFactory.getLocalInstance((Context)ctx);
        try {
            boolean hasPermission;
            boolean bl = hasPermission = CASWebHelper.getAuthorizedOrg((Context)ctx, (String)DELETEPERITEM, (boolean)false).size() > 0;
            if (!hasPermission) {
                throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
            }
            int lens = dataVO.getDeleteIDs().length;
            ArrayList<ObjectUuidPK> sucPKList = new ArrayList<ObjectUuidPK>();
            StringBuffer errorMsg = new StringBuffer();
            ArrayList<String> errorMsgList = new ArrayList<String>();
            ObjectUuidPK delPK = null;
            for (int idx = 0; idx < lens; ++idx) {
                delPK = new ObjectUuidPK(dataVO.getDeleteIDs()[idx]);
                IObjectPK[] pkArray = new IObjectPK[]{delPK};
                try {
                    OpenAreaHelper.getInstance().isReferenced((IDataBase)iOpenArea, pkArray, ctx);
                    sucPKList.add(delPK);
                    continue;
                }
                catch (EASBizException ee) {
                    errorMsg.append(ee.getMessage(ctx.getLocale()));
                    errorMsgList.add(ee.getMessage(ctx.getLocale()));
                }
            }
            int sucDelCount = sucPKList.size();
            if (sucDelCount > 0) {
                ObjectUuidPK[] sucDelPKArray = new ObjectUuidPK[sucDelCount];
                for (int idx = 0; idx < sucDelCount; ++idx) {
                    sucDelPKArray[idx] = (IObjectPK)sucPKList.get(idx);
                }
                iOpenArea.deleteBatchData((IObjectPK[])sucDelPKArray);
            }
            if (errorMsg.length() > 0) {
                String[] args = new String[]{String.valueOf(sucDelCount), String.valueOf(lens - sucDelCount)};
                String opHeadMsg = CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])args);
                rstData.put("MsgStr", opHeadMsg);
                rstData.put("MsgDetail", errorMsg.toString());
                rstData.put("OPStatus", "success");
                rstData.put("DeleteSuccessCount", sucDelCount);
                rstData.put("errorMsgList", errorMsgList);
                return rstData;
            }
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"DeletedOK"));
            rstData.put("OPStatus", "success");
            return rstData;
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
    }

    @Override
    protected Map _saveOpenArea(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        OpenAreaVO dataVO = (OpenAreaVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, OpenAreaVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputDataExption"));
            return rstData;
        }
        OpenAreaInfo openAreaInfo = OpenAreaHelper.getInstance().VOToInfo(ctx, dataVO);
        IOpenArea iOpenArea = OpenAreaFactory.getLocalInstance((Context)ctx);
        IObjectPK rstID = null;
        try {
            boolean hasPermission;
            boolean bl = hasPermission = CASWebHelper.getAuthorizedOrg((Context)ctx, (String)ADDPERITEM, (boolean)false).size() > 0;
            if (!hasPermission) {
                if (openAreaInfo.getId() == null) {
                    throw new CasWebException(CasWebException.NO_ADDNEW_AUTHRIZED);
                }
                throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankInterFaceid", (Object)openAreaInfo.getBankInterFaceid()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)openAreaInfo.getNumber()));
            filter.getFilterItems().add(new FilterItemInfo("province", (Object)openAreaInfo.getProvince()));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)openAreaInfo.getName()));
            if (OpenAreaFactory.getRemoteInstance().exists(filter)) {
                throw new BEException(BEException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"342_OpenAreaEditUI", (Locale)ctx.getLocale())});
            }
            rstID = iOpenArea.submit((CoreBaseInfo)openAreaInfo);
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
        if (rstID != null) {
            rstData.put("MsgStr", CASWebHelper.getCASMsg((Context)ctx, (String)"SAVE_Successfully"));
            rstData.put("OPStatus", "success");
            rstData.put("IdAfterSave", (String)rstID);
        }
        return rstData;
    }
}

