/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.RptBizTypeEnum;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportHelper {
    private static final Logger logger = CoreUIObject.getLogger(ReportHelper.class);

    public static Map turnListToMap(List ltJg) {
        HashMap<String, String> returnValue = new HashMap<String, String>();
        int size = ltJg.size();
        for (int i = 0; i < size; ++i) {
            String value = ((BankInterface)ltJg.get(i)).getNumber();
            String alias = ((BankInterface)ltJg.get(i)).getName();
            returnValue.put(value, alias);
        }
        return returnValue;
    }

    public static LinkedHashMap turnSqlToList(Context ctx, String sql) {
        LinkedHashMap<String, String> returnValue = new LinkedHashMap<String, String>();
        IRowSet rst = null;
        try {
            ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
            rst = exec.executeSQL();
            while (rst.next()) {
                String value = rst.getString(1);
                String name = rst.getString(2);
                returnValue.put(value, name);
            }
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public static void setSchemaConfigFileMacroValue(Map measureMap, SchemaSource ss, String varName) {
        StringBuffer m = new StringBuffer();
        for (String key : measureMap.keySet()) {
            String value = (String)measureMap.get(key);
            logger.info((Object)(key + " " + value));
            m.append("<Measure name=\"" + value + "\" caption=\"" + value + "\" column=\"F" + value + "\" aggregator=\"sum\" formatString=\"#,##0.00\"/>\r\n");
        }
        ss.setMacroValue(varName, m.toString());
    }

    public static StringBuffer madeFactObjSql(RptParams params, Map objMap, String compareVar, String comparesSign) {
        RptBizTypeEnum upDownType = (RptBizTypeEnum)((Object)params.getObjectElement("upDownType.value"));
        Date dtpFromDate = (Date)params.getObjectElement("dtpFromDate.value");
        Date dtpToDate = (Date)params.getObjectElement("dtpToDate.value");
        CurrencyInfo currency = (CurrencyInfo)params.getObjectElement("cboCurrency.value");
        StringBuffer debitOrCredit = new StringBuffer();
        StringBuffer where = new StringBuffer();
        where.append(" where t3.FIsMotherAccount =0 ");
        if (RptBizTypeEnum.transUp.equals((Object)upDownType)) {
            debitOrCredit.append(" FDebitAmount ");
            where.append(" and t2.FBizType = ").append(2);
        } else if (RptBizTypeEnum.transDown.equals((Object)upDownType)) {
            debitOrCredit.append(" FCreditAmount ");
            where.append(" and t2.FBizType = ").append(3);
        } else {
            debitOrCredit.append(" FDebitAmount-FCreditAmount ");
            where.append(" and t2.FBizType in (").append(2).append(",").append(3).append(")");
        }
        if (currency != null) {
            where.append(" and t2.FCurrencyID = '").append(currency.getId().toString()).append("'");
        }
        if (dtpFromDate != null) {
            where.append(" and t2.FBizTime >= {").append(DateUtil.getSQLBegin((Date)dtpFromDate)).append("}");
        }
        if (dtpToDate != null) {
            where.append(" and t2.FBizTime <= {").append(DateUtil.getSQLBegin((Date)DateUtil.getNextDay((Date)dtpToDate))).append("}");
        }
        StringBuffer resultSql = new StringBuffer();
        resultSql.append("select t2.FCompanyID FCompanyID ");
        for (String key : objMap.keySet()) {
            String value = (String)objMap.get(key);
            resultSql.append(" ,sum(\n ");
            resultSql.append(" case when ");
            resultSql.append(compareVar);
            resultSql.append(comparesSign);
            resultSql.append("'" + key + "'");
            resultSql.append(" then ");
            resultSql.append(debitOrCredit);
            resultSql.append("  else 0 end ) ");
            resultSql.append("\"F");
            resultSql.append(value);
            resultSql.append("\"");
            resultSql.append(" \n  ");
        }
        resultSql.append(" from t_be_transdetail t2\n");
        resultSql.append(" INNER JOIN t_bd_accountbanks  t3 on t2.fbankaccountid=t3.fid ");
        resultSql.append(where);
        resultSql.append(" group by t2.FCompanyID \n");
        return resultSql;
    }

    public static StringBuffer madeFactXueWeiSql(LinkedHashMap objMap, int beforeZeroCount, int afterZeroCount, String samllClassId, Context ctx) {
        int i;
        StringBuffer resultSql = new StringBuffer();
        resultSql.append("select t2.fjingyglrc FBigClassID, ");
        resultSql.append(samllClassId);
        resultSql.append(" FSmallClassID \n");
        for (i = 0; i < beforeZeroCount; ++i) {
            resultSql.append(",0 ");
        }
        resultSql.append(" , sum(\n  case when t1.fhighestdegreeid='5a35e819-0101-1000-e000-1a7cc0a83c7f9B3E5DD3' then 1  else 0 end ) \"" + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"101_ReportHelper", (Locale)ctx.getLocale()) + "\n   ,sum(\n  case when t1.fhighestdegreeid='5a35e819-0101-1000-e000-1a52c0a83c7f9B3E5DD3' then 1  else 0 end ) \"" + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"102_ReportHelper", (Locale)ctx.getLocale()) + "\n   ,sum(\n  case when T2.fisforeign ='1' then 1  else 0 end ) " + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"15_ReportHelper", (Locale)ctx.getLocale()));
        for (i = 0; i < afterZeroCount; ++i) {
            resultSql.append(",0 ");
        }
        resultSql.append(" from t_bd_person t1\n");
        resultSql.append(" LEFT JOIN t_hr_empsh T2 ON T2.Fpersonidid = T1.fid\n");
        resultSql.append(" group by t2.fjingyglrc\n");
        return resultSql;
    }

    public static StringBuffer madeFactXueLiSql(LinkedHashMap objMap, int beforeZeroCount, int afterZeroCount, String samllClassId, Context ctx) {
        int i;
        StringBuffer resultSql = new StringBuffer();
        resultSql.append("select t2.fjingyglrc FBigClassID, ");
        resultSql.append(samllClassId);
        resultSql.append(" FSmallClassID \n");
        for (i = 0; i < beforeZeroCount; ++i) {
            resultSql.append(",0 ");
        }
        resultSql.append(" , sum(\n  case when t1.fhighestdegreeid ='5a35e819-0101-1000-e000-1a52c0a83c7f9B3E5DD3' then 1  else 0 end )\"" + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"103_ReportHelper", (Locale)ctx.getLocale()) + "\n");
        resultSql.append(" , sum(\n  case when t1.fhighestdegreeid ='5a35e819-0101-1000-e000-1a44c0a83c7f9B3E5DD3' then 1  else 0 end )\"" + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"104_ReportHelper", (Locale)ctx.getLocale()) + "\n");
        resultSql.append(" , sum(\n  case when t1.fhighestdegreeid ='5a35e819-0101-1000-e000-1a1fc0a83c7f9B3E5DD3' then 1  else 0 end )\"" + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"105_ReportHelper", (Locale)ctx.getLocale()) + "\n");
        resultSql.append(" , sum(\n  case when t1.fhighestdegreeid ='5a35e819-0101-1000-e000-03b5c0a83c7f9B3E5DD3' then 1  else 0 end )\"" + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"106_ReportHelper", (Locale)ctx.getLocale()) + "\n");
        resultSql.append(" , sum(\n  case when t1.fhighestdegreeid in ('5a35e819-0101-1000-e000-0380c0a83c7f9B3E5DD3','5a35e819-0101-1000-e000-0366c0a83c7f9B3E5DD3') then 1  else 0 end )\"" + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"107_ReportHelper", (Locale)ctx.getLocale()) + "\n");
        for (i = 0; i < afterZeroCount; ++i) {
            resultSql.append(",0 ");
        }
        resultSql.append(" from t_bd_person t1\n");
        resultSql.append(" LEFT JOIN t_hr_empsh T2 ON T2.Fpersonidid = T1.fid\n");
        resultSql.append(" group by t2.fjingyglrc\n");
        return resultSql;
    }

    public static StringBuffer madeMdxSql(LinkedHashMap objMap) {
        StringBuffer mdxSql = new StringBuffer();
        Iterator it = objMap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)objMap.get(key);
            if (i != 0) {
                mdxSql.append(",");
            }
            mdxSql.append("[Measures].[");
            mdxSql.append(value);
            mdxSql.append("]");
            ++i;
        }
        return mdxSql;
    }

    public static StringBuffer madeMdxSqlTotal(LinkedHashMap objMap) {
        StringBuffer mdxSql = new StringBuffer();
        Iterator it = objMap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)objMap.get(key);
            if (i != 0) {
                mdxSql.append("+");
            }
            mdxSql.append("[Measures].[");
            mdxSql.append(value);
            mdxSql.append("]");
            ++i;
        }
        return mdxSql;
    }

    public static StringBuffer madeColumnSql(LinkedHashMap objMap) {
        StringBuffer columnSql = new StringBuffer();
        Iterator it = objMap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)objMap.get(key);
            if (i != 0) {
                columnSql.append(",");
            }
            columnSql.append("0 ");
            columnSql.append("\"F");
            columnSql.append(value);
            columnSql.append("\"");
            ++i;
        }
        return columnSql;
    }
}

