/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CASCommonWebFacadeFactory;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.IScheduleJob;
import com.kingdee.eas.fm.be.JobTypeEnum;
import com.kingdee.eas.fm.be.ScheduleJobCollection;
import com.kingdee.eas.fm.be.ScheduleJobFactory;
import com.kingdee.eas.fm.be.ScheduleJobInfo;
import com.kingdee.eas.fm.be.app.AbstractScheduleJobWebFacadeControllerBean;
import com.kingdee.eas.fm.be.util.ScheduleJobHelper;
import com.kingdee.eas.fm.be.vo.ScheduleJobVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScheduleJobWebFacadeControllerBean
extends AbstractScheduleJobWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.ScheduleJobWebFacadeControllerBean");
    private static final String resourcePath = "com.kingdee.eas.fm.be.beResourse";
    private static final String DELETEPERITEM = "schedule_03delte";
    private static final String VIEWPERITEM = "schedule_02view";
    private static final String EDITPERITEM = "schedule_03edit";
    private static final String ADDPERITEM = "schedule_01addnew";
    private boolean isBatchSet = false;

    @Override
    protected Map _f7BankDataChange(Context ctx, String f7BankID) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        if (StringUtil.isEmptyString((String)f7BankID)) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputAccountBankIsNull"));
            return rstData;
        }
        AccountBankInfo bankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(f7BankID));
        if (EmptyUtil.isEmpty((CoreBaseInfo)bankInfo)) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputAccountBankIsNull"));
            return rstData;
        }
        String compenyID = bankInfo.getCompany().getId().toString();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(compenyID));
        String bankInterFace = bankInfo.getBankInterFace();
        CurrencyInfo currency = null;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)bankInfo) && bankInfo.isIsByCurrency()) {
            currency = bankInfo.getCurrency();
            rstData.put("currencyDisable", "true");
        } else {
            currency = company.getBaseCurrency();
        }
        if (currency != null && currency.getId() != null && currency.getName() == null) {
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()));
        }
        rstData.put("currency", (String)currency);
        rstData.put("bankInterFace", bankInterFace);
        return rstData;
    }

    @Override
    protected Map _enableRecord(Context ctx, Map idMap) throws BOSException, EASBizException {
        boolean isEditPermission;
        HashMap<String, String> rstData = new HashMap<String, String>();
        boolean bl = isEditPermission = CASWebHelper.getAuthorizedOrg((Context)ctx, (String)EDITPERITEM, (boolean)false).size() > 0;
        if (!isEditPermission) {
            throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
        }
        List idList = (List)idMap.get("selectedIds");
        if (idList == null || idList.size() <= 0) {
            rstData.put("MsgStr", ResourceBase.getString((String)resourcePath, (String)"Check_isSelect", (Locale)ctx.getLocale()));
            return rstData;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        IScheduleJob iScheduleJob = ScheduleJobFactory.getRemoteInstance();
        entityViewInfo.setFilter(filter);
        ScheduleJobCollection scheduleJobCollection = iScheduleJob.getScheduleJobCollection(entityViewInfo);
        int startNumer = 0;
        if (scheduleJobCollection != null && scheduleJobCollection.size() > 0) {
            for (int i = 0; i < scheduleJobCollection.size(); ++i) {
                ScheduleJobInfo info = scheduleJobCollection.get(i);
                if (!info.isIsEffected()) {
                    info.setIsEffected(true);
                    iScheduleJob.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
                    continue;
                }
                ++startNumer;
            }
        }
        if (startNumer == scheduleJobCollection.size() && startNumer > 0) {
            rstData.put("MsgStr", ResourceBase.getString((String)resourcePath, (String)"Check_StateStart", (Locale)ctx.getLocale()));
            return rstData;
        }
        rstData.put("OPStatus", "success");
        return rstData;
    }

    @Override
    protected Map _disableRecord(Context ctx, Map idMap) throws BOSException, EASBizException {
        boolean isEditPermission;
        HashMap<String, String> rstData = new HashMap<String, String>();
        boolean bl = isEditPermission = CASWebHelper.getAuthorizedOrg((Context)ctx, (String)EDITPERITEM, (boolean)false).size() > 0;
        if (!isEditPermission) {
            throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
        }
        List idList = (List)idMap.get("selectedIds");
        if (idList == null || idList.size() <= 0) {
            rstData.put("MsgStr", ResourceBase.getString((String)resourcePath, (String)"Check_isSelect", (Locale)ctx.getLocale()));
            return rstData;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        IScheduleJob iScheduleJob = ScheduleJobFactory.getRemoteInstance();
        entityViewInfo.setFilter(filter);
        ScheduleJobCollection scheduleJobCollection = iScheduleJob.getScheduleJobCollection(entityViewInfo);
        int stopNumer = 0;
        if (scheduleJobCollection != null && scheduleJobCollection.size() > 0) {
            for (int i = 0; i < scheduleJobCollection.size(); ++i) {
                ScheduleJobInfo info = scheduleJobCollection.get(i);
                if (info.isIsEffected()) {
                    info.setIsEffected(false);
                    iScheduleJob.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
                    continue;
                }
                ++stopNumer;
            }
        }
        if (stopNumer == scheduleJobCollection.size() && stopNumer > 0) {
            rstData.put("MsgStr", ResourceBase.getString((String)resourcePath, (String)"Check_StateStop", (Locale)ctx.getLocale()));
            return rstData;
        }
        rstData.put("OPStatus", "success");
        return rstData;
    }

    @Override
    protected Map _deleteScheduleJob(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, Object> rstData = new HashMap<String, Object>();
        ScheduleJobVO dataVO = (ScheduleJobVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, ScheduleJobVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputDataExption"));
            return rstData;
        }
        if (dataVO.getDeleteIDs() == null || dataVO.getDeleteIDs().length <= 0) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"PleSelectedDeleteRow"));
            return rstData;
        }
        IScheduleJob iScheduleJob = ScheduleJobFactory.getLocalInstance(ctx);
        try {
            boolean hasPermission;
            boolean bl = hasPermission = CASWebHelper.getAuthorizedOrg((Context)ctx, (String)DELETEPERITEM, (boolean)false).size() > 0;
            if (!hasPermission) {
                throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
            }
            int lens = dataVO.getDeleteIDs().length;
            ArrayList<ObjectUuidPK> sucPKList = new ArrayList<ObjectUuidPK>();
            StringBuffer errorMsg = new StringBuffer();
            ArrayList<String> errorMsgList = new ArrayList<String>();
            ObjectUuidPK delPK = null;
            for (int idx = 0; idx < lens; ++idx) {
                delPK = new ObjectUuidPK(dataVO.getDeleteIDs()[idx]);
                IObjectPK[] pkArray = new IObjectPK[]{delPK};
                try {
                    ScheduleJobHelper.getInstance().isReferenced(iScheduleJob, pkArray, ctx);
                    sucPKList.add(delPK);
                    continue;
                }
                catch (EASBizException ee) {
                    errorMsg.append(ee.getMessage(ctx.getLocale()));
                    errorMsgList.add(ee.getMessage(ctx.getLocale()));
                }
            }
            int sucDelCount = sucPKList.size();
            if (sucDelCount > 0) {
                ObjectUuidPK[] sucDelPKArray = new ObjectUuidPK[sucDelCount];
                for (int idx = 0; idx < sucDelCount; ++idx) {
                    sucDelPKArray[idx] = (IObjectPK)sucPKList.get(idx);
                }
                iScheduleJob.deleteBatchData((IObjectPK[])sucDelPKArray);
            }
            if (errorMsg.length() > 0) {
                String[] args = new String[]{String.valueOf(sucDelCount), String.valueOf(lens - sucDelCount)};
                String opHeadMsg = CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])args);
                rstData.put("MsgStr", opHeadMsg);
                rstData.put("MsgDetail", errorMsg.toString());
                rstData.put("OPStatus", "success");
                rstData.put("DeleteSuccessCount", sucDelCount);
                rstData.put("errorMsgList", errorMsgList);
                return rstData;
            }
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"DeletedOK"));
            rstData.put("OPStatus", "success");
            return rstData;
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
    }

    @Override
    protected Map _scheduleJobImport(Context ctx, Map dataMap) throws BOSException, EASBizException {
        boolean isEditPermission;
        HashMap<String, String> rstData = new HashMap<String, String>();
        boolean bl = isEditPermission = CASWebHelper.getAuthorizedOrg((Context)ctx, (String)EDITPERITEM, (boolean)false).size() > 0;
        if (!isEditPermission) {
            throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
        }
        List idList = (List)dataMap.get("selectedIds");
        JobTypeEnum type = JobTypeEnum.getEnum(Integer.parseInt(dataMap.get("type").toString()));
        String bankInterface = (String)dataMap.get("bankInterface");
        IScheduleJob iScheduleJob = ScheduleJobFactory.getRemoteInstance();
        boolean isSuccess = iScheduleJob.batchSetScheduleWeb(idList, type, bankInterface);
        if (isSuccess) {
            rstData.put("OPStatus", "success");
            rstData.put("MsgStr", ResourceBase.getString((String)resourcePath, (String)"SuccessSet", (Locale)ctx.getLocale()));
        }
        return rstData;
    }

    @Override
    protected Map _saveScheduleJob(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        ScheduleJobVO dataVO = (ScheduleJobVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, ScheduleJobVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputDataExption"));
            return rstData;
        }
        ScheduleJobInfo scheduleJobInfo = ScheduleJobHelper.getInstance().VOToInfo(ctx, dataVO);
        IScheduleJob iScheduleJob = ScheduleJobFactory.getLocalInstance(ctx);
        IObjectPK rstID = null;
        try {
            boolean hasPermission;
            boolean bl = hasPermission = CASWebHelper.getAuthorizedOrg((Context)ctx, (String)ADDPERITEM, (boolean)false).size() > 0;
            if (!hasPermission) {
                if (scheduleJobInfo.getId() == null) {
                    throw new CasWebException(CasWebException.NO_ADDNEW_AUTHRIZED);
                }
                throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
            }
            if (!(scheduleJobInfo.getType().equals((Object)JobTypeEnum.BEBANK) || scheduleJobInfo.getCycle() >= 1 && scheduleJobInfo.getCycle() <= 10)) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"865_ScheduleJobWebFacadeControllerBean", (Locale)ctx.getLocale())});
            }
            rstID = iScheduleJob.submit((CoreBaseInfo)scheduleJobInfo);
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
        if (rstID != null) {
            rstData.put("MsgStr", CASWebHelper.getCASMsg((Context)ctx, (String)"SAVE_Successfully"));
            rstData.put("OPStatus", "success");
            rstData.put("IdAfterSave", (String)rstID);
        }
        return rstData;
    }

    @Override
    protected String _getOrgDataFilterList(Context ctx, boolean share) throws BOSException, EASBizException {
        StringBuffer orgDataFilter = new StringBuffer("id in ( ");
        if (!share) {
            CompanyOrgUnitInfo current = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
            if (current.isIsBizUnit()) {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(current.getId().toString()), (String)VIEWPERITEM);
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_VOUCHER__PERMISSION_ONE);
                }
            } else {
                throw new CasWebException(CasWebException.BIZUNIT_NO_AHTHORITY);
            }
        }
        CompanyOrgUnitCollection orgUnitCollection = CASCommonWebFacadeFactory.getLocalInstance((Context)ctx).getAuthizedCompanyOrg(VIEWPERITEM);
        CompanyOrgUnitInfo current = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        CompanyOrgUnitCollection sort = new CompanyOrgUnitCollection();
        if (share) {
            if (orgUnitCollection.size() > 0) {
                if (!orgUnitCollection.get(0).getId().equals((Object)current.getId())) {
                    sort.add(current);
                    orgUnitCollection.remove(current);
                    sort.addCollection(orgUnitCollection);
                } else {
                    sort.addCollection(orgUnitCollection);
                }
            }
        } else {
            sort.add(current);
        }
        ArrayList<String> orgDataFilterList = new ArrayList<String>();
        for (int i = 0; i < sort.size(); ++i) {
            CompanyOrgUnitInfo orgUnit = sort.get(i);
            if (!orgUnit.isIsBizUnit()) continue;
            orgDataFilterList.add(orgUnit.getId().toString());
        }
        for (int j = 0; j < orgDataFilterList.size(); ++j) {
            String orgUnitId = (String)orgDataFilterList.get(j);
            orgDataFilter.append("'" + orgUnitId + "',");
        }
        if (orgDataFilter.toString().equals("id in ( ")) {
            orgDataFilter = new StringBuffer("id in ('NE')");
        } else {
            orgDataFilter.deleteCharAt(orgDataFilter.length() - 1);
            orgDataFilter.append(") ");
        }
        return orgDataFilter.toString();
    }
}

