/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.ISwiftCode;
import com.kingdee.eas.fm.be.SwiftCodeFactory;
import com.kingdee.eas.fm.be.SwiftCodeInfo;
import com.kingdee.eas.fm.be.app.AbstractSwiftCodeWebFacadeControllerBean;
import com.kingdee.eas.fm.be.util.SwiftCodeHelper;
import com.kingdee.eas.fm.be.vo.SwiftCodeVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SwiftCodeWebFacadeControllerBean
extends AbstractSwiftCodeWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.SwiftCodeWebFacadeControllerBean");
    private static String PERMITEM_SWIFTCODE_DELETE = "swiftCode_del";
    private static String PERMITEM_SWIFTCODE_EDIT = "swiftCode_edit";
    private static String PERMITEM_SWIFTCODE_VIEW = "swiftCode_view";

    @Override
    protected Map _saveSwiftCode(Context ctx, String jsonStr) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        SwiftCodeVO dataVO = (SwiftCodeVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, SwiftCodeVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputDataExption"));
            return rstData;
        }
        SwiftCodeInfo swiftCodeInfo = SwiftCodeHelper.getInstance().VOToInfo(ctx, dataVO);
        ISwiftCode iSwiftCode = SwiftCodeFactory.getRemoteInstance();
        IObjectPK rstID = null;
        try {
            boolean isPermission;
            boolean bl = isPermission = CASWebHelper.getAuthorizedOrg((Context)ctx, (String)PERMITEM_SWIFTCODE_EDIT, (boolean)false).size() > 0;
            if (!isPermission) {
                if (swiftCodeInfo.getId() == null) {
                    throw new CasWebException(CasWebException.NO_ADDNEW_AUTHRIZED);
                }
                throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
            }
            rstID = iSwiftCode.submit((CoreBaseInfo)swiftCodeInfo);
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
        if (rstID != null) {
            rstData.put("MsgStr", CASWebHelper.getCASMsg((Context)ctx, (String)"SAVE_Successfully"));
            rstData.put("OPStatus", "success");
            rstData.put("IdAfterSave", (String)rstID);
        }
        return rstData;
    }

    @Override
    protected Map _deleteSwiftCode(Context ctx, String jsonStr) throws BOSException, EASBizException {
        HashMap<String, Object> rstData = new HashMap<String, Object>();
        SwiftCodeVO dataVO = (SwiftCodeVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, SwiftCodeVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputDataExption"));
            return rstData;
        }
        if (dataVO.getDeleteIDs() == null || dataVO.getDeleteIDs().length <= 0) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"PleSelectedDeleteRow"));
            return rstData;
        }
        ISwiftCode iSwiftCode = SwiftCodeFactory.getRemoteInstance();
        try {
            boolean isPermission;
            boolean bl = isPermission = CASWebHelper.getAuthorizedOrg((Context)ctx, (String)PERMITEM_SWIFTCODE_DELETE, (boolean)false).size() > 0;
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
            }
            int lens = dataVO.getDeleteIDs().length;
            ArrayList<ObjectUuidPK> sucPKList = new ArrayList<ObjectUuidPK>();
            StringBuffer errorMsg = new StringBuffer();
            ArrayList<String> detailMsgList = new ArrayList<String>();
            ObjectUuidPK delPK = null;
            for (int idx = 0; idx < lens; ++idx) {
                delPK = new ObjectUuidPK(dataVO.getDeleteIDs()[idx]);
                IObjectPK[] pkArray = new IObjectPK[]{delPK};
                try {
                    SwiftCodeHelper.getInstance().isReferenced(iSwiftCode, pkArray, ctx);
                    sucPKList.add(delPK);
                    continue;
                }
                catch (EASBizException ee) {
                    errorMsg.append(ee.getMessage(ctx.getLocale()));
                    detailMsgList.add(ee.getMessage(ctx.getLocale()));
                }
            }
            int sucDelCount = sucPKList.size();
            if (sucDelCount > 0) {
                ObjectUuidPK[] sucDelPKArray = new ObjectUuidPK[sucDelCount];
                for (int idx = 0; idx < sucDelCount; ++idx) {
                    sucDelPKArray[idx] = (IObjectPK)sucPKList.get(idx);
                }
                iSwiftCode.deleteBatchData((IObjectPK[])sucDelPKArray);
            }
            if (errorMsg.length() > 0) {
                String[] args = new String[]{String.valueOf(sucDelCount), String.valueOf(lens - sucDelCount)};
                String opHeadMsg = CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])args);
                rstData.put("summaryMsg", opHeadMsg);
                rstData.put("MsgDetail", errorMsg.toString());
                rstData.put("OPStatus", "success");
                rstData.put("DeleteSuccessCount", sucDelCount);
                rstData.put("detailMsgList", detailMsgList);
                return rstData;
            }
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
        rstData.put("summaryMsg", CASWebUtil.getResource((Context)ctx, (String)"DeletedOK"));
        rstData.put("OPStatus", "success");
        return rstData;
    }
}

