/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxCollection;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableCollection;
import com.kingdee.eas.basedata.assistant.ExchangeTableFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.IRateParser;
import com.kingdee.eas.fm.be.app.AbstractSynchroRateFacadeControllerBean;
import com.kingdee.eas.fm.be.app.RateParserFactory;
import com.kingdee.eas.fm.be.app.SynchroRateHelper;
import com.kingdee.eas.mobile.convert.util.EmptyUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SynchroRateFacadeControllerBean
extends AbstractSynchroRateFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.SynchroRateFacadeControllerBean");
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    protected void _sysnchroRateForRMB(Context ctx, String type, String rateNumber, String address) throws BOSException, EASBizException {
        try {
            logger.error((Object)("\u540c\u6b65\u6c47\u7387\u63a5\u53e3\u7c7b\u578b\uff1a" + type + "  \u6c47\u7387\u8868\u7f16\u7801\u4e3a\uff1a" + rateNumber));
            if (!EmptyUtil.isEmpty((String)rateNumber) && rateNumber.split(",").length > 0) {
                String[] rate = rateNumber.split(",");
                for (int i = 0; i < rate.length; ++i) {
                    ExchangeTableInfo rateTableInfo = this.getExchangeTableByNumber(ctx, rate[i]);
                    if (rateTableInfo == null) {
                        logger.error((Object)"\u4e0d\u5b58\u5728\u8be5\u7f16\u53f7\u7684\u6c47\u7387\u8868\uff0c\u8bf7\u68c0\u67e5\u6c47\u7387\u8868\u7f16\u53f7\uff01");
                        continue;
                    }
                    IRateParser rateParser = RateParserFactory.getInstance(type, address);
                    if (rateParser == null) {
                        logger.error((Object)"\u4e0d\u652f\u6301\u7684\u6c47\u7387\u63a5\u53e3\u7c7b\u578b\uff01");
                        continue;
                    }
                    Map<String, BigDecimal> rateMap = rateParser.getRateMap();
                    if (rateMap != null) {
                        CurrencyInfo rmbCurrencyInfo = this.getCurrencyInfoByName(ctx, "\u4eba\u6c11\u5e01");
                        if (rmbCurrencyInfo == null) {
                            logger.error((Object)"\u6ca1\u6709\u67e5\u8be2\u5230\u4eba\u6c11\u5e01\u4fe1\u606f\uff01");
                            continue;
                        }
                        this.doProcessSynRate(ctx, rateMap, rateTableInfo, rmbCurrencyInfo);
                        continue;
                    }
                    logger.error((Object)"\u83b7\u53d6\u6c47\u7387\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u6c47\u7387\u4fe1\u606f\uff01");
                    throw new BOSException("\u83b7\u53d6\u6c47\u7387\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u6c47\u7387\u4fe1\u606f\uff01");
                }
            }
            logger.error((Object)"\u540c\u6b65\u6c47\u7387\u5b8c\u6210-----------------------------------------------------------");
        }
        catch (Exception e) {
            logger.error((Object)"\u540c\u6b65\u6c47\u7387\u4fe1\u606f\u5f02\u5e38\uff01");
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private void doProcessSynRate(Context ctx, Map<String, BigDecimal> rateMap, ExchangeTableInfo rateTableInfo, CurrencyInfo rmbCurrencyInfo) throws BOSException {
        java.util.Date today = new java.util.Date();
        String todayFormat = sdf.format(today);
        ExchangeAuxCollection exchangeAuxColls = SynchroRateHelper.getExchangeRateAuxByExTableId(ctx, rateTableInfo.getId().toString());
        ExchangeRateCollection availExRateColls = SynchroRateHelper.getExchangeRateCollsByExTableId(ctx, rateTableInfo.getId().toString(), null, todayFormat);
        Set<String> currencyNameSet = rateMap.keySet();
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        Connection conn = null;
        Statement stmtUpdate = null;
        try {
            conn = this.getConnection(ctx);
            stmtUpdate = conn.createStatement();
            String beforeToday = sdf.format(DateUtil.getBeforeDay((java.util.Date)today));
            ExchangeRateCollection exRateColls = SynchroRateHelper.getExchangeRateCollsByExTableId(ctx, rateTableInfo.getId().toString(), beforeToday, null);
            logger.error((Object)("\u66f4\u65b0exRateColls\u3010" + exRateColls + "\u3011"));
            if (exRateColls != null) {
                logger.error((Object)("\u66f4\u65b0exRateColls\u3010" + exRateColls.size() + "\u3011"));
            }
            if (exRateColls == null) {
                exRateColls = SynchroRateHelper.getExchangeRateCollsByExTableId(ctx, rateTableInfo.getId().toString(), null, null);
            }
            if (exRateColls != null) {
                logger.error((Object)("\u66f4\u65b0exRateColls222222222222\u3010" + exRateColls.size() + "\u3011"));
            }
            Set<String> companyIdSet = SynchroRateHelper.getCompayIdSetFromRateColls(exRateColls);
            logger.error((Object)("\u66f4\u65b0companyIdSet\u3010" + companyIdSet + "\u3011"));
            if (EmptyUtil.isEmpty(companyIdSet)) {
                exRateColls = SynchroRateHelper.getExchangeRateCollsByExTableId(ctx, null, null, null);
                companyIdSet = SynchroRateHelper.getCompayIdSetFromRateColls(exRateColls);
            }
            for (String curCurrencyName : currencyNameSet) {
                CurrencyInfo curCurrencyInfo = this.getCurrencyInfoByName(ctx, curCurrencyName);
                if (curCurrencyInfo == null) {
                    logger.error((Object)("\u6ca1\u6709\u67e5\u8be2\u5230 " + curCurrencyName));
                    continue;
                }
                BigDecimal convertAmt = rateMap.get(curCurrencyName);
                logger.error((Object)("\u66f4\u65b0\u3010" + curCurrencyName + "\u3011\u6c47\u7387\u3010" + convertAmt + "\u3011"));
                ExchangeAuxInfo auxInfo = SynchroRateHelper.getRateAux(curCurrencyInfo.getId().toString(), rmbCurrencyInfo.getId().toString(), exchangeAuxColls);
                String sql = "";
                logger.error((Object)("\u66f4\u65b0auxInfo==\u3010" + auxInfo + "\u3011"));
                logger.error((Object)("\u66f4\u65b0companyIdSet==\u3010" + companyIdSet + "\u3011"));
                if (auxInfo != null) {
                    for (String companyId : companyIdSet) {
                        sql = this.getSqlForUpdateRate(currentUser, availExRateColls, todayFormat, companyId, auxInfo.getId().toString(), this.round(convertAmt, auxInfo.getPrecision(), RoundingMode.HALF_UP));
                        stmtUpdate.addBatch(sql);
                    }
                }
                BigDecimal destRate = new BigDecimal("1").setScale(15, RoundingMode.CEILING).divide(convertAmt, 3);
                auxInfo = SynchroRateHelper.getRateAux(rmbCurrencyInfo.getId().toString(), curCurrencyInfo.getId().toString(), exchangeAuxColls);
                logger.error((Object)("\u66f4\u65b0auxInfo==\u3010" + auxInfo + "\u3011"));
                if (auxInfo == null) continue;
                for (String companyId : companyIdSet) {
                    sql = this.getSqlForUpdateRate(currentUser, availExRateColls, todayFormat, companyId, auxInfo.getId().toString(), this.round(destRate, auxInfo.getPrecision(), RoundingMode.HALF_UP));
                    stmtUpdate.addBatch(sql);
                }
            }
            stmtUpdate.executeBatch();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtUpdate);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtUpdate);
        SQLUtils.cleanup((Connection)conn);
    }

    private String getSqlForUpdateRate(UserInfo currentUser, ExchangeRateCollection exRateColls, String today, String companyId, String auxId, BigDecimal convertAmt) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        java.util.Date now = new java.util.Date();
        String dateTime = sdf.format(now);
        Calendar cl = Calendar.getInstance();
        cl.setTime(now);
        cl.add(5, 1);
        java.util.Date afterNow = cl.getTime();
        String after = sdf.format(afterNow);
        String sql = null;
        logger.error((Object)("\u66f4\u65b0\u6c47\u7387exRateColls\u3010  " + exRateColls + "  \u3011auxId:auxId" + auxId));
        for (int i = 0; i < exRateColls.size(); ++i) {
            ExchangeRateInfo rateInfo = exRateColls.get(i);
            logger.error((Object)("\u66f4\u65b0\u6c47\u7387companyId\u3010  " + companyId + "  \u3011auxId:auxId" + auxId));
            logger.error((Object)("\u66f4\u65b0\u6c47\u7387rateInfo.getCU()\u3010  " + rateInfo.getCU().getId().toString() + "  \u3011rateInfo.getExchangeAux().getId()" + rateInfo.getExchangeAux().getId()));
            if (!rateInfo.getCU().getId().toString().equals(companyId) || !rateInfo.getExchangeAux().getId().toString().equals(auxId)) continue;
            sql = "update T_BD_ExchangeRate set FLastUpdateUserID='" + currentUser.getId() + "', FLastUpdateTime={ts'" + dateTime + "'}, FConvertRate=" + convertAmt + " where fid ='" + rateInfo.getId().toString() + "'";
            logger.error((Object)("\u66f4\u65b0\u6c47\u7387id\u3010  " + rateInfo.getId().toString() + "  \u3011\u6c47\u7387\u503c:" + convertAmt));
            return sql;
        }
        if (sql == null) {
            StringBuffer sqlBuffer = new StringBuffer("insert into T_BD_ExchangeRate(fid,FAvailTime,FInvalidTime,FConvertRate,FExchangeAuxID,FIsUsedBG,FQuoteprice,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID)");
            sqlBuffer.append("values(newbosid('80E547EE'),{ts'");
            sqlBuffer.append(dateTime);
            sqlBuffer.append("'},{ts'");
            sqlBuffer.append(after);
            sqlBuffer.append("'},");
            sqlBuffer.append(convertAmt);
            sqlBuffer.append(",'");
            sqlBuffer.append(auxId);
            sqlBuffer.append("',0,1,'");
            sqlBuffer.append(currentUser.getId());
            sqlBuffer.append("',{ts'");
            sqlBuffer.append(sdf1.format(now));
            sqlBuffer.append("'},'");
            sqlBuffer.append(currentUser.getId());
            sqlBuffer.append("',{ts'");
            sqlBuffer.append(sdf1.format(now));
            sqlBuffer.append("'},'");
            sqlBuffer.append(companyId);
            sqlBuffer.append("' )");
            sql = sqlBuffer.toString();
        }
        logger.error((Object)("\u66f4\u65b0\u6c47\u7387sql\u3010  " + sql + "  \u3011"));
        return sql;
    }

    private void doProcessUpdateRateOld(Context ctx, Map<String, BigDecimal> rateMap, CurrencyInfo rmbCurrencyInfo) throws BOSException {
        Set<String> currencyNameSet = rateMap.keySet();
        if (currencyNameSet != null) {
            for (String curCurrencyName : currencyNameSet) {
                CurrencyInfo curCurrencyInfo = this.getCurrencyInfoByName(ctx, curCurrencyName);
                if (curCurrencyInfo == null) {
                    logger.error((Object)("\u6ca1\u6709\u67e5\u8be2\u5230 " + curCurrencyName));
                    continue;
                }
                BigDecimal convertAmt = rateMap.get(curCurrencyName);
                this.updateExchangeRate(ctx, curCurrencyInfo, convertAmt, rmbCurrencyInfo);
                BigDecimal destRate = new BigDecimal("1").setScale(15, RoundingMode.CEILING).divide(convertAmt, 3);
                this.updateExchangeRate(ctx, rmbCurrencyInfo, destRate, curCurrencyInfo);
            }
        } else {
            logger.error((Object)"\u6ca1\u6709\u67e5\u8be2\u5230\u5e01\u522b\u4fe1\u606f\uff01");
        }
    }

    private void updateExchangeRate(Context ctx, CurrencyInfo srcCurrencyInfo, BigDecimal convertAmt, CurrencyInfo destCurrencyInfo) throws BOSException {
        PreparedStatement stmtUpdate = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fm.common.app", "ExchangeRateQuery"));
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)srcCurrencyInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("targetCurrency.id", (Object)destCurrencyInfo.getId().toString()));
            ev.setFilter(filter);
            exec.setObjectView(ev);
            IRowSet rs = exec.executeQuery();
            List<Map<String, Object>> preList = this.parseRsToIDPreList(rs);
            String srcCurrencyName = srcCurrencyInfo.getName();
            String destCurrencyName = destCurrencyInfo.getName();
            if (preList == null || preList.size() == 0) {
                logger.error((Object)("\u6ca1\u6709\u6e90\u5e01\uff1a " + srcCurrencyName + "  \u76ee\u6807\u5e01\uff1a" + destCurrencyName + "  \u7684\u6c47\u7387\u9700\u8981\u66f4\u65b0"));
                return;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            java.util.Date now = new java.util.Date();
            String dateTime = sdf.format(now);
            UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
            Connection conn = this.getConnection(ctx);
            String sql = " update T_BD_ExchangeRate set FLastUpdateUserID='" + currentUser.getId() + "', FLastUpdateTime={ts'" + dateTime + "'}, FConvertRate=? where fid =?";
            stmtUpdate = conn.prepareStatement(sql);
            for (Map<String, Object> preMap : preList) {
                int percision = (Integer)preMap.get("precision");
                BigDecimal curConvertAmt = this.round(convertAmt, percision, RoundingMode.HALF_UP);
                stmtUpdate.setBigDecimal(1, curConvertAmt);
                stmtUpdate.setString(2, (String)preMap.get("id"));
                stmtUpdate.addBatch();
                logger.error((Object)("\u66f4\u65b0\u6e90\u5e01\uff1a" + srcCurrencyName + "  \u76ee\u6807\u5e01\uff1a" + destCurrencyName + "  \u7684\u6c47\u7387\u4e3a\uff1a" + curConvertAmt + " \u6c47\u7387id\u3010  " + preMap.get("id") + "  \u3011"));
            }
            stmtUpdate.executeBatch();
            SQLUtils.cleanup((Statement)stmtUpdate);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(stmtUpdate);
        }
    }

    private List<Map<String, Object>> parseRsToIDPreList(IRowSet rs) throws SQLException {
        ArrayList<Map<String, Object>> preList = new ArrayList<Map<String, Object>>();
        String curOrgId = null;
        String curExChangeTableId = null;
        Date curAvailTime = null;
        int curPrecision = 0;
        String id = null;
        while (rs.next()) {
            if (curOrgId == null) {
                curOrgId = rs.getString("CU.id");
                curExChangeTableId = rs.getString("exchangeTable.id");
                curAvailTime = rs.getDate("availTime");
                curPrecision = rs.getInt("exchangeAux.precision");
                id = rs.getString("id");
                continue;
            }
            String orgId = rs.getString("CU.id");
            String exChangeTableId = rs.getString("exchangeTable.id");
            Date availTime = rs.getDate("availTime");
            int precision = rs.getInt("exchangeAux.precision");
            String temId = rs.getString("id");
            if (curOrgId.equals(orgId) && curExChangeTableId.equals(exChangeTableId)) {
                if (!availTime.after(curAvailTime)) continue;
                curOrgId = orgId;
                curExChangeTableId = exChangeTableId;
                curAvailTime = availTime;
                id = temId;
                continue;
            }
            HashMap<String, Object> preMap = new HashMap<String, Object>();
            preMap.put("id", id);
            preMap.put("precision", curPrecision);
            preList.add(preMap);
            curOrgId = orgId;
            curExChangeTableId = exChangeTableId;
            curAvailTime = availTime;
            curPrecision = precision;
            id = temId;
        }
        if (id != null) {
            HashMap<String, Object> preMap = new HashMap<String, Object>();
            preMap.put("id", id);
            preMap.put("precision", curPrecision);
            preList.add(preMap);
        }
        return preList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateRMBExchangeRate(Context ctx, String srcCurrencyName, BigDecimal convertAmt, CurrencyInfo rmbCurrencyInfo) throws BOSException {
        Statement stmtUpdate;
        block13: {
            block12: {
                stmtUpdate = null;
                try {
                    CurrencyInfo srcCurrencyInfo = this.getCurrencyInfoByName(ctx, srcCurrencyName);
                    if (srcCurrencyInfo == null) {
                        logger.error((Object)("\u6ca1\u6709\u67e5\u8be2\u5230 " + srcCurrencyName));
                        return;
                    }
                    IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.basedata.assistant.app", "ExchangeRateQuery"));
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)srcCurrencyInfo.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("targetCurrency.id", (Object)rmbCurrencyInfo.getId().toString()));
                    ev.setFilter(filter);
                    exec.setObjectView(ev);
                    IRowSet rs = exec.executeQuery();
                    Map<String, Map<String, Object>> rateInfoMap = this.getExchangeRateMap(rs);
                    Collection<Map<String, Object>> rateValueColls = rateInfoMap.values();
                    if (rateValueColls == null || rateValueColls.size() == 0) {
                        logger.error((Object)("\u6ca1\u6709\u6e90\u5e01\uff1a " + srcCurrencyName + "  \u76ee\u6807\u5e01\uff1a" + rmbCurrencyInfo.getName() + "  \u7684\u6c47\u7387\u9700\u8981\u66f4\u65b0"));
                        if (stmtUpdate == null) return;
                        break block12;
                    }
                    for (Map<String, Object> rateValueMap : rateValueColls) {
                        int percision = (Integer)rateValueMap.get("precision");
                        BigDecimal curConvertAmt = this.round(convertAmt, percision, RoundingMode.HALF_UP);
                        Connection conn = this.getConnection(ctx);
                        String sql = " update T_BD_ExchangeRate set FConvertRate=? where fid =?";
                        stmtUpdate = conn.prepareStatement(sql);
                        stmtUpdate.setBigDecimal(1, curConvertAmt);
                        stmtUpdate.setString(2, (String)rateValueMap.get("id"));
                        stmtUpdate.addBatch();
                    }
                    if (stmtUpdate != null) {
                        stmtUpdate.executeBatch();
                    }
                    if (stmtUpdate == null) return;
                    break block13;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
            }
            SQLUtils.cleanup((Statement)stmtUpdate);
            return;
        }
        SQLUtils.cleanup((Statement)stmtUpdate);
        return;
        finally {
            if (stmtUpdate != null) {
                SQLUtils.cleanup(stmtUpdate);
            }
        }
    }

    private CurrencyInfo getCurrencyInfoByName(Context ctx, String currencyName) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)currencyName));
        view.setFilter(filter);
        CurrencyCollection colls = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
        if (colls != null && colls.size() > 0) {
            return colls.get(0);
        }
        return null;
    }

    private Map<String, Map<String, Object>> getExchangeRateMap(IRowSet rs) throws SQLException {
        HashMap<String, Map<String, Object>> rsMap = new HashMap<String, Map<String, Object>>();
        while (rs.next()) {
            String orgId = rs.getString("CU.id");
            String exChangeTableId = rs.getString("exchangeTable.id");
            HashMap<String, Object> rateInfoMap = (HashMap<String, Object>)rsMap.get(orgId + exChangeTableId);
            if (rateInfoMap == null) {
                rateInfoMap = new HashMap<String, Object>();
                rateInfoMap.put("availTime", rs.getDate("availTime"));
                rateInfoMap.put("precision", rs.getInt("exchangeAux.precision"));
                rateInfoMap.put("id", rs.getString("id"));
            } else {
                Date availTime = (Date)rateInfoMap.get("availTime");
                Date currAvailTime = rs.getDate("availTime");
                if (currAvailTime.after(availTime)) {
                    rateInfoMap = new HashMap();
                    rateInfoMap.put("availTime", rs.getDate("availTime"));
                    rateInfoMap.put("precision", rs.getInt("exchangeAux.precision"));
                    rateInfoMap.put("id", rs.getString("id"));
                }
            }
            rsMap.put(orgId + exChangeTableId, rateInfoMap);
        }
        return rsMap;
    }

    private BigDecimal round(BigDecimal value, int scale, RoundingMode roundingMode) {
        value = value.setScale(scale, roundingMode);
        return value;
    }

    private ExchangeTableInfo getExchangeTableByNumber(Context ctx, String number) throws BOSException {
        ExchangeTableInfo exTable = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        view.setSelector(sic);
        ExchangeTableCollection colls = ExchangeTableFactory.getLocalInstance((Context)ctx).getExchangeTableCollection(view);
        if (colls != null && colls.size() > 0) {
            exTable = colls.get(0);
        }
        return exTable;
    }
}

