/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.ExchangeAuxCollection;
import com.kingdee.eas.basedata.assistant.ExchangeAuxFactory;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class SynchroRateHelper {
    protected static ExchangeAuxCollection getExchangeRateAuxByExTableId(Context ctx, String exchangeTableId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("id"));
        sel.add(new SelectorItemInfo("sourceCurrency.id"));
        sel.add(new SelectorItemInfo("targetCurrency.id"));
        sel.add(new SelectorItemInfo("precision"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeTable", (Object)exchangeTableId));
        view.setSelector(sel);
        view.setFilter(filter);
        return ExchangeAuxFactory.getLocalInstance((Context)ctx).getExchangeAuxCollection(view);
    }

    protected static ExchangeRateCollection getExchangeRateCollsByExTableId(Context ctx, String exchangeTableId, String createTime, String availTime) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("id"));
        sel.add(new SelectorItemInfo("CU.id"));
        sel.add(new SelectorItemInfo("exchangeAux"));
        FilterInfo filter = new FilterInfo();
        System.out.println("exchangeTableId===" + exchangeTableId);
        System.out.println("createTime===" + createTime);
        if (exchangeTableId != null) {
            filter.getFilterItems().add(new FilterItemInfo("exchangeAux.exchangeTable", (Object)exchangeTableId));
        }
        if (createTime != null) {
            filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)createTime, CompareType.GREATER_EQUALS));
            String afterDate = null;
            try {
                Date afterDateTime = DateUtil.getAfterDay((Date)sdf.parse(createTime));
                afterDate = sdf.format(afterDateTime);
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)afterDate, CompareType.LESS));
        }
        if (availTime != null) {
            filter.getFilterItems().add(new FilterItemInfo("availTime", (Object)availTime, CompareType.GREATER_EQUALS));
        }
        view.setSelector(sel);
        view.setFilter(filter);
        return ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateCollection(view);
    }

    protected static ExchangeAuxInfo getRateAux(String srcCurrencyId, String destCurrencyId, ExchangeAuxCollection auxColls) {
        System.out.println("auxColls===" + auxColls);
        for (int i = 0; i < auxColls.size(); ++i) {
            ExchangeAuxInfo auxInfo = auxColls.get(i);
            System.out.println("srcCurrencyId===" + srcCurrencyId);
            if (!auxInfo.getSourceCurrency().getId().toString().equals(srcCurrencyId) || !auxInfo.getTargetCurrency().getId().toString().equals(destCurrencyId)) continue;
            System.out.println("auxInfo.getTargetCurrency().getId().toString()===22222222" + auxInfo.getTargetCurrency().getId().toString());
            return auxInfo;
        }
        System.out.println("auxInfo.getTargetCurrency().getId().toString()===11111111");
        return null;
    }

    protected static Set<String> getCompayIdSetFromRateColls(ExchangeRateCollection exRateColls) {
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int i = 0; i < exRateColls.size(); ++i) {
            companyIdSet.add(exRateColls.get(i).getCU().getId().toString());
        }
        System.out.println("companyIdSet====" + companyIdSet);
        return companyIdSet;
    }
}

