/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.be.AccountBankBalanceCollection;
import com.kingdee.eas.fm.be.AccountBankBalanceFactory;
import com.kingdee.eas.fm.be.AccountBankBalanceInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.be.IAccountBankBalance;
import com.kingdee.eas.fm.be.IBankPayingBill;
import com.kingdee.eas.fm.be.IEReceipt;
import com.kingdee.eas.fm.be.PayBitBackRecordCollection;
import com.kingdee.eas.fm.be.PayBitBackRecordFactory;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailFilterParam;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.TransDetailRecedEnum;
import com.kingdee.eas.fm.be.TransDetailVerify;
import com.kingdee.eas.fm.be.TransdetailSourceEnum;
import com.kingdee.eas.fm.be.app.AbstractTransDetailControllerBean;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.H;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransDetailControllerBean
extends AbstractTransDetailControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.TransDetailControllerBean");

    @Override
    protected void _getData(Context ctx, TransDetailFilterParam p0) throws BOSException {
    }

    @Override
    protected void _fetchData(Context ctx) throws BOSException {
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TransDetailInfo info = (TransDetailInfo)model;
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"bizDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"bizTime");
        IObjectPK pk = super._addnew(ctx, model);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"\u65b0\u589e", (BOSObjectType)new TransDetailInfo().getBOSType(), (IObjectPK)pk, (String)pk.toString(), (String)"bbc_transdetail_addNew");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!this._exists(ctx, pk)) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1039_TransDetailControllerBean", (Locale)ctx.getLocale())});
        }
        TransDetailInfo info = (TransDetailInfo)this._getValue(ctx, pk);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"\u5220\u9664", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)info.getId().toString(), (String)"bbc_transdetail_delete");
        if (info.isIsDownToBankState()) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"transDel", (Locale)ctx.getLocale())});
        }
        if (info.isIsTransUp()) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"21_TransDetailControllerBean", (Locale)ctx.getLocale())});
        }
        if (info.isIsCreatedTransUp()) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"22_TransDetailControllerBean", (Locale)ctx.getLocale())});
        }
        if (info.isIsTransDown()) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"181_hasTransDown", (Locale)ctx.getLocale())});
        }
        if (info.isIsCreatedtransDown()) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"182_beTransDown", (Locale)ctx.getLocale())});
        }
        if (TransDetailRecedEnum.reced == info.getIsReced()) {
            throw new BEException(BEException.TRANSDETAILHASDOWN, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"310_TransDetailRecord", (Locale)ctx.getLocale())});
        }
        if (EReceiptIsMatchEnum.UnMatch != info.getIsMatchEReceipt()) {
            throw new BEException(BEException.TRANSDETAILHASDOWN, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"334_TransDetailHasMatch", (Locale)ctx.getLocale())});
        }
        IEReceipt eReceipt = EReceiptFactory.getLocalInstance(ctx);
        eReceipt.canTransDetail(pk);
        super._delete(ctx, pk);
        this.updateAcctBankBalance(ctx, info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void updateAcctBankBalance(Context ctx, TransDetailInfo info) throws BOSException, EASBizException {
        boolean BE018 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("BE018", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (TransdetailSourceEnum.IMPORT.equals((Object)info.getIsDataImport()) && BE018) {
            IAccountBankBalance balance = AccountBankBalanceFactory.getLocalInstance(ctx);
            FilterInfo acctFilter = new FilterInfo();
            acctFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)info.getBizDate()));
            acctFilter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
            acctFilter.getFilterItems().add(new FilterItemInfo("accountBank", (Object)info.getBankAccount().getId().toString()));
            acctFilter.getFilterItems().add(new FilterItemInfo("currency", (Object)info.getCurrency().getId().toString()));
            EntityViewInfo acctView = new EntityViewInfo();
            acctView.setFilter(acctFilter);
            SelectorItemCollection acctSic = new SelectorItemCollection();
            acctSic.add("balance");
            acctSic.add("valiBalance");
            acctSic.add("accurateBizDate");
            acctSic.add("isImport");
            acctSic.add("lastUpdateTime");
            acctView.setSelector(acctSic);
            AccountBankBalanceCollection acctBankBalanceColl = balance.getAccountBankBalanceCollection(acctView);
            AccountBankBalanceCollection transBankBalanceCol = new AccountBankBalanceCollection();
            for (int i = 0; i < acctBankBalanceColl.size(); ++i) {
                if (acctBankBalanceColl.get(i).isIsImport()) continue;
                transBankBalanceCol.add(acctBankBalanceColl.get(i));
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)info.getBizDate()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)info.getBankAccount().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("currency", (Object)info.getCurrency().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("transBalance", null, CompareType.NOTEQUALS));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            view.setSelector(sic);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo bizTimeSorter = new SorterItemInfo("bizTime");
            bizTimeSorter.setSortType(SortType.DESCEND);
            sorter.add(bizTimeSorter);
            SorterItemInfo lineNoSorter = new SorterItemInfo("transBalance");
            lineNoSorter.setSortType(SortType.DESCEND);
            sorter.add(lineNoSorter);
            view.setSorter(sorter);
            CoreBaseCollection transDetailColl = this.getCollection(ctx, view);
            if (EmptyUtil.isEmpty((AbstractObjectCollection)transDetailColl)) {
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)transBankBalanceCol)) {
                    balance.delete((IObjectPK)new ObjectUuidPK(transBankBalanceCol.get(0).getId()));
                }
            } else if (acctBankBalanceColl.size() == transBankBalanceCol.size()) {
                TransDetailInfo lastTransInfo = (TransDetailInfo)transDetailColl.get(0);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)acctBankBalanceColl)) {
                    AccountBankBalanceInfo balanceInfo = new AccountBankBalanceInfo();
                    balanceInfo.setCompany(lastTransInfo.getCompany());
                    balanceInfo.setCurrency(lastTransInfo.getCurrency());
                    balanceInfo.setBizDate(lastTransInfo.getBizDate());
                    balanceInfo.setAccurateBizDate(lastTransInfo.getBizTime());
                    balanceInfo.setAccountBank(lastTransInfo.getBankAccount());
                    balanceInfo.setBalance(lastTransInfo.getTransBalance());
                    balanceInfo.setValiBalance(lastTransInfo.getTransBalance());
                    balance.addnew((CoreBaseInfo)balanceInfo);
                } else {
                    AccountBankBalanceInfo balanceInfo = acctBankBalanceColl.get(0);
                    if (balanceInfo.getAccurateBizDate().compareTo(lastTransInfo.getBizTime()) >= 0) {
                        balanceInfo.setBalance(lastTransInfo.getTransBalance());
                        balanceInfo.setValiBalance(lastTransInfo.getTransBalance());
                        balanceInfo.setAccurateBizDate(lastTransInfo.getBizTime());
                        balanceInfo.setLastUpdateTime(this.getCurrentTime());
                        balance.updatePartial((CoreBaseInfo)balanceInfo, acctSic);
                    }
                }
            }
        }
    }

    private Timestamp getCurrentTime() {
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp current = new Timestamp(d.getTime().getTime());
        return current;
    }

    protected void _canDelete(Context arg0, IObjectPK arg1, Connection arg2) throws CanNotDeleteException {
        super._canDelete(arg0, arg1, arg2);
    }

    @Override
    protected IObjectCollection _getUnRecColl(Context ctx, String companyId, java.util.Date beginDate, java.util.Date endDate, String[] account) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)companyId)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isDebit", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isReced", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("IsCreatedTransUp", (Object)Boolean.FALSE));
        HashSet<String> set = new HashSet<String>();
        if (account != null) {
            for (int i = 0; i < account.length; ++i) {
                set.add(account[i]);
            }
            filter.getFilterItems().add(new FilterItemInfo("bankAccount", set, CompareType.INCLUDE));
        }
        if (beginDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)DateUtil.getSQLBegin((java.util.Date)beginDate), CompareType.GREATER_EQUALS));
        }
        if (endDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)DateUtil.getSQLEnd((java.util.Date)endDate), CompareType.LESS_EQUALS));
        }
        FilterInfo kdFilter = new FilterInfo();
        kdFilter.getFilterItems().add(new FilterItemInfo("number", (Object)"KD%", CompareType.NOTLIKE));
        kdFilter.getFilterItems().add(new FilterItemInfo("number", null));
        kdFilter.setMaskString("#0 or #1 ");
        filter.mergeFilter(kdFilter, "AND");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("company.*"));
        evi.getSelector().add(new SelectorItemInfo("bankAccount.account.*"));
        evi.getSelector().add(new SelectorItemInfo("bankAccount.bank.*"));
        evi.getSelector().add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        return this.getTransDetailCollection(ctx, evi);
    }

    @Override
    protected void _disposeRecInfo(Context ctx, List ids, Map valueMap) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((Collection)ids)) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE T_BE_TransDetail SET FIsReced = ?, FRecDate = ?, FrecedBillType = ?, FRecedBillNumber = ? WHERE FID = ? ";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            Date date = new Date(System.currentTimeMillis());
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                if (ids.get(i) == null) continue;
                Map value = (Map)valueMap.get(ids.get(i).toString());
                boolean isReced = (Boolean)value.get("isReced");
                String recedBillType = "";
                if (!FMHelper.isEmpty(value.get("recedBillType"))) {
                    recedBillType = value.get("recedBillType").toString();
                }
                String recedBillNumber = "";
                if (!FMHelper.isEmpty(value.get("recedBillNumber"))) {
                    recedBillNumber = value.get("recedBillNumber").toString();
                }
                if (isReced) {
                    pstmt.setInt(1, 1);
                    pstmt.setDate(2, date);
                    pstmt.setString(3, recedBillType);
                    pstmt.setString(4, recedBillNumber);
                } else {
                    pstmt.setInt(1, 0);
                    pstmt.setNull(2, 91);
                    pstmt.setString(3, "");
                    pstmt.setString(4, "");
                }
                pstmt.setString(5, (String)ids.get(i));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isMatchEReceipt", (Object)new Integer(1), CompareType.EQUALS));
        view.setFilter(filter);
        TransDetailCollection transCol = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(view);
        try {
            String ereceiptSql = "Update T_BE_EReceipt set  FSrcBillbizType = null ,FBillNumber = null where FTransDetailId = ?";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(ereceiptSql);
            for (int i = 0; i < transCol.size(); ++i) {
                String id = transCol.get(i).getId().toString();
                Map value = (Map)valueMap.get(id);
                boolean isReced = (Boolean)value.get("isReced");
                if (isReced) continue;
                pstmt.setString(1, id);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    @Override
    protected IObjectCollection _getUnRec2Coll(Context ctx, Set OBJPKColl) throws BOSException, BEException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)OBJPKColl, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isReced", (Object)false, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("company.*"));
        evi.getSelector().add(new SelectorItemInfo("bankAccount.*"));
        evi.getSelector().add(new SelectorItemInfo("bankInterfaceType.*"));
        evi.getSelector().add(new SelectorItemInfo("bankAccount.bank.name"));
        TransDetailCollection coll = this.getTransDetailCollection(ctx, evi);
        if (EmptyUtil.isEmpty((Object)((Object)coll)) || coll.size() == 0) {
            throw new BEException(BEException.NOTRANSDETAIL);
        }
        return coll;
    }

    @Override
    protected Map _detailCheck(Context ctx, String acctId, String currencyId, java.util.Date beginDate, java.util.Date endDate) throws BOSException, EASBizException {
        HashMap<String, StringBuffer> resultMap = new HashMap<String, StringBuffer>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)acctId));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("isDataImport", (Object)new Boolean(false), CompareType.EQUALS));
        if (beginDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)DateUtil.getSQLBegin((java.util.Date)beginDate), CompareType.GREATER_EQUALS));
        }
        if (endDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)DateUtil.getSQLEnd((java.util.Date)endDate), CompareType.LESS_EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SorterItemInfo sortItem1 = new SorterItemInfo("bizTime");
        sortItem1.setSortType(SortType.ASCEND);
        SorterItemInfo sortItem2 = new SorterItemInfo("sortedId");
        sortItem2.setSortType(SortType.ASCEND);
        evi.getSorter().add(sortItem1);
        evi.getSorter().add(sortItem2);
        TransDetailCollection detailColl = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(evi);
        for (int i = 0; i < detailColl.size(); ++i) {
            if (i == 0) continue;
            TransDetailInfo beforeInfo = detailColl.get(i - 1);
            TransDetailInfo info = detailColl.get(i);
            StringBuffer result = new StringBuffer();
            if (beforeInfo.getTransBalance() == null) {
                throw new BEException(BEException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"309_TransDetailCheck", (Locale)ctx.getLocale())});
            }
            if (info.getTransBalance() == null || info.getTransBalance().compareTo(beforeInfo.getTransBalance().add(info.getCreditAmount().subtract(info.getDebitAmount()))) == 0) continue;
            result = this.getResult(beforeInfo, info, ctx);
            resultMap.put(String.valueOf(i), result);
        }
        return resultMap;
    }

    private StringBuffer getResult(TransDetailInfo beforeInfo, TransDetailInfo info, Context ctx) {
        StringBuffer result = new StringBuffer();
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(true);
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"23_TransDetailControllerBean", (Locale)ctx.getLocale())).append(beforeInfo.getDescription());
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"24_TransDetailControllerBean", (Locale)ctx.getLocale())).append(beforeInfo.getBizTime());
        if (beforeInfo.isIsDebit()) {
            result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"25_TransDetailControllerBean", (Locale)ctx.getLocale())).append(fm.format(beforeInfo.getDebitAmount()));
        } else {
            result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"26_TransDetailControllerBean", (Locale)ctx.getLocale())).append(fm.format(beforeInfo.getCreditAmount()));
        }
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"27_TransDetailControllerBean", (Locale)ctx.getLocale())).append(fm.format(beforeInfo.getTransBalance()));
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"28_TransDetailControllerBean", (Locale)ctx.getLocale())).append(info.getDescription());
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"24_TransDetailControllerBean", (Locale)ctx.getLocale())).append(info.getBizTime());
        if (info.isIsDebit()) {
            result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"25_TransDetailControllerBean", (Locale)ctx.getLocale())).append(fm.format(info.getDebitAmount()));
        } else {
            result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"26_TransDetailControllerBean", (Locale)ctx.getLocale())).append(fm.format(info.getCreditAmount()));
        }
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"27_TransDetailControllerBean", (Locale)ctx.getLocale())).append(fm.format(info.getTransBalance()));
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"29_TransDetailControllerBean", (Locale)ctx.getLocale()));
        return result;
    }

    @Override
    protected Map _confirmTransUP(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        HashSet<String> oks = new HashSet<String>();
        ret.put("oks", oks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("isTransUp"));
        evi.getSelector().add(new SelectorItemInfo("creditAmount"));
        TransDetailCollection col = this.getTransDetailCollection(ctx, evi);
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            TransDetailInfo info = col.get(i);
            if (!TransDetailVerify.isCanConfirmTransUP(info)) {
                throw new BEException(BEException.COMMON, new String[]{MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"30_TransDetailControllerBean", (Locale)ctx.getLocale()), info.getNumber())});
            }
            info.setIsTransUp(true);
            super._update(ctx, (IObjectPK)new ObjectStringPK(info.getId().toString()), (IObjectValue)info);
            oks.add(info.getId().toString());
        }
        return ret;
    }

    @Override
    protected Map _cancelConfirmTransUP(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        HashSet<String> oks = new HashSet<String>();
        ret.put("oks", oks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("isTransUp"));
        evi.getSelector().add(new SelectorItemInfo("isCreatedTransUp"));
        TransDetailCollection col = this.getTransDetailCollection(ctx, evi);
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            TransDetailInfo info = col.get(i);
            if (!TransDetailVerify.isCanCancelConfirmTransUP(info)) {
                throw new BEException(BEException.COMMON, new String[]{MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"31_TransDetailControllerBean", (Locale)ctx.getLocale()), info.getNumber())});
            }
            info.setIsTransUp(false);
            super._update(ctx, (IObjectPK)new ObjectStringPK(info.getId().toString()), (IObjectValue)info);
            oks.add(info.getId().toString());
        }
        return ret;
    }

    @Override
    protected void _setCreateTransUp(Context ctx, Set ids, boolean value) throws BOSException, EASBizException {
        String sql = "update T_BE_TransDetail set FIsCreatedTransUp={0} where fid in {1}";
        String valueStr = value ? "1" : "0";
        DbUtil.execute((Context)ctx, (String)MessageFormat.format(sql, valueStr, FMHelper.setTran2String((Set)ids)));
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        if (botRelation.getDestEntityID().equals(TransUpBillInfo.BOSTypeString())) {
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                String sql = "update T_BE_TransDetail set FIsCreatedTransUp=0 where fid= '" + srcBillPK + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            } else {
                String sql = "update T_BE_TransDetail set FIsCreatedTransUp=1 where fid= '" + srcBillPK + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
    }

    @Override
    protected Map _cancelConfirmTransDown(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        HashSet<String> oks = new HashSet<String>();
        ret.put("oks", oks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("isTransDown"));
        evi.getSelector().add(new SelectorItemInfo("isCreatedtransDown"));
        TransDetailCollection col = this.getTransDetailCollection(ctx, evi);
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            TransDetailInfo info = col.get(i);
            if (!TransDetailVerify.isCanCancelConfirmTransDown(info)) {
                throw new BEException(BEException.COMMON, new String[]{MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"32_TransDetailControllerBean", (Locale)ctx.getLocale()), info.getNumber())});
            }
            info.setIsTransDown(false);
            super._update(ctx, (IObjectPK)new ObjectStringPK(info.getId().toString()), (IObjectValue)info);
            oks.add(info.getId().toString());
        }
        return ret;
    }

    @Override
    protected Map _confirmTransDown(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        HashSet<String> oks = new HashSet<String>();
        ret.put("oks", oks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("isTransDown"));
        evi.getSelector().add(new SelectorItemInfo("debitAmount"));
        TransDetailCollection col = this.getTransDetailCollection(ctx, evi);
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            TransDetailInfo info = col.get(i);
            if (!TransDetailVerify.isCanConfirmTransDown(info)) {
                throw new BEException(BEException.COMMON, new String[]{MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"33_TransDetailControllerBean", (Locale)ctx.getLocale()), info.getNumber())});
            }
            info.setIsTransDown(true);
            super._update(ctx, (IObjectPK)new ObjectStringPK(info.getId().toString()), (IObjectValue)info);
            oks.add(info.getId().toString());
        }
        return ret;
    }

    @Override
    protected Map _confirmRecked(Context ctx, Set idSet, int recedStatus) throws BOSException, EASBizException {
        HashMap<String, String> rstMap = new HashMap<String, String>();
        StringBuffer failed = new StringBuffer();
        ArrayList<String> recIds = new ArrayList<String>(idSet.size());
        int failedCount = 0;
        String summary = "";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("fid"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("recedBillType"));
        evi.setSelector(evi.getSelector());
        TransDetailCollection col = this.getTransDetailCollection(ctx, evi);
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                TransDetailInfo detail = col.get(i);
                if (detail.getRecedBillType() != null && !"".equals(detail.getRecedBillType().getValue())) {
                    ++failedCount;
                    if (recedStatus == 0) {
                        failed.append(detail.getNumber()).append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"reced_transDetail", (Locale)ctx.getLocale(), (Object[])new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1040_TransDetailControllerBean", (Locale)ctx.getLocale())})).append(" \n");
                        continue;
                    }
                    if (recedStatus == 1) {
                        failed.append(detail.getNumber()).append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"reced_transDetail", (Locale)ctx.getLocale(), (Object[])new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1041_TransDetailControllerBean", (Locale)ctx.getLocale())})).append(" \n");
                        continue;
                    }
                    if (detail.getRecedBillType() == null || "".equals(detail.getRecedBillType().getValue())) continue;
                    failed.append(detail.getNumber()).append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"reced_transDetail", (Locale)ctx.getLocale(), (Object[])new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1042_TransDetailControllerBean", (Locale)ctx.getLocale())})).append(" \n");
                    continue;
                }
                recIds.add(detail.getId().toString());
            }
        }
        if (recIds.size() > 0) {
            String sql = "update T_BE_TransDetail set fisReced =" + recedStatus + " where fid in(";
            int n = recIds.size();
            for (int i = 0; i < n; ++i) {
                String id = (String)recIds.get(i);
                sql = i == 0 ? sql + "'" + id + "'" : sql + ",'" + id + "'";
            }
            sql = sql + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        summary = recedStatus == 0 ? summary + ResourceBase.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"reced_transdetail_summary", (Locale)ctx.getLocale(), (Object[])new Object[]{recIds.size(), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1040_TransDetailControllerBean", (Locale)ctx.getLocale()), failedCount}) : (recedStatus == 1 ? summary + ResourceBase.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"reced_transdetail_summary", (Locale)ctx.getLocale(), (Object[])new Object[]{recIds.size(), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1041_TransDetailControllerBean", (Locale)ctx.getLocale()), failedCount}) : summary + ResourceBase.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"reced_transdetail_summary", (Locale)ctx.getLocale(), (Object[])new Object[]{recIds.size(), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1042_TransDetailControllerBean", (Locale)ctx.getLocale()), failedCount}));
        rstMap.put("summary", summary);
        rstMap.put("fails", failed.toString());
        return rstMap;
    }

    @Override
    protected Map _getRefundPaymentBills(Context ctx, Map params) throws BOSException, EASBizException {
        String id = (String)params.get("id");
        TransDetailInfo info = this.getTransDetailInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (info.isIsTransDown() || info.isIsTransUp()) {
            throw new BEException(BEException.NOTALLOWREFUNDPAY);
        }
        if (info.isIsRefund() && !EmptyUtil.isEmpty((String)info.getRefundNo())) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankcheckflag", (Object)info.getRefundNo()));
            evi.setFilter(filter);
            PaymentBillCollection col = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(evi);
            PaymentBillCollection newCol = new PaymentBillCollection();
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)col)) {
                for (int i = 0; i < col.size(); ++i) {
                    if (col.get(i).getBankPayState() == null || !BankPayingBillStateEnum.TS.equals((Object)col.get(i).getBankPayState())) continue;
                    newCol.add(col.get(i));
                }
                this.removeBitBackBill(ctx, newCol);
                HashMap<String, PaymentBillCollection> data = new HashMap<String, PaymentBillCollection>();
                data.put("bills", newCol);
                return data;
            }
        }
        String companyId = (String)params.get("companyId");
        String accountId = (String)params.get("accountId");
        String currencyId = (String)params.get("currencyId");
        BigDecimal amount = (BigDecimal)params.get("amount");
        String currentCompanyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        if (!companyId.equals(currentCompanyId)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("shareType");
            selector.add("bankAccountNumber");
            AccountBankInfo accountInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountId), selector);
            if (!SharedAcctType.normal.equals((Object)accountInfo.getShareType())) {
                String bankAccountNumber = accountInfo.getBankAccountNumber();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)bankAccountNumber, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.EQUALS));
                view.setFilter(filter);
                SelectorItemCollection select = new SelectorItemCollection();
                select.add(new SelectorItemInfo("id"));
                select.add(new SelectorItemInfo("company.id"));
                view.setSelector(select);
                AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    if (!currentCompanyId.equals(coll.get(i).getCompany().getId().toString())) continue;
                    companyId = currentCompanyId;
                    accountId = coll.get(i).getId().toString();
                    break;
                }
            }
        }
        String strValue = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("BE013", (IObjectPK)new ObjectUuidPK(companyId));
        int d = Integer.parseInt(strValue) + 1;
        java.util.Date date = H.DATE((Object[])new Object[]{params.get("date"), "yyyy-MM-dd"});
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
        amount = amount.abs();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -d);
        java.util.Date stDate = cal.getTime();
        cal.setTime(date);
        cal.add(5, 1);
        java.util.Date edDate = cal.getTime();
        SelectorItemCollection sic = H.SIC((Object[])new Object[]{"id,number,billStatus,settlementType,description,payeeName,payeeBank,payeeAccountBank,company.name,payerAccountBank.*,currency.*,bizDate,actPayAmt"});
        boolean matchPayee = !EmptyUtil.isEmpty((String)info.getOppUnit());
        FilterInfo filter = H.FILTER((FilterItemInfo[])new FilterItemInfo[]{H.FITEM((Object[])new Object[]{"billStatus", 15}), H.FITEM((Object[])new Object[]{"payerAccountBank.id", accountId}), H.FITEM((Object[])new Object[]{"company.id", companyId}), H.FITEM((Object[])new Object[]{"currency.id", currencyId}), H.FITEM((Object[])new Object[]{"commitBeTime", H.DATE((Object[])new Object[]{stDate, "yyyy-MM-dd"}), CompareType.GREATER_EQUALS}), H.FITEM((Object[])new Object[]{"commitBeTime", H.DATE((Object[])new Object[]{edDate, "yyyy-MM-dd"}), CompareType.LESS}), H.FITEM((Object[])new Object[]{"actPayAmt", amount}), H.FITEM((Object[])new Object[]{"bankPayState", 6})});
        if (matchPayee) {
            filter.getFilterItems().add(H.FITEM((Object[])new Object[]{"payeeName", info.getOppUnit()}));
            filter.getFilterItems().add(H.FITEM((Object[])new Object[]{"bankAcctName", info.getOppUnit()}));
            filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 AND (#8 OR #9)");
        }
        EntityViewInfo evi = H.newEV((Object[])new Object[]{sic, filter});
        PaymentBillCollection col = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(evi);
        this.removeBitBackBill(ctx, col);
        return H.JSMAP((Object[])new Object[]{"bills", col, "DateRange", d});
    }

    private void removeBitBackBill(Context ctx, PaymentBillCollection col) throws BOSException, EASBizException {
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)col)) {
            HashSet<String> refundPayedIdSet;
            HashMap<String, PaymentBillInfo> payBillMap = new HashMap<String, PaymentBillInfo>(col.size());
            for (int i = 0; i < col.size(); ++i) {
                payBillMap.put(col.get(i).getId().toString(), col.get(i));
            }
            FilterInfo bitBackFilter = new FilterInfo();
            HashSet payIdSet = new HashSet();
            payIdSet.addAll(payBillMap.keySet());
            bitBackFilter.getFilterItems().add(new FilterItemInfo("payBillId", payIdSet, CompareType.INCLUDE));
            EntityViewInfo bitbackEvi = H.newEV((Object[])new Object[]{null, bitBackFilter});
            PayBitBackRecordCollection payBitBackRecordCollection = PayBitBackRecordFactory.getLocalInstance(ctx).getPayBitBackRecordCollection(bitbackEvi);
            IBankPayingBill IBP = BankPayingBillFactory.getLocalInstance(ctx);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)payBitBackRecordCollection)) {
                for (int i = 0; i < payBitBackRecordCollection.size(); ++i) {
                    String bitbackBillId = payBitBackRecordCollection.get(i).getPayBillId();
                    FilterInfo bankPayFilter = H.FILTER((FilterItemInfo[])new FilterItemInfo[]{H.FITEM((Object[])new Object[]{"sourceBillId", bitbackBillId}), H.FITEM((Object[])new Object[]{"isBitBack", FMConstants.FALSE})});
                    if (IBP.exists(bankPayFilter) || !payBillMap.containsKey(bitbackBillId)) continue;
                    col.remove((PaymentBillInfo)payBillMap.get(bitbackBillId));
                }
            }
            if (!EmptyUtil.isEmpty(refundPayedIdSet = this.getRefundPayedIdSet(ctx))) {
                payBillMap.clear();
                for (int i = 0; i < col.size(); ++i) {
                    payBillMap.put(col.get(i).getId().toString(), col.get(i));
                }
                for (String payID : payBillMap.keySet()) {
                    if (!refundPayedIdSet.contains(payID)) continue;
                    col.remove((PaymentBillInfo)payBillMap.get(payID));
                }
            }
        }
    }

    private HashSet<String> getRefundPayedIdSet(Context ctx) throws BOSException {
        HashSet<String> result = new HashSet<String>();
        String sql = "SELECT FREFUNDPAYBILLID FROM T_CAS_PAYMENTBILL WHERE FREFUNDPAYBILLID IS NOT NULL";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (iRowSet.next()) {
                result.add(iRowSet.getString("FREFUNDPAYBILLID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _createRefundPaymentBill(Context ctx, Map params) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _confirmBankWithHolding(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        HashSet<String> oks = new HashSet<String>();
        ret.put("oks", oks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("isBankWithHolding"));
        evi.getSelector().add(new SelectorItemInfo("debitAmount"));
        TransDetailCollection col = this.getTransDetailCollection(ctx, evi);
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            TransDetailInfo info = col.get(i);
            if (!TransDetailVerify.isCanConfirmBankWithHolding(info)) {
                throw new BEException(BEException.COMMON, new String[]{MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"210_TransDetailControllerBean", (Locale)ctx.getLocale()), info.getNumber())});
            }
            info.setIsBankWithHolding(true);
            super._update(ctx, (IObjectPK)new ObjectStringPK(info.getId().toString()), (IObjectValue)info);
            oks.add(info.getId().toString());
            logger.error((Object)MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"bankWithHolding_byOpe", (Locale)ctx.getLocale()), info.getNumber()));
        }
        return ret;
    }

    @Override
    protected Map _cancelConfirmBankWithHolding(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        HashSet<String> oks = new HashSet<String>();
        ret.put("oks", oks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("isBankWithHolding"));
        evi.getSelector().add(new SelectorItemInfo("isReced"));
        TransDetailCollection col = this.getTransDetailCollection(ctx, evi);
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            TransDetailInfo info = col.get(i);
            if (!TransDetailVerify.isCanCancelConfirmBankWithHolding(info)) {
                throw new BEException(BEException.COMMON, new String[]{MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"211_TransDetailControllerBean", (Locale)ctx.getLocale()), info.getNumber())});
            }
            info.setIsBankWithHolding(false);
            super._update(ctx, (IObjectPK)new ObjectStringPK(info.getId().toString()), (IObjectValue)info);
            oks.add(info.getId().toString());
            logger.error((Object)MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"cancelBankWithHolding_byOpe", (Locale)ctx.getLocale()), info.getNumber()));
        }
        return ret;
    }

    @Override
    protected Map _cancelConfirmRecked(Context ctx, Set idSet) throws BOSException, EASBizException {
        return null;
    }
}

