/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.AccountBankBalanceCollection;
import com.kingdee.eas.fm.be.AccountBankBalanceFactory;
import com.kingdee.eas.fm.be.AccountBankBalanceInfo;
import com.kingdee.eas.fm.be.BalSourceTpye;
import com.kingdee.eas.fm.be.BizTypeEnum;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.TransdetailSourceEnum;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransDetailDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)TransDetailDataImport.class.getName());
    private Map companyMap = new HashMap();
    private Map currencyMap = new HashMap();
    private Map bankMap = new HashMap();
    private String resPath = "com.kingdee.eas.fm.be.BEAutoGenerateResource";

    private String getBEAutoGenerateResource(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)resName, (Locale)ctx.getLocale());
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        TransDetailInfo info = new TransDetailInfo();
        info.setIsDataImport(TransdetailSourceEnum.IMPORT);
        info.setIsDownToBankState(false);
        this.parseData(hsData, info, ctx);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
            view.setFilter(fi);
            TransDetailCollection coll = null;
            try {
                coll = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(view);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll != null && coll.size() > 0) {
                info.setId(coll.get(0).getId());
                info.setName(info.getName(), ctx.getLocale());
            }
        } else {
            boolean isUsedParam;
            if (EmptyUtil.isEmpty((CoreBaseInfo)info) && (isUsedParam = DataImportUtils.getImportParam((Context)ctx))) {
                try {
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (iCodingRuleManager.isExist((IObjectValue)info, info.getCompany().getId().toString())) {
                        info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, info.getCompany().getId().toString()));
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
            info.setName(info.getName(), ctx.getLocale());
        }
        return info;
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    private CoreBaseInfo parseData(Hashtable hsData, TransDetailInfo info, Context ctx) throws TaskExternalException {
        FilterInfo filter;
        EntityViewInfo view;
        Object data = null;
        String companyid = null;
        CurrencyInfo currency = new CurrencyInfo();
        data = this.getData(hsData, "FCompany_number");
        String companyNumber = data.toString().trim();
        if (data != null && data.toString().trim().length() > 0) {
            if (this.companyMap.containsKey(data.toString().trim())) {
                info.setCompany((CompanyOrgUnitInfo)this.companyMap.get(data.toString().trim()));
                companyid = ((CompanyOrgUnitInfo)this.companyMap.get(data.toString().trim())).getId().toString();
            } else {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
                view.setFilter(filter);
                CompanyOrgUnitCollection companyCol = null;
                try {
                    companyCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (companyCol == null || companyCol.size() < 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"342_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"343_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyCol.get(0).getId().toString()), (String)"transDetail_12import");
                    if (!isPermission) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"762_EReceiptDataImport", (Locale)ctx.getLocale()));
                    }
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"356_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"356_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                this.companyMap.put(data.toString().trim(), companyCol.get(0));
                info.setCompany(companyCol.get(0));
                companyid = companyCol.get(0).getId().toString();
            }
        }
        if ((data = this.getData(hsData, "FBankAccount_bankAccountNumber")) != null && data.toString().trim().length() > 0) {
            if (this.bankMap.containsKey(data.toString().trim() + companyid)) {
                AccountBankInfo accountBankInfo = (AccountBankInfo)this.bankMap.get(data.toString().trim() + companyid);
                info.setBankAccount(accountBankInfo);
                if (companyid == null) {
                    companyid = accountBankInfo.getCompany().getId().toString();
                    info.setCompany(accountBankInfo.getCompany());
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getCurrency())) {
                        currency = accountBankInfo.getCurrency();
                        info.setCurrency(accountBankInfo.getCurrency());
                    }
                } else if (!EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getCurrency())) {
                    currency = accountBankInfo.getCurrency();
                    info.setCurrency(accountBankInfo.getCurrency());
                }
            } else {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)data.toString().trim()));
                if (companyid != null) {
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
                }
                view.setFilter(filter);
                AccountBankCollection AccountBankCol = new AccountBankCollection();
                try {
                    AccountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (AccountBankCol == null || AccountBankCol.size() < 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"344_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"345_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                if (AccountBankCol.get(0).isIsClosed()) {
                    throw new TaskExternalException(MessageFormat.format(this.getBEAutoGenerateResource(ctx, "264_TransDetailDataImport"), data));
                }
                if (AccountBankCol.get(0).isIsSetBankInterface()) {
                    throw new TaskExternalException(MessageFormat.format(this.getBEAutoGenerateResource(ctx, "265_TransDetailDataImport"), data));
                }
                AccountBankInfo accountBankInfo = AccountBankCol.get(0);
                if (companyid != null && accountBankInfo.getShareType() != null && accountBankInfo.getShareType().getValue() == 2) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"347_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"348_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"349_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                this.bankMap.put(data.toString().trim() + companyid, AccountBankCol.get(0));
                info.setBankAccount(AccountBankCol.get(0));
                if (companyid == null) {
                    info.setCompany(accountBankInfo.getCompany());
                    companyid = accountBankInfo.getCompany().getId().toString();
                    if (EmptyUtil.isEmpty((CoreBaseInfo)AccountBankCol.get(0).getCurrency())) {
                        Object currencyNumber = this.getData(hsData, "FCurrency_number");
                        if (!EmptyUtil.isEmpty((CoreBaseInfo)currency)) {
                            info.setCurrency(currency);
                        } else if (currencyNumber == null || currencyNumber.toString().trim().length() <= 0) {
                            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"344_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"350_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                        }
                    } else {
                        currency = accountBankInfo.getCurrency();
                        info.setCurrency(currency);
                    }
                } else if (!EmptyUtil.isEmpty((CoreBaseInfo)AccountBankCol.get(0).getCurrency())) {
                    currency = accountBankInfo.getCurrency();
                    info.setCurrency(currency);
                }
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"351_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FCurrency_number");
        if (data != null && data.toString().trim().length() > 0 && EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
            if (this.currencyMap.containsKey(data.toString().trim())) {
                currency = (CurrencyInfo)this.currencyMap.get(data.toString().trim());
                info.setCurrency(currency);
            } else {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
                view.setFilter(filter);
                CurrencyCollection currencyCol = null;
                try {
                    currencyCol = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (currencyCol == null || currencyCol.size() < 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"357_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"343_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                currency = currencyCol.get(0);
                this.currencyMap.put(data.toString().trim(), currency);
                info.setCurrency(currency);
            }
        }
        if (companyid == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"352_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"358_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FBizTime");
        if (data != null && data.toString().trim().length() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
            try {
                sdf.parse(data.toString());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            info.setBizTime(TypeConversionUtils.objToTimestamp((Object)data));
            info.setBizDate(DateTimeUtils.truncateDate((Date)TypeConversionUtils.objToDate((Object)data)));
            Date bankOpenDate = info.getBankAccount().getBankOpenDate();
            if (bankOpenDate != null && bankOpenDate.compareTo(info.getBizDate()) <= 0) {
                throw new TaskExternalException(this.getBEAutoGenerateResource(ctx, "BankOpenDateCheckMsg"));
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"763_EReceiptDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FBizType");
        if (data != null && data.toString().trim().length() > 0) {
            int draftType = TypeConversionUtils.objToInt((Object)data);
            if (draftType != 1 && draftType != 2 && draftType != 3) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"199_IMPORT_BIZTYPE", (Locale)ctx.getLocale()));
            }
            if (draftType == 2) {
                info.setBizType(BizTypeEnum.transUp);
            } else if (draftType == 3) {
                info.setBizType(BizTypeEnum.transDown);
            } else {
                info.setBizType(BizTypeEnum.normal);
            }
        }
        if ((data = this.getData(hsData, "FName_l2")) != null && data.toString().trim().length() > 0) {
            info.setName(data.toString());
        }
        if ((data = this.getData(hsData, "FDescription")) != null && data.toString().trim().length() > 0) {
            info.setDescription(data.toString());
        }
        BigDecimal debitAmount = BigDecimal.ZERO;
        data = this.getData(hsData, "FDebitAmount");
        if (data != null && data.toString().trim().length() > 0) {
            String dataStr = data.toString().trim().replaceAll(",", "").replaceAll("\uff0c", "");
            try {
                debitAmount = TypeConversionUtils.objToBigDecimal((Object)dataStr);
            }
            catch (IllegalConversionException e) {
                throw new TaskExternalException(ResourceBase.getString((String)this.resPath, (String)"FDebitAmountFormat", (Locale)ctx.getLocale()));
            }
        }
        info.setDebitAmount(debitAmount);
        BigDecimal creditAmount = BigDecimal.ZERO;
        data = this.getData(hsData, "FCreditAmount");
        if (data != null && data.toString().trim().length() > 0) {
            String dataStr = data.toString().trim().replaceAll(",", "").replaceAll("\uff0c", "");
            try {
                creditAmount = TypeConversionUtils.objToBigDecimal((Object)dataStr);
            }
            catch (IllegalConversionException e) {
                throw new TaskExternalException(ResourceBase.getString((String)this.resPath, (String)"FCreditAmountFormat", (Locale)ctx.getLocale()));
            }
        }
        info.setCreditAmount(creditAmount);
        if (debitAmount.compareTo(BigDecimal.ZERO) == 0 && creditAmount.compareTo(BigDecimal.ZERO) == 0 || debitAmount.compareTo(BigDecimal.ZERO) > 0 && creditAmount.compareTo(BigDecimal.ZERO) > 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"200_IMPORT_CD_ERROR", (Locale)ctx.getLocale()));
        }
        if (creditAmount.compareTo(BigDecimal.ZERO) > 0) {
            info.setIsDebit(false);
        } else {
            info.setIsDebit(true);
        }
        data = this.getData(hsData, "FTransBalance");
        if (data != null && data.toString().trim().length() > 0) {
            BigDecimal transBalance;
            String dataStr = data.toString().trim().replaceAll(",", "").replaceAll("\uff0c", "");
            try {
                transBalance = TypeConversionUtils.objToBigDecimal((Object)dataStr);
            }
            catch (IllegalConversionException e) {
                throw new TaskExternalException(ResourceBase.getString((String)this.resPath, (String)"FTransBalanceFormat", (Locale)ctx.getLocale()));
            }
            info.setTransBalance(transBalance);
        }
        if ((data = this.getData(hsData, "FbizNumber")) != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FNumber")) != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FOppUnit")) != null && data.toString().trim().length() > 0) {
            info.setOppUnit(data.toString());
        }
        if ((data = this.getData(hsData, "FOppBankNumber")) != null && data.toString().trim().length() > 0) {
            info.setOppBankNumber(data.toString());
            AccountBankInfo oppAccountBankInfo = null;
            try {
                oppAccountBankInfo = FmBeHelper.getAccountBankByNumber(ctx, info.getOppBankNumber());
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            if (oppAccountBankInfo != null) {
                info.setOppCompany(oppAccountBankInfo.getCompany());
            }
        }
        if ((data = this.getData(hsData, "FOppBank")) != null && data.toString().trim().length() > 0) {
            info.setOppBank(data.toString());
        }
        if ((data = this.getData(hsData, "FTranPackageID")) != null && data.toString().trim().length() > 0) {
            info.setTranPackageID(data.toString());
            info.setTranPackageUQID(info.getTranPackageID());
        }
        if (EmptyUtil.isEmpty((String)info.getTranPackageUQID())) {
            info.setTranPackageUQID(BOSUuid.create((BOSObjectType)info.getBOSType()).toString() + beServiceHelper.getSerialNumber(1)[0]);
        }
        if ((data = this.getData(hsData, "FIsTransUp")) != null && data.toString().trim().length() > 0) {
            info.setIsTransUp(TypeConversionUtils.objToBoolean((Object)data));
        }
        if ((data = this.getData(hsData, "FIsTransDown")) != null && data.toString().trim().length() > 0) {
            info.setIsTransDown(TypeConversionUtils.objToBoolean((Object)data));
        }
        if ((data = this.getData(hsData, "FBankCheckFlag")) != null && data.toString().trim().length() > 0) {
            info.setBankCheckFlag(data.toString());
        }
        if (info.isIsTransDown() && info.isIsTransUp()) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"201_IMPORT_DONWUP", (Locale)ctx.getLocale()));
        }
        if (this.checkIsAllLike(ctx, info)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"202_IMPORT_DETAIL", (Locale)ctx.getLocale()));
        }
        return info;
    }

    private boolean checkIsAllLike(Context ctx, TransDetailInfo info) {
        if (info.getTranPackageID() != null && info.getTranPackageID().length() > 0) {
            TransDetailCollection coll = null;
            try {
                coll = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection("where tranPackageID ='" + info.getTranPackageID() + "'");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll != null && coll.size() > 0) {
                return true;
            }
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)info.getBankAccount().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("transBalance", (Object)info.getTransBalance()));
            filter.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)info.getCreditAmount()));
            filter.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)info.getDebitAmount()));
            filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)info.getBizTime()));
            filter.getFilterItems().add(new FilterItemInfo("oppBankNumber", (Object)info.getOppBankNumber()));
            filter.getFilterItems().add(new FilterItemInfo("oppUnit", (Object)info.getOppUnit()));
            filter.getFilterItems().add(new FilterItemInfo("oppBank", (Object)info.getOppBank()));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
            filter.getFilterItems().add(new FilterItemInfo("description", (Object)info.getDescription()));
            view.setFilter(filter);
            TransDetailCollection transColl = null;
            try {
                transColl = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(view);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (transColl != null && transColl.size() > 0) {
                return true;
            }
        }
        return false;
    }

    protected ICoreBase getController(Context context) throws TaskExternalException {
        try {
            return TransDetailFactory.getLocalInstance(context);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        super.submit(coreBaseInfo, ctx);
        TransDetailInfo info = (TransDetailInfo)coreBaseInfo;
        if (EmptyUtil.isEmpty((Object)info.getTransBalance())) {
            return;
        }
        boolean BE018 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("BE018", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (BE018) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)info.getBizDate()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("accountBank", (Object)info.getBankAccount().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("currency", (Object)info.getCurrency().getId().toString()));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("balance");
            sic.add("valiBalance");
            sic.add("accurateBizDate");
            sic.add("isImport");
            sic.add("lastUpdateTime");
            view.setSelector(sic);
            AccountBankBalanceInfo acctInfo = null;
            AccountBankBalanceInfo balanceInfo = new AccountBankBalanceInfo();
            try {
                AccountBankBalanceCollection coll = AccountBankBalanceFactory.getLocalInstance(ctx).getAccountBankBalanceCollection(view);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
                    balanceInfo.setCompany(info.getCompany());
                    balanceInfo.setCurrency(info.getCurrency());
                    balanceInfo.setBizDate(info.getBizDate());
                    balanceInfo.setAccurateBizDate(info.getBizTime());
                    balanceInfo.setAccountBank(info.getBankAccount());
                    balanceInfo.setBalance(info.getTransBalance());
                    balanceInfo.setValiBalance(info.getTransBalance());
                    balanceInfo.setBalSourceType(BalSourceTpye.DETAIL);
                    AccountBankBalanceFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)balanceInfo);
                } else {
                    acctInfo = coll.get(0);
                    if (!acctInfo.isIsImport() && acctInfo.getAccurateBizDate().compareTo(info.getBizTime()) <= 0) {
                        acctInfo.setBalance(info.getTransBalance());
                        acctInfo.setValiBalance(info.getTransBalance());
                        acctInfo.setAccurateBizDate(info.getBizTime());
                        acctInfo.setLastUpdateTime(this.getTime());
                        AccountBankBalanceFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)acctInfo, sic);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp current = new Timestamp(d.getTime().getTime());
        return current;
    }
}

