/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AutoGenRuleForPayBillCollection;
import com.kingdee.eas.fi.cas.AutoGenRuleForPayBillFactory;
import com.kingdee.eas.fi.cas.AutoGenRuleForPayBillInfo;
import com.kingdee.eas.fi.cas.AutoGenRuleForRecBillCollection;
import com.kingdee.eas.fi.cas.AutoGenRuleForRecBillFactory;
import com.kingdee.eas.fi.cas.AutoGenRuleForRecBillInfo;
import com.kingdee.eas.fi.cas.IPaymentBillWebFacade;
import com.kingdee.eas.fi.cas.IReceivingbillWebFacade;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillWebFacadeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingbillWebFacadeFactory;
import com.kingdee.eas.fi.cas.model.AutoBatchExecuteResult;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fm.be.ITransDetail;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ss.BusinessTypeInfo;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.SmartSettleEntryCompanyCollection;
import com.kingdee.eas.fm.ss.SmartSettleEntryCompanyFactory;
import com.kingdee.eas.fm.ss.SmartSettleEntryCompanyInfo;
import com.kingdee.eas.fm.ss.SmartSettleSchemaInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleProcess;
import com.kingdee.eas.fm.ss.app.ISmartSettleProcess;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransDetailSmartFilter
extends AbstractSmartSettleProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.TransDetailSmartFilter");

    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        ArrayList<String> result;
        block16: {
            List rs;
            IQueryExecutor iexec;
            IMetaDataPK mainQueryPK;
            FilterInfo filter;
            HashSet<String> comIdSet;
            String queryOql;
            String operatorNumber;
            block15: {
                result = new ArrayList<String>();
                filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK);
                SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
                operatorNumber = busiInfo.getOperatorNumber();
                queryOql = "";
                try {
                    FilterInfo filterInfo = new FilterInfo(filterSql);
                    if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
                        FilterItemCollection filterItemCol = filterInfo.getFilterItems();
                        for (int i = 0; i < filterItemCol.size(); ++i) {
                            String compareOp;
                            FilterItemInfo filterItemInfo = filterItemCol.get(i);
                            String filterField = filterItemInfo.getPropertyName();
                            String filterValue = "";
                            Object cmpVal = filterItemInfo.getCompareValue();
                            if (cmpVal != null) {
                                filterValue = cmpVal.toString();
                            }
                            if ("=".equals(compareOp = filterItemInfo.getCompareType().toString()) && filterValue != null && filterValue.indexOf("00:00:00") > -1) {
                                String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + filterValue.substring(0, 10) + " 23:59:59')";
                                filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                                continue;
                            }
                            if (!"=".equals(compareOp) || filterValue == null || filterValue.indexOf(":") <= -1 || filterValue.indexOf("-") <= -1) continue;
                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            String endValue = "";
                            try {
                                java.util.Date date = df.parse(filterValue);
                                date.setTime(date.getTime() + 1000L);
                                endValue = df.format(date);
                                if (EmptyUtil.isEmpty((String)endValue)) continue;
                                String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + endValue + " ')";
                                filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                                continue;
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (ParserException e) {
                    e.printStackTrace();
                }
                comIdSet = new HashSet<String>();
                EntityViewInfo evi = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("company.id"));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("smartAccounting.id", (Object)schemaID, CompareType.EQUALS));
                evi.setFilter(filterInfo);
                evi.setSelector(sic);
                SmartSettleEntryCompanyCollection comCol = SmartSettleEntryCompanyFactory.getLocalInstance((Context)ctx).getSmartSettleEntryCompanyCollection(evi);
                for (int i = 0; i < comCol.size(); ++i) {
                    comIdSet.add(comCol.get(i).getCompany().getId().toString());
                }
                if (!"transdetail_autoPay".equals(operatorNumber)) break block15;
                AutoGenRuleForPayBillCollection ruleCol = this.getAutoGenRuleForPayBillCollection(ctx, comIdSet);
                for (int i = 0; i < ruleCol.size(); ++i) {
                    filter = this.getTransDetailFilterForPayBill(ctx, ruleCol.get(i));
                    if (filterSql != null && filterSql.length() > 0) {
                        queryOql = "select id,number where (" + filterSql + ") and " + filter.toSql();
                    }
                    mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
                    iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
                    logger.error((Object)("TransDetailSmartFilter=======  transdetail_autoPay \u65b9\u6848\uff1a" + ruleCol.get(i).getId() + "  =====" + iexec.getSQL()));
                    rs = this.getSourceBillRowSet(ctx, iexec.getSQL());
                    for (int t = 0; t < rs.size(); ++t) {
                        result.add(rs.get(t).toString());
                    }
                }
                break block16;
            }
            if (!"transdetail_autoRec".equals(operatorNumber)) break block16;
            AutoGenRuleForRecBillCollection ruleCol = this.getAutoGenRuleForRecBillCollection(ctx, comIdSet);
            for (int i = 0; i < ruleCol.size(); ++i) {
                filter = this.getTransDetailFilterForRecBill(ctx, ruleCol.get(i));
                if (filterSql != null && filterSql.length() > 0) {
                    queryOql = "select id,number where (" + filterSql + ") and " + filter.toString();
                }
                mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
                iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
                logger.error((Object)("TransDetailSmartFilter=====  transdetail_autoRec\u65b9\u6848\uff1a" + ruleCol.get(i).getId() + "  =======" + iexec.getSQL()));
                rs = this.getSourceBillRowSet(ctx, iexec.getSQL());
                for (int t = 0; t < rs.size(); ++t) {
                    result.add(rs.get(t).toString());
                }
            }
        }
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        SmartSettleEntryCompanyInfo comInfo = (SmartSettleEntryCompanyInfo)ctx.get((Object)"comInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"companyInfo");
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartSettleProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, (OrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"492_BankPaymentSmartFilter", (Locale)ctx.getLocale()) + className + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"493_BankPaymentSmartFilter", (Locale)ctx.getLocale()), (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ").append(filterSql);
            }
        } else {
            result.append(filterSql);
        }
        return result.toString();
    }

    public Map _process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap map = new HashMap();
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)paramMap.get("busiInfo");
        SmartSettleSchemaInfo schemaInfo = (SmartSettleSchemaInfo)paramMap.get("schemaInfo");
        BusinessTypeInfo busiType = busiInfo.getBusinessType();
        List billList = (List)paramMap.get("billList");
        String companyID = "" + paramMap.get("companyID");
        int success = 0;
        int failure = 0;
        StringBuffer errorMsg = new StringBuffer();
        if (!EmptyUtil.isEmpty((Collection)billList)) {
            AutoGenRuleForPayBillCollection ruleCol;
            TransDetailCollection col;
            String operatorNumber = busiInfo.getOperatorNumber();
            TransDetailCollection transDetailCol = this.getTransDetailCollForPayBill(ctx, billList);
            HashMap<String, TransDetailCollection> transDetailMap = new HashMap<String, TransDetailCollection>();
            for (int i = 0; i < transDetailCol.size(); ++i) {
                TransDetailInfo info = transDetailCol.get(i);
                String acctBankId = info.getBankAccount().getId().toString();
                if (transDetailMap.containsKey(acctBankId)) {
                    col = (TransDetailCollection)((Object)transDetailMap.get(acctBankId));
                    col.add(info);
                    continue;
                }
                col = new TransDetailCollection();
                col.add(info);
                transDetailMap.put(acctBankId, col);
            }
            Set acctBankIds = transDetailMap.keySet();
            if ("transdetail_autoPay".equals(operatorNumber)) {
                ruleCol = this.getAutoGenRuleForPayBillCollection(ctx, acctBankIds, false);
                for (int i = 0; i < ruleCol.size(); ++i) {
                    col = (TransDetailCollection)((Object)transDetailMap.get(ruleCol.get(i).getAccountBank().getId().toString()));
                    int failCount = this.dealPaymentBillRule(ctx, col, ruleCol.get(i), errorMsg);
                    failure += failCount;
                    success = success + col.size() - failCount;
                }
            } else if ("transdetail_autoRec".equals(operatorNumber)) {
                ruleCol = this.getAutoGenRuleForRecBillCollection(ctx, acctBankIds, false);
                for (int i = 0; i < ruleCol.size(); ++i) {
                    col = (TransDetailCollection)((Object)transDetailMap.get(ruleCol.get(i).getAccountBank().getId().toString()));
                    int failCount = this.dealReceivingBillRule(ctx, col, ruleCol.get(i), errorMsg);
                    failure += failCount;
                    success = success + col.size() - failCount;
                }
            }
        }
        String msg = "";
        int state = 0;
        if (errorMsg.length() > 0) {
            logger.error((Object)("TransDetailSmartFilter=====   errorMsg: " + errorMsg.toString()));
            state = 1;
        }
        msg = errorMsg.length() > 600 ? errorMsg.substring(0, 600) : errorMsg.toString();
        result.put("state", state);
        result.put("success", success);
        result.put("errorMsg", msg);
        result.put("failure", failure);
        return result;
    }

    protected int dealReceivingBillRule(Context ctx, TransDetailCollection col, AutoGenRuleForRecBillInfo rule, StringBuffer errorMsg) throws EASBizException, BOSException {
        int i;
        int failCount = 0;
        AutoBatchExecuteResult autoExeResult = new AutoBatchExecuteResult();
        for (i = 0; i < col.size(); ++i) {
            TransDetailInfo info = col.get(i);
            HashSet<String> ids = new HashSet<String>();
            ids.add(info.getId().toString());
            logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\uff1a[" + info.getId().toString() + "] \u751f\u6210\u6536\u6b3e\u5355\u3002"));
            int autoExecOper = rule.getAutoExecOper().getValue();
            ReceivingBillCollection colls = null;
            try {
                colls = (ReceivingBillCollection)ReceivingBillFactory.getLocalInstance((Context)ctx).recTrans(ids);
                if (colls != null && colls.size() > 0) {
                    if (rule.getCreaterId() != null && !rule.getCreaterId().trim().equals("")) {
                        StringBuffer sb = new StringBuffer("UPDATE T_CAS_RECEIVINGBILL SET FCREATORID = '" + rule.getCreaterId() + "' where fid in (");
                        for (int t = 0; t < colls.size(); ++t) {
                            if (t < colls.size() - 1) {
                                sb.append("'" + colls.get(t).getId().toString() + "',");
                                continue;
                            }
                            sb.append("'" + colls.get(t).getId().toString() + "')");
                        }
                        DbUtil.execute((Context)ctx, (String)sb.toString());
                    }
                    String number = colls.getObject(0).getString("number");
                    try {
                        logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\uff1a[" + info.getId().toString() + "] \u63d0\u4ea4\u6536\u6b3e\u5355\u3002"));
                        IReceivingbillWebFacade recWebFacade = ReceivingbillWebFacadeFactory.getLocalInstance((Context)ctx);
                        if (autoExecOper < 1) continue;
                        String[] recBillIds = new String[]{colls.getObject(0).getString("id")};
                        logger.error((Object)"\u5f00\u59cb\u63d0\u4ea4\u6536\u6b3e\u5355\u3002");
                        BatchExecuteResult result = (BatchExecuteResult)recWebFacade.batchSubmit(recBillIds);
                        if (result.getDetailMsgList().size() > 0) {
                            autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                            continue;
                        }
                        logger.error((Object)"\u5f00\u59cb\u5ba1\u6279\u6536\u6b3e\u5355\u3002");
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(rule.getAuditorId()));
                        ctx.put((Object)"UserInfo", (Object)UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                        result = (BatchExecuteResult)recWebFacade.batchAudit(recBillIds);
                        if (result.getDetailMsgList().size() > 0) {
                            autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                            continue;
                        }
                        if (autoExecOper != 2) continue;
                        logger.error((Object)"\u5f00\u59cb\u6536\u6b3e\u5355\u6536\u6b3e\u3002");
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(rule.getCasherId()));
                        ctx.put((Object)"UserInfo", (Object)UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                        result = (BatchExecuteResult)recWebFacade.batchRec(recBillIds);
                        if (result.getDetailMsgList().size() <= 0) continue;
                        autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                    }
                    catch (Exception e) {
                        autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1051_TransDetailSmartFilter", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1052_TransDetailSmartFilter", (Locale)ctx.getLocale()) + e.getMessage());
                    }
                    continue;
                }
                ++failCount;
                autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1053_TransDetailSmartFilter", (Locale)ctx.getLocale()) + info.getId().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1054_TransDetailSmartFilter", (Locale)ctx.getLocale()));
                continue;
            }
            catch (Exception e) {
                ++failCount;
                autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1053_TransDetailSmartFilter", (Locale)ctx.getLocale()) + info.getId().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1055_TransDetailSmartFilter", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        for (i = 0; i < autoExeResult.getDetailMsgList().size(); ++i) {
            errorMsg.append(((String)autoExeResult.getDetailMsgList().get(i)).toString()).append("\n");
        }
        return failCount;
    }

    protected int dealPaymentBillRule(Context ctx, TransDetailCollection col, AutoGenRuleForPayBillInfo rule, StringBuffer errorMsg) throws EASBizException, BOSException {
        int i;
        int failCount = 0;
        AutoBatchExecuteResult autoExeResult = new AutoBatchExecuteResult();
        for (i = 0; i < col.size(); ++i) {
            TransDetailInfo info = col.get(i);
            int autoExecOper = rule.getAutoExecOper().getValue();
            HashSet<String> ids = new HashSet<String>();
            ids.add(info.getId().toString());
            logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\uff1a[" + info.getId().toString() + "] \u751f\u6210\u4ed8\u6b3e\u5355\u3002"));
            PaymentBillCollection colls = null;
            try {
                colls = (PaymentBillCollection)PaymentBillFactory.getLocalInstance((Context)ctx).recTrans(ids);
                if (colls != null && colls.size() > 0) {
                    if (rule.getCreaterId() != null && !rule.getCreaterId().trim().equals("")) {
                        StringBuffer sb = new StringBuffer("UPDATE T_CAS_PAYMENTBILL SET FCREATORID = '" + rule.getCreaterId() + "' where fid in (");
                        for (int t = 0; t < colls.size(); ++t) {
                            if (t < colls.size() - 1) {
                                sb.append("'" + colls.get(t).getId().toString() + "',");
                                continue;
                            }
                            sb.append("'" + colls.get(t).getId().toString() + "')");
                        }
                        DbUtil.execute((Context)ctx, (String)sb.toString());
                    }
                    String number = colls.getObject(0).getString("number");
                    try {
                        logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\uff1a[" + info.getId().toString() + "] \u63d0\u4ea4\u4ed8\u6b3e\u5355\u3002"));
                        IPaymentBillWebFacade payWebFacade = PaymentBillWebFacadeFactory.getLocalInstance((Context)ctx);
                        if (autoExecOper < 1) continue;
                        String[] payBillIds = new String[]{colls.getObject(0).getString("id")};
                        logger.error((Object)"\u5f00\u59cb\u63d0\u4ea4\u4ed8\u6b3e\u5355\u3002");
                        BatchExecuteResult result = (BatchExecuteResult)payWebFacade.batchSubmit(payBillIds, null);
                        if (result.getDetailMsgList().size() > 0) {
                            autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                            continue;
                        }
                        logger.error((Object)"\u5f00\u59cb\u5ba1\u6279\u4ed8\u6b3e\u5355\u3002");
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(rule.getAuditorId()));
                        ctx.put((Object)"UserInfo", (Object)UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                        result = (BatchExecuteResult)payWebFacade.batchAudit(payBillIds, null);
                        if (result.getDetailMsgList().size() > 0) {
                            autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                            continue;
                        }
                        if (autoExecOper != 3) continue;
                        logger.error((Object)"\u5f00\u59cb\u4ed8\u6b3e\u5355\u4ed8\u6b3e\u3002");
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(rule.getCasherId()));
                        ctx.put((Object)"UserInfo", (Object)UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                        result = (BatchExecuteResult)payWebFacade.batchPay(payBillIds, null);
                        if (result.getDetailMsgList().size() <= 0) continue;
                        autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1061_TransDetailSmartFilter", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1052_TransDetailSmartFilter", (Locale)ctx.getLocale()) + e.getMessage());
                    }
                    continue;
                }
                ++failCount;
                autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1053_TransDetailSmartFilter", (Locale)ctx.getLocale()) + info.getId().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1062_TransDetailSmartFilter", (Locale)ctx.getLocale()));
                continue;
            }
            catch (Exception e) {
                ++failCount;
                autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1053_TransDetailSmartFilter", (Locale)ctx.getLocale()) + info.getId().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1063_TransDetailSmartFilter", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        for (i = 0; i < autoExeResult.getDetailMsgList().size(); ++i) {
            errorMsg.append(((String)autoExeResult.getDetailMsgList().get(i)).toString()).append("\n");
        }
        return failCount;
    }

    private AutoGenRuleForRecBillCollection getAutoGenRuleForRecBillCollection(Context ctx, Set comIdSet) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        if (!EmptyUtil.isEmpty((Collection)comIdSet)) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)comIdSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)DateUtil.getDayBegin(), CompareType.LESS_EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        ev.setSelector(sic);
        AutoGenRuleForRecBillCollection coll = AutoGenRuleForRecBillFactory.getLocalInstance((Context)ctx).getAutoGenRuleForRecBillCollection(ev);
        return coll;
    }

    private AutoGenRuleForRecBillCollection getAutoGenRuleForRecBillCollection(Context ctx, Set idSet, boolean b) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        ev.setSelector(sic);
        AutoGenRuleForRecBillCollection coll = AutoGenRuleForRecBillFactory.getLocalInstance((Context)ctx).getAutoGenRuleForRecBillCollection(ev);
        return coll;
    }

    private AutoGenRuleForPayBillCollection getAutoGenRuleForPayBillCollection(Context ctx, Set comIdSet) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        Date now = new Date(new java.util.Date().getTime());
        if (!EmptyUtil.isEmpty((Collection)comIdSet)) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)comIdSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)DateUtil.getDayBegin(), CompareType.LESS_EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        ev.setSelector(sic);
        logger.error((Object)("SQL:" + ev.toString()));
        AutoGenRuleForPayBillCollection coll = AutoGenRuleForPayBillFactory.getLocalInstance((Context)ctx).getAutoGenRuleForPayBillCollection(ev);
        return coll;
    }

    private AutoGenRuleForPayBillCollection getAutoGenRuleForPayBillCollection(Context ctx, Set idSet, boolean b) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        Date now = new Date(new java.util.Date().getTime());
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        ev.setSelector(sic);
        logger.error((Object)("SQL:" + ev.toString()));
        AutoGenRuleForPayBillCollection coll = AutoGenRuleForPayBillFactory.getLocalInstance((Context)ctx).getAutoGenRuleForPayBillCollection(ev);
        return coll;
    }

    protected FilterInfo getTransDetailFilterForRecBill(Context ctx, AutoGenRuleForRecBillInfo rule) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)rule.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)rule.getAccountBank().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)rule.getStartDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)new Double(0.0), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isReced", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isTransUp", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isKDRetFlag", (Object)new Integer(0), CompareType.EQUALS));
        Set<String> acctSet = null;
        String strValue = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("TM113", (IObjectPK)new ObjectUuidPK(rule.getCompany().getId().toString()));
        if (strValue == null || "0".equals(strValue)) {
            acctSet = this.getBankAccount(ctx, rule.getCompany().getId().toString());
        }
        if (acctSet != null) {
            filter.getFilterItems().add(new FilterItemInfo("oppBankNumber", acctSet, CompareType.INCLUDE));
        }
        logger.error((Object)("filter:" + filter.toString()));
        return filter;
    }

    protected FilterInfo getTransDetailFilterForPayBill(Context ctx, AutoGenRuleForPayBillInfo rule) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)rule.getCompany().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)rule.getAccountBank().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)rule.getStartDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)new Double(0.0), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isReced", (Object)new Integer(0), CompareType.EQUALS));
        FilterInfo kdFilter = new FilterInfo();
        kdFilter.getFilterItems().add(new FilterItemInfo("isTransUp", (Object)new Integer(1), CompareType.EQUALS));
        kdFilter.getFilterItems().add(new FilterItemInfo("isBankWithHolding", (Object)new Integer(1), CompareType.EQUALS));
        kdFilter.setMaskString("#0 OR #1");
        filter.mergeFilter(kdFilter, "AND");
        logger.error((Object)("filter:" + filter.toString()));
        return filter;
    }

    protected TransDetailCollection getTransDetailCollForPayBill(Context ctx, List billList) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        Set idSet = FMHelper.list2Set((List)billList);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("bankAccount.id"));
        SorterItemInfo sorterItem = new SorterItemInfo("bankAccount.id");
        sorterItem.setSortType(SortType.ASCEND);
        ITransDetail iTrans = TransDetailFactory.getLocalInstance(ctx);
        logger.error((Object)("\u5355\u636e\u4e2a\u6570:" + billList.size()));
        TransDetailCollection transColl = iTrans.getTransDetailCollection(evi);
        return transColl;
    }

    private Set<String> getBankAccount(Context ctx, String companyId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select FRelatedCompanyId from T_BD_Bank where FRelatedCompanyId = '");
        sb.append(companyId).append("'");
        String relatedCompanyId = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                relatedCompanyId = rs.getString("FRelatedCompanyId");
            }
            HashSet<String> acctNotIncluSet = new HashSet<String>();
            if (relatedCompanyId != null) {
                sb = new StringBuffer();
                sb.append("select FBankAccountNumber from t_bd_accountBanks where FCompanyID = '");
                sb.append(relatedCompanyId);
                sb.append("'");
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                while (rs.next()) {
                    acctNotIncluSet.add(rs.getString("FBankAccountNumber"));
                }
            }
            if (acctNotIncluSet.size() > 0) {
                return acctNotIncluSet;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return null;
    }
}

