/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayWebFacadeFactory;
import com.kingdee.eas.fm.be.IBankPayWebFacade;
import com.kingdee.eas.fm.be.ITransDetail;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.TransDetailRecedEnum;
import com.kingdee.eas.fm.be.TransDetailVerify;
import com.kingdee.eas.fm.be.app.AbstractTransDetailWebFacadeControllerBean;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.be.vo.DetailRefundBillRow;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.H;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransDetailWebFacadeControllerBean
extends AbstractTransDetailWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.TransDetailWebFacadeControllerBean");
    private static final String BE_TRANSDETAIL_01VIEW = "transDetail_01view";
    private static final String BE_TRANSDETAIL_01REMOVE = "transDetail_01Remove";

    @Override
    protected Map _getSumInfo(Context ctx, String filter) throws BOSException, EASBizException {
        IBankPayWebFacade iBankPayWebFacde = BankPayWebFacadeFactory.getLocalInstance(ctx);
        CompanyOrgUnitCollection orgUnitCollection = iBankPayWebFacde.getAuthrizedCompanyOrg(ctx.getCaller().toString(), BE_TRANSDETAIL_01VIEW, false);
        StringBuffer where = new StringBuffer("company.id in ('NE',");
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            where.append("'" + orgUnitCollection.get(i).getId().toString() + "',");
        }
        where.deleteCharAt(where.length() - 1);
        where.append(")");
        filter = filter == null || filter.equals("") ? where.toString() : filter + " AND " + where.toString();
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fm.be.TransDetailBillSumQuery"));
        queryExecutor.setObjectView("SELECT billCount,moneySum where " + filter);
        logger.info((Object)("TransDetail_Bill SumInfo SQL: " + queryExecutor.getSQL()));
        IRowSet rowSet = queryExecutor.executeQuery();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            rowSet.next();
            result.put("billCount", rowSet.getBigDecimal("billCount"));
            result.put("moneySum", rowSet.getBigDecimal("moneySum"));
            result.put("error", 0);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("msg", e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected Map _getTransDetailUIDefaultValue(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        CompanyOrgUnitInfo validCompanyInfo = null;
        CompanyOrgUnitCollection fiOrgColls = CASWebHelper.getAuthorizedOrgCollection((Context)ctx, (String)BE_TRANSDETAIL_01VIEW, (boolean)false);
        HashSet<String> idSet = new HashSet<String>();
        for (int idx = 0; idx < fiOrgColls.size(); ++idx) {
            CompanyOrgUnitInfo fiOrgUnit = fiOrgColls.get(idx);
            if (fiOrgUnit == null || fiOrgUnit.getId() == null) continue;
            idSet.add(fiOrgUnit.getId().toString());
        }
        ArrayList companyIdList = new ArrayList(idSet);
        if (companyIdList.contains(companyInfo.getId().toString())) {
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
            if (companyInfo.isIsBizUnit()) {
                validCompanyInfo = companyInfo;
            } else {
                for (int i = 0; i < companyIdList.size(); ++i) {
                    companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK((String)companyIdList.get(i)));
                    if (!companyInfo.isIsBizUnit()) continue;
                    validCompanyInfo = companyInfo;
                    break;
                }
            }
        } else {
            for (int i = 0; i < companyIdList.size(); ++i) {
                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK((String)companyIdList.get(i)));
                if (!companyInfo.isIsBizUnit()) continue;
                validCompanyInfo = companyInfo;
                break;
            }
        }
        if (validCompanyInfo != null) {
            defaultValueMap.put("DEFAULT_COMPANY", validCompanyInfo);
        }
        if (companyIdList != null && companyIdList.size() > 0) {
            defaultValueMap.put("VALID_COMPANYIDS", CASWebHelper.getAuthorizedOrgFilter_F7Special((Context)ctx, (String)BE_TRANSDETAIL_01VIEW, (boolean)false, (String)"unit.id", null));
        }
        return defaultValueMap;
    }

    public static AccountBankInfo getAccountBnakShareInfo(Context ctx, AccountBankInfo accountbank) throws EASBizException, BOSException {
        String bankAccoutId = "";
        SharedAcctInfo sharedAcctInfo = accountbank.getShareAcct();
        bankAccoutId = sharedAcctInfo.getBankAccount().getId().toString();
        accountbank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankAccoutId), TransDetailWebFacadeControllerBean.getBankOnChangeSelector());
        return accountbank;
    }

    private static SelectorItemCollection getBankOnChangeSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.*"));
        selector.add(new SelectorItemInfo("bankAccountNumber"));
        selector.add(new SelectorItemInfo("isonlyread"));
        selector.add(new SelectorItemInfo("relatedBankNumber"));
        selector.add(new SelectorItemInfo("bankOrgNumber"));
        selector.add(new SelectorItemInfo("customerNumber"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("openArea.id"));
        selector.add(new SelectorItemInfo("openArea.number"));
        selector.add(new SelectorItemInfo("openArea.*"));
        selector.add(new SelectorItemInfo("bank.name"));
        selector.add(new SelectorItemInfo("currency.id"));
        selector.add(new SelectorItemInfo("currency.isoCode"));
        selector.add(new SelectorItemInfo("isByCurrency"));
        selector.add(new SelectorItemInfo("isByCurrency"));
        selector.add(new SelectorItemInfo("shareAcct.*"));
        return selector;
    }

    @Override
    protected Map _accountBankChange(Context ctx, String accountBankId) throws BOSException, EASBizException {
        AccountBankInfo bankInfo;
        int i;
        HashMap<String, String> rstData = new HashMap<String, String>();
        if (StringUtil.isEmptyString((String)accountBankId)) {
            rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputAccountBankIsNull"));
            return rstData;
        }
        HashSet<String> idSet = new HashSet<String>();
        String[] acctIds = accountBankId.split(",");
        for (int i2 = 0; i2 < acctIds.length; ++i2) {
            idSet.add(acctIds[i2]);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(TransDetailWebFacadeControllerBean.getBankOnChangeSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        AccountBankCollection bankColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        AccountBankCollection accountBankColl = new AccountBankCollection();
        CurrencyInfo currency = null;
        for (i = 0; i < bankColl.size(); ++i) {
            bankInfo = bankColl.get(i);
            if (SharedAcctType.userd == bankInfo.getShareType()) {
                bankInfo = TransDetailWebFacadeControllerBean.getAccountBnakShareInfo(ctx, bankInfo);
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)bankInfo)) {
                rstData.put("MsgStr", CASWebUtil.getResource((Context)ctx, (String)"InputAccountBankIsNull"));
                return rstData;
            }
            accountBankColl.add(bankInfo);
        }
        for (i = 0; i < accountBankColl.size(); ++i) {
            bankInfo = accountBankColl.get(i);
            if (EmptyUtil.isEmpty((CoreBaseInfo)bankInfo) || !bankInfo.isIsByCurrency()) continue;
            currency = bankInfo.getCurrency();
            break;
        }
        if (currency != null && currency.getId() != null && currency.getName() == null) {
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()));
        }
        rstData.put("currency", (String)currency);
        rstData.put("acctBankColl", (String)accountBankColl);
        return rstData;
    }

    @Override
    protected Map _deleteTransDetail(Context ctx, HashMap idsMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        ITransDetail transDetail = TransDetailFactory.getLocalInstance(ctx);
        ArrayList<String> idList = new ArrayList<String>();
        for (Object v : idsMap.values()) {
            if (idList.contains(v.toString())) continue;
            idList.add(v.toString());
        }
        int success = 0;
        String summary = null;
        TransDetailInfo info = TransDetailFactory.getLocalInstance(ctx).getTransDetailInfo((IObjectPK)new ObjectUuidPK((String)idList.get(0)));
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)BE_TRANSDETAIL_01REMOVE);
        if (!isPermission) {
            throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
        }
        for (int i = 0; i < idList.size(); ++i) {
            try {
                transDetail.delete((IObjectPK)new ObjectUuidPK((String)idList.get(i)));
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "136_TRANSDETAIL_DELETE_FAILED", new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"109_BankPayingBillListUI", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1065_TransDetailWebFacadeControllerBean", (Locale)ctx.getLocale()), e.getMessage()}));
            }
        }
        summary = success == idList.size() ? FmBeWebUtils.getResource(ctx, "114_ALL_DELETE_SUCCESS") : FmBeWebUtils.getResource(ctx, "115_DELETE_RESULT", new String[]{String.valueOf(success), String.valueOf(idList.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _confirmTransUP(Context ctx, HashMap dataMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        ITransDetail transDetail = TransDetailFactory.getLocalInstance(ctx);
        TransDetailCollection col = this.getTransDetailCollection(ctx, dataMap);
        int success = 0;
        String summary = null;
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            TransDetailInfo info = null;
            try {
                info = col.get(i);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"transDetail_04confirmTransUp");
                if (!isPermission) {
                    throw new BOSException(FmBeWebUtils.getResource(ctx, "121_TransDetail", new String[]{info.getCompany().getName()}));
                }
                if (TransDetailVerify.isCanConfirmTransUP(info)) {
                    info.setIsTransUp(true);
                    transDetail.update((IObjectPK)new ObjectStringPK(info.getId().toString()), (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "140_CANNOT_TRANSUP01", new String[]{String.valueOf(dataMap.get(info.getId().toString()))}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "141_CANNOT_TRANSUP02", new String[]{String.valueOf(dataMap.get(info.getId().toString())), e.getMessage()}));
            }
        }
        summary = success == col.size() ? FmBeWebUtils.getResource(ctx, "142_TRANSUP_ALLSUCCESS") : FmBeWebUtils.getResource(ctx, "143_TRANSUP_RESULT", new String[]{String.valueOf(success), String.valueOf(col.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _cancleConfirmTransUP(Context ctx, HashMap dataMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        ITransDetail transDetail = TransDetailFactory.getLocalInstance(ctx);
        TransDetailCollection col = this.getTransDetailCollection(ctx, dataMap);
        int success = 0;
        String summary = null;
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            TransDetailInfo info = null;
            try {
                info = col.get(i);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"transDetail_05canelConfirmTransUp");
                if (!isPermission) {
                    throw new BOSException(FmBeWebUtils.getResource(ctx, "122_TransDetail", new String[]{info.getCompany().getName()}));
                }
                if (TransDetailVerify.isCanCancelConfirmTransUP(info)) {
                    info.setIsTransUp(false);
                    transDetail.update((IObjectPK)new ObjectStringPK(info.getId().toString()), (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "144_CANNOT_CANCELTRANSUP01", new String[]{String.valueOf(dataMap.get(info.getId().toString()))}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "145_CANNOT_CANCELTRANSUP02", new String[]{String.valueOf(dataMap.get(info.getId().toString())), e.getMessage()}));
            }
        }
        summary = success == col.size() ? FmBeWebUtils.getResource(ctx, "146_CANCELTRANSUP_ALLSUCCESS") : FmBeWebUtils.getResource(ctx, "147_CANCELTRANSUP_RESULT", new String[]{String.valueOf(success), String.valueOf(col.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _confirmTransDown(Context ctx, HashMap dataMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        ITransDetail transDetail = TransDetailFactory.getLocalInstance(ctx);
        TransDetailCollection col = this.getTransDetailCollection(ctx, dataMap);
        int success = 0;
        String summary = null;
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            TransDetailInfo info = null;
            try {
                info = col.get(i);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"transDetail_06confirmTransDown");
                if (!isPermission) {
                    throw new BOSException(FmBeWebUtils.getResource(ctx, "123_TransDetail", new String[]{info.getCompany().getName()}));
                }
                if (TransDetailVerify.isCanConfirmTransDown(info)) {
                    info.setIsTransDown(true);
                    transDetail.update((IObjectPK)new ObjectStringPK(info.getId().toString()), (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "148_CANNOT_TRANSDOWN01", new String[]{String.valueOf(dataMap.get(info.getId().toString()))}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "149_CANNOT_TRANSDOMN02", new String[]{String.valueOf(dataMap.get(info.getId().toString())), e.getMessage()}));
            }
        }
        summary = success == col.size() ? FmBeWebUtils.getResource(ctx, "150_TRANSDOMN_ALLSUCCESS") : FmBeWebUtils.getResource(ctx, "151_TRANSDOWN_RESULT", new String[]{String.valueOf(success), String.valueOf(col.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _cancleConfirmTransDown(Context ctx, HashMap dataMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        ITransDetail transDetail = TransDetailFactory.getLocalInstance(ctx);
        TransDetailCollection col = this.getTransDetailCollection(ctx, dataMap);
        int success = 0;
        String summary = null;
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            TransDetailInfo info = null;
            try {
                info = col.get(i);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"transDetail_07canelConfirmTransDown");
                if (!isPermission) {
                    throw new BOSException(FmBeWebUtils.getResource(ctx, "124_TransDetail", new String[]{info.getCompany().getName()}));
                }
                if (TransDetailVerify.isCanCancelConfirmTransDown(info)) {
                    info.setIsTransDown(false);
                    transDetail.update((IObjectPK)new ObjectStringPK(info.getId().toString()), (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "152_CANNOT_CANCELTRANSDOWN01", new String[]{String.valueOf(dataMap.get(info.getId().toString()))}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "153_CANNOT_CANCELTRANSDOWN02", new String[]{String.valueOf(dataMap.get(info.getId().toString())), e.getMessage()}));
            }
        }
        summary = success == col.size() ? FmBeWebUtils.getResource(ctx, "154_CANCELTRANSDOWN_ALLSUCCESS") : FmBeWebUtils.getResource(ctx, "155_CANCELTRANSDOWN_RESULT", new String[]{String.valueOf(success), String.valueOf(col.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private TransDetailCollection getTransDetailCollection(Context ctx, HashMap dataMap) throws BOSException {
        ITransDetail transDetail = TransDetailFactory.getLocalInstance(ctx);
        HashSet<String> ids = new HashSet<String>();
        for (Object key : dataMap.keySet()) {
            ids.add(key.toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("isTransUp"));
        evi.getSelector().add(new SelectorItemInfo("isTransDown"));
        evi.getSelector().add(new SelectorItemInfo("isCreatedTransUp"));
        evi.getSelector().add(new SelectorItemInfo("isCreatedTransDown"));
        evi.getSelector().add(new SelectorItemInfo("creditAmount"));
        evi.getSelector().add(new SelectorItemInfo("debitAmount"));
        evi.getSelector().add(new SelectorItemInfo("company.name"));
        TransDetailCollection col = transDetail.getTransDetailCollection(evi);
        return col;
    }

    @Override
    protected Map _confirmReced(Context ctx, HashMap dataMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        ITransDetail transDetail = TransDetailFactory.getLocalInstance(ctx);
        ArrayList<String> idList = new ArrayList<String>();
        for (Object key : dataMap.keySet()) {
            idList.add(key.toString());
        }
        int success = 0;
        String summary = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.name"));
        for (int i = 0; i < idList.size(); ++i) {
            TransDetailInfo info = null;
            try {
                info = TransDetailFactory.getLocalInstance(ctx).getTransDetailInfo((IObjectPK)new ObjectUuidPK((String)idList.get(i)), selector);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"transDetail_10confirmReced");
                if (!isPermission) {
                    throw new BOSException(FmBeWebUtils.getResource(ctx, "125_TransDetail", new String[]{info.getCompany().getName()}));
                }
                if (info.getIsReced() != TransDetailRecedEnum.reced) {
                    info.setIsReced(TransDetailRecedEnum.reced);
                    transDetail.update((IObjectPK)new ObjectUuidPK((String)idList.get(i)), (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "156_CANNOT_CONFIRRECED01", new String[]{String.valueOf(dataMap.get(info.getId().toString()))}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "157_CANNOT_CONFIRRECED02", new String[]{String.valueOf(dataMap.get(info.getId().toString())), e.getMessage()}));
            }
        }
        summary = success == idList.size() ? FmBeWebUtils.getResource(ctx, "158_CONFIMRECED_ALLSUCCESS") : FmBeWebUtils.getResource(ctx, "159_CONFIRM_RESULT", new String[]{String.valueOf(success), String.valueOf(idList.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _cancleConfirmReced(Context ctx, HashMap dataMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        ITransDetail transDetail = TransDetailFactory.getLocalInstance(ctx);
        ArrayList<String> idList = new ArrayList<String>();
        for (Object key : dataMap.keySet()) {
            idList.add(key.toString());
        }
        int success = 0;
        String summary = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.name"));
        for (int i = 0; i < idList.size(); ++i) {
            TransDetailInfo info = null;
            try {
                info = TransDetailFactory.getLocalInstance(ctx).getTransDetailInfo((IObjectPK)new ObjectUuidPK((String)idList.get(i)), selector);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"transDetail_11cancelConfirmReced");
                if (!isPermission) {
                    throw new BOSException(FmBeWebUtils.getResource(ctx, "126_TransDetail", new String[]{info.getCompany().getName()}));
                }
                if (TransDetailRecedEnum.reced.equals((Object)info.getIsReced()) && EmptyUtil.isEmpty((String)info.getRecedBillNumber())) {
                    info.setIsReced(TransDetailRecedEnum.toBeReced);
                    transDetail.update((IObjectPK)new ObjectUuidPK((String)idList.get(i)), (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                if (TransDetailRecedEnum.reced.equals((Object)info.getIsReced()) && !EmptyUtil.isEmpty((String)info.getRecedBillNumber())) {
                    result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "212_CANNOT_CANCELCONFIRRECED02", new String[]{String.valueOf(dataMap.get(info.getId().toString())), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1066_TransDetailWebFacadeControllerBean", (Locale)ctx.getLocale())}));
                    continue;
                }
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "211_CANNOT_CANCELCONFIRRECED01", new String[]{String.valueOf(dataMap.get(info.getId().toString()))}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "212_CANNOT_CANCELCONFIRRECED02", new String[]{String.valueOf(dataMap.get(info.getId().toString())), e.getMessage()}));
            }
        }
        summary = success == idList.size() ? FmBeWebUtils.getResource(ctx, "213_CANCELCONFIMRECED_ALLSUCCESS") : FmBeWebUtils.getResource(ctx, "214_CANCELCONFIRM_RESULT", new String[]{String.valueOf(success), String.valueOf(idList.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _confirmBankWithHolding(Context ctx, HashMap dataMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        ITransDetail transDetail = TransDetailFactory.getLocalInstance(ctx);
        ArrayList<String> idList = new ArrayList<String>();
        for (Object key : dataMap.keySet()) {
            idList.add(key.toString());
        }
        int success = 0;
        String summary = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.name"));
        for (int i = 0; i < idList.size(); ++i) {
            TransDetailInfo info = null;
            try {
                info = transDetail.getTransDetailInfo((IObjectPK)new ObjectUuidPK((String)idList.get(i)), selector);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"transDetail_08confirmBankWithHolding");
                if (!isPermission) {
                    throw new BOSException(FmBeWebUtils.getResource(ctx, "127_TransDetail", new String[]{info.getCompany().getName()}));
                }
                if (TransDetailVerify.isCanConfirmBankWithHolding(info)) {
                    info.setIsBankWithHolding(true);
                    transDetail.update((IObjectPK)new ObjectStringPK(info.getId().toString()), (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "163_CANNOT_CONFIRMBANKWITHHOLDING", new String[]{String.valueOf(dataMap.get(info.getId().toString()))}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "164_CANNOT_CONFIRMBANKWITHHOLDING1", new String[]{String.valueOf(dataMap.get(info.getId().toString())), e.getMessage()}));
            }
        }
        summary = success == idList.size() ? FmBeWebUtils.getResource(ctx, "165_CONFIRMBANKWITHHOLDING_ALLSUCCESS") : FmBeWebUtils.getResource(ctx, "166_CONFIRMBANKWITHHOLDING_RESULT", new String[]{String.valueOf(success), String.valueOf(idList.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _cancelConfirmBankWithHolding(Context ctx, HashMap dataMap) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        ITransDetail transDetail = TransDetailFactory.getLocalInstance(ctx);
        ArrayList<String> idList = new ArrayList<String>();
        for (Object key : dataMap.keySet()) {
            idList.add(key.toString());
        }
        int success = 0;
        String summary = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.name"));
        for (int i = 0; i < idList.size(); ++i) {
            TransDetailInfo info = null;
            try {
                info = transDetail.getTransDetailInfo((IObjectPK)new ObjectUuidPK((String)idList.get(i)), selector);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"transDetail_09cancleConfirmBankWithHolding");
                if (!isPermission) {
                    throw new BOSException(FmBeWebUtils.getResource(ctx, "128_TransDetail", new String[]{info.getCompany().getName()}));
                }
                if (TransDetailVerify.isCanCancelConfirmBankWithHolding(info)) {
                    info.setIsBankWithHolding(false);
                    transDetail.update((IObjectPK)new ObjectStringPK(info.getId().toString()), (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "167_CANNOT_CANCELCONFIRMBANKWITHHOLDING", new String[]{String.valueOf(dataMap.get(info.getId().toString()))}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "168_CANNOT_CANCELCONFIRMBANKWITHHOLDING1", new String[]{String.valueOf(dataMap.get(info.getId().toString())), e.getMessage()}));
            }
        }
        summary = success == idList.size() ? FmBeWebUtils.getResource(ctx, "169_CANCELCONFIRMBANKWITHHOLDING_ALLSUCCESS") : FmBeWebUtils.getResource(ctx, "170_CANCELCONFIRMBANKWITHHOLDING_RESULT", new String[]{String.valueOf(success), String.valueOf(idList.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _matchBizBill(Context ctx, Date beginDate, Date endDate, String[] acctIds) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> appliedList = new HashSet<String>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList releasedList = new ArrayList();
        try {
            Boolean boolResult;
            int i;
            if (EmptyUtil.isEmpty((Object)beginDate)) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1067_TransDetailWebFacadeControllerBean", (Locale)ctx.getLocale())});
            }
            if (EmptyUtil.isEmpty((Object)endDate)) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1068_TransDetailWebFacadeControllerBean", (Locale)ctx.getLocale())});
            }
            if (beginDate.after(endDate)) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1069_TransDetailWebFacadeControllerBean", (Locale)ctx.getLocale())});
            }
            ArrayList<String> idList = new ArrayList<String>();
            ArrayList<String> lockIds = new ArrayList<String>();
            for (int i2 = 0; i2 < acctIds.length; ++i2) {
                lockIds.add(acctIds[i2] + "MatchBill");
                idList.add(acctIds[i2]);
            }
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(lockIds);
            for (i = 0; i < lockIds.size(); ++i) {
                boolResult = (Boolean)resultRequest.get(lockIds.get(i));
                if (!boolResult.booleanValue()) continue;
                appliedList.add((String)idList.get(i));
                releasedList.add(lockIds.get(i));
            }
            for (i = 0; i < lockIds.size(); ++i) {
                boolResult = (Boolean)resultRequest.get(lockIds.get(i));
                if (boolResult.booleanValue()) continue;
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.FmBeWebResource", (String)"139_ACCOUNTBANK_USING", (Locale)ctx.getLocale())});
            }
            Map ret = BankFacadeFactory.getLocalInstance(ctx).matchBizBillInfo(appliedList, beginDate, endDate);
            int matchCount = (Integer)ret.get("totalCount");
            result.put("error", 1);
            result.put("count", matchCount);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("error", 0);
            result.put("msg", e.getMessage());
        }
        finally {
            if (releasedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(releasedList);
            }
        }
        return result;
    }

    @Override
    protected Map _refundPay(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ITransDetail biz = TransDetailFactory.getLocalInstance(ctx);
            TransDetailInfo info = biz.getTransDetailInfo(H.PK((Object)id));
            if (info.isHasRefundPay()) {
                throw new BEException(BEException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"323_ExsitDataForRepay", (Locale)ctx.getLocale())});
            }
            boolean isCanRefundPay = TransDetailWebFacadeControllerBean.isCanRefundPay(info);
            if (!isCanRefundPay) {
                throw new BEException(BEException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"343_DataCanNotForRepay", (Locale)ctx.getLocale())});
            }
            Map params = H.JSMAP((Object[])new Object[]{"id", id});
            params.put("date", H.DATE((Object[])new Object[]{info.getBizTime(), "yyyy-MM-dd"}));
            params.put("accountId", H.IDSTR((Object)info.getBankAccount()));
            params.put("companyId", H.IDSTR((Object)info.getCompany()));
            params.put("currencyId", H.IDSTR((Object)info.getCurrency()));
            if (H.isEmpty((Object)info.getCreditAmount())) {
                params.put("amount", H.BDEC((Object)info.getDebitAmount()));
            } else {
                params.put("amount", H.BDEC((Object)info.getCreditAmount()));
            }
            Map ret = biz.getRefundPaymentBills(params);
            PaymentBillCollection bills = (PaymentBillCollection)ret.get("bills");
            if (bills == null || bills.size() == 0) {
                int d = (Integer)ret.get("DateRange");
                throw new BEException(BEException.COMMON, new String[]{MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"313_NoDataForRepay", (Locale)ctx.getLocale()), new Integer(d), new Integer(d))});
            }
            if (bills.size() == 1) {
                result.put("error", 0);
                result.put("billSize", bills.size());
                result.put("bizBill", bills.get(0).getId().toString());
            } else {
                HashSet<String> detailBizBillIdSet = new HashSet<String>();
                for (int i = 0; i < bills.size(); ++i) {
                    detailBizBillIdSet.add(bills.get(i).getId().toString());
                }
                result.put("error", 0);
                result.put("bizBill", detailBizBillIdSet);
                result.put("billSize", bills.size());
            }
        }
        catch (BEException e) {
            e.printStackTrace();
            result.put("error", 1);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _buildRefundPayBillData(Context ctx, String[] ids) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        ArrayList<DetailRefundBillRow> rowList = new ArrayList<DetailRefundBillRow>();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i]);
        }
        if (idSet.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("billStatus");
            sic.add("bizDate");
            sic.add("payeeName");
            sic.add("payeeBank");
            sic.add("actPayAmt");
            sic.add("payeeAccountBank");
            sic.add("description");
            sic.add("company.name");
            sic.add("settlementType.name");
            sic.add("currency.*");
            sic.add("payerAccountBank.*");
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sorterItem = new SorterItemInfo("bizDate");
            sorterItem.setSortType(SortType.DESCEND);
            sorter.add(sorterItem);
            evi.setFilter(filter);
            evi.setSelector(sic);
            evi.setSorter(sorter);
            PaymentBillCollection col = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(evi);
            for (int i = 0; i < col.size(); ++i) {
                PaymentBillInfo info = col.get(i);
                DetailRefundBillRow row = new DetailRefundBillRow();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                row.setId(info.getId().toString());
                row.setNumber(info.getNumber().toString());
                row.setCompany(info.getCompany().getName());
                row.setBizdate(sdf.format(info.getBizDate()));
                row.setState(info.getBillStatus().getAlias());
                row.setPayAccount(info.getPayerAccountBank().getBankAccountNumber());
                row.setCurrency(info.getCurrency().getName());
                row.setAmount(info.getActPayAmt());
                row.setPayeeName(info.getPayeeName());
                row.setPayeeBank(info.getPayeeBank());
                row.setPayeeAccount(info.getPayeeAccountBank());
                row.setSettleType(info.getSettlementType().getName());
                row.setDescription(info.getDescription());
                rowList.add(row);
            }
        }
        result.put("rowList", rowList);
        return result;
    }

    @Override
    protected Map _noReced(Context ctx, HashMap dataMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        ITransDetail transDetail = TransDetailFactory.getLocalInstance(ctx);
        ArrayList<String> idList = new ArrayList<String>();
        for (Object key : dataMap.keySet()) {
            idList.add(key.toString());
        }
        int success = 0;
        String summary = null;
        for (int i = 0; i < idList.size(); ++i) {
            TransDetailInfo info = null;
            try {
                info = TransDetailFactory.getLocalInstance(ctx).getTransDetailInfo((IObjectPK)new ObjectUuidPK((String)idList.get(i)));
                if (info.getRecedBillType() == null) {
                    info.setIsReced(TransDetailRecedEnum.noNeedReced);
                    transDetail.update((IObjectPK)new ObjectUuidPK((String)idList.get(i)), (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "223_CANNOT_NORECED01", new String[]{String.valueOf(dataMap.get(info.getId().toString()))}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "224_CANNOT_NORECED02", new String[]{String.valueOf(dataMap.get(info.getId().toString())), e.getMessage()}));
            }
        }
        summary = success == idList.size() ? FmBeWebUtils.getResource(ctx, "225_NORECED_ALLSUCCESS") : FmBeWebUtils.getResource(ctx, "226_NORECED_RESULT", new String[]{String.valueOf(success), String.valueOf(idList.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    public static boolean isCanRefundPay(TransDetailInfo info) {
        return H.BDEC((Object)info.getCreditAmount()).compareTo(Constants.ZERO) == 1 || H.BDEC((Object)info.getDebitAmount()).compareTo(Constants.ZERO) == -1;
    }
}

