/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.VirtualDetailFactory;
import com.kingdee.eas.fm.be.VirtualDetailInfo;
import com.kingdee.eas.fm.be.app.AbstractVirtualDetailControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class VirtualDetailControllerBean
extends AbstractVirtualDetailControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.VirtualDetailControllerBean");

    @Override
    public BigDecimal _getPreDateBalance(Context ctx, VirtualDetailInfo info) throws BOSException, EASBizException {
        Date today = info.getVirtualDate();
        Date preDate = new Date(today.getTime() - 86400000L);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("virtualDate", (Object)DateTimeUtils.truncateDate((Date)preDate), CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("virtualDate", (Object)DateTimeUtils.truncateDate((Date)today), CompareType.LESS));
        filterItems.add(new FilterItemInfo("BankAcnt", (Object)info.getBankAcnt().getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        BigDecimal balance = new BigDecimal("0.0");
        CoreBaseCollection infos = VirtualDetailFactory.getLocalInstance(ctx).getCollection(view);
        if (infos != null && infos.size() > 0) {
            VirtualDetailInfo tmp = (VirtualDetailInfo)infos.get(0);
            balance = tmp.getBalance();
        }
        return balance;
    }

    @Override
    protected BOSUuid _getBOSUuid(Context ctx, VirtualDetailInfo info) throws BOSException, EASBizException {
        Date virtualDate = info.getVirtualDate();
        Date nextDate = new Date(virtualDate.getTime() + 86400000L);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("virtualDate", (Object)DateTimeUtils.truncateDate((Date)virtualDate), CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("virtualDate", (Object)DateTimeUtils.truncateDate((Date)nextDate), CompareType.LESS));
        filterItems.add(new FilterItemInfo("BankAcnt", (Object)info.getBankAcnt().getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        CoreBaseCollection infos = VirtualDetailFactory.getLocalInstance(ctx).getCollection(view);
        if (infos != null && infos.size() > 0) {
            VirtualDetailInfo tmp = (VirtualDetailInfo)infos.get(0);
            return tmp.getId();
        }
        return null;
    }
}

