/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankAcntRelationInfo;
import com.kingdee.eas.fm.be.VirtualDetailFactory;
import com.kingdee.eas.fm.be.VirtualDetailInfo;
import java.math.BigDecimal;
import java.util.List;

public class VirtualDetailUtil {
    public static void accountData(Context ctx, VirtualDetailInfo firstInfo, VirtualDetailInfo secondOverInfo, List secondNormalInfo, BankAcntRelationInfo model) throws EASBizException, BOSException {
        if (firstInfo != null) {
            VirtualDetailUtil.initFirstInfo(ctx, firstInfo);
        }
        if (secondOverInfo != null) {
            VirtualDetailUtil.initSecondOverInfo(ctx, secondOverInfo);
        }
        VirtualDetailUtil.initSecondNormalInfo(ctx, secondNormalInfo);
        if (secondOverInfo != null) {
            VirtualDetailUtil.processOver(secondOverInfo, ctx, secondNormalInfo);
        } else if (firstInfo != null) {
            VirtualDetailUtil.processOver(firstInfo, ctx, secondNormalInfo);
        }
        if (firstInfo != null) {
            if (secondOverInfo != null) {
                VirtualDetailUtil.pricessFirst(firstInfo, secondOverInfo, model);
            } else {
                VirtualDetailUtil.pricessFirst(firstInfo, firstInfo, model);
            }
        } else if (secondOverInfo != null) {
            VirtualDetailUtil.pricessFirst(secondOverInfo, secondOverInfo, model);
        }
    }

    private static void processTotalFirstBalance(VirtualDetailInfo firstInfo, List secondNormalInfo) {
        VirtualDetailInfo tmpInfo = null;
        for (int i = 0; i < secondNormalInfo.size(); ++i) {
            tmpInfo = (VirtualDetailInfo)secondNormalInfo.get(i);
            firstInfo.setBalance(firstInfo.getBalance().add(tmpInfo.getBalance()));
        }
        firstInfo.setChangeBalance(firstInfo.getBalance().subtract(firstInfo.getPrebalance()));
    }

    private static void pricessFirst(VirtualDetailInfo firstInfo, VirtualDetailInfo secondOverInfo, BankAcntRelationInfo model) {
        if (model.getBankOverAccountType().getValue().equals("0") && firstInfo != null) {
            firstInfo.setBankLimit(model.getBankOverAccount());
            if (firstInfo.getOverdraftLimit().compareTo(Constants.ZERO) >= 0) {
                firstInfo.setUseBankLimit(Constants.ZERO);
            } else {
                firstInfo.setUseBankLimit(firstInfo.getOverdraftLimit().abs());
            }
        }
        firstInfo.setUnuseBankLimit(firstInfo.getBankLimit().subtract(firstInfo.getUseBankLimit()));
        firstInfo.setAllDrafLimit(firstInfo.getUseBankLimit().add(secondOverInfo.getOverUseLimit()));
        firstInfo.setAllUseLimit(firstInfo.getUnuseBankLimit().add(secondOverInfo.getOverUnuseLimit()));
    }

    private static void processOver(VirtualDetailInfo info, Context ctx, List secondNormalInfo) {
        VirtualDetailInfo tmpInfo = null;
        for (int i = 0; i < secondNormalInfo.size(); ++i) {
            tmpInfo = (VirtualDetailInfo)secondNormalInfo.get(i);
            info.setInOverdraftLimit(info.getInOverdraftLimit().add(tmpInfo.getInOverdraftLimit()));
            tmpInfo.setInOverdraftLimit(Constants.ZERO);
            tmpInfo.setOverUseLimit(Constants.ZERO);
            tmpInfo.setOverUnuseLimit(Constants.ZERO);
        }
        if (info.getBalance().compareTo(Constants.ZERO) >= 0) {
            info.setOverUseLimit(Constants.ZERO);
        } else if (info.getBalance().abs().compareTo(info.getInOverdraftLimit()) <= 0) {
            info.setOverUseLimit(info.getBalance().abs());
        } else {
            info.setOverUseLimit(info.getInOverdraftLimit());
        }
        info.setOverUnuseLimit(info.getInOverdraftLimit().subtract(info.getOverUseLimit()));
    }

    public static void initFirstInfo(Context ctx, VirtualDetailInfo firstInfo) throws EASBizException, BOSException {
        BigDecimal preBalance = Constants.ZERO;
        preBalance = VirtualDetailFactory.getLocalInstance(ctx).getPreDateBalance(firstInfo);
        firstInfo.setPrebalance(preBalance);
        firstInfo.setChangeBalance(firstInfo.getBalance().subtract(preBalance));
        firstInfo.setOverUseLimit(Constants.ZERO);
        firstInfo.setOverUnuseLimit(Constants.ZERO);
    }

    public static void initSecondOverInfo(Context ctx, VirtualDetailInfo secondOverInfo) throws EASBizException, BOSException {
        BigDecimal preBalance = Constants.ZERO;
        preBalance = VirtualDetailFactory.getLocalInstance(ctx).getPreDateBalance(secondOverInfo);
        secondOverInfo.setPrebalance(preBalance);
        secondOverInfo.setChangeBalance(secondOverInfo.getBalance().subtract(preBalance));
        secondOverInfo.setBankLimit(Constants.ZERO);
        secondOverInfo.setUseBankLimit(Constants.ZERO);
        secondOverInfo.setUnuseBankLimit(Constants.ZERO);
        secondOverInfo.setAllDrafLimit(Constants.ZERO);
        secondOverInfo.setAllUseLimit(Constants.ZERO);
    }

    public static void initSecondNormalInfo(Context ctx, List secondNormalInfo) throws EASBizException, BOSException {
        BigDecimal preBalance = Constants.ZERO;
        for (int i = 0; i < secondNormalInfo.size(); ++i) {
            VirtualDetailInfo tmp = (VirtualDetailInfo)secondNormalInfo.get(i);
            preBalance = VirtualDetailFactory.getLocalInstance(ctx).getPreDateBalance(tmp);
            tmp.setPrebalance(preBalance);
            tmp.setChangeBalance(tmp.getBalance().subtract(preBalance));
            tmp.setBankLimit(Constants.ZERO);
            tmp.setUseBankLimit(Constants.ZERO);
            tmp.setUnuseBankLimit(Constants.ZERO);
            tmp.setAllDrafLimit(Constants.ZERO);
            tmp.setAllUseLimit(Constants.ZERO);
        }
    }
}

