/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.bankpay;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.ExtendableElement;
import com.kingdee.bos.ebservice.LinkPayRequestBody;
import com.kingdee.bos.ebservice.LinkPayResponseBody;
import com.kingdee.bos.ebservice.OverseaPayDetail;
import com.kingdee.bos.ebservice.PayBody;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.BankLogFactory;
import com.kingdee.eas.fm.be.BankLogInfo;
import com.kingdee.eas.fm.be.BankLogTypeEnum;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.ErrCodeHelper;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.IBankLog;
import com.kingdee.eas.fm.be.IBankLogFacade;
import com.kingdee.eas.fm.be.app.service.BankPayUtil;
import com.kingdee.eas.fm.be.app.service.CBPaymentPayUtil;
import com.kingdee.eas.fm.be.app.service.LinkPayUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.be.bean.BankLogBuildInfo;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class BankPayingBillPayUtil {
    public static final String IS_LINKPAY = "isListPay";
    private static final Logger logger = Logger.getLogger(BankPayingBillPayUtil.class);

    public BankPayingBillCollection getBankPayingBillCollection(Context ctx, Set<String> bankPayBillIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("remitAccountBank.*");
        selector.add("remitAccountBank.bank.name");
        selector.add("currency.*");
        selector.add("payAccountBank.*");
        selector.add("payAccountBank.bank.*");
        selector.add("recProvince.*");
        selector.add("recCity.*");
        selector.add("FRecCountry.*");
        selector.add("recRegion.*");
        selector.add("recOpenArea.*");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bankPayBillIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("payAccountBank.id");
        sorters.add(sorterItem);
        view.setSorter(sorters);
        BankPayingBillCollection collection = BankPayingBillFactory.getLocalInstance(ctx).getBankPayingBillCollection(view);
        return collection;
    }

    private void updateBankLogForException(IObjectPK logpk, IBankLog ibankLog) throws BOSException, EASBizException {
        BankLogInfo bankLogInfo = ibankLog.getBankLogInfo(logpk);
        bankLogInfo.setPaySourceId(null);
        ibankLog.update(logpk, bankLogInfo);
    }

    private void updateBankLogForExceptionBatch(Map<String, IObjectPK> bankPayBillLog, IBankLog ibankLog) throws BOSException, EASBizException {
        for (IObjectPK pk : bankPayBillLog.values()) {
            this.updateBankLogForException(pk, ibankLog);
        }
    }

    private BankLogTypeEnum getBankLogType(BankPayingBillInfo info) {
        BankLogTypeEnum bankType = info.isIsLinkPay() ? BankLogTypeEnum.linkPayment : (info.isIsPersonPay() ? BankLogTypeEnum.privatePay : BankLogTypeEnum.Pay);
        return bankType;
    }

    private IObjectPK buildLogMessage(Context ctx, BankPayingBillInfo bankPayingBillInfo, IBankLogFacade iBankLogFacade, IBankLog ibankLog) throws EASBizException, BOSException {
        String[] payAcnt = new String[]{bankPayingBillInfo.getPayAccountBank().getBankAccountNumber()};
        String[] payeeAcnt = new String[]{bankPayingBillInfo.getRecAccountBank()};
        BankLogTypeEnum bankType = this.getBankLogType(bankPayingBillInfo);
        BankLogBuildInfo build = new BankLogBuildInfo();
        build.setPayAcnt(payAcnt);
        build.setPayeeAcnt(payeeAcnt);
        build.setLogType(bankType);
        build.setCompany(bankPayingBillInfo.getCompany());
        build.setBankInterFace(bankPayingBillInfo.getPayAccountBank().getBankInterFace());
        build.setBankInterFaceID(bankPayingBillInfo.getPayAccountBank().getBankInterFaceID());
        build.setPayBillId(ConvertUtils.IDSTR((Object)bankPayingBillInfo));
        build.setSourceBillId(ConvertUtils.IDSTR((Object)bankPayingBillInfo));
        IObjectPK logpk = iBankLogFacade.buildBaseMessage(build);
        return logpk;
    }

    private void buildLogException(Context ctx, BankPayingBillInfo info, Exception e) {
        try {
            IBankLogFacade iBankLogFacade = BankLogFacadeFactory.getLocalInstance(ctx);
            IBankLog ibankLog = BankLogFactory.getLocalInstance(ctx);
            IObjectPK logpk = this.buildLogMessage(ctx, info, iBankLogFacade, ibankLog);
            iBankLogFacade.buildException(logpk, e, 0);
            this.updateBankLogForException(logpk, ibankLog);
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    public LinkPayResponseBody linkPay(Context ctx, BankPayingBillInfo info, IObjectPK logpk) throws Exception {
        LinkPayUtil linkPayUtil = new LinkPayUtil();
        LinkPayRequestBody body = beServiceHelper.parseLinkPayBody(ctx, info);
        linkPayUtil.setPk(logpk);
        BankBizInfo bizInfo = new BankBizInfo();
        bizInfo.setBankAcct(info.getPayAccountBank().getBankAccountNumber());
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getRemitAccountBank())) {
            bizInfo.setBillType(BillTypeEnum.PAYMENT_BILL);
        } else {
            bizInfo.setBillType(BillTypeEnum.AgentPay);
        }
        bizInfo.setCurrency(FmBeHelper.getCurrencyISO(ctx, info.getCurrency()));
        LinkPayResponseBody responseBody = linkPayUtil.linkPay(ctx, body, bizInfo, FmBeHelper.getCurrencyISO(ctx, info.getCurrency()));
        return responseBody;
    }

    public PaymentDetail bankPay(Context ctx, BankPayingBillInfo info, IObjectPK logpk) throws Exception {
        BankPayUtil bankPayUtil = new BankPayUtil();
        PayBody body = beServiceHelper.parseBankPayBody(ctx, info);
        BankBizInfo bizInfo = new BankBizInfo();
        bizInfo.setBankAcct(info.getPayAccountBank().getBankAccountNumber());
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getRemitAccountBank())) {
            bizInfo.setBillType(BillTypeEnum.PAYMENT_BILL);
        } else {
            bizInfo.setBillType(BillTypeEnum.AgentPay);
        }
        bizInfo.setCurrency(FmBeHelper.getCurrencyISO(ctx, info.getCurrency()));
        bankPayUtil.setPk(logpk);
        return bankPayUtil.pay(ctx, bizInfo, body)[0];
    }

    private void addBankPayResullt(List<BankPayResult> bankPayResults, BankPayingBillInfo info, BankPayingBillStateEnum state, String returnMsg, String errorDetail, boolean isSubmitToBe) {
        BankPayResult payResult = new BankPayResult(info.getId().toString(), info.getSerialNumber(), state, returnMsg);
        payResult.setSrcId(info.getSourceBillId());
        payResult.setErrorDetail(errorDetail);
        payResult.setSubmitToBe(isSubmitToBe);
        bankPayResults.add(payResult);
    }

    private BankPayResult beResult2BankPayResult(Context ctx, BankPayingBillInfo info, ExtendableElement bankReturnResult) throws EASBizException, BOSException {
        BankPayResult bankPayResult = new BankPayResult();
        if (bankReturnResult == null) {
            return bankPayResult;
        }
        BankPayingBillStateEnum state = null;
        String returnMsg = null;
        if (bankReturnResult instanceof LinkPayResponseBody) {
            LinkPayResponseBody linkPayResult = (LinkPayResponseBody)bankReturnResult;
            state = beServiceHelper.transferState(linkPayResult.getStatus());
            returnMsg = linkPayResult.getStatusMsg();
        } else if (bankReturnResult instanceof PaymentDetail) {
            PaymentDetail paymentDetail = (PaymentDetail)bankReturnResult;
            state = beServiceHelper.transferState(paymentDetail.getEbStatus());
            returnMsg = paymentDetail.getBankStatusMsg();
        }
        bankPayResult.setId(info.getId().toString());
        bankPayResult.setNumber(info.getSerialNumber());
        bankPayResult.setState(state);
        bankPayResult.setReturnMsg(returnMsg);
        bankPayResult.setSubmitToBe(true);
        return bankPayResult;
    }

    public BankPayResult doOnePay(Context ctx, BankPayingBillInfo info) throws BOSException, BEException, EASBizException {
        IBankLogFacade iBankLogFacade = BankLogFacadeFactory.getLocalInstance(ctx);
        IBankLog ibankLog = BankLogFactory.getLocalInstance(ctx);
        IObjectPK logpk = this.buildLogMessage(ctx, info, iBankLogFacade, ibankLog);
        ExtendableElement bankReturnResult = null;
        try {
            bankReturnResult = info.isIsLinkPay() ? this.linkPay(ctx, info, logpk) : this.bankPay(ctx, info, logpk);
            return this.beResult2BankPayResult(ctx, info, bankReturnResult);
        }
        catch (BEException e) {
            iBankLogFacade.buildException(logpk, (Exception)((Object)e), 0);
            this.updateBankLogForException(logpk, ibankLog);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            iBankLogFacade.buildException(logpk, (Exception)((Object)e), 0);
            this.updateBankLogForException(logpk, ibankLog);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (RemoteException e) {
            iBankLogFacade.buildException(logpk, e, 0);
            this.updateBankLogForException(logpk, ibankLog);
            throw new BEException(BEException.GETSERVICEFAILURE);
        }
        catch (Exception e) {
            iBankLogFacade.buildException(logpk, e, 0);
            this.updateBankLogForException(logpk, ibankLog);
            if (e.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            String error = new BEException(BEException.WRITESTATEFAILURE).getMessage();
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{error});
        }
    }

    private void doOnePayByType(Context ctx, List<BankPayResult> bankPayResults, BankPayingBillCollection bankPayingBills, BankLogTypeEnum bankType) {
        boolean isConnetionException = false;
        int size = bankPayingBills.size();
        for (int i = 0; i < size; ++i) {
            BankPayingBillInfo info = bankPayingBills.get(i);
            try {
                if (isConnetionException) {
                    BEException e = new BEException(BEException.GETSERVICEFAILURE);
                    this.buildLogException(ctx, info, (Exception)((Object)e));
                    throw e;
                }
                BankPayResult bankPayResult = this.doOnePay(ctx, info);
                bankPayResults.add(bankPayResult);
                continue;
            }
            catch (BEException e) {
                isConnetionException = e.getSubCode().equals(BEException.GETSERVICEFAILURE.getCode());
                this.addBankPayResullt(bankPayResults, info, BankPayingBillStateEnum.OF, e.getMessage(), e.getMessage(), false);
                continue;
            }
            catch (Exception e) {
                this.addBankPayResullt(bankPayResults, info, BankPayingBillStateEnum.NC, e.getMessage(), e.getMessage(), false);
            }
        }
    }

    private LinkPayResponseBody batchLinkPay(Context ctx, BankPayingBillCollection collection, Map<String, IObjectPK> bankPayBillLog) throws Exception {
        LinkPayUtil linkPayUtil = new LinkPayUtil();
        LinkPayRequestBody body = beServiceHelper.parseLinkPayBody(ctx, collection);
        linkPayUtil.setBatchPK(bankPayBillLog);
        BankBizInfo bizInfo = new BankBizInfo();
        bizInfo.setBankAcct(collection.get(0).getPayAccountBank().getBankAccountNumber());
        if (EmptyUtil.isEmpty((CoreBaseInfo)collection.get(0).getRemitAccountBank())) {
            bizInfo.setBillType(BillTypeEnum.PAYMENT_BILL);
        } else {
            bizInfo.setBillType(BillTypeEnum.AgentPay);
        }
        bizInfo.setCurrency(FmBeHelper.getCurrencyISO(ctx, collection.get(0).getCurrency()));
        LinkPayResponseBody responseBody = linkPayUtil.linkPay(ctx, body, bizInfo, FmBeHelper.getCurrencyISO(ctx, collection.get(0).getCurrency()));
        return responseBody;
    }

    private PaymentDetail[] batchBankPay(Context ctx, BankPayingBillCollection collection, Map<String, IObjectPK> bankPayBillLog) throws EASBizException, BOSException, RemoteException, ServiceException {
        BankPayUtil bankPayUtil = new BankPayUtil();
        PayBody body = beServiceHelper.parseBankPayBody(ctx, collection);
        BankBizInfo bizInfo = new BankBizInfo();
        bizInfo.setBankAcct(collection.get(0).getPayAccountBank().getBankAccountNumber());
        if (EmptyUtil.isEmpty((CoreBaseInfo)collection.get(0).getRemitAccountBank())) {
            bizInfo.setBillType(BillTypeEnum.PAYMENT_BILL);
        } else {
            bizInfo.setBillType(BillTypeEnum.AgentPay);
        }
        bizInfo.setCurrency(FmBeHelper.getCurrencyISO(ctx, collection.get(0).getCurrency()));
        bankPayUtil.setBatchPK(bankPayBillLog);
        return bankPayUtil.pay(ctx, bizInfo, body);
    }

    private BankPayResult[] paymentDetails2BankPayResult(Context ctx, PaymentDetail[] paymentDetails) throws EASBizException, BOSException {
        if (EmptyUtil.isEmpty((Object[])paymentDetails)) {
            return new BankPayResult[0];
        }
        int length = paymentDetails.length;
        BankPayResult[] bankPayResults = new BankPayResult[length];
        for (int i = 0; i < length; ++i) {
            PaymentDetail paymentDetail = paymentDetails[i];
            BankPayingBillStateEnum state = beServiceHelper.transferState(paymentDetail.getEbStatus());
            String returnMsg = paymentDetail.getBankStatusMsg();
            if (CheckUtils.isEmpty((Object)returnMsg)) {
                returnMsg = paymentDetail.getEbStatusMsg();
            }
            String detailSeqID = paymentDetail.getDetailSeqID();
            BankPayResult bankPayResult = new BankPayResult(null, detailSeqID, state, returnMsg);
            if (CheckUtils.isEmpty((Object)paymentDetail.getBankStatusMsg()) && CheckUtils.same((Object)((Object)state), (Object)((Object)BankPayingBillStateEnum.OF))) {
                bankPayResult.setErrorDetail(paymentDetail.getEbStatusMsg());
            }
            bankPayResult.setSubmitToBe(true);
            bankPayResults[i] = bankPayResult;
        }
        return bankPayResults;
    }

    private void batchAddBankPayResullt(List<BankPayResult> bankPayResults, BankPayingBillCollection bankPayingBills, BankPayingBillStateEnum state, String returnMsg, String errorDetail) {
        int size = bankPayingBills.size();
        for (int i = 0; i < size; ++i) {
            BankPayingBillInfo info = bankPayingBills.get(i);
            this.addBankPayResullt(bankPayResults, info, state, returnMsg, errorDetail, false);
        }
    }

    public BankPayResult[] doBatchPay(Context ctx, BankPayingBillCollection bankPayingBills, BankLogTypeEnum bankType) throws BOSException, BEException, EASBizException {
        IBankLog ibankLog;
        IBankLogFacade iBankLogFacade;
        ArrayList<String> ids = new ArrayList<String>();
        logger.info((Object)"********doBatchPay begin********");
        ConcurrentHashMap<String, IObjectPK> bankPayBillLog = new ConcurrentHashMap<String, IObjectPK>();
        try {
            iBankLogFacade = BankLogFacadeFactory.getLocalInstance(ctx);
            ibankLog = BankLogFactory.getLocalInstance(ctx);
            if (bankPayingBills.size() >= 1) {
                CoreBaseCollection bankPayingBillCollection = new CoreBaseCollection();
                String serialNumber = bankPayingBills.get(0).getSerialNumber();
                int length = bankPayingBills.size();
                for (int i = 0; i < length; ++i) {
                    BankPayingBillInfo bankPayingBillInfo = bankPayingBills.get(i);
                    IObjectPK logpk = this.buildLogMessage(ctx, bankPayingBillInfo, iBankLogFacade, ibankLog);
                    bankPayBillLog.put(bankPayingBillInfo.getSerialNumber(), logpk);
                    bankPayingBillInfo.setBatchSeqID(serialNumber);
                    bankPayingBillCollection.add((CoreBaseInfo)bankPayingBillInfo);
                    ids.add(bankPayingBillInfo.getId().toString());
                }
                BankPayingBillFactory.getLocalInstance(ctx).updateBatchData(bankPayingBillCollection);
            }
        }
        catch (Exception e) {
            logger.error((Object)"before doBatchPay\u5f02\u5e38\u3002", (Throwable)e);
            throw new BEException(BEException.COMMON, new Object[]{ErrCodeHelper.getResourceByErrCode("BE5001", e.getMessage())});
        }
        try {
            if (bankPayingBills.get(0).isIsCBPay()) {
                CBPaymentPayUtil payUtil = new CBPaymentPayUtil();
                OverseaPayDetail[] details = payUtil.batchBankPay(ctx, bankPayingBills, bankPayBillLog);
                BankPayResult[] bankPayResults = payUtil.overseaPayDetailsPayResult(ctx, details);
                return bankPayResults;
            }
            PaymentDetail[] paymentDetails = null;
            if (BankLogTypeEnum.linkPayment.equals((Object)bankType)) {
                LinkPayResponseBody responseBody = this.batchLinkPay(ctx, bankPayingBills, bankPayBillLog);
                paymentDetails = responseBody.getLinkPayDetails();
            } else {
                paymentDetails = this.batchBankPay(ctx, bankPayingBills, bankPayBillLog);
            }
            BankPayResult[] bankPayResults = this.paymentDetails2BankPayResult(ctx, paymentDetails);
            logger.info((Object)"********doBatchPay end********");
            return bankPayResults;
        }
        catch (BEException e) {
            logger.error((Object)"doBatchPay\u5f02\u5e38BEException\u3002", (Throwable)((Object)e));
            iBankLogFacade.buildExceptionBatch(bankPayBillLog, (Exception)((Object)e), 0);
            this.updateBankLogForExceptionBatch(bankPayBillLog, ibankLog);
            throw new BEException(BEException.COMMON, new Object[]{ErrCodeHelper.getResourceByErrCode("BE5004", e.getMessage())});
        }
        catch (ServiceException e) {
            logger.error((Object)"doBatchPay\u5f02\u5e38ServiceException\u3002", (Throwable)e);
            iBankLogFacade.buildExceptionBatch(bankPayBillLog, (Exception)((Object)e), 0);
            this.updateBankLogForExceptionBatch(bankPayBillLog, ibankLog);
            throw new BEException(BEException.COMMON, new Object[]{ErrCodeHelper.getResourceByErrCode("BE5002", e.getMessage())});
        }
        catch (Exception e) {
            logger.error((Object)"doBatchPay\u5f02\u5e38Exception\u3002", (Throwable)e);
            iBankLogFacade.buildExceptionBatch(bankPayBillLog, e, 0);
            this.updateBankLogForExceptionBatch(bankPayBillLog, ibankLog);
            if (e.getCause() instanceof ConnectException) {
                throw new BEException(BEException.COMMON, new Object[]{ErrCodeHelper.getResourceByErrCode("BE5003", e.getMessage())});
            }
            if (!EmptyUtil.isEmpty(ids)) {
                SynThread synThread = new SynThread(ctx, ids);
                synThread.start();
            }
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ErrCodeHelper.getResourceByErrCode("BE5005", e.getMessage())});
        }
    }

    private void doBatchMergePay(Context ctx, List<BankPayResult> bankPayResults, BankPayingBillCollection bankPayingBills, BankLogTypeEnum bankType, Map<String, BankPayingBillInfo> serialNumberMap) {
        try {
            for (BankPayResult bankPayResult : this.doBatchPay(ctx, bankPayingBills, bankType)) {
                String detailSeqID = bankPayResult.getNumber();
                if (!serialNumberMap.containsKey(detailSeqID)) continue;
                BankPayingBillInfo info = serialNumberMap.get(detailSeqID);
                this.addBankPayResullt(bankPayResults, info, bankPayResult.getState(), bankPayResult.getReturnMsg(), bankPayResult.getErrorDetail(), bankPayResult.isSubmitToBe());
            }
        }
        catch (BEException e) {
            this.batchAddBankPayResullt(bankPayResults, bankPayingBills, BankPayingBillStateEnum.OF, e.getMessage(), e.getMessage());
        }
        catch (Exception e) {
            this.batchAddBankPayResullt(bankPayResults, bankPayingBills, BankPayingBillStateEnum.NC, e.getMessage(), e.getMessage());
        }
    }

    private void doBatchPayByType(Context ctx, List<BankPayResult> bankPayResults, BankPayingBillCollection bankPayingBills, BankLogTypeEnum bankType) {
        HashMap<String, BankPayingBillInfo> serialNumberMap = new HashMap<String, BankPayingBillInfo>();
        int size = bankPayingBills.size();
        for (int i = 0; i < size; ++i) {
            BankPayingBillInfo info = bankPayingBills.get(i);
            serialNumberMap.put(info.getSerialNumber(), info);
        }
        this.doBatchMergePay(ctx, bankPayResults, bankPayingBills, bankType, serialNumberMap);
    }

    private Map<String, BankPayingBillCollection> getBankPayingBillsByPayAccount(Context ctx, IObjectCollection collection) {
        HashMap<String, BankPayingBillCollection> resultMap = new HashMap<String, BankPayingBillCollection>();
        BankPayingBillCollection bankPayingBills = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            String groupId;
            BankPayingBillInfo info = (BankPayingBillInfo)collection.getObject(i);
            String bankAccountId = info.getPayAccountBank().getId().toString();
            if (info.isIsLinkPay()) {
                bankAccountId = IS_LINKPAY + bankAccountId;
            }
            if (EmptyUtil.isEmpty((AbstractObjectCollection)(bankPayingBills = (BankPayingBillCollection)((Object)resultMap.get(groupId = bankAccountId + info.getCurrency().getId().toString() + (EmptyUtil.isEmpty((CoreBaseInfo)info.getRemitAccountBank()) ? "NOAGENT" : "AGENT")))))) {
                bankPayingBills = new BankPayingBillCollection();
                resultMap.put(groupId, bankPayingBills);
            }
            bankPayingBills.add(info);
        }
        return resultMap;
    }

    private List<BankPayingBillCollection> splitBankPayingBills(BankPayingBillCollection bankPayingBillColls, int maxBatchCount) {
        ArrayList<BankPayingBillCollection> bankPayingBillList = new ArrayList<BankPayingBillCollection>();
        int size = bankPayingBillColls.size();
        if (size > maxBatchCount) {
            BankPayingBillCollection bankPayingBills = new BankPayingBillCollection();
            for (int i = 0; i < size; ++i) {
                if (i > 0 && i % maxBatchCount == 0) {
                    bankPayingBills = new BankPayingBillCollection();
                    bankPayingBillList.add(bankPayingBills);
                }
                bankPayingBills.add(bankPayingBillColls.get(i));
            }
            if (bankPayingBills.size() > 0) {
                bankPayingBillList.add(bankPayingBills);
            }
        } else {
            bankPayingBillList.add(bankPayingBillColls);
        }
        return bankPayingBillList;
    }

    public List<BankPayResult> batchBankPay(Context ctx, BankPayingBillCollection collection) {
        ArrayList<BankPayResult> bankPayResults = new ArrayList<BankPayResult>();
        Map<String, BankPayingBillCollection> bankPayBillMap = this.getBankPayingBillsByPayAccount(ctx, (IObjectCollection)collection);
        for (String key : bankPayBillMap.keySet()) {
            BankLogTypeEnum bankType = key.startsWith(IS_LINKPAY) ? BankLogTypeEnum.linkPayment : BankLogTypeEnum.Pay;
            BankPayingBillCollection typebankPayColl = bankPayBillMap.get(key);
            this.doBatchPayByType(ctx, bankPayResults, typebankPayColl, bankType);
        }
        return bankPayResults;
    }

    public List<BankPayResult> batchBankPay(Context ctx, Set<String> bankPayBillIdSet) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty(bankPayBillIdSet)) {
            return new ArrayList<BankPayResult>();
        }
        logger.info((Object)"begin to submit bankPaymentBill");
        BankPayingBillCollection collection = this.getBankPayingBillCollection(ctx, bankPayBillIdSet);
        return this.batchBankPay(ctx, collection);
    }

    class SynThread
    extends Thread {
        private Context ctx;
        private List<String> ids;

        public SynThread(Context ctx, List<String> ids) {
            this.ctx = ctx;
            this.ids = ids;
        }

        @Override
        public void run() {
            block3: {
                if (EmptyUtil.isEmpty(this.ids)) {
                    return;
                }
                try {
                    BankFacadeFactory.getLocalInstance(this.ctx).syncStateByBillIds(this.ids);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.error((Object)e.getMessage());
                }
            }
        }
    }
}

