/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.bankpay;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BusinessTollUtil;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.ROMRowSet;
import com.kingdee.eas.fm.common.app.SQL;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankPayingBillSateUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.bankpay.BankPayingBillSateUtil");
    private static final String UPDATE_SETTLEMENT_BILL = "Update T_FS_SettlementBill set FIsCommittoBe={0},FSubmitTime={1},FBankPayState={2},FBankReturnInfo=''{3}'',FBatchNo=''{4}'' , FReqSeqNo = ''{5}'', FIsRefund={6} Where FId=''{7}'';\n";
    private static final String UPDATE_PAYMENT_BILL = "Update T_CAS_PaymentBill set FIsCommittoBe={0},FCommitBeTime={1},FBankPayState={2},FBankReturnInfo=''{3}'',FBatchNo=''{4}'' , FBankCheckFlag = ''{5}'', FIsRefund={6}  Where FId=''{7}'';\n";
    private static final String UPDATE_PAYMENT_BILL_PAYSTATE = "Update T_CAS_PaymentBill set FBankPayState={0} where FId=''{1}'';\n";
    private static final String SELECT_SETTLEMENT_BILL_SOURCEID = "Select FSourceBillID,FSettBatchID From T_FS_SettlementBill Where FId=?";
    private static final String UPDATE_JOURNAL_FBATCHNO = "Update T_CAS_Journal set FBatchNo=''{0}'',  FBankCheckFlag = ''{1}''  Where FBillId = ''{2}'';\n";
    private static final String UPDATE_PAYMENT_BILL_BANKCHECKFLAG = "Update T_CAS_PaymentBill set FBankCheckFlag=''{0}'' Where FId=''{1}'';\n";
    private static final String UPDATE_JOURNAL_BANKCHECKFLAG = "Update T_CAS_Journal set FBankCheckFlag=''{0}'' Where FBillId = ''{1}'';\n";
    private static final String UPDATE_SETTLEMENT_BILL_REQSEQNO = "Update T_FS_SettlementBill set FReqSeqNo=''{0}'' Where FId=''{1}'';\n";
    private static final String UPDATE_BANK_PAY_BILL_FSTATE = "Update T_BE_BankPayingBill set FState={0},FHandlerID=''{1}'',FSubmitTime={2},FBankReturnInfo=''{3}'',FBatchNo=''{4}'' Where FId = ''{5}''";
    private static final String UPDATE_BANK_PAYING_BILL_FSTATE = "Update T_BE_BankPayingBill set FState={0},FHandlerID=''{1}'',FSubmitTime={2},FBankReturnInfo=''{3}'',FBatchNo=''{4}'', FBankCheckFlag=''{5}'', FIsRefund={6} Where FId = ''{7}''";
    private static final String DELETE_BANK_PAYING_BILL = "Delete From T_BE_bankPayingBill Where FId=?";
    private final String UPDATE_BANK_PAYING_BILL_STATE = "UPDATE T_BE_BankPayingBill Set FState = %d WHERE FID = '%s';\n";
    private static final String UPDATE_PAYMENTBILL_FSTATE = "Update T_CAS_PaymentBill set FBankPayState = %d Where FId = '%s';\n";
    private static final String UPDATE_SETTLEMENTBILL_FSTATE = "Update T_FS_SettlementBill set FBankPayState = %d Where FId = '%s';\n";

    private String cnulls(String str) {
        return StringUtils.cnulls((String)str);
    }

    private String formatDateTime(Context ctx, Date date) {
        return BOSLocaleUtil.getDateTimeFormat((Locale)LocaleUtils.locale_l2).format(date);
    }

    private void updateSettlementBill(Context ctx, String id, int state, String returnMsg, String time, String batchNo, String bankDetailSeqId, boolean isRefund, boolean isBeException) throws BOSException {
        SQL sql = new SQL(ctx);
        String reFund = isRefund ? "1" : "0";
        String msg = "";
        if (!EmptyUtil.isEmpty((String)returnMsg)) {
            msg = returnMsg.replace("'", "\u2018");
        }
        if (isBeException) {
            sql.add(UPDATE_SETTLEMENT_BILL, new Object[]{"0", "null", state, this.cnulls(msg), this.cnulls(batchNo), this.cnulls(bankDetailSeqId), "0", id});
        } else {
            sql.add(UPDATE_SETTLEMENT_BILL, new Object[]{"1", time, state, this.cnulls(msg), this.cnulls(batchNo), this.cnulls(bankDetailSeqId), reFund, id});
        }
        sql.execute().clear();
        String sourceBillId = null;
        String settBatchId = null;
        ROMRowSet rowSet = sql.add(SELECT_SETTLEMENT_BILL_SOURCEID, new Object[]{id}).query();
        if (rowSet.next()) {
            sourceBillId = rowSet.getString("FSourceBillID");
            settBatchId = rowSet.getString("FSettBatchID");
        }
        sql.clear();
        if (sourceBillId != null && BOSUuid.read((String)sourceBillId).getType().equals((Object)new PaymentBillInfo().getBOSType())) {
            if (isBeException) {
                sql.add(UPDATE_PAYMENT_BILL, new Object[]{"0", "null", state, this.cnulls(msg), this.cnulls(batchNo), this.cnulls(bankDetailSeqId), "0", sourceBillId});
            } else {
                sql.add(UPDATE_PAYMENT_BILL, new Object[]{"1", time, state, this.cnulls(msg), this.cnulls(batchNo), this.cnulls(bankDetailSeqId), reFund, sourceBillId});
            }
        }
        sql.add(UPDATE_JOURNAL_FBATCHNO, new Object[]{this.cnulls(batchNo), this.cnulls(bankDetailSeqId), id});
        sql.execute();
    }

    public void updateSettlementBillInfo(Context ctx, String id, int state, String returnMsg, Timestamp time, String batchNo, boolean isBeException) throws BOSException, EASBizException {
        String subtmitTimeStr = null;
        if (time != null) {
            subtmitTimeStr = "{ts'" + this.formatDateTime(ctx, time) + "'}";
        }
        this.updateSettlementBill(ctx, id, state, returnMsg, subtmitTimeStr, batchNo, "", false, isBeException);
    }

    private void updatePaymentBill(Context ctx, String id, int state, String returnMsg, String time, String batchNo, String bankDetailSeqId, boolean isRefund, boolean isBeException) throws BOSException {
        String isRefund2Sql;
        SQL sql = new SQL(ctx);
        String msg = "";
        if (!EmptyUtil.isEmpty((String)returnMsg)) {
            msg = returnMsg.replace("'", "\u2018");
        }
        String string = isRefund2Sql = isRefund ? "1" : "0";
        if (isBeException) {
            sql.add(UPDATE_PAYMENT_BILL, new Object[]{"0", "null", state, this.cnulls(msg), this.cnulls(batchNo), this.cnulls(bankDetailSeqId), "0", id});
        } else {
            sql.add(UPDATE_PAYMENT_BILL, new Object[]{"1", time, state, this.cnulls(msg), this.cnulls(batchNo), this.cnulls(bankDetailSeqId), isRefund2Sql, id});
        }
        sql.add(UPDATE_JOURNAL_FBATCHNO, new Object[]{this.cnulls(batchNo), this.cnulls(bankDetailSeqId), id});
        sql.execute();
    }

    public void updatePaymentBillInfo(Context ctx, String id, int state, String returnMsg, String batchNo, boolean isRefund, boolean isBeException) throws BOSException {
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        String subtmitTimeStr = null;
        if (currTime != null) {
            subtmitTimeStr = "{ts'" + this.formatDateTime(ctx, currTime) + "'}";
        }
        this.updatePaymentBill(ctx, id, state, returnMsg, subtmitTimeStr, batchNo, "", isRefund, isBeException);
    }

    private void updateLinkPaymentBill(Context ctx, String id, int state, String returnMsg, Timestamp time, String batchNo, String transDownCheckFlag, String payCheckFlag, boolean isRefund, boolean isBeException) throws BOSException {
        BOSUuid bisid;
        BOSObjectType idType;
        String isRefund2Sql;
        SQL sql = new SQL(ctx);
        String subtmitTimeStr = null;
        if (time != null) {
            subtmitTimeStr = "{ts'" + this.formatDateTime(ctx, time) + "'}";
        }
        String string = isRefund2Sql = isRefund ? "1" : "0";
        if (isBeException) {
            sql.add(UPDATE_SETTLEMENT_BILL, new Object[]{"0", "null", state, returnMsg, this.cnulls(batchNo), this.cnulls(transDownCheckFlag), "0", id});
        } else {
            sql.add(UPDATE_SETTLEMENT_BILL, new Object[]{"1", subtmitTimeStr, state, returnMsg, this.cnulls(batchNo), this.cnulls(transDownCheckFlag), isRefund2Sql, id});
        }
        sql.execute().clear();
        String sourceBillId = null;
        String settBatchId = null;
        ROMRowSet rowSet = sql.add(SELECT_SETTLEMENT_BILL_SOURCEID, new Object[]{id}).query();
        if (rowSet.next()) {
            sourceBillId = rowSet.getString("FSourceBillID");
            settBatchId = rowSet.getString("FSettBatchID");
        }
        sql.clear();
        if (sourceBillId != null && (idType = (bisid = BOSUuid.read((String)sourceBillId)).getType()).equals((Object)new PaymentBillInfo().getBOSType())) {
            if (isBeException) {
                sql.add(UPDATE_PAYMENT_BILL, new Object[]{"0", "null", state, returnMsg, this.cnulls(batchNo), this.cnulls(payCheckFlag), "0", sourceBillId});
            } else {
                sql.add(UPDATE_PAYMENT_BILL, new Object[]{"1", subtmitTimeStr, state, returnMsg, this.cnulls(batchNo), this.cnulls(payCheckFlag), isRefund2Sql, sourceBillId});
            }
            sql.add(UPDATE_JOURNAL_FBATCHNO, new Object[]{this.cnulls(batchNo), this.cnulls(payCheckFlag), sourceBillId});
        }
        sql.add(UPDATE_JOURNAL_FBATCHNO, new Object[]{this.cnulls(batchNo), this.cnulls(transDownCheckFlag), id});
        sql.execute();
    }

    private void updateLinkPaymentSourceBill(Context ctx, String id, int state, String returnMsg, Timestamp time, String batchNo, String transDownCheckFlag, String payCheckFlag, boolean isRefund, boolean isBeException) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)id)) {
            return;
        }
        this.updateLinkPaymentBill(ctx, id, state, returnMsg, time, batchNo, transDownCheckFlag, payCheckFlag, isRefund, isBeException);
    }

    private void updateSourceBill(Context ctx, String id, int state, String returnMsg, Timestamp time, String batchNo, String bankDetailSeqId, boolean isRefund, boolean isBeException) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)id)) {
            return;
        }
        String subtmitTimeStr = null;
        if (time != null) {
            subtmitTimeStr = "{ts'" + this.formatDateTime(ctx, time) + "'}";
        }
        BOSObjectType bosType = BOSUuid.read((String)id).getType();
        String msg = "";
        if (!EmptyUtil.isEmpty((String)returnMsg)) {
            msg = returnMsg.replace("'", "\u2018");
        }
        if (bosType.equals((Object)new PaymentBillInfo().getBOSType())) {
            this.updatePaymentBill(ctx, id, state, msg, subtmitTimeStr, batchNo, bankDetailSeqId, isRefund, isBeException);
        } else if (bosType.equals((Object)new SettlementBillInfo().getBOSType())) {
            this.updateSettlementBill(ctx, id, state, msg, subtmitTimeStr, batchNo, bankDetailSeqId, isRefund, isBeException);
        }
    }

    public void updateLinkSourceBillState(Context ctx, String id, int state, String returnMsg, Timestamp time, String batchNo, String transDownCheckFlag, String payCheckFlag, boolean isRefund, boolean isBeException) throws BOSException, EASBizException {
        this.updateLinkPaymentSourceBill(ctx, id, state, returnMsg, time, batchNo, transDownCheckFlag, payCheckFlag, isRefund, isBeException);
    }

    public void updateSourceBillState(Context ctx, String id, int state, String returnMsg, Timestamp time, String batchNo, String bankDetailSeqId, boolean isRefund, boolean isBeException) throws BOSException, EASBizException {
        this.updateSourceBill(ctx, id, state, returnMsg, time, batchNo, bankDetailSeqId, isRefund, isBeException);
    }

    private void updateBankPayingBill(Context ctx, BankPayingBillInfo info, int state, UserInfo handler, Timestamp subtmitTime, String bankReturnInfo, String batchNo) throws BOSException, EASBizException {
        String subtmitTimeStr = null;
        if (subtmitTime != null) {
            subtmitTimeStr = " {ts '" + this.formatDateTime(ctx, subtmitTime) + "'}";
        }
        String msg = "";
        if (!EmptyUtil.isEmpty((String)bankReturnInfo)) {
            msg = bankReturnInfo.replace("'", "\u2018");
        }
        SQL sql = new SQL(ctx, UPDATE_BANK_PAY_BILL_FSTATE, new Object[]{state, this.cnulls(ConvertUtils.IDSTR((Object)handler)), subtmitTimeStr, this.cnulls(msg), this.cnulls(batchNo), ConvertUtils.IDSTR((Object)info)});
        sql.execute();
    }

    private void updateBankPayingBill(Context ctx, BankPayingBillInfo info, int state, UserInfo handler, Timestamp subtmitTime, String bankReturnInfo, String batchNo, String bankDetailSeqId, boolean isRefund) throws BOSException, EASBizException {
        String subtmitTimeStr = null;
        if (subtmitTime != null) {
            subtmitTimeStr = " {ts '" + this.formatDateTime(ctx, subtmitTime) + "'}";
        }
        String msg = "";
        if (!EmptyUtil.isEmpty((String)bankReturnInfo)) {
            msg = bankReturnInfo.replace("'", "\u2018");
        }
        String reFund = isRefund ? "1" : "0";
        SQL sql = new SQL(ctx, UPDATE_BANK_PAYING_BILL_FSTATE, new Object[]{state, this.cnulls(ConvertUtils.IDSTR((Object)handler)), subtmitTimeStr, this.cnulls(msg), this.cnulls(batchNo), this.cnulls(bankDetailSeqId), reFund, ConvertUtils.IDSTR((Object)info)});
        sql.execute();
    }

    public void updateBankPayingBillInfo(Context ctx, BankPayingBillInfo info, int state, UserInfo handler, Timestamp subtmitTime, String bankReturnInfo, String batchNo) throws BOSException, EASBizException {
        if (info.isIsBitBack()) {
            return;
        }
        this.updateBankPayingBill(ctx, info, state, handler, subtmitTime, bankReturnInfo, batchNo);
    }

    public void updateBankPayingBillInfo(Context ctx, BankPayingBillInfo info, int state, UserInfo handler, Timestamp subtmitTime, String bankReturnInfo, String batchNo, String bankDetailSeqId, boolean isRefund) throws BOSException, EASBizException {
        if (info.isIsBitBack()) {
            return;
        }
        this.updateBankPayingBill(ctx, info, state, handler, subtmitTime, bankReturnInfo, batchNo, bankDetailSeqId, isRefund);
    }

    public void updateBankPayingBillInfo(Context ctx, BankPayingBillInfo info, UserInfo handler, Timestamp subtmitTime, int state, String bankReturnInfo, String batchNo) throws BOSException, EASBizException {
        this.updateBankPayingBill(ctx, info, state, handler, subtmitTime, bankReturnInfo, batchNo);
    }

    public void reserveForBeException(Context ctx, BankPayingBillInfo info) throws BOSException, EASBizException {
        this.updateBankPayingBillInfo(ctx, info, 1, null, null, null, null);
        if (!EmptyUtil.isEmpty((String)info.getSourceBillId())) {
            this.updateSourceBillState(ctx, info.getSourceBillId(), 0, "", null, null, null, false, true);
        }
    }

    public void reserveForBeException(Context ctx, BankPayingBillCollection collection) throws BOSException, EASBizException {
        int state = 1;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            BankPayingBillInfo info = collection.get(i);
            String id = info.getId().toString();
            this.updateBankPayingBill(ctx, info, state, null, null, null, null);
            if (EmptyUtil.isEmpty((String)info.getSourceBillId())) continue;
            this.updateSourceBill(ctx, info.getSourceBillId(), state, null, null, null, null, false, true);
        }
    }

    public void reserveForOtherException(Context ctx, BankPayingBillInfo info, String returnMsg) throws BOSException, EASBizException {
        int state = 4;
        Timestamp subtmitTime = info.getSubmitTime();
        this.updateBankPayingBillInfo(ctx, info, state, info.getHandler(), info.getSubmitTime(), FmBeHelper.cutString(returnMsg), null);
        if (!EmptyUtil.isEmpty((String)info.getSourceBillId())) {
            this.updateSourceBillState(ctx, info.getSourceBillId(), state, FmBeHelper.cutString(returnMsg), subtmitTime, null, null, false, false);
        }
    }

    public void reserveForOtherException(Context ctx, BankPayingBillCollection collection, String returnMsg) throws BOSException, EASBizException {
        int state = 4;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            BankPayingBillInfo info = collection.get(i);
            String id = info.getId().toString();
            this.updateBankPayingBill(ctx, info, state, info.getHandler(), info.getSubmitTime(), FmBeHelper.cutString(returnMsg), null);
            if (EmptyUtil.isEmpty((String)info.getSourceBillId())) continue;
            this.updateSourceBill(ctx, info.getSourceBillId(), state, FmBeHelper.cutString(returnMsg), null, null, null, false, false);
        }
    }

    public void deleteBankPayingBill(Context ctx, BankPayingBillInfo info) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)DELETE_BANK_PAYING_BILL, (Object[])new Object[]{info.getId().toString()});
        if (!EmptyUtil.isEmpty((String)info.getSourceBillId())) {
            BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationBySrcObjId(info.getSourceBillId(), info.getId().getType().toString());
        }
    }

    public Map batchUpdateBankPayState(Context ctx, IObjectPK[] pks, BankPayingBillStateEnum state) throws EASBizException, BOSException {
        Map resultMap = ConvertUtils.JSMAP((Object[])new Object[0]);
        BankPayingBillCollection infos = this.getBankPayColl(ctx, pks);
        BankPayingBillCollection need2Update2EBSInfos = new BankPayingBillCollection();
        for (int i = 0; i < infos.size(); ++i) {
            BankPayingBillInfo info = infos.get(i);
            BankPayResult oneRet = new BankPayResult();
            oneRet.setId(ConvertUtils.IDSTR((Object)info));
            oneRet.setNumber(info.getNumber());
            oneRet.setState(info.getState());
            oneRet.setSubmitToBe(false);
            if (info.getState() == BankPayingBillStateEnum.NC) {
                need2Update2EBSInfos.add(info);
            } else {
                oneRet.setErrorDetail(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"193_STATE_UNCONFIRMED", (Locale)ctx.getLocale()));
            }
            resultMap.put(ConvertUtils.IDSTR((Object)info), oneRet);
        }
        BusinessTollUtil util = new BusinessTollUtil();
        Map out = util.UpdatePayState2EBS(ctx, need2Update2EBSInfos, state);
        for (int i = 0; i < need2Update2EBSInfos.size(); ++i) {
            BankPayingBillInfo info = need2Update2EBSInfos.get(i);
            String srcBillId = info.getSourceBillId();
            Map entry = (Map)out.get(ConvertUtils.IDSTR((Object)info));
            BankPayResult ontRet = (BankPayResult)resultMap.get(ConvertUtils.IDSTR((Object)info));
            ontRet.setSubmitToBe(ConvertUtils.BOOL(entry.get("submit2EBS")));
            ontRet.setErrorDetail(ConvertUtils.STR(entry.get("errorMsg")));
            if (!CheckUtils.same((Object)"SUCCESS", entry.get("result"))) continue;
            SQL sql = new SQL(ctx);
            sql.add("UPDATE T_BE_BankPayingBill Set FState = %d WHERE FID = '%s';\n", new Object[]{state.getValue(), ConvertUtils.IDSTR((Object)info)});
            try {
                if (!CheckUtils.exist((Object)srcBillId)) continue;
                if (CheckUtils.same((Object)ConvertUtils.BOSTYPE((Object)srcBillId), (Object)ConvertUtils.BOSTYPE(PaymentBillInfo.class))) {
                    sql.add(UPDATE_PAYMENTBILL_FSTATE, new Object[]{state.getValue(), srcBillId});
                    sql.execute();
                    continue;
                }
                if (!CheckUtils.same((Object)ConvertUtils.BOSTYPE((Object)srcBillId), (Object)ConvertUtils.BOSTYPE(SettlementBillInfo.class))) continue;
                sql.add(UPDATE_SETTLEMENTBILL_FSTATE, new Object[]{state.getValue(), srcBillId});
                sql.execute().clear();
                String sourceBillId = "";
                ROMRowSet rowSet = sql.add(SELECT_SETTLEMENT_BILL_SOURCEID, new Object[]{srcBillId}).query();
                if (rowSet.next()) {
                    sourceBillId = rowSet.getString("FSourceBillID");
                }
                if (!CheckUtils.same((Object)ConvertUtils.BOSTYPE((Object)sourceBillId), (Object)ConvertUtils.BOSTYPE(PaymentBillInfo.class))) continue;
                sql.add(UPDATE_PAYMENT_BILL_PAYSTATE, new Object[]{state.getValue(), sourceBillId});
                sql.execute();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                ontRet.setErrorDetail(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"194_SYNRESOURCE_ERROR", (Locale)ctx.getLocale()));
            }
        }
        return ConvertUtils.JSMAP((Object[])new Object[]{"resultList", ConvertUtils.LIST((Object)resultMap)});
    }

    private BankPayingBillCollection getBankPayColl(Context ctx, IObjectPK[] pks) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(Arrays.asList((Object[])pks)), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("sourceBillId"));
        selector.add(new SelectorItemInfo("isLinkPay"));
        selector.add(new SelectorItemInfo("isPersonPay"));
        selector.add(new SelectorItemInfo("serialNumber"));
        selector.add(new SelectorItemInfo("batchSeqID"));
        selector.add(new SelectorItemInfo("batchNo"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("payAccountBank.name"));
        selector.add(new SelectorItemInfo("recAccountBank"));
        selector.add(new SelectorItemInfo("company.*"));
        view.setSelector(selector);
        return BankPayingBillFactory.getLocalInstance(ctx).getBankPayingBillCollection(view);
    }
}

