/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.elstatement.service;

import com.enterprisedt.util.debug.Logger;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.ElStatementBillCollection;
import com.kingdee.eas.fm.be.ElStatementBillInfo;
import com.kingdee.eas.fm.be.app.elstatement.service.ElStatementBatchService;
import com.kingdee.eas.fm.be.app.util.ElStatementJDBC;
import com.kingdee.eas.fm.be.vo.EReceiptVO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DBElStatementBatchService
extends ElStatementBatchService {
    private static Logger logger = Logger.getLogger((String)DBElStatementBatchService.class.getName());

    @Override
    public Map<String, byte[]> getFileValueMapByElStateIds(Context ctx, List elStateIdList) throws BOSException, EASBizException {
        Map<String, byte[]> pdfMap;
        ElStatementJDBC elStatementJDBCTool = new ElStatementJDBC();
        logger.error("\u7535\u5b50\u5bf9\u8d26\u5355\u6570\u636e 1\u4e3a\u6570\u636e\u5b58\u653e\u5728PDF\u6570\u636e\u5e93\u4e2d  ");
        try {
            pdfMap = elStatementJDBCTool.getBatchEReceiptPDFValues(elStateIdList, CompareType.INCLUDE, this.eReceiptStorageSettingInfo);
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u5bf9\u8d26\u5355\u53d6\u6570\u636e 0\u4e3a\u6570\u636e\u5b58\u653e\u5728PDFl\u6570\u636e\u5e93\u4e2d  \u8fd4\u56de\u7ed3\u679c \u53d1\u751f\u5f02\u5e38 \u5f02\u5e38\u4fe1\u606f\u4e3a\uff1ae  " + e.getMessage());
            throw new BOSException((Throwable)e);
        }
        logger.error("\u7535\u5b50\u5bf9\u8d26\u5355\u53d6\u6570\u636e 0\u4e3a\u6570\u636e\u5b58\u653e\u5728PDFl\u6570\u636e\u5e93\u4e2d  \u8fd4\u56de\u7ed3\u679c \u5b8c\u6210  ");
        return pdfMap;
    }

    @Override
    protected Map<String, byte[]> getBatchStoreFileMap(Context ctx, List list) throws BOSException, EASBizException {
        return this.getFileValueMapByElStateIds(ctx, list);
    }

    @Override
    protected CoreBaseCollection upLoadFiles(Context ctx, ElStatementBillCollection coll) throws BOSException, EASBizException {
        List<EReceiptVO> voList = this.parseEReceiptVO(ctx, coll);
        CoreBaseCollection savedColl = new CoreBaseCollection();
        ElStatementJDBC elStateJDBCTool = new ElStatementJDBC();
        try {
            logger.error("\u6279\u91cf\u4fdd\u5b58PDF\u5230 \u6570\u636e\u5e93  start");
            elStateJDBCTool.batchInsert(voList, this.eReceiptStorageSettingInfo);
            logger.error("\u6279\u91cf\u4fdd\u5b58PDF\u5230 \u6570\u636e\u5e93  OK");
        }
        catch (Exception e) {
            String exMsg = "\u4fdd\u5b58PDF\u5230\u7535\u5b50\u5bf9\u8d26\u5355\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4PDF\u5e93\u8fde\u63a5\u662f\u5426\u6b63\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage();
            logger.error(exMsg);
            e.printStackTrace();
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"551_DBElStatementBatchService", (Locale)ctx.getLocale()));
        }
        for (int i = 0; i < coll.size(); ++i) {
            savedColl.add((CoreBaseInfo)coll.get(i));
        }
        return savedColl;
    }

    public List<EReceiptVO> parseEReceiptVO(Context ctx, ElStatementBillCollection coll) throws BOSException, EASBizException {
        ArrayList<EReceiptVO> voList = new ArrayList<EReceiptVO>();
        for (int i = 0; i < coll.size(); ++i) {
            ElStatementBillInfo info = coll.get(i);
            info.setFileSource("1");
            EReceiptVO eReceiptVO = new EReceiptVO();
            eReceiptVO.setFID(info.getId().toString());
            eReceiptVO.setEASID(info.getId().toString());
            eReceiptVO.setFILENAME(info.getFileName());
            eReceiptVO.setDETAILNO("");
            eReceiptVO.setBANKNUMBER(info.getBankAccount().getBankAccountNumber());
            eReceiptVO.setTRANSDATE(info.getTransDate());
            ByteArrayInputStream input = new ByteArrayInputStream(info.getFileValue());
            eReceiptVO.setFILEVALUE(input);
            voList.add(eReceiptVO);
        }
        return voList;
    }
}

