/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.elstatement.service;

import com.enterprisedt.util.debug.Logger;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.ElStatementBillCollection;
import com.kingdee.eas.fm.be.ElStatementBillFactory;
import com.kingdee.eas.fm.be.ElStatementBillInfo;
import com.kingdee.eas.fm.be.app.elstatement.service.ElStatementBatchService;
import com.kingdee.eas.fm.be.app.util.ElStatementCloundDriveUtils;
import com.kingdee.eas.fm.be.app.util.KingDeeCloundDriveApiUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DriveElStatementBatchService
extends ElStatementBatchService {
    private static Logger logger = Logger.getLogger((String)DriveElStatementBatchService.class.getName());

    @Override
    public Map<String, byte[]> getFileValueMapByElStateIds(Context ctx, List elStateIdList) throws BOSException, EASBizException {
        byte[] fileValue = null;
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        ElStatementBillCollection elCol = this.getElStatementCol(ctx, elStateIdList);
        try {
            for (int i = 0; i < elCol.size(); ++i) {
                ElStatementBillInfo info = elCol.get(i);
                logger.error("\u7535\u5b50\u5bf9\u8d26\u5355\u6570\u636e " + info.getFileId() + "\u4e3a\u6570\u636e\u5b58\u653e\u5728\u91d1\u8776\u4e91\u76d8 ");
                fileValue = KingDeeCloundDriveApiUtils.getFileValue(info.getFileId(), this.storageSetting.getOrgAccessToken(), this.eReceiptStorageSettingInfo.getDriveUserId());
                pdfMap.put(info.getId().toString(), fileValue);
                logger.error(info.getFileId() + "\u4e91\u76d8\u8fd4\u56de\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u6d41  \u5b8c\u6210 ,\u83b7\u53d6\u5230\u3010\u6587\u4ef6\u3011\u5927\u5c0f\u4e3a\uff1a " + fileValue.length);
            }
            return pdfMap;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private ElStatementBillCollection getElStatementCol(Context ctx, List idList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fileId"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        return ElStatementBillFactory.getLocalInstance(ctx).getElStatementBillCollection(view);
    }

    @Override
    protected Map<String, byte[]> getBatchStoreFileMap(Context ctx, List list) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected CoreBaseCollection upLoadFiles(Context ctx, ElStatementBillCollection coll) throws BOSException, EASBizException {
        CoreBaseCollection savedColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            ElStatementBillInfo info = coll.get(i);
            try {
                String fileId = ElStatementCloundDriveUtils.uploadFileToDrive(ctx, info, this.storageSetting.getOrgAccessToken(), this.storageSetting.getStorageSettingInfo().getDriveUserId(), this.storageSetting.getFolderIdMap());
                logger.error("\u4e0a\u4f20PDF \u5230\u91d1\u8776\u4e91\u76d8  ok,\u6587\u4ef6id\u4e3a\uff1a" + fileId);
                if (fileId == null) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"558_DriveElStatementBatchService", (Locale)ctx.getLocale()));
                }
                logger.error("\u66f4\u65b0\u4e91\u76d8\u6587\u4ef6Id\u5230\u6570\u636e\u5e93  start");
                info.setFileId(fileId);
                info.setFileSource("2");
                savedColl.add((CoreBaseInfo)info);
                logger.error("\u66f4\u65b0\u4e91\u76d8\u6587\u4ef6Id\u5230\u6570\u636e\u5e93  ok");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return savedColl;
    }
}

