/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.elstatement.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.ElStatementBillCollection;
import com.kingdee.eas.fm.be.ElStatementBillFactory;
import com.kingdee.eas.fm.be.ElStatementBillInfo;
import com.kingdee.eas.fm.be.StorageSettingInstance;
import com.kingdee.eas.fm.be.app.elstatement.service.IElStatementBatchService;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.util.ofd.OfdUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ElStatementBatchService
implements IElStatementBatchService {
    private static Logger logger = Logger.getLogger((String)ElStatementBatchService.class.getName());
    protected Context ctx;
    protected EReceiptStorageSettingInfo eReceiptStorageSettingInfo;
    protected StorageSettingInstance storageSetting;

    @Override
    public void initService(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)"---------\u5f00\u59cb\u3010\u521d\u59cb\u5316\u3011\u57fa\u7840\u7535\u5b50\u5bf9\u8d26\u5b58\u50a8\u8bbe\u7f6e\u6570\u636e--------------");
        this.ctx = ctx;
        try {
            StorageSettingInstance.init(ctx);
            this.storageSetting = StorageSettingInstance.getInstance(ctx);
            logger.error((Object)"-----------\u521d\u59cb\u5316\u57fa\u7840\u7535\u5b50\u5bf9\u8d26\u5355\u5b58\u50a8\u8bbe\u7f6e\u6570\u636e------------");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        this.eReceiptStorageSettingInfo = this.storageSetting.getStorageSettingInfo();
        if (this.eReceiptStorageSettingInfo == null) {
            throw new BOSException("\u8bf7\u7ef4\u62a4 \u7535\u5b50\u5bf9\u8d26\u5355 \u5b58\u50a8\u8bbe\u7f6e\u6570\u636e\uff01");
        }
    }

    @Override
    public List<byte[]> getFileValueByElStateIds(Context ctx, List elStateIdList) throws BOSException, EASBizException {
        return null;
    }

    private ElStatementBillCollection getElStatementBillColl(Context ctx, List idList) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("fileId"));
        sic.add(new SelectorItemInfo("fileSource"));
        sic.add(new SelectorItemInfo("fileValue"));
        sic.add(new SelectorItemInfo("fileName"));
        sic.add(new SelectorItemInfo("transDate"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("explanation"));
        sic.add(new SelectorItemInfo("bizType"));
        sic.add(new SelectorItemInfo("billNumber"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        logger.error((Object)("\u7535\u5b50\u5bf9\u8d26\u5355\u6253\u5370\u6216\u67e5\u770bSQL \uff1a " + view.toString()));
        return ElStatementBillFactory.getLocalInstance(ctx).getElStatementBillCollection(view);
    }

    @Override
    public Map<String, byte[]> getFileValueMapByElStateIds(Context ctx, List elStateIdList, boolean isConvertToPDF) throws BOSException, EASBizException {
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        ElStatementBillCollection coll = this.getElStatementBillColl(ctx, elStateIdList);
        ArrayList<String> storeList = new ArrayList<String>();
        ArrayList<String> noDownList = new ArrayList<String>();
        HashMap<String, String> ofdMap = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            String fileType;
            String[] strSplit;
            String fileName;
            ElStatementBillInfo info = coll.get(i);
            if (info.getFileSource().equals("1") || info.getFileSource().equals("2")) {
                storeList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (!fileType.equals("ofd")) continue;
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (info.getFileSource().equals("0")) {
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("ofd") && isConvertToPDF) {
                    pdfMap.put(info.getId().toString(), OfdUtil.convertToPdfNew((byte[])info.getFileValue()));
                    continue;
                }
                pdfMap.put(info.getId().toString(), info.getFileValue());
                continue;
            }
            if (!info.getFileSource().equals("3")) continue;
            noDownList.add(info.getId().toString());
        }
        if (storeList != null && storeList.size() > 0) {
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStoreFileMap(ctx, storeList);
            for (String id : storePdfMap.keySet()) {
                byte[] str = storePdfMap.get(id);
                if (ofdMap.containsKey(id) && isConvertToPDF) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfMap.put(id, str);
            }
        }
        return pdfMap;
    }

    @Override
    public Map<String, byte[]> getFileValueMapByElStateIds(Context ctx, List elStateIdList) throws BOSException, EASBizException {
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        ElStatementBillCollection coll = this.getElStatementBillColl(ctx, elStateIdList);
        ArrayList<String> storeList = new ArrayList<String>();
        ArrayList<String> noDownList = new ArrayList<String>();
        HashMap<String, String> ofdMap = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            String fileType;
            String[] strSplit;
            String fileName;
            ElStatementBillInfo info = coll.get(i);
            if (info.getFileSource().equals("1") || info.getFileSource().equals("2")) {
                storeList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (!fileType.equals("ofd")) continue;
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (info.getFileSource().equals("0")) {
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("ofd")) {
                    pdfMap.put(info.getId().toString(), info.getFileValue());
                    continue;
                }
                pdfMap.put(info.getId().toString(), info.getFileValue());
                continue;
            }
            if (!info.getFileSource().equals("3")) continue;
            noDownList.add(info.getId().toString());
        }
        if (storeList != null && storeList.size() > 0) {
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStoreFileMap(ctx, storeList);
            for (String id : storePdfMap.keySet()) {
                byte[] str = storePdfMap.get(id);
                if (ofdMap.containsKey(id)) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfMap.put(id, str);
            }
        }
        return pdfMap;
    }

    private ElStatementBillCollection getElStatementBillColl(Context ctx, List idList, Map sortIems) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("fileId"));
        sic.add(new SelectorItemInfo("fileSource"));
        sic.add(new SelectorItemInfo("fileValue"));
        sic.add(new SelectorItemInfo("fileName"));
        sic.add(new SelectorItemInfo("transDate"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("explanation"));
        sic.add(new SelectorItemInfo("bizType"));
        sic.add(new SelectorItemInfo("billNumber"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        logger.error((Object)("\u7535\u5b50\u5bf9\u8d26\u5355\u6253\u5370\u6216\u67e5\u770bSQL \uff1a " + view.toString()));
        return ElStatementBillFactory.getLocalInstance(ctx).getElStatementBillCollection(view);
    }

    @Override
    public List<byte[]> getFileValueMapByElStateIds(Context ctx, List elStateIdList, Map sortIems) throws BOSException, EASBizException {
        ArrayList<byte[]> pdfList = new ArrayList<byte[]>();
        ElStatementBillCollection coll = this.getElStatementBillColl(ctx, elStateIdList, sortIems);
        ArrayList<String> storeList = new ArrayList<String>();
        ArrayList<String> noDownList = new ArrayList<String>();
        HashMap<String, String> ofdMap = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            String fileType;
            String[] strSplit;
            String fileName;
            ElStatementBillInfo info = coll.get(i);
            if (info.getFileSource().equals("1") || info.getFileSource().equals("2")) {
                storeList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (!fileType.equals("ofd")) continue;
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (info.getFileSource().equals("0")) {
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("ofd")) {
                    pdfList.add(info.getFileValue());
                    continue;
                }
                pdfList.add(info.getFileValue());
                continue;
            }
            if (!info.getFileSource().equals("3")) continue;
            noDownList.add(info.getId().toString());
        }
        if (storeList != null && storeList.size() > 0) {
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStoreFileMap(ctx, storeList);
            for (String id : storePdfMap.keySet()) {
                byte[] str = storePdfMap.get(id);
                if (ofdMap.containsKey(id)) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfList.add(str);
            }
        }
        return pdfList;
    }

    @Override
    public List<byte[]> getFileValueMapByElStateIds(Context ctx, List elStateIdList, Map sortIems, boolean isConvertToPDF) throws BOSException, EASBizException {
        ArrayList<byte[]> pdfList = new ArrayList<byte[]>();
        ElStatementBillCollection coll = this.getElStatementBillColl(ctx, elStateIdList, sortIems);
        ArrayList<String> storeList = new ArrayList<String>();
        ArrayList<String> noDownList = new ArrayList<String>();
        HashMap<String, String> ofdMap = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            String fileType;
            String[] strSplit;
            String fileName;
            ElStatementBillInfo info = coll.get(i);
            if (info.getFileSource().equals("1") || info.getFileSource().equals("2")) {
                storeList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (!fileType.equals("ofd")) continue;
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (info.getFileSource().equals("0")) {
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("ofd")) {
                    if (isConvertToPDF) {
                        pdfList.add(OfdUtil.convertToPdfNew((byte[])info.getFileValue()));
                        continue;
                    }
                    pdfList.add(info.getFileValue());
                    continue;
                }
                pdfList.add(info.getFileValue());
                continue;
            }
            if (!info.getFileSource().equals("3")) continue;
            noDownList.add(info.getId().toString());
        }
        if (storeList != null && storeList.size() > 0) {
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStoreFileMap(ctx, storeList);
            for (String id : storePdfMap.keySet()) {
                byte[] str = storePdfMap.get(id);
                if (ofdMap.containsKey(id) && isConvertToPDF) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfList.add(str);
            }
        }
        return pdfList;
    }

    @Override
    public void batchSaveFileValue(Context ctx, ElStatementBillCollection coll) throws BOSException, EASBizException {
    }

    protected abstract Map<String, byte[]> getBatchStoreFileMap(Context var1, List var2) throws BOSException, EASBizException;

    protected abstract CoreBaseCollection upLoadFiles(Context var1, ElStatementBillCollection var2) throws BOSException, EASBizException;
}

