/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.mthread.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.mthread.ExecuteContext;
import com.kingdee.eas.fi.cas.app.mthread.ExecuteResult;
import com.kingdee.eas.fi.cas.app.mthread.task.AbstractTask;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.CasBosUtils;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.IBankPayingBill;
import com.kingdee.eas.fm.be.app.mthread.task.IBankPayingBillCommitToBeTask;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BankPayingBillCommitToBeTask
extends AbstractTask<IBankPayingBillCommitToBeTask>
implements IBankPayingBillCommitToBeTask {
    protected final String INFO_MAP = "INFO_MAP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(String id) throws Exception {
        Context ctx = this.getExecuteContext().getAppContext();
        ExecuteResult result = new ExecuteResult();
        result.setSuccess(true);
        IMutexServiceControl mutexService = null;
        try {
            BankPayResult resultInfo;
            IBankPayingBill iBankPayingBill = BankPayingBillFactory.getLocalInstance(ctx);
            BankPayingBillInfo info = this.getInfoById(id);
            result.getOtherMap().put("INFO", info);
            mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            iPermission.checkDataPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "bankPayingbill_submit", (IObjectPK)new ObjectUuidPK(id));
            if (!mutexService.requestObjIDForUpdate(id)) {
                result.setMsg(FmBeWebUtils.getResource(ctx, "121_BANKPAYINGBILL_BILL_LOCKED", new String[]{info.getNumber()}));
                ExecuteResult executeResult = result;
                return executeResult;
            }
            if (((IBankPayingBillCommitToBeTask)this.inf).isSubmit(ctx, info.getCompany().getId().toString())) {
                result.setSuccess(false);
                result.setMsg(FmBeWebUtils.getResource(ctx, "120_BANKPAYINGBILL_PARAM_TM018_ERROR"));
                ExecuteResult executeResult = result;
                return executeResult;
            }
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(id);
            ArrayList resultList = iBankPayingBill.commitToBENewBatch(idSet);
            if (resultList.size() > 0 && (resultInfo = (BankPayResult)resultList.get(0)).getErrorDetail() != null) {
                result.setSuccess(false);
                result.setMsg(resultInfo.getErrorDetail());
            }
        }
        catch (EASBizException e) {
            result.setSuccess(false);
            result.setMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSuccess(false);
            result.setMsg(e.getMessage());
        }
        finally {
            mutexService.releaseObjIDForUpdate(id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BankPayingBillInfo getInfoById(String id) throws BOSException {
        ExecuteContext eContext;
        ExecuteContext executeContext = eContext = this.getExecuteContext();
        synchronized (executeContext) {
            this.batchGetInfo();
        }
        return (BankPayingBillInfo)((Map)eContext.getParameter("INFO_MAP")).get(id);
    }

    @Override
    public boolean isSubmit(Context ctx, String companyId) throws EASBizException, BOSException {
        int tm018 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("TM018", (IObjectPK)new ObjectUuidPK(companyId));
        return tm018 == 0;
    }

    private void batchGetInfo() throws BOSException {
        ExecuteContext eContext = this.getExecuteContext();
        HashMap<String, BankPayingBillInfo> infoMap = (HashMap<String, BankPayingBillInfo>)eContext.getParameter("INFO_MAP");
        if (infoMap != null) {
            return;
        }
        String[] ids = eContext.getIds();
        EntityViewInfo view = CasBosUtils.entityViewBuilder().select(new String[]{"number", "company.id", "company.name", "isCBPay"}).filter("id", (Object)CASWebUtil.ids2Set((String[])ids), CompareType.INCLUDE).build();
        BankPayingBillCollection coll = BankPayingBillFactory.getLocalInstance(eContext.getAppContext()).getBankPayingBillCollection(view);
        infoMap = new HashMap<String, BankPayingBillInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            infoMap.put(coll.get(i).getId().toString(), coll.get(i));
        }
        eContext.setParameter("INFO_MAP", infoMap);
    }
}

