/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.Balance;
import com.kingdee.bos.ebservice.BalanceRequest;
import com.kingdee.bos.ebservice.BalanceRequestBody;
import com.kingdee.bos.ebservice.BalanceResponse;
import com.kingdee.bos.ebservice.BalanceResponseBody;
import com.kingdee.bos.ebservice.BatchBalanceRequest;
import com.kingdee.bos.ebservice.BatchBalanceRequestBody;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class BankAcctBalanceUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(BankAcctBalanceUtil.class);
    private IObjectPK pk = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public Balance[] getBatchBalance(Context ctx, BankBizInfo bizInfo) throws RemoteException, ServiceException, EASBizException, BOSException {
        EBGServiceUtil service = null;
        service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
        boolean isVirtualAcct = bizInfo.isVirtualAcct();
        String bankAcct = bizInfo.getBankAcct();
        BalanceResponse response = service.getBatchBalance(this.parseBatchBalanceRequest(ctx, bankAcct.split(";"), isVirtualAcct, bizInfo.getCurrency()));
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        BalanceResponseBody body = response.getBody();
        int type = 0;
        if (!EmptyUtil.isEmpty((Object)body)) {
            String errorMsg = "";
            for (int index = 0; index < body.getBalances().length; ++index) {
                Balance balanceInfo = body.getBalances()[index];
                if (EmptyUtil.isEmpty((String)balanceInfo.getReserved1())) continue;
                errorMsg = "\n";
                errorMsg = errorMsg + balanceInfo.getAccNo() + " \uff1a " + balanceInfo.getReserved1() + ";";
            }
            if (!EmptyUtil.isEmpty((String)errorMsg)) {
                EBGException e = new EBGException(EBGException.BALANCEERR, new Object[]{errorMsg});
                try {
                    Thread.sleep(2000L);
                    BankLogFacadeFactory.getLocalInstance(ctx).buildException(this.pk, (Exception)((Object)e), type);
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
                logger.error((Object)"get bankAccount balance failure! exception message is:", (Throwable)((Object)e));
            }
            return body.getBalances();
        }
        EBException excetion = response.getException();
        throw new EBGException(EBGException.BALANCEERR, new Object[]{excetion.getMessage()});
    }

    public Balance[] getBatchHisBalance(Context ctx, BankBizInfo bizInfo) throws RemoteException, ServiceException, EASBizException, BOSException {
        EBGServiceUtil service = null;
        service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
        boolean isVirtualAcct = bizInfo.isVirtualAcct();
        String bankAcct = bizInfo.getBankAcct();
        BalanceResponse response = service.getBatchBalance(this.parseBatchHisBalanceRequest(ctx, bankAcct.split(";"), isVirtualAcct, bizInfo.getCurrency(), new SimpleDateFormat("yyyyMMdd").format(bizInfo.getBeginDate()), new SimpleDateFormat("yyyyMMdd").format(bizInfo.getEndDate())));
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        int type = 0;
        BalanceResponseBody body = response.getBody();
        if (!EmptyUtil.isEmpty((Object)body)) {
            String errorMsg = "";
            for (int index = 0; index < body.getBalances().length; ++index) {
                Balance balanceInfo = body.getBalances()[index];
                if (EmptyUtil.isEmpty((String)balanceInfo.getReserved1())) continue;
                errorMsg = "\n";
                errorMsg = errorMsg + balanceInfo.getAccNo() + " \uff1a " + balanceInfo.getReserved1() + ";";
            }
            if (!EmptyUtil.isEmpty((String)errorMsg)) {
                EBGException e = new EBGException(EBGException.BALANCEERR, new Object[]{errorMsg});
                try {
                    Thread.sleep(2000L);
                    BankLogFacadeFactory.getLocalInstance(ctx).buildException(this.pk, (Exception)((Object)e), type);
                }
                catch (Exception e1) {
                    logger.error((Object)e.getMessage(), (Throwable)e1);
                }
                logger.error((Object)"get bankAccount balance failure! exception message is:", (Throwable)((Object)e));
            }
            return body.getBalances();
        }
        EBException excetion = response.getException();
        throw new EBGException(EBGException.BALANCEERR, new Object[]{excetion.getMessage()});
    }

    public Balance[] getBalance(Context ctx, BankBizInfo bizInfo) throws RemoteException, ServiceException, EASBizException, BOSException {
        EBGServiceUtil service = null;
        service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
        boolean isVirtualAcct = bizInfo.isVirtualAcct();
        BalanceResponse response = service.getBalance(this.parseBalanceRequest(ctx, bizInfo.getBankAcct(), isVirtualAcct, bizInfo.getCurrency()));
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        BalanceResponseBody body = response.getBody();
        if (!EmptyUtil.isEmpty((Object)body)) {
            return body.getBalances();
        }
        EBException excetion = response.getException();
        throw new EBGException(EBGException.BALANCEERR, new Object[]{excetion.getMessage()});
    }

    public Balance[] getBalanceHistory(Context ctx, BankBizInfo bizInfo) throws RemoteException, ServiceException, EASBizException, BOSException {
        EBGServiceUtil service = null;
        service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
        boolean isVirtualAcct = bizInfo.isVirtualAcct();
        BalanceResponse response = service.getBalance(this.parseBalanceRequestHistory(ctx, bizInfo.getBankAcct(), isVirtualAcct, bizInfo.getCurrency(), new SimpleDateFormat("yyyyMMdd").format(bizInfo.getBeginDate()), new SimpleDateFormat("yyyyMMdd").format(bizInfo.getEndDate())));
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        BalanceResponseBody body = response.getBody();
        if (!EmptyUtil.isEmpty((Object)body)) {
            return body.getBalances();
        }
        EBException excetion = response.getException();
        throw new EBGException(EBGException.BALANCEERR, new Object[]{excetion.getMessage()});
    }

    private BalanceRequest parseBalanceRequestHistory(Context ctx, String BankAcct, boolean isVirtualAcct, String currency, String beginDate, String endDate) {
        BalanceRequest request = new BalanceRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct, isVirtualAcct, currency, true, false));
        request.setBody(this.parseBodyHistory(beginDate, endDate));
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return request;
    }

    private BatchBalanceRequest parseBatchBalanceRequest(Context ctx, String[] BankAcct, boolean isVirtualAcct, String currency) {
        BatchBalanceRequest request = new BatchBalanceRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct[0], isVirtualAcct, currency, false, true));
        request.setBody(this.parseBatchBody(ctx, BankAcct));
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return request;
    }

    private BatchBalanceRequest parseBatchHisBalanceRequest(Context ctx, String[] BankAcct, boolean isVirtualAcct, String currency, String beginDate, String endDate) {
        BatchBalanceRequest request = new BatchBalanceRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct[0], isVirtualAcct, currency, true, true));
        request.setBody(this.parseBatchBodyHistory(BankAcct, beginDate, endDate));
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return request;
    }

    private BalanceRequest parseBalanceRequest(Context ctx, String BankAcct, boolean isVirtualAcct, String currency) {
        BalanceRequest request = new BalanceRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct, isVirtualAcct, currency, false, false));
        request.setBody(this.parseBody());
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return request;
    }

    protected EBHeader parseHeader(Context ctx, String BankAcct, boolean isVirtualAcct, String currency, boolean isHis, boolean isBatch) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        header.setBizType("balance");
        if (isVirtualAcct) {
            header.setSubBizType("virtual_balance");
        } else if (isHis) {
            if (isBatch) {
                header.setSubBizType("batch_his_balance");
            } else {
                header.setSubBizType("history_balance");
            }
        } else if (isBatch) {
            header.setSubBizType("batch_balance");
        } else {
            header.setSubBizType("today_balance");
        }
        if (isBatch) {
            header.setOperationName("batchBalance");
        } else {
            header.setOperationName("balance");
        }
        header.setCurrency(currency);
        header.setAccNo(BankAcct);
        return header;
    }

    protected BalanceRequestBody parseBody() {
        BalanceRequestBody body = new BalanceRequestBody();
        return body;
    }

    protected BatchBalanceRequestBody parseBatchBody(Context ctx, String[] accNos) {
        BatchBalanceRequestBody body = new BatchBalanceRequestBody();
        body.setAccNos(accNos);
        return body;
    }

    protected BatchBalanceRequestBody parseBatchBodyHistory(String[] accNos, String startDate, String endDate) {
        BatchBalanceRequestBody body = new BatchBalanceRequestBody();
        body.setAccNos(accNos);
        body.setStartDate(startDate);
        body.setEndDate(endDate);
        return body;
    }

    protected BalanceRequestBody parseBodyHistory(String startDate, String endDate) {
        BalanceRequestBody body = new BalanceRequestBody();
        body.setStartDate(startDate);
        body.setEndDate(endDate);
        return body;
    }
}

