/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.Detail;
import com.kingdee.bos.ebservice.DetailRequest;
import com.kingdee.bos.ebservice.DetailRequestBody;
import com.kingdee.bos.ebservice.DetailResponse;
import com.kingdee.bos.ebservice.DetailResponseBody;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.common.FMHelper;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class BankAcctDetailUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(BankAcctDetailUtil.class);
    private IObjectPK pk = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public Object[] getDetail(Context ctx, BankBizInfo bizInfo) throws RemoteException, ServiceException, EASBizException, BOSException {
        int i;
        EBGServiceUtil service = null;
        service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
        int pageNm = 1;
        ArrayList<Detail> resultList = new ArrayList<Detail>();
        String BankAcct = bizInfo.getBankAcct();
        String currency = bizInfo.getCurrency();
        Date beginDate = bizInfo.getBeginDate();
        Date endDate = bizInfo.getEndDate();
        boolean isVirtualAcct = bizInfo.isVirtualAcct();
        DetailResponse response = service.getDetail(this.parseDetailRequest(ctx, BankAcct, currency, isVirtualAcct, beginDate, endDate, String.valueOf(pageNm++)));
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        DetailResponseBody body = response.getBody();
        if (!EmptyUtil.isEmpty((Object)body)) {
            for (i = 0; i < body.getDetails().length; ++i) {
                resultList.add(body.getDetails()[i]);
            }
        } else {
            EBException excetion = response.getException();
            throw new EBGException(EBGException.DETAILERR, new Object[]{excetion.getMessage()});
        }
        while (!body.getLastPage().equalsIgnoreCase("true")) {
            try {
                this.pk = BankLogFacadeFactory.getLocalInstance(ctx).copyBeaseMessage(this.pk);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            response = service.getDetail(this.parseDetailRequest(ctx, BankAcct, currency, isVirtualAcct, beginDate, endDate, String.valueOf(pageNm++)));
            try {
                BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            body = response.getBody();
            if (!FMHelper.isEmpty((Object)body)) {
                for (i = 0; i < body.getDetails().length; ++i) {
                    resultList.add(body.getDetails()[i]);
                }
                continue;
            }
            EBException excetion = response.getException();
            throw new EBGException(EBGException.DETAILERR, new Object[]{excetion.getMessage()});
        }
        return resultList.toArray();
    }

    private DetailRequest parseDetailRequest(Context ctx, String BankAcct, String currency, boolean isVirtualAcct, Date beginDate, Date endDate, String pageNum) {
        DetailRequest request = new DetailRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct, isVirtualAcct, currency));
        request.setBody(this.parseBody(beginDate, endDate, pageNum));
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return request;
    }

    protected EBHeader parseHeader(Context ctx, String BankAcct, boolean isVirtualAcct, String currency) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        header.setBizType("detail");
        if (isVirtualAcct) {
            header.setSubBizType("virtual_detail");
        } else {
            header.setSubBizType("normal_detail");
        }
        header.setOperationName("detail");
        header.setCurrency(currency);
        header.setAccNo(BankAcct);
        return header;
    }

    protected DetailRequestBody parseBody(Date beginDate, Date endDate, String pageNum) {
        DetailRequestBody body = new DetailRequestBody();
        body.setStartDate(this.format(beginDate, "yyyyMMdd"));
        body.setEndDate(this.format(endDate, "yyyyMMdd"));
        body.setPageNum(pageNum);
        return body;
    }
}

