/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.AccountToDel;
import com.kingdee.bos.ebservice.AccountToSync;
import com.kingdee.bos.ebservice.DelAccountsBody;
import com.kingdee.bos.ebservice.DelAccountsRequest;
import com.kingdee.bos.ebservice.DelAccountsResponse;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.ListLoginsRequest;
import com.kingdee.bos.ebservice.ListLoginsRequestBody;
import com.kingdee.bos.ebservice.ListLoginsResponse;
import com.kingdee.bos.ebservice.ListLoginsResponseBody;
import com.kingdee.bos.ebservice.Login;
import com.kingdee.bos.ebservice.SyncAccountsBody;
import com.kingdee.bos.ebservice.SyncAccountsRequest;
import com.kingdee.bos.ebservice.SyncAccountsResponse;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BeServiceAddInfo;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IContextHelper;
import java.rmi.RemoteException;
import java.util.Locale;
import javax.xml.rpc.ServiceException;

public class BankAcctUtil
extends BaseEBGUtil {
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.beResourse";

    public Login[] listLogins(Context ctx, BankBizInfo bizInfo) throws ServiceException, RemoteException, EBGException {
        EBGServiceUtil service = new EBGServiceUtil(ctx);
        ListLoginsRequest request = this.parseBankServiceRequest(ctx, bizInfo.getBankName());
        ListLoginsResponse response = service.ListLogins(request);
        ListLoginsResponseBody body = response.getBody();
        if (!FMHelper.isEmpty((Object)body)) {
            return body.getLogins();
        }
        EBException excetion = response.getException();
        Logger.info((String)excetion.getMessage());
        throw new EBGException(EBGException.GETLOGINERR);
    }

    public Login[] listLogins(Context ctx, BankBizInfo bizInfo, String companyId) throws ServiceException, RemoteException, EBGException {
        EBGServiceUtil service = new EBGServiceUtil(ctx, companyId);
        ListLoginsRequest request = this.parseBankServiceRequest(ctx, bizInfo.getBankName());
        ListLoginsResponse response = service.ListLogins(request);
        ListLoginsResponseBody body = response.getBody();
        if (!FMHelper.isEmpty((Object)body)) {
            return body.getLogins();
        }
        EBException excetion = response.getException();
        Logger.info((String)excetion.getMessage());
        throw new EBGException(EBGException.GETLOGINERR);
    }

    public Login[] listLogins(Context ctx, BeServiceAddInfo bizInfo) throws ServiceException, RemoteException, EBGException {
        EBGServiceUtil service = new EBGServiceUtil(ctx, (IObjectValue)bizInfo);
        ListLoginsRequest request = this.parseBankServiceRequest(ctx, "");
        ListLoginsResponse response = service.ListLogins(request);
        ListLoginsResponseBody body = response.getBody();
        if (!FMHelper.isEmpty((Object)body)) {
            return body.getLogins();
        }
        EBException excetion = response.getException();
        Logger.info((String)excetion.getMessage());
        throw new EBGException(EBGException.GETLOGINERR);
    }

    private ListLoginsRequest parseBankServiceRequest(Context ctx, String bankName) {
        ListLoginsRequest request = new ListLoginsRequest();
        request.setHeader(this.parseBankServiceHeader(ctx, "BankAcct", "BANKINTER"));
        ListLoginsRequestBody body = new ListLoginsRequestBody();
        body.setBankName(bankName);
        request.setBody(body);
        return request;
    }

    public AccountToSync[] syncBankAccount(Context ctx, Object[] accts) throws RemoteException, ServiceException, EASBizException, BOSException {
        EBGServiceUtil service = null;
        if (FmBeHelper.isNotExistsMulBeService(ctx)) {
            service = new EBGServiceUtil(ctx);
        } else {
            IContextHelper iContextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
            service = new EBGServiceUtil(ctx, iContextHelper.getCurrentCompany().getId().toString());
        }
        SyncAccountsRequest request = this.parseSyncAccountsRequest(ctx, accts);
        SyncAccountsResponse response = service.syncAccounts(request);
        SyncAccountsBody body = response.getBody();
        if (FMHelper.isEmpty((Object)body)) {
            EBException excetion = response.getException();
            throw new EBGException(EBGException.BANKACCTERR, new Object[]{excetion.getMessage()});
        }
        return body.getAccounts();
    }

    public AccountToDel[] delBankAccount(Context ctx, Object[] accts) throws RemoteException, ServiceException, EASBizException, BOSException {
        EBGServiceUtil service = null;
        if (FmBeHelper.isNotExistsMulBeService(ctx)) {
            service = new EBGServiceUtil(ctx);
        } else {
            IContextHelper iContextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
            service = new EBGServiceUtil(ctx, iContextHelper.getCurrentCompany().getId().toString());
        }
        DelAccountsRequest request = this.parseDelAccountsRequest(ctx, accts);
        DelAccountsResponse response = service.delAccounts(request);
        DelAccountsBody body = response.getBody();
        if (FMHelper.isEmpty((Object)body)) {
            EBException excetion = response.getException();
            throw new EBGException(EBGException.BANKACCTERR, new Object[]{excetion.getMessage()});
        }
        return body.getAccounts();
    }

    private SyncAccountsRequest parseSyncAccountsRequest(Context ctx, Object[] accts) throws BEException, EBGException, RemoteException, ServiceException {
        SyncAccountsRequest request = new SyncAccountsRequest();
        request.setHeader(this.parseBankServiceHeader(ctx, "BankAcct", "syncAccounts"));
        request.setBody(this.parseBankAccountBody(ctx, accts));
        return request;
    }

    private DelAccountsRequest parseDelAccountsRequest(Context ctx, Object[] accts) throws BEException, EBGException, RemoteException, ServiceException {
        DelAccountsRequest request = new DelAccountsRequest();
        request.setHeader(this.parseBankServiceHeader(ctx, "BankAcct", "delAccounts"));
        request.setBody(this.parseDelAccountBody(ctx, accts));
        return request;
    }

    protected EBHeader parseBankServiceHeader(Context ctx, String bankname, String operate) {
        EBHeader header = super.parseHeader(ctx);
        header.setAccNo(bankname);
        header.setMessageType("request");
        if (operate.equalsIgnoreCase("syncAccounts")) {
            header.setBizType("sync_accounts");
            header.setSubBizType("account_sysnc");
            header.setOperationName("syncAccounts");
        } else if (operate.equalsIgnoreCase("delAccounts")) {
            header.setBizType("sync_accounts");
            header.setSubBizType("account_sysnc");
            header.setOperationName("delAccounts");
        } else {
            header.setBizType("list_logins");
            header.setSubBizType("list_logins");
            header.setOperationName("listLogins");
        }
        return header;
    }

    private SyncAccountsBody parseBankAccountBody(Context ctx, Object[] accts) throws BEException, EBGException, RemoteException, ServiceException {
        SyncAccountsBody body = new SyncAccountsBody();
        AccountToSync[] banks = new AccountToSync[accts.length];
        for (int i = 0; i < accts.length; ++i) {
            AccountBankInfo info = (AccountBankInfo)accts[i];
            AccountToSync bank = new AccountToSync();
            String[] otherMsg = new String[]{"", "", ""};
            try {
                String bankCurrency;
                bank.setAccNo(info.getBankAccountNumber());
                if (FMHelper.isEmpty((String)info.getAcctName())) {
                    bank.setAccName(info.getCompany().getName());
                } else {
                    bank.setAccName(info.getAcctName());
                }
                bank.setBankAddress(info.getOpenArea().getName());
                bank.setBankAreaCode(info.getOpenArea().getNumber());
                bank.setBankDeptCode(info.getOpenArea().getDeptID());
                if (FMHelper.isEmpty((String)info.getOpenArea().getDeptID())) {
                    bank.setBankDeptCode("0");
                }
                bank.setBankName(info.getBank().getName());
                bank.setCity(info.getOpenArea().getName());
                bank.setProvince(info.getOpenArea().getProvince());
                bank.setCountry(info.getCountry().getName());
                bank.setSwiftCode(info.getOpenArea().getNumber());
                if (FMHelper.isEmpty((String)info.getBankInterFaceID())) {
                    BankBizInfo bizInfo = new BankBizInfo();
                    bizInfo.setBankName(info.getBank().getName());
                    Login[] login = this.listLogins(ctx, bizInfo);
                    if (login.length == 1) {
                        bank.setBankServiceLoginId(login[0].getId());
                        otherMsg[1] = login[0].getDescription();
                    } else {
                        otherMsg[0] = login.length > 1 ? EASResource.getString((String)RESOURCEPATH, (String)"syncMulErr", (Locale)ctx.getLocale()) : EASResource.getString((String)RESOURCEPATH, (String)"GetLoginErr", (Locale)ctx.getLocale());
                    }
                } else {
                    bank.setBankServiceLoginId(info.getBankInterFaceID());
                    otherMsg[1] = info.getBankInterFace();
                }
                otherMsg[2] = info.isIsVirtualAcct() ? "isVirtual=true" : "isVirtual=false";
                bank.setReserveds(otherMsg);
                if (info.isIsByCurrency()) {
                    bankCurrency = FmBeHelper.getCurrency(ctx, info.getCurrency());
                    bank.setCurrency(bankCurrency);
                } else {
                    bankCurrency = FmBeHelper.getCurrency(ctx, info.getCompany().getBaseCurrency());
                    bank.setCurrency(bankCurrency);
                }
                if (info.getOldBankAccountNumber() != null) {
                    bank.setReserved1(info.getOldBankAccountNumber());
                }
                if (!FMHelper.isEmpty((Object)info.getBank().getId())) {
                    IBank BankFacade2 = BankFactory.getLocalInstance((Context)ctx);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("ACCOUNTBANK.NUMBER"));
                    BankInfo BankInfo2 = BankFacade2.getBankInfo((IObjectPK)new ObjectUuidPK(info.getBank().getId()), sic);
                    if (BankInfo2.getAccountBank() != null) {
                        bank.setReserved2(BankInfo2.getAccountBank().getNumber());
                    }
                }
                if (info.isIsEReceipt()) {
                    bank.setReserved3("true");
                } else {
                    bank.setReserved3("false");
                }
            }
            catch (Exception e) {
                otherMsg[0] = e.getMessage();
                bank.setReserveds(otherMsg);
            }
            banks[i] = bank;
        }
        body.setAccounts(banks);
        return body;
    }

    private DelAccountsBody parseDelAccountBody(Context ctx, Object[] accts) throws BEException, EBGException, RemoteException, ServiceException {
        DelAccountsBody body = new DelAccountsBody();
        AccountToDel[] acct = new AccountToDel[accts.length];
        for (int i = 0; i < accts.length; ++i) {
            AccountBankInfo info = (AccountBankInfo)accts[i];
            AccountToDel del = new AccountToDel();
            del.setAccNo(info.getBankAccountNumber());
            acct[i] = del;
        }
        body.setAccounts(acct);
        return body;
    }
}

