/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.BEBankProxyServiceCollection;
import com.kingdee.eas.fm.be.BEBankProxyServiceFactory;
import com.kingdee.eas.fm.be.BEBankProxyServiceInfo;
import com.kingdee.eas.fm.be.BECnapsDataWeb;
import com.kingdee.eas.util.ResourceBase;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankCnapsService {
    private static final Logger logger = Logger.getLogger(BankCnapsService.class);
    private static final String webAddr = "http://web20.kingdee.com";
    private static final String webPath = "/eb_cloud_cnaps/api/branches?since=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getgetCnapsFromWeb(String path) throws Exception {
        BufferedReader in = null;
        StringBuffer result = null;
        try {
            String line;
            URL url = new URL(path);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(600000);
            connection.setReadTimeout(1800000);
            connection.connect();
            result = new StringBuffer();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
            String string = result.toString();
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public static Map getCnapsWeb(Context ctx, String date) throws Exception {
        if (EmptyUtil.isEmpty((String)date)) {
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"866_BankCnapsService", (Locale)ctx.getLocale()));
        }
        String url = BankCnapsService.setWebAddr(ctx, date);
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"867_BankCnapsService", (Locale)ctx.getLocale()) + url));
        String response = BankCnapsService.getgetCnapsFromWeb(url);
        JSONObject json = JSONObject.parseObject((String)response);
        JSONArray data = json.getJSONArray("data");
        Gson gs = new Gson();
        HashMap<String, BECnapsDataWeb> map = new HashMap<String, BECnapsDataWeb>();
        for (int i = 0; i < data.size(); ++i) {
            BECnapsDataWeb cnpsData = new BECnapsDataWeb();
            Map cnapsObject = (Map)gs.fromJson(data.get(i).toString(), HashMap.class);
            if (!EmptyUtil.isEmpty(cnapsObject.get("cnapNo"))) {
                cnpsData.setBankCnaps((String)cnapsObject.get("cnapNo"));
                if (!EmptyUtil.isEmpty(cnapsObject.get("subBankName"))) {
                    cnpsData.setBankName((String)cnapsObject.get("subBankName"));
                }
                if (!EmptyUtil.isEmpty(cnapsObject.get("province"))) {
                    cnpsData.setProvinceName((String)cnapsObject.get("province"));
                }
                if (!EmptyUtil.isEmpty(cnapsObject.get("district"))) {
                    cnpsData.setCityName((String)cnapsObject.get("district"));
                }
                if (!EmptyUtil.isEmpty(cnapsObject.get("isovertime"))) {
                    cnpsData.setIsovertime((String)cnapsObject.get("isovertime"));
                }
                map.put(cnpsData.getBankCnaps(), cnpsData);
                continue;
            }
            cnpsData.setBankCnaps("");
            if (!EmptyUtil.isEmpty(cnapsObject.get("subBankName"))) {
                cnpsData.setBankName((String)cnapsObject.get("subBankName"));
            }
            if (!EmptyUtil.isEmpty(cnapsObject.get("province"))) {
                cnpsData.setProvinceName((String)cnapsObject.get("province"));
            }
            if (!EmptyUtil.isEmpty(cnapsObject.get("district"))) {
                cnpsData.setCityName((String)cnapsObject.get("district"));
            }
            if (!EmptyUtil.isEmpty(cnapsObject.get("isovertime"))) {
                cnpsData.setIsovertime((String)cnapsObject.get("isovertime"));
            }
            map.put(cnpsData.getBankCnaps(), cnpsData);
        }
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"868_BankCnapsService", (Locale)ctx.getLocale()) + map.keySet().size() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"869_BankCnapsService", (Locale)ctx.getLocale())));
        return map;
    }

    public static String setWebAddr(Context ctx, String date) {
        String URL2 = null;
        BEBankProxyServiceCollection infoColl = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            SorterItemCollection bankSortColl = new SorterItemCollection();
            SorterItemInfo sort = new SorterItemInfo("createTime");
            sort.setSortType(SortType.ASCEND);
            bankSortColl.add(sort);
            view.setSorter(bankSortColl);
            infoColl = BEBankProxyServiceFactory.getLocalInstance(ctx).getBEBankProxyServiceCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (infoColl != null && infoColl.size() > 0) {
            BEBankProxyServiceInfo BEBankProxyServiceInfo2 = infoColl.get(0);
            URL2 = BEBankProxyServiceInfo2.getServiceAdd() + webPath + date;
        } else {
            URL2 = "http://web20.kingdee.com/eb_cloud_cnaps/api/branches?since=" + date;
        }
        return URL2;
    }
}

