/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.PayBody;
import com.kingdee.bos.ebservice.PayRequest;
import com.kingdee.bos.ebservice.PayResponse;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.common.FMException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class BankPayUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(BankPayUtil.class);
    IObjectPK pk = null;
    Map<String, IObjectPK> batchPK = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public Map<String, IObjectPK> getBatchPK() {
        return this.batchPK;
    }

    public void setBatchPK(Map<String, IObjectPK> batchPK) {
        this.batchPK = batchPK;
    }

    public PaymentDetail[] pay(Context ctx, BankBizInfo bizInfo, PayBody body) throws RemoteException, ServiceException, EASBizException, BOSException {
        logger.info((Object)("********pay " + body.getBatchSeqID() + " begin********"));
        EBGServiceUtil service = null;
        service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
        PayResponse response = service.pay(this.parsePayRequest(ctx, bizInfo, body));
        PayBody resultBody = response.getBody();
        if (!EmptyUtil.isEmpty((Object)resultBody)) {
            this.buildResponseLog(ctx, body, response);
            logger.info((Object)("********pay " + body.getBatchSeqID() + " end********"));
            return resultBody.getDetails();
        }
        if (response.getException() != null && response.getException().getErrorCode() != null && response.getException().getErrorCode().equalsIgnoreCase("pre")) {
            logger.error((Object)("********pay " + body.getBatchSeqID() + " exception :" + response.getException().getMessage() + "********"));
            throw new BEException(BEException.COMMON, new Object[]{response.getException().getMessage()});
        }
        if (response.getException() != null && response.getException().getMessage().startsWith("\u4f7f\u7528\u4e86\u94f6\u4f01\u4e2d\u95f4\u4ef6\u4e2d\u672a\u7ef4\u62a4\u7684\u8d26\u53f7")) {
            logger.error((Object)("********pay " + body.getBatchSeqID() + " exception :" + response.getException().getMessage() + "********"));
            throw new BEException(BEException.COMMON, new Object[]{response.getException().getMessage()});
        }
        logger.error((Object)("********pay " + body.getBatchSeqID() + " exception :" + response.getException().getMessage() + "********"));
        throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{response.getException().getMessage()});
    }

    private void buildResponseLog(Context ctx, PayBody body, PayResponse response) {
        try {
            if (this.batchPK == null) {
                BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
            } else {
                BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("\u6279\u6b21\u53f7\uff1a" + body.getBatchSeqID() + "\u62fc\u88c5EAS\u94f6\u4f01\u8fd4\u56de\u62a5\u6587\u65f6\u5931\u8d25"), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("\u6279\u6b21\u53f7\uff1a" + body.getBatchSeqID() + "\u62fc\u88c5EAS\u94f6\u4f01\u8fd4\u56de\u62a5\u6587\u65f6\u5931\u8d25"), (Throwable)e);
        }
    }

    private PayRequest parsePayRequest(Context ctx, BankBizInfo bizInfo, PayBody body) {
        PayRequest request = new PayRequest();
        request.setHeader(this.parseHeader(ctx, bizInfo));
        request.setBody(body);
        try {
            if (this.batchPK == null) {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
            } else {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequestBatch(this.batchPK, request);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("\u6279\u6b21\u53f7\uff1a" + body.getBatchSeqID() + "\u62fc\u88c5EAS\u53d1\u9001\u94f6\u4f01\u62a5\u6587\u65f6\u5931\u8d25"), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("\u6279\u6b21\u53f7\uff1a" + body.getBatchSeqID() + "\u62fc\u88c5EAS\u53d1\u9001\u94f6\u4f01\u62a5\u6587\u65f6\u5931\u8d25"), (Throwable)e);
        }
        return request;
    }

    protected EBHeader parseHeader(Context ctx, BankBizInfo bizInfo) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        header.setBizType("pay");
        if (BillTypeEnum.PAYMENT_BILL.equals((Object)bizInfo.getBillType())) {
            header.setSubBizType("pay");
        } else if (BillTypeEnum.AgencySalary.equals((Object)bizInfo.getBillType())) {
            header.setSubBizType("pay_for_salary");
        } else if (BillTypeEnum.AgentPay.equals((Object)bizInfo.getBillType())) {
            header.setSubBizType("pay_for_agentpay");
        } else {
            header.setSubBizType("pay_for_capital_allocation");
        }
        header.setOperationName("pay");
        header.setAccNo(bizInfo.getBankAcct());
        header.setCurrency(bizInfo.getCurrency());
        return header;
    }
}

