/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ebservice.CurrentToFixedRequest;
import com.kingdee.bos.ebservice.CurrentToFixedRequestBody;
import com.kingdee.bos.ebservice.CurrentToFixedResponse;
import com.kingdee.bos.ebservice.CurrentToFixedResponseBody;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.FixedInfo;
import com.kingdee.bos.ebservice.FixedToCurrentRequest;
import com.kingdee.bos.ebservice.FixedToCurrentRequestBody;
import com.kingdee.bos.ebservice.FixedToCurrentResponse;
import com.kingdee.bos.ebservice.FixedToCurrentResponseBody;
import com.kingdee.bos.ebservice.QueryFixedRequest;
import com.kingdee.bos.ebservice.QueryFixedRequestBody;
import com.kingdee.bos.ebservice.QueryFixedResponse;
import com.kingdee.bos.ebservice.QueryFixedResponseBody;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.RegularBizInfo;
import com.kingdee.eas.fm.common.FMHelper;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;

public class BankRegularUtil
extends BaseEBGUtil {
    public FixedInfo[] QueryFixed(Context ctx, RegularBizInfo bizInfo, String currency) throws ServiceException, EASBizException, BOSException, RemoteException {
        EBGServiceUtil service = new EBGServiceUtil(ctx);
        QueryFixedRequestBody body = beServiceHelper.parseRegularBody(ctx, bizInfo);
        QueryFixedResponse response = service.queryFixed(this.parseQueryFixedRequest(ctx, body, bizInfo.getAccNoArray()[0], currency, bizInfo.getBillType()));
        QueryFixedResponseBody resultBody = response.getBody();
        if (!FMHelper.isEmpty((Object)resultBody)) {
            return resultBody.getFixedInfos();
        }
        EBException excetion = response.getException();
        throw new EBGException(EBGException.BALANCEERR, new Object[]{excetion.getMessage()});
    }

    public RegularBizInfo fixedToCurrent(Context ctx, RegularBizInfo bizInfo, String currency) throws ServiceException, RemoteException, EASBizException, BOSException {
        EBGServiceUtil service = new EBGServiceUtil(ctx);
        FixedToCurrentRequestBody body = beServiceHelper.parseFixedToCurrentBody(ctx, bizInfo);
        FixedToCurrentResponse response = service.fixedToCurrent(this.parseFixedToCurrentRequest(ctx, body, bizInfo.getFixedAccNo(), currency, bizInfo.getBillType()));
        FixedToCurrentResponseBody resultBody = response.getBody();
        if (!FMHelper.isEmpty((Object)resultBody)) {
            bizInfo.setStatus(beServiceHelper.transferState(resultBody.getStatus()));
            bizInfo.setStatusMsg(resultBody.getStatusMsg());
            return bizInfo;
        }
        EBException excetion = response.getException();
        throw new EBGException(EBGException.BALANCEERR, new Object[]{excetion.getMessage()});
    }

    public RegularBizInfo currentToFixed(Context ctx, RegularBizInfo bizInfo, String currency) throws ServiceException, RemoteException, EASBizException, BOSException {
        EBGServiceUtil service = new EBGServiceUtil(ctx);
        CurrentToFixedRequestBody body = beServiceHelper.parseCurrentToFixedBody(ctx, bizInfo);
        CurrentToFixedResponse response = service.currentToFixed(this.parseCurrentToFixedRequest(ctx, body, bizInfo.getCurrentAccNo(), currency, bizInfo.getBillType()));
        CurrentToFixedResponseBody resultBody = response.getBody();
        if (!FMHelper.isEmpty((Object)resultBody)) {
            bizInfo.setStatus(beServiceHelper.transferState(resultBody.getStatus()));
            bizInfo.setStatusMsg(resultBody.getStatusMsg());
            return bizInfo;
        }
        EBException excetion = response.getException();
        throw new EBGException(EBGException.BALANCEERR, new Object[]{excetion.getMessage()});
    }

    private QueryFixedRequest parseQueryFixedRequest(Context ctx, QueryFixedRequestBody body, String BankAcct, String currency, BillTypeEnum billType) {
        QueryFixedRequest request = new QueryFixedRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct, currency, "queryFixed"));
        request.setBody(body);
        return request;
    }

    private FixedToCurrentRequest parseFixedToCurrentRequest(Context ctx, FixedToCurrentRequestBody body, String BankAcct, String currency, BillTypeEnum billType) {
        FixedToCurrentRequest request = new FixedToCurrentRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct, currency, "fixedToCurrent"));
        request.setBody(body);
        return request;
    }

    private CurrentToFixedRequest parseCurrentToFixedRequest(Context ctx, CurrentToFixedRequestBody body, String BankAcct, String currency, BillTypeEnum billType) {
        CurrentToFixedRequest request = new CurrentToFixedRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct, currency, "currentToFixed"));
        request.setBody(body);
        return request;
    }

    protected EBHeader parseHeader(Context ctx, String BankAcct, String currency, String bizType) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        if (bizType.equals("queryFixed")) {
            header.setBizType("get_regular_details");
            header.setSubBizType("get_regular_details");
            header.setOperationName("queryFixed");
        } else if (bizType.equals("fixedToCurrent")) {
            header.setBizType("trans_current");
            header.setSubBizType("trans_current");
            header.setOperationName("fixedToCurrent");
        } else {
            header.setBizType("trans_regular");
            header.setSubBizType("trans_regular");
            header.setOperationName("currentToFixed");
        }
        header.setCurrency(currency);
        header.setAccNo(BankAcct);
        return header;
    }
}

