/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.BatchQueryPayRequest;
import com.kingdee.bos.ebservice.BatchQueryPayRequestBody;
import com.kingdee.bos.ebservice.BatchQueryPayResponse;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.PayBody;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class BatchBankPayQueryUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(BatchBankPayQueryUtil.class);
    IObjectPK pk = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public PayBody[] queryPay(Context ctx, BankBizInfo bizInfo) throws RemoteException, EBGException, ServiceException {
        EBGServiceUtil service = new EBGServiceUtil(ctx);
        BatchQueryPayRequestBody body = new BatchQueryPayRequestBody();
        body.setBatchSeqIDs(bizInfo.getBatchSeqIDs());
        BatchQueryPayResponse response = service.queryBatchPay(this.parseBatchPayQueryRequest(ctx, bizInfo.getBankAcct(), body));
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        Object[] resultBody = response.getBodys();
        if (!EmptyUtil.isEmpty((Object[])resultBody)) {
            return resultBody;
        }
        EBException excetion = response.getException();
        throw new EBGException(EBGException.QUERYPAYERR, new Object[]{excetion.getMessage()});
    }

    private BatchQueryPayRequest parseBatchPayQueryRequest(Context ctx, String BankAcct, BatchQueryPayRequestBody body) {
        BatchQueryPayRequest request = new BatchQueryPayRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct));
        request.setBody(body);
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return request;
    }

    protected EBHeader parseHeader(Context ctx, String BankAcct) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        header.setBizType("pay");
        header.setSubBizType("pay");
        header.setOperationName("batchQueryPay");
        header.setAccNo(BankAcct);
        return header;
    }
}

