/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.LinkPayDetail;
import com.kingdee.bos.ebservice.OverseaPayDetail;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEPayInterfaceCostCollection;
import com.kingdee.eas.fm.be.BEPayInterfaceCostFactory;
import com.kingdee.eas.fm.be.BEPayInterfaceCostInfo;
import com.kingdee.eas.fm.be.BEpayInterfaceCostStatusEnum;
import com.kingdee.eas.fm.be.BankAgentPayBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankTransDownBillInfo;
import com.kingdee.eas.fm.be.BankTransUpBillInfo;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.util.ThreadLocalTimeUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class BePayInterfaceCostUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cbs.app.service.BePayInterfaceCostUtil");
    private static final String EAS_PAY_INSERT_TIME = "EAS_PAY_INSERT_TIME";
    private static final String EAS_PAY_START_TIME = "EAS_PAY_START_TIME";
    private static final String EAS_PAY_END_TIME = "EAS_PAY_END_TIME";

    public void saveDataForPayBillQueryOverseaPay(Context ctx, OverseaPayDetail info, BankPayingBillInfo bill) {
        try {
            BEPayInterfaceCostInfo bePayInterfaceCostInfo = new BEPayInterfaceCostInfo();
            this.buildBeTimeInfo(info, bePayInterfaceCostInfo);
            bePayInterfaceCostInfo.setPayBillId(bill.getId().toString());
            bePayInterfaceCostInfo.setPayBillEntryId(bill.getId().toString());
            bePayInterfaceCostInfo.setCompany(bill.getCompany());
            bePayInterfaceCostInfo.setPayeeBankAccount(bill.getRecAccountBank());
            bePayInterfaceCostInfo.setBankAccount(bill.getPayAccountBank());
            bePayInterfaceCostInfo.setBankAccountName(bill.getPayAccountBank().getBankAccountNumber());
            bePayInterfaceCostInfo.setInterfaceId(bill.getPayAccountBank().getBankInterFaceID());
            bePayInterfaceCostInfo.setInterfaceName(bill.getPayAccountBank().getBankInterFace());
            bePayInterfaceCostInfo.setBillNumber(bill.getNumber());
            bePayInterfaceCostInfo.setSourceBillId(bill.getSourceBillId());
            bePayInterfaceCostInfo.setBillType(bill.getSrcBillType());
            bePayInterfaceCostInfo.setCommitBETime(bill.getSubmitTime());
            bePayInterfaceCostInfo.setSourceBillNumber(bill.getSrcBillNumber());
            bePayInterfaceCostInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            this.saveBEPayInterfaceCostTime(ctx, info, bePayInterfaceCostInfo);
        }
        catch (Exception e) {
            logger.error((Object)("\u4ed8\u6b3e\u5355-\u5883\u5916\u652f\u4ed8\u94f6\u4f01\u4e1a\u652f\u4ed8\u6548\u80fd\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    public void savePayBillQueryLinkPayInterfaceCos(Context ctx, LinkPayDetail info, BankPayingBillInfo bill) {
        try {
            BEPayInterfaceCostInfo bePayInterfaceCostInfo = new BEPayInterfaceCostInfo();
            this.buildBeTimeInfo(info, bePayInterfaceCostInfo);
            bePayInterfaceCostInfo.setPayBillId(bill.getId().toString());
            bePayInterfaceCostInfo.setPayBillEntryId(bill.getId().toString());
            bePayInterfaceCostInfo.setCompany(bill.getCompany());
            bePayInterfaceCostInfo.setPayeeBankAccount(bill.getRecAccountBank());
            bePayInterfaceCostInfo.setBankAccount(bill.getPayAccountBank());
            bePayInterfaceCostInfo.setBankAccountName(bill.getPayAccountBank().getBankAccountNumber());
            bePayInterfaceCostInfo.setInterfaceId(bill.getPayAccountBank().getBankInterFaceID());
            bePayInterfaceCostInfo.setInterfaceName(bill.getPayAccountBank().getBankInterFace());
            bePayInterfaceCostInfo.setBillNumber(bill.getNumber());
            bePayInterfaceCostInfo.setSourceBillId(bill.getSourceBillId());
            bePayInterfaceCostInfo.setBillType(bill.getSrcBillType());
            bePayInterfaceCostInfo.setCommitBETime(bill.getSubmitTime());
            bePayInterfaceCostInfo.setSourceBillNumber(bill.getSrcBillNumber());
            this.saveBEPayInterfaceCostTime(ctx, info, bePayInterfaceCostInfo);
        }
        catch (Exception e) {
            logger.error((Object)("\u4ed8\u6b3e\u5355-\u8054\u52a8\u652f\u4ed8\u94f6\u4f01\u4e1a\u652f\u4ed8\u6548\u80fd\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    public void savePayBillQueryPayInterfaceCost(Context ctx, PaymentDetail info, BankPayingBillInfo bill) {
        try {
            BEPayInterfaceCostInfo bePayInterfaceCostInfo = new BEPayInterfaceCostInfo();
            this.buildBeTimeInfo(info, bePayInterfaceCostInfo);
            bePayInterfaceCostInfo.setPayBillId(bill.getId().toString());
            bePayInterfaceCostInfo.setPayBillEntryId(bill.getId().toString());
            bePayInterfaceCostInfo.setCompany(bill.getCompany());
            bePayInterfaceCostInfo.setPayeeBankAccount(bill.getRecAccountBank());
            bePayInterfaceCostInfo.setBankAccount(bill.getPayAccountBank());
            bePayInterfaceCostInfo.setBankAccountName(bill.getPayAccountBank().getBankAccountNumber());
            bePayInterfaceCostInfo.setInterfaceId(bill.getPayAccountBank().getBankInterFaceID());
            bePayInterfaceCostInfo.setInterfaceName(bill.getPayAccountBank().getBankInterFace());
            bePayInterfaceCostInfo.setBillNumber(bill.getNumber());
            bePayInterfaceCostInfo.setSourceBillNumber(bill.getSrcBillNumber());
            bePayInterfaceCostInfo.setSourceBillId(bill.getSourceBillId());
            bePayInterfaceCostInfo.setBillType(bill.getSrcBillType());
            bePayInterfaceCostInfo.setCommitBETime(bill.getSubmitTime());
            bePayInterfaceCostInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            this.saveBEPayInterfaceCostTime(ctx, info, bePayInterfaceCostInfo);
        }
        catch (Exception e) {
            logger.error((Object)("\u4ed8\u6b3e\u5355\u94f6\u4f01\u4e1a\u652f\u4ed8\u6548\u80fd\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    public void buildTransDownBillQueryPayInterfaceCost(BankTransDownBillInfo bill, Set<String> alreadyDoneIds, PaymentDetail info, CoreBaseCollection saveList, CoreBaseCollection updateList, Context ctx) {
        try {
            BEPayInterfaceCostInfo bePayInterfaceCostInfo = new BEPayInterfaceCostInfo();
            bePayInterfaceCostInfo.setPayBillId(bill.getId().toString());
            for (int j = 0; j < bill.getEntrys().size(); ++j) {
                if (!bill.getEntrys().get(j).getSerialNumber().equals(info.getDetailSeqID())) continue;
                bePayInterfaceCostInfo.setPayBillEntryId(bill.getEntrys().get(j).getId().toString());
                bePayInterfaceCostInfo.setPayeeBankAccount(bill.getEntrys().get(j).getUnitAcctBank().getBankAccountNumber());
                break;
            }
            if (EmptyUtil.isEmpty((String)bePayInterfaceCostInfo.getPayBillEntryId()) || alreadyDoneIds.contains(bePayInterfaceCostInfo.getPayBillEntryId())) {
                return;
            }
            this.buildBeTimeInfo(info, bePayInterfaceCostInfo);
            bePayInterfaceCostInfo.setBankAccount(bill.getMotherAcctBank());
            bePayInterfaceCostInfo.setBankAccountName(bill.getMotherAcctBank().getBankAccountNumber());
            bePayInterfaceCostInfo.setInterfaceId(bill.getMotherAcctBank().getBankInterFaceID());
            bePayInterfaceCostInfo.setInterfaceName(bill.getMotherAcctBank().getBankInterFace());
            bePayInterfaceCostInfo.setCompany(bill.getCompany());
            bePayInterfaceCostInfo.setBillNumber(bill.getNumber());
            bePayInterfaceCostInfo.setSourceBillNumber(bill.getSrcBillNumber());
            bePayInterfaceCostInfo.setSourceBillId(bill.getSourceBillId());
            bePayInterfaceCostInfo.setBillType(BillTypeEnum.transDownBill);
            bePayInterfaceCostInfo.setCommitBETime(bill.getSubmitTime());
            this.buildSaveOrUpdateList(ctx, info, bePayInterfaceCostInfo, saveList, updateList);
            alreadyDoneIds.add(bePayInterfaceCostInfo.getPayBillEntryId());
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0b\u62e8\u5355\u94f6\u4f01\u4e1a\u652f\u4ed8\u6548\u80fd\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    public void buildTransUpBillQueryPayCost(BankTransUpBillInfo bill, PaymentDetail info, Set<String> alreadyDoneIds, CoreBaseCollection saveList, CoreBaseCollection updateList, Context ctx) {
        try {
            BEPayInterfaceCostInfo bePayInterfaceCostInfo = new BEPayInterfaceCostInfo();
            bePayInterfaceCostInfo.setPayBillId(bill.getId().toString());
            for (int j = 0; j < bill.getEntrys().size(); ++j) {
                if (!bill.getEntrys().get(j).getSerialNumber().equals(info.getDetailSeqID())) continue;
                bePayInterfaceCostInfo.setPayBillEntryId(bill.getEntrys().get(j).getId().toString());
                bePayInterfaceCostInfo.setBankAccount(bill.getEntrys().get(j).getUnitAcctBank());
                bePayInterfaceCostInfo.setBankAccountName(bill.getEntrys().get(j).getUnitAcctBank().getBankAccountNumber());
                break;
            }
            if (EmptyUtil.isEmpty((String)bePayInterfaceCostInfo.getPayBillEntryId()) || alreadyDoneIds.contains(bePayInterfaceCostInfo.getPayBillEntryId())) {
                return;
            }
            this.buildBeTimeInfo(info, bePayInterfaceCostInfo);
            bePayInterfaceCostInfo.setPayeeBankAccount(bill.getMotherAcctBank().getBankAccountNumber());
            bePayInterfaceCostInfo.setInterfaceId(bill.getMotherAcctBank().getBankInterFaceID());
            bePayInterfaceCostInfo.setInterfaceName(bill.getMotherAcctBank().getBankInterFace());
            bePayInterfaceCostInfo.setCompany(bill.getCompany());
            bePayInterfaceCostInfo.setBillNumber(bill.getNumber());
            bePayInterfaceCostInfo.setSourceBillId(bill.getSourceBillId());
            bePayInterfaceCostInfo.setBillType(BillTypeEnum.transUpBill);
            bePayInterfaceCostInfo.setCommitBETime(bill.getSubmitTime());
            bePayInterfaceCostInfo.setSourceBillNumber(bill.getSrcBillNumber());
            this.buildSaveOrUpdateList(ctx, info, bePayInterfaceCostInfo, saveList, updateList);
            alreadyDoneIds.add(bePayInterfaceCostInfo.getPayBillEntryId());
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0b\u5212\u5355\u94f6\u4f01\u4e1a\u652f\u4ed8\u6548\u80fd\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    public void buildAgentBillQueryOverseaPayCost(BankAgentPayBillInfo bill, PaymentDetail info, Set<String> alreadyDoneIds, CoreBaseCollection saveList, CoreBaseCollection updateList, Context ctx) {
        try {
            BEPayInterfaceCostInfo bePayInterfaceCostInfo = new BEPayInterfaceCostInfo();
            bePayInterfaceCostInfo.setPayBillId(bill.getId().toString());
            for (int k = 0; k < bill.getEntrys().size(); ++k) {
                if (!bill.getEntrys().get(k).getSerialNumber().equals(info.getDetailSeqID())) continue;
                bePayInterfaceCostInfo.setPayBillEntryId(bill.getEntrys().get(k).getId().toString());
                bePayInterfaceCostInfo.setPayeeBankAccount(bill.getEntrys().get(k).getRecBankAccount());
                break;
            }
            if (EmptyUtil.isEmpty((String)bePayInterfaceCostInfo.getPayBillEntryId()) || alreadyDoneIds.contains(bePayInterfaceCostInfo.getPayBillEntryId())) {
                return;
            }
            this.buildBeTimeInfo(info, bePayInterfaceCostInfo);
            bePayInterfaceCostInfo.setBankAccount(bill.getPayAccountBank());
            bePayInterfaceCostInfo.setBankAccountName(bill.getPayAccountBank().getBankAccountNumber());
            bePayInterfaceCostInfo.setInterfaceId(bill.getPayAccountBank().getBankInterFaceID());
            bePayInterfaceCostInfo.setInterfaceName(bill.getPayAccountBank().getBankInterFace());
            bePayInterfaceCostInfo.setCompany(bill.getCompany());
            bePayInterfaceCostInfo.setBillNumber(bill.getNumber());
            bePayInterfaceCostInfo.setSourceBillId(bill.getSourceBillId());
            bePayInterfaceCostInfo.setBillType(BillTypeEnum.AgencySalary);
            bePayInterfaceCostInfo.setCommitBETime(bill.getCreateTime());
            bePayInterfaceCostInfo.setSourceBillNumber(bill.getAgentNumber());
            this.buildSaveOrUpdateList(ctx, info, bePayInterfaceCostInfo, saveList, updateList);
            alreadyDoneIds.add(bePayInterfaceCostInfo.getPayBillEntryId());
        }
        catch (Exception e) {
            logger.error((Object)("\u4ee3\u53d1\u5355-\u5883\u5916\u652f\u4ed8\u94f6\u4f01\u4e1a\u652f\u4ed8\u6548\u80fd\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    public void batchSaveOrUpdate(CoreBaseCollection saveList, CoreBaseCollection updateList, Context ctx) {
        try {
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)saveList)) {
                BEPayInterfaceCostFactory.getLocalInstance(ctx).saveBatchData(saveList);
            }
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)updateList)) {
                BEPayInterfaceCostFactory.getLocalInstance(ctx).updateBatchData(updateList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u6279\u91cf\u4fdd\u5b58\u94f6\u4f01\u652f\u4ed8\u6548\u80fd\u6570\u636e\u5931\u8d25\uff0cerror:", (Throwable)e);
        }
    }

    private void saveBEPayInterfaceCostTime(Context ctx, PaymentDetail info, BEPayInterfaceCostInfo bePayInterfaceCostInfo) throws BOSException, ParseException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("payBillEntryId", (Object)bePayInterfaceCostInfo.getPayBillEntryId()));
        entityViewInfo.setFilter(filter);
        BEPayInterfaceCostCollection costCollection = BEPayInterfaceCostFactory.getLocalInstance(ctx).getBEPayInterfaceCostCollection(entityViewInfo);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)costCollection)) {
            if (bePayInterfaceCostInfo.getCommitBETime() != null && bePayInterfaceCostInfo.getBERecieveTime() != null) {
                long differentMills = Math.abs(bePayInterfaceCostInfo.getBERecieveTime().getTime() - bePayInterfaceCostInfo.getCommitBETime().getTime());
                bePayInterfaceCostInfo.setCommitCost(new BigDecimal((float)differentMills / 1000.0f).setScale(0, 4));
                bePayInterfaceCostInfo.setPayStatus(BEpayInterfaceCostStatusEnum.PAYED);
            } else {
                bePayInterfaceCostInfo.setPayStatus(BEpayInterfaceCostStatusEnum.PAYING);
            }
            BEPayInterfaceCostFactory.getLocalInstance(ctx).addnew(bePayInterfaceCostInfo);
        } else {
            if (null != costCollection.get(0).getBERecieveTime() && null != costCollection.get(0).getResponseBETime() && null != costCollection.get(0).getBESendTime()) {
                return;
            }
            BEPayInterfaceCostInfo bePayInterfaceCostInfoNew = new BEPayInterfaceCostInfo();
            bePayInterfaceCostInfoNew.setId(costCollection.get(0).getId());
            bePayInterfaceCostInfoNew.setCommitBETime(costCollection.get(0).getCommitBETime());
            this.buildBeTimeInfo(info, bePayInterfaceCostInfoNew);
            if (bePayInterfaceCostInfoNew.getCommitBETime() != null && bePayInterfaceCostInfoNew.getBERecieveTime() != null) {
                long differentMills = Math.abs(bePayInterfaceCostInfoNew.getBERecieveTime().getTime() - bePayInterfaceCostInfoNew.getCommitBETime().getTime());
                bePayInterfaceCostInfoNew.setCommitCost(new BigDecimal((float)differentMills / 1000.0f).setScale(0, 4));
                bePayInterfaceCostInfoNew.setPayStatus(BEpayInterfaceCostStatusEnum.PAYED);
            } else {
                bePayInterfaceCostInfoNew.setPayStatus(BEpayInterfaceCostStatusEnum.PAYING);
            }
            BEPayInterfaceCostFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(costCollection.get(0).getId()), bePayInterfaceCostInfoNew);
        }
    }

    private void buildSaveOrUpdateList(Context ctx, PaymentDetail info, BEPayInterfaceCostInfo bePayInterfaceCostInfo, CoreBaseCollection saveList, CoreBaseCollection updateList) throws BOSException, ParseException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("payBillEntryId", (Object)bePayInterfaceCostInfo.getPayBillEntryId()));
        entityViewInfo.setFilter(filter);
        BEPayInterfaceCostCollection costCollection = BEPayInterfaceCostFactory.getLocalInstance(ctx).getBEPayInterfaceCostCollection(entityViewInfo);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)costCollection)) {
            if (bePayInterfaceCostInfo.getCommitBETime() != null && bePayInterfaceCostInfo.getBERecieveTime() != null) {
                long differentMills = Math.abs(bePayInterfaceCostInfo.getBERecieveTime().getTime() - bePayInterfaceCostInfo.getCommitBETime().getTime());
                bePayInterfaceCostInfo.setCommitCost(new BigDecimal((float)differentMills / 1000.0f).setScale(0, 4));
                bePayInterfaceCostInfo.setPayStatus(BEpayInterfaceCostStatusEnum.PAYED);
            } else {
                bePayInterfaceCostInfo.setPayStatus(BEpayInterfaceCostStatusEnum.PAYING);
            }
            saveList.add((CoreBaseInfo)bePayInterfaceCostInfo);
        } else {
            if (null != costCollection.get(0).getBERecieveTime() && null != costCollection.get(0).getResponseBETime() && null != costCollection.get(0).getBESendTime()) {
                return;
            }
            BEPayInterfaceCostInfo bePayInterfaceCostInfoNew = new BEPayInterfaceCostInfo();
            bePayInterfaceCostInfoNew.setId(costCollection.get(0).getId());
            bePayInterfaceCostInfoNew.setCommitBETime(costCollection.get(0).getCommitBETime());
            this.buildBeTimeInfo(info, bePayInterfaceCostInfoNew);
            if (bePayInterfaceCostInfoNew.getCommitBETime() != null && bePayInterfaceCostInfoNew.getBERecieveTime() != null) {
                long differentMills = Math.abs(bePayInterfaceCostInfoNew.getBERecieveTime().getTime() - bePayInterfaceCostInfoNew.getCommitBETime().getTime());
                bePayInterfaceCostInfoNew.setCommitCost(new BigDecimal((float)differentMills / 1000.0f).setScale(0, 4));
                bePayInterfaceCostInfoNew.setPayStatus(BEpayInterfaceCostStatusEnum.PAYED);
            } else {
                bePayInterfaceCostInfoNew.setPayStatus(BEpayInterfaceCostStatusEnum.PAYING);
            }
            updateList.add((CoreBaseInfo)bePayInterfaceCostInfoNew);
        }
    }

    private void buildBeTimeInfo(PaymentDetail info, BEPayInterfaceCostInfo bePayInterfaceCostInfo) throws ParseException {
        if (null != info.getReserveds() && info.getReserveds().length > 0) {
            for (int i = 0; i < info.getReserveds().length; ++i) {
                Timestamp timestamp;
                long tempTime;
                String[] timeArr;
                String timeString = info.getReserveds()[i];
                if (!timeString.contains("=") || (timeArr = timeString.split("=")).length <= 1) continue;
                if (timeArr[0].equals(EAS_PAY_INSERT_TIME)) {
                    Date commitDateTime = ThreadLocalTimeUtil.parse(timeArr[1]);
                    tempTime = commitDateTime.getTime();
                    timestamp = new Timestamp(tempTime);
                    bePayInterfaceCostInfo.setResponseBETime(timestamp);
                }
                if (timeArr[0].equals(EAS_PAY_START_TIME)) {
                    Date sendTime = ThreadLocalTimeUtil.parse(timeArr[1]);
                    tempTime = sendTime.getTime();
                    timestamp = new Timestamp(tempTime);
                    bePayInterfaceCostInfo.setBESendTime(timestamp);
                }
                if (!timeArr[0].equals(EAS_PAY_END_TIME)) continue;
                Date receiveTime = ThreadLocalTimeUtil.parse(timeArr[1]);
                tempTime = receiveTime.getTime();
                timestamp = new Timestamp(tempTime);
                bePayInterfaceCostInfo.setBERecieveTime(timestamp);
            }
        }
    }
}

