/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebgateway.common.data.DataObject;
import com.kingdee.bos.ebgateway.common.data.DataPacker;
import com.kingdee.bos.ebgateway.common.data.DataParser;
import com.kingdee.bos.ebservice.BusinessRequest;
import com.kingdee.bos.ebservice.BusinessRequestBody;
import com.kingdee.bos.ebservice.BusinessResponse;
import com.kingdee.bos.ebservice.BusinessResponseBody;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.NameValuePair;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BECnapsData;
import com.kingdee.eas.fm.be.BECnapsDataWeb;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryCollection;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryInfo;
import com.kingdee.eas.fm.be.BankAgentPayBillInfo;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.BankLogTypeEnum;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankPayingStatusEnum;
import com.kingdee.eas.fm.be.BankTransDownBillEntryCollection;
import com.kingdee.eas.fm.be.BankTransDownBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransDownBillInfo;
import com.kingdee.eas.fm.be.BankTransUpBillEntryCollection;
import com.kingdee.eas.fm.be.BankTransUpBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransUpBillInfo;
import com.kingdee.eas.fm.be.BeOpenAreaData;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.IBankLogFacade;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.bean.BankLogBuildInfo;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class BusinessTollUtil
extends BaseEBGUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.service.BusinessTollUtil");

    public Map getAreaCode(Context ctx) throws EBGException {
        HashMap map = new HashMap();
        try {
            this.doGetAreaCode(ctx, null, null, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public Map getAreaCodeByProvince(Context ctx, ProvinceInfo province) throws Exception {
        HashMap map = new HashMap();
        try {
            EBGServiceUtil service = new EBGServiceUtil(ctx);
            BusinessResponse response = service.business(this.getAreaCodeRequest(ctx, null, null));
            EBException ex = response.getException();
            if (ex != null) {
                throw new Exception(ex.getMessage());
            }
            DataObject cnapsObject = null;
            BusinessResponseBody body = response.getBody();
            NameValuePair[] pairs = body.getDatas();
            DataParser parser = DataParser.getInstance(pairs);
            DataObject[] cnapsResults = parser.getDataObjects("areaCodeResult");
            if ("province".equalsIgnoreCase(parser.getProperty("type")) && cnapsResults != null) {
                for (int i = 0; i < cnapsResults.length; ++i) {
                    DataObject tmp = cnapsResults[i];
                    System.out.println(tmp.getProperty("areaName"));
                    if (EmptyUtil.isEmpty((String)tmp.getProperty("areaName")) || !tmp.getProperty("areaName").startsWith(province.getName())) continue;
                    cnapsObject = tmp;
                    break;
                }
            }
            this.doGetAreaCodeByProvince(ctx, parser, cnapsObject, map, cnapsObject.getProperty("areaName"), null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return map;
    }

    public Map getProvince(Context ctx) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            EBGServiceUtil service = new EBGServiceUtil(ctx);
            BusinessResponse response = service.business(this.getAreaCodeRequest(ctx, null, null));
            EBException ex = response.getException();
            if (ex != null) {
                throw new Exception(ex.getMessage());
            }
            BusinessResponseBody body = response.getBody();
            NameValuePair[] pairs = body.getDatas();
            DataParser parser = DataParser.getInstance(pairs);
            DataObject[] cnapsResults = parser.getDataObjects("areaCodeResult");
            if ("province".equalsIgnoreCase(parser.getProperty("type")) && cnapsResults != null) {
                for (int i = 0; i < cnapsResults.length; ++i) {
                    DataObject cnapsObject = cnapsResults[i];
                    if (EmptyUtil.isEmpty((String)cnapsObject.getProperty("areaCode")) || map.containsKey(cnapsObject.getProperty("areaCode"))) continue;
                    map.put(cnapsObject.getProperty("areaCode"), cnapsObject.getProperty("areaName"));
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return map;
    }

    public Map getCity(Context ctx, String provinceId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            EBGServiceUtil service = new EBGServiceUtil(ctx);
            NameValuePair[] pair = new NameValuePair[]{new NameValuePair("type", "province")};
            DataParser parserParam = DataParser.getInstance(pair);
            DataObject cnapsObjectParam = new DataObject();
            cnapsObjectParam.setProperty("areaCode", provinceId);
            BusinessResponse response = service.business(this.getAreaCodeRequest(ctx, parserParam, cnapsObjectParam));
            EBException ex = response.getException();
            if (ex != null) {
                throw new Exception(ex.getMessage());
            }
            BusinessResponseBody body = response.getBody();
            NameValuePair[] pairs = body.getDatas();
            DataParser parser = DataParser.getInstance(pairs);
            DataObject[] cnapsResults = parser.getDataObjects("areaCodeResult");
            if ("city".equalsIgnoreCase(parser.getProperty("type")) && cnapsResults != null) {
                for (int i = 0; i < cnapsResults.length; ++i) {
                    DataObject cnapsObject = cnapsResults[i];
                    if (EmptyUtil.isEmpty((String)cnapsObject.getProperty("areaCode")) || map.containsKey(cnapsObject.getProperty("areaCode"))) continue;
                    map.put(cnapsObject.getProperty("areaCode"), cnapsObject.getProperty("areaName"));
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return map;
    }

    private DataObject getOneUpdatePayStateDetail(Context ctx, BankPayingBillInfo info, BankPayingBillStateEnum toState) {
        DataObject ret = new DataObject();
        ret.setProperty("batchSeqID", info.getBatchSeqID());
        ret.setProperty("detailSeqID", info.getSerialNumber());
        ret.setProperty("ebStatus", this.trans2BeEnum(toState).getName());
        ret.setProperty("operator", ctx.getUserName());
        ret.setProperty("organizationName", info.getCompany().getName());
        ret.setProperty("updateReason", info.getReason());
        ret.setProperty("reserved1", ConvertUtils.IDSTR((Object)info));
        return ret;
    }

    private DataObject getOneUpdateAgentPayStateDetail(Context ctx, BankAgentPayBillInfo info, BankAgentPayBillEntryInfo entryInfo, BankPayingBillStateEnum toState) {
        DataObject ret = new DataObject();
        ret.setProperty("batchSeqID", info.getSerialNumber());
        ret.setProperty("detailSeqID", entryInfo.getSerialNumber());
        ret.setProperty("ebStatus", this.trans2BeEnum(toState).getName());
        ret.setProperty("operator", ctx.getUserName());
        ret.setProperty("organizationName", info.getCompany().getName());
        ret.setProperty("updateReason", entryInfo.getBankReturnInfo());
        ret.setProperty("reserved1", ConvertUtils.IDSTR((Object)entryInfo));
        return ret;
    }

    private DataObject getOneUpdateTransUpStateDetail(Context ctx, BankTransUpBillInfo info, BankTransUpBillEntryInfo entryInfo, BankPayingBillStateEnum toState) {
        DataObject ret = new DataObject();
        ret.setProperty("batchSeqID", entryInfo.getSerialNumber());
        ret.setProperty("detailSeqID", entryInfo.getSerialNumber());
        ret.setProperty("ebStatus", this.trans2BeEnum(toState).getName());
        ret.setProperty("operator", ctx.getUserName());
        ret.setProperty("organizationName", info.getCompany().getName());
        ret.setProperty("updateReason", entryInfo.getBankReturnInfo());
        ret.setProperty("reserved1", ConvertUtils.IDSTR((Object)entryInfo));
        return ret;
    }

    private DataObject getOneUpdateTransDownStateDetail(Context ctx, BankTransDownBillInfo info, BankTransDownBillEntryInfo entryInfo, BankPayingBillStateEnum toState) {
        DataObject ret = new DataObject();
        ret.setProperty("batchSeqID", info.getSerialNumber());
        ret.setProperty("detailSeqID", entryInfo.getSerialNumber());
        ret.setProperty("ebStatus", this.trans2BeEnum(toState).getName());
        ret.setProperty("operator", ctx.getUserName());
        ret.setProperty("organizationName", info.getCompany().getName());
        ret.setProperty("updateReason", entryInfo.getBankReturnInfo());
        ret.setProperty("reserved1", ConvertUtils.IDSTR((Object)entryInfo));
        return ret;
    }

    private BusinessRequest getUpdatePayStateRequest(Context ctx) {
        BusinessRequest request = new BusinessRequest();
        EBHeader header = super.parseHeader(ctx);
        header.setAccNo("123456");
        header.setClientVersion("EAS7.0");
        header.setRequestTime(this.format(new Date(), "yyyyMMddHHmmss"));
        header.setCurrency("CNY");
        header.setBizType("updatepaystate");
        header.setSubBizType("pay");
        header.setOperationName("business");
        request.setHeader(header);
        BusinessRequestBody body = new BusinessRequestBody();
        request.setBody(body);
        return request;
    }

    private BankPayingStatusEnum trans2BeEnum(BankPayingBillStateEnum state) {
        if (state == BankPayingBillStateEnum.TS) {
            return BankPayingStatusEnum.BANK_SUCCESS;
        }
        return BankPayingStatusEnum.BANK_FAIL;
    }

    private BankLogTypeEnum getBankLogType(BankPayingBillInfo info) {
        BankLogTypeEnum bankType = info.isIsLinkPay() ? BankLogTypeEnum.linkPayment : (info.isIsPersonPay() ? BankLogTypeEnum.privatePay : BankLogTypeEnum.Pay);
        return bankType;
    }

    private Map setValue2All(Map out, BankPayingBillCollection infos, String key, Object value) {
        for (int i = 0; i < infos.size(); ++i) {
            BankPayingBillInfo info = infos.get(i);
            this.setOneValue(out, info, key, value);
        }
        return out;
    }

    private Map setAgentPayValue2All(Map out, BankAgentPayBillEntryCollection col, String key, Object value) {
        for (int i = 0; i < col.size(); ++i) {
            BankAgentPayBillEntryInfo info = col.get(i);
            this.setOneAgentPayValue(out, info, key, value);
        }
        return out;
    }

    private Map setOneAgentPayValue(Map out, BankAgentPayBillEntryInfo info, String key, Object value) {
        Map oneEntry = (Map)out.get(ConvertUtils.STR((Object)info.getId()));
        if (oneEntry != null) {
            oneEntry.put(key, value);
        }
        return out;
    }

    private Map setOneValue(Map out, BankPayingBillInfo info, String key, Object value) {
        Map oneEntry = (Map)out.get(ConvertUtils.STR((Object)info.getId()));
        if (oneEntry != null) {
            oneEntry.put(key, value);
        }
        return out;
    }

    private Map setOneTransUpValue(Map out, BankTransUpBillEntryInfo info, String key, Object value) {
        Map oneEntry = (Map)out.get(ConvertUtils.STR((Object)info.getId()));
        if (oneEntry != null) {
            oneEntry.put(key, value);
        }
        return out;
    }

    private Map setOneTransUpValue2All(Map out, BankTransUpBillEntryCollection col, String key, Object value) {
        for (int i = 0; i < col.size(); ++i) {
            BankTransUpBillEntryInfo info = col.get(i);
            this.setOneTransUpValue(out, info, key, value);
        }
        return out;
    }

    private Map setOneTransDownValue(Map out, BankTransDownBillEntryInfo info, String key, Object value) {
        Map oneEntry = (Map)out.get(ConvertUtils.STR((Object)info.getId()));
        if (oneEntry != null) {
            oneEntry.put(key, value);
        }
        return out;
    }

    private Map setOneTransDownValue2All(Map out, BankTransDownBillEntryCollection col, String key, Object value) {
        for (int i = 0; i < col.size(); ++i) {
            BankTransDownBillEntryInfo info = col.get(i);
            this.setOneTransDownValue(out, info, key, value);
        }
        return out;
    }

    public Map UpdatePayState2EBS(Context ctx, BankPayingBillCollection infos, BankPayingBillStateEnum state) {
        BusinessResponse response;
        EBGServiceUtil service;
        Map out = ConvertUtils.JSMAP((Object[])new Object[0]);
        for (int i = 0; i < infos.size(); ++i) {
            BankPayingBillInfo info = infos.get(i);
            ConvertUtils.JSMAP((Map)out, (Object[])new Object[]{ConvertUtils.STR((Object)info.getId()), ConvertUtils.JSMAP((Object[])new Object[]{"logpk", null, "submit2EBS", false, "errorMsg", "", "result", "FAIL", "state", info.getState()})});
        }
        try {
            service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, infos.get(0).getCompany().getId().toString());
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return this.setValue2All(out, infos, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        catch (BOSException e) {
            e.printStackTrace();
            return this.setValue2All(out, infos, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return this.setValue2All(out, infos, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        IBankLogFacade iLogBiz = null;
        BusinessRequest request = null;
        try {
            iLogBiz = BankLogFacadeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return this.setValue2All(out, infos, "errorMsg", "\u83b7\u53d6BankLogFacade\u4e1a\u52a1\u63a5\u53e3\u51fa\u9519");
        }
        List detialEntrys = ConvertUtils.JSLIST((Object[])new Object[0]);
        Map logBatchMap = ConvertUtils.JSMAP((Object[])new Object[0]);
        for (int i = 0; i < infos.size(); ++i) {
            BankPayingBillInfo info = infos.get(i);
            try {
                DataObject detailObj = this.getOneUpdatePayStateDetail(ctx, info, state);
                request = this.getUpdatePayStateRequest(ctx);
                DataPacker packer = new DataPacker();
                packer.setDataObject("paystates", detailObj);
                request.getBody().setDatas(packer.pack());
                String[] payAcnt = new String[]{info.getPayAccountBank().getBankAccountNumber()};
                String[] payeeAcnt = new String[]{info.getRecAccountBank()};
                BankLogTypeEnum bankType = BankLogTypeEnum.syncBankPayBill;
                BankLogBuildInfo build = new BankLogBuildInfo();
                build.setPayAcnt(payAcnt);
                build.setPayeeAcnt(payeeAcnt);
                build.setLogType(bankType);
                build.setCompany(info.getCompany());
                build.setBankInterFaceID(info.getPayAccountBank().getBankInterFaceID());
                build.setBankInterFace(info.getPayAccountBank().getBankInterFace());
                build.setPayBillId(ConvertUtils.IDSTR((Object)info));
                build.setSourceBillId(ConvertUtils.IDSTR((Object)info));
                IObjectPK logpk = iLogBiz.buildBaseMessage(build);
                iLogBiz.buildRequest(logpk, request);
                this.setOneValue(out, info, "logpk", logpk);
                detialEntrys.add(detailObj);
                logBatchMap.put(info.getSerialNumber(), logpk);
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                this.setOneValue(out, info, "errMsg", "\u6784\u9020\u5355\u6761\u6570\u636e\u7684\u62a5\u6587\u8bb0\u5f55\u548c\u65e5\u5fd7\u51fa\u9519");
            }
        }
        if (CheckUtils.isEmpty((Object)detialEntrys)) {
            return out;
        }
        try {
            request = this.getUpdatePayStateRequest(ctx);
            DataObject[] details = (DataObject[])ConvertUtils.ARRAY((Object)detialEntrys, DataObject.class);
            DataPacker packer = new DataPacker();
            packer.setDataObjects("paystates", details);
            request.getBody().setDatas(packer.pack());
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, e, 0);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return this.setValue2All(out, infos, "errorMsg", "\u6784\u9020\u66f4\u65b0\u62a5\u6587\u4f53\u51fa\u9519");
        }
        try {
            response = service.business(request);
            this.setValue2All(out, infos, "submit2EBS", true);
            try {
                iLogBiz.buildResponseBatch(logBatchMap, response);
            }
            catch (Exception e1) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, e, 1);
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (e.getCause() instanceof ConnectException) {
                return this.setValue2All(out, infos, "errorMsg", "\u94fe\u63a5EBS\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5EBS\u914d\u7f6e\uff0cEBS\u662f\u5426\u5f00\u542f");
            }
            return this.setValue2All(out, infos, "errorMsg", "\u8c03\u7528EBS-[\u4fee\u6539\u5355\u636e\u72b6\u6001UpdatePayState]\u6307\u4ee4\u51fa\u9519,\u8bf7\u624b\u5de5\u6267\u884c\u4e00\u6b21\u3010\u540c\u6b65\u72b6\u6001\u3011");
        }
        String errorMsg = "";
        if (CheckUtils.exist((Object)response.getException())) {
            errorMsg = "EBS\u6267\u884c\u6307\u4ee4UpdatePayState\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a" + response.getException().getMessage();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, new Exception(errorMsg), 1);
            }
            catch (Exception e2) {
                // empty catch block
            }
            return this.setValue2All(out, infos, "errorMsg", errorMsg);
        }
        BusinessResponseBody body = response.getBody();
        DataObject[] retDetails = null;
        if (body == null || body.getDatas() == null || CheckUtils.isEmpty((Object)(retDetails = DataParser.getInstance(body.getDatas()).getDataObjects("paystates")))) {
            errorMsg = "EBS\u8fd4\u56de\u4fe1\u606f\u4f53\u6570\u636ebody-datas-NameValuePair\u4e0d\u6b63\u786e";
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, new Exception(errorMsg), 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.setValue2All(out, infos, "errorMsg", errorMsg);
        }
        for (DataObject retEntry : retDetails) {
            String retID = retEntry.getProperty("reserved1");
            BankPayingBillInfo info = (BankPayingBillInfo)CheckUtils.find((Object)((Object)infos), (Object)retID);
            if (CheckUtils.same((Object)"SUCCESS", (Object)retEntry.getProperty("updateStatus"))) {
                this.setOneValue(out, info, "result", "SUCCESS");
            } else if (retEntry.getProperty("updateStatusMsg").startsWith("\u94f6\u4f01\u5e73\u53f0\u4e2d\u4e0d\u5305\u542b\u6279\u6b21\u53f7")) {
                this.setOneValue(out, info, "result", "SUCCESS");
            } else {
                errorMsg = "EBS\u8fd4\u56de\u4fe1\u606f\u4e3a:" + retEntry.getProperty("updateStatusMsg") + ",\u8bf7\u624b\u5de5\u6267\u884c\u4e00\u6b21\u3010\u540c\u6b65\u72b6\u6001\u3011";
                try {
                    Map entry = (Map)out.get(ConvertUtils.IDSTR((Object)info));
                    iLogBiz.buildException(ConvertUtils.PK(entry.get("logpk")), new Exception(errorMsg), 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setOneValue(out, info, "errorMsg", errorMsg);
            }
            this.setOneValue(out, info, "state", retEntry.getProperty("updateStatus"));
        }
        return out;
    }

    public Map UpdateAgnetPayState2EBS(Context ctx, BankAgentPayBillInfo info, BankAgentPayBillEntryCollection entryCol, BankPayingBillStateEnum state) {
        BusinessResponse response;
        EBGServiceUtil service;
        Map out = ConvertUtils.JSMAP((Object[])new Object[0]);
        for (int i = 0; i < entryCol.size(); ++i) {
            BankAgentPayBillEntryInfo entryInfo = entryCol.get(i);
            ConvertUtils.JSMAP((Map)out, (Object[])new Object[]{ConvertUtils.STR((Object)entryInfo.getId()), ConvertUtils.JSMAP((Object[])new Object[]{"logpk", null, "submit2EBS", false, "errorMsg", "", "result", "FAIL", "state", entryInfo.getState()})});
        }
        try {
            service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, info.getCompany().getId().toString());
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return this.setAgentPayValue2All(out, entryCol, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        catch (BOSException e) {
            e.printStackTrace();
            return this.setAgentPayValue2All(out, entryCol, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return this.setAgentPayValue2All(out, entryCol, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        IBankLogFacade iLogBiz = null;
        BusinessRequest request = null;
        try {
            iLogBiz = BankLogFacadeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return this.setAgentPayValue2All(out, entryCol, "errorMsg", "\u83b7\u53d6BankLogFacade\u4e1a\u52a1\u63a5\u53e3\u51fa\u9519");
        }
        List detialEntrys = ConvertUtils.JSLIST((Object[])new Object[0]);
        Map logBatchMap = ConvertUtils.JSMAP((Object[])new Object[0]);
        for (int i = 0; i < entryCol.size(); ++i) {
            BankAgentPayBillEntryInfo entryInfo = entryCol.get(i);
            try {
                DataObject detailObj = this.getOneUpdateAgentPayStateDetail(ctx, info, entryInfo, state);
                request = this.getUpdatePayStateRequest(ctx);
                DataPacker packer = new DataPacker();
                packer.setDataObject("paystates", detailObj);
                request.getBody().setDatas(packer.pack());
                String[] payAcnt = new String[]{info.getPayAccountBank().getBankAccountNumber()};
                String[] payeeAcnt = new String[]{entryInfo.getRecBankAccount()};
                BankLogTypeEnum bankType = BankLogTypeEnum.syncAgentPayBill;
                BankLogBuildInfo build = new BankLogBuildInfo();
                build.setPayAcnt(payAcnt);
                build.setPayeeAcnt(payeeAcnt);
                build.setLogType(bankType);
                build.setCompany(info.getCompany());
                build.setBankInterFaceID(info.getPayAccountBank().getBankInterFaceID());
                build.setBankInterFace(info.getPayAccountBank().getBankInterFace());
                build.setPayBillId(ConvertUtils.IDSTR((Object)entryInfo));
                build.setSourceBillId(ConvertUtils.IDSTR((Object)entryInfo));
                IObjectPK logpk = iLogBiz.buildBaseMessage(build);
                iLogBiz.buildRequest(logpk, request);
                this.setOneAgentPayValue(out, entryInfo, "logpk", logpk);
                detialEntrys.add(detailObj);
                logBatchMap.put(entryInfo.getSerialNumber(), logpk);
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                this.setOneAgentPayValue(out, entryInfo, "errMsg", "\u6784\u9020\u5355\u6761\u6570\u636e\u7684\u62a5\u6587\u8bb0\u5f55\u548c\u65e5\u5fd7\u51fa\u9519");
            }
        }
        if (CheckUtils.isEmpty((Object)detialEntrys)) {
            return out;
        }
        try {
            request = this.getUpdatePayStateRequest(ctx);
            DataObject[] details = (DataObject[])ConvertUtils.ARRAY((Object)detialEntrys, DataObject.class);
            DataPacker packer = new DataPacker();
            packer.setDataObjects("paystates", details);
            request.getBody().setDatas(packer.pack());
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, e, 0);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return this.setAgentPayValue2All(out, entryCol, "errorMsg", "\u6784\u9020\u66f4\u65b0\u62a5\u6587\u4f53\u51fa\u9519");
        }
        try {
            response = service.business(request);
            this.setAgentPayValue2All(out, entryCol, "submit2EBS", true);
            try {
                iLogBiz.buildResponseBatch(logBatchMap, response);
            }
            catch (Exception e1) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, e, 1);
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (e.getCause() instanceof ConnectException) {
                return this.setAgentPayValue2All(out, entryCol, "errorMsg", "\u94fe\u63a5EBS\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5EBS\u914d\u7f6e\uff0cEBS\u662f\u5426\u5f00\u542f");
            }
            return this.setAgentPayValue2All(out, entryCol, "errorMsg", "\u8c03\u7528EBS-[\u4fee\u6539\u5355\u636e\u72b6\u6001UpdatePayState]\u6307\u4ee4\u51fa\u9519,\u8bf7\u624b\u5de5\u6267\u884c\u4e00\u6b21\u3010\u540c\u6b65\u72b6\u6001\u3011");
        }
        String errorMsg = "";
        if (CheckUtils.exist((Object)response.getException())) {
            errorMsg = "EBS\u6267\u884c\u6307\u4ee4UpdatePayState\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a" + response.getException().getMessage();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, new Exception(errorMsg), 1);
            }
            catch (Exception e2) {
                // empty catch block
            }
            return this.setAgentPayValue2All(out, entryCol, "errorMsg", errorMsg);
        }
        BusinessResponseBody body = response.getBody();
        DataObject[] retDetails = null;
        if (body == null || body.getDatas() == null || CheckUtils.isEmpty((Object)(retDetails = DataParser.getInstance(body.getDatas()).getDataObjects("paystates")))) {
            errorMsg = "EBS\u8fd4\u56de\u4fe1\u606f\u4f53\u6570\u636ebody-datas-NameValuePair\u4e0d\u6b63\u786e";
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, new Exception(errorMsg), 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.setAgentPayValue2All(out, entryCol, "errorMsg", errorMsg);
        }
        for (DataObject retEntry : retDetails) {
            String retID = retEntry.getProperty("reserved1");
            BankAgentPayBillEntryInfo entryInfo = (BankAgentPayBillEntryInfo)CheckUtils.find((Object)((Object)entryCol), (Object)retID);
            if (CheckUtils.same((Object)"SUCCESS", (Object)retEntry.getProperty("updateStatus"))) {
                this.setOneAgentPayValue(out, entryInfo, "result", "SUCCESS");
            } else if (retEntry.getProperty("updateStatusMsg").startsWith("\u94f6\u4f01\u5e73\u53f0\u4e2d\u4e0d\u5305\u542b\u6279\u6b21\u53f7")) {
                this.setOneAgentPayValue(out, entryInfo, "result", "SUCCESS");
            } else {
                errorMsg = "EBS\u8fd4\u56de\u4fe1\u606f\u4e3a:" + retEntry.getProperty("updateStatusMsg") + ",\u8bf7\u624b\u5de5\u6267\u884c\u4e00\u6b21\u3010\u540c\u6b65\u72b6\u6001\u3011";
                try {
                    Map entry = (Map)out.get(ConvertUtils.IDSTR((Object)entryInfo));
                    iLogBiz.buildException(ConvertUtils.PK(entry.get("logpk")), new Exception(errorMsg), 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setOneAgentPayValue(out, entryInfo, "errorMsg", errorMsg);
            }
            this.setOneAgentPayValue(out, entryInfo, "state", retEntry.getProperty("updateStatus"));
        }
        return out;
    }

    public Map updateTransUpState2EBS(Context ctx, BankTransUpBillInfo info, BankTransUpBillEntryCollection entryCol, BankPayingBillStateEnum state) {
        BusinessResponse response;
        EBGServiceUtil service;
        Map out = ConvertUtils.JSMAP((Object[])new Object[0]);
        for (int i = 0; i < entryCol.size(); ++i) {
            BankTransUpBillEntryInfo entryInfo = entryCol.get(i);
            ConvertUtils.JSMAP((Map)out, (Object[])new Object[]{ConvertUtils.STR((Object)entryInfo.getId()), ConvertUtils.JSMAP((Object[])new Object[]{"logpk", null, "submit2EBS", false, "errorMsg", "", "result", "FAIL", "state", entryInfo.getState()})});
        }
        try {
            service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, info.getCompany().getId().toString());
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return this.setOneTransUpValue2All(out, entryCol, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        catch (BOSException e) {
            e.printStackTrace();
            return this.setOneTransUpValue2All(out, entryCol, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return this.setOneTransUpValue2All(out, entryCol, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        IBankLogFacade iLogBiz = null;
        BusinessRequest request = null;
        try {
            iLogBiz = BankLogFacadeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return this.setOneTransUpValue2All(out, entryCol, "errorMsg", "\u83b7\u53d6BankLogFacade\u4e1a\u52a1\u63a5\u53e3\u51fa\u9519");
        }
        List detialEntrys = ConvertUtils.JSLIST((Object[])new Object[0]);
        Map logBatchMap = ConvertUtils.JSMAP((Object[])new Object[0]);
        for (int i = 0; i < entryCol.size(); ++i) {
            BankTransUpBillEntryInfo entryInfo = entryCol.get(i);
            try {
                DataObject detailObj = this.getOneUpdateTransUpStateDetail(ctx, info, entryInfo, state);
                request = this.getUpdatePayStateRequest(ctx);
                DataPacker packer = new DataPacker();
                packer.setDataObject("paystates", detailObj);
                request.getBody().setDatas(packer.pack());
                String[] payAcnt = new String[]{entryInfo.getUnitAcctBank().getBankAccountNumber()};
                String[] payeeAcnt = new String[]{info.getMotherAcctBank().getBankAccountNumber()};
                BankLogTypeEnum bankType = BankLogTypeEnum.fundTransferState;
                BankLogBuildInfo build = new BankLogBuildInfo();
                build.setPayAcnt(payAcnt);
                build.setPayeeAcnt(payeeAcnt);
                build.setLogType(bankType);
                build.setCompany(info.getCompany());
                build.setBankInterFaceID(entryInfo.getUnitAcctBank().getBankInterFaceID());
                build.setBankInterFace(entryInfo.getUnitAcctBank().getBankInterFace());
                build.setPayBillId(ConvertUtils.IDSTR((Object)entryInfo));
                build.setSourceBillId(ConvertUtils.IDSTR((Object)entryInfo));
                IObjectPK logpk = iLogBiz.buildBaseMessage(build);
                iLogBiz.buildRequest(logpk, request);
                this.setOneTransUpValue(out, entryInfo, "logpk", logpk);
                detialEntrys.add(detailObj);
                logBatchMap.put(entryInfo.getSerialNumber(), logpk);
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                this.setOneTransUpValue(out, entryInfo, "errMsg", "\u6784\u9020\u5355\u6761\u6570\u636e\u7684\u62a5\u6587\u8bb0\u5f55\u548c\u65e5\u5fd7\u51fa\u9519");
            }
        }
        if (CheckUtils.isEmpty((Object)detialEntrys)) {
            return out;
        }
        try {
            request = this.getUpdatePayStateRequest(ctx);
            DataObject[] details = (DataObject[])ConvertUtils.ARRAY((Object)detialEntrys, DataObject.class);
            DataPacker packer = new DataPacker();
            packer.setDataObjects("paystates", details);
            request.getBody().setDatas(packer.pack());
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, e, 0);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return this.setOneTransUpValue2All(out, entryCol, "errorMsg", "\u6784\u9020\u66f4\u65b0\u62a5\u6587\u4f53\u51fa\u9519");
        }
        try {
            response = service.business(request);
            this.setOneTransUpValue2All(out, entryCol, "submit2EBS", true);
            try {
                iLogBiz.buildResponseBatch(logBatchMap, response);
            }
            catch (Exception e1) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, e, 1);
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (e.getCause() instanceof ConnectException) {
                return this.setOneTransUpValue2All(out, entryCol, "errorMsg", "\u94fe\u63a5EBS\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5EBS\u914d\u7f6e\uff0cEBS\u662f\u5426\u5f00\u542f");
            }
            return this.setOneTransUpValue2All(out, entryCol, "errorMsg", "\u8c03\u7528EBS-[\u4fee\u6539\u5355\u636e\u72b6\u6001UpdatePayState]\u6307\u4ee4\u51fa\u9519,\u8bf7\u624b\u5de5\u6267\u884c\u4e00\u6b21\u3010\u540c\u6b65\u72b6\u6001\u3011");
        }
        String errorMsg = "";
        if (CheckUtils.exist((Object)response.getException())) {
            errorMsg = "EBS\u6267\u884c\u6307\u4ee4UpdatePayState\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a" + response.getException().getMessage();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, new Exception(errorMsg), 1);
            }
            catch (Exception e2) {
                // empty catch block
            }
            return this.setOneTransUpValue2All(out, entryCol, "errorMsg", errorMsg);
        }
        BusinessResponseBody body = response.getBody();
        DataObject[] retDetails = null;
        if (body == null || body.getDatas() == null || CheckUtils.isEmpty((Object)(retDetails = DataParser.getInstance(body.getDatas()).getDataObjects("paystates")))) {
            errorMsg = "EBS\u8fd4\u56de\u4fe1\u606f\u4f53\u6570\u636ebody-datas-NameValuePair\u4e0d\u6b63\u786e";
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, new Exception(errorMsg), 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.setOneTransUpValue2All(out, entryCol, "errorMsg", errorMsg);
        }
        for (DataObject retEntry : retDetails) {
            String retID = retEntry.getProperty("reserved1");
            BankTransUpBillEntryInfo entryInfo = (BankTransUpBillEntryInfo)CheckUtils.find((Object)((Object)entryCol), (Object)retID);
            if (CheckUtils.same((Object)"SUCCESS", (Object)retEntry.getProperty("updateStatus"))) {
                this.setOneTransUpValue(out, entryInfo, "result", "SUCCESS");
            } else if (retEntry.getProperty("updateStatusMsg").startsWith("\u94f6\u4f01\u5e73\u53f0\u4e2d\u4e0d\u5305\u542b\u6279\u6b21\u53f7")) {
                this.setOneTransUpValue(out, entryInfo, "result", "SUCCESS");
            } else {
                errorMsg = "EBS\u8fd4\u56de\u4fe1\u606f\u4e3a:" + retEntry.getProperty("updateStatusMsg") + ",\u8bf7\u624b\u5de5\u6267\u884c\u4e00\u6b21\u3010\u540c\u6b65\u72b6\u6001\u3011";
                try {
                    Map entry = (Map)out.get(ConvertUtils.IDSTR((Object)entryInfo));
                    iLogBiz.buildException(ConvertUtils.PK(entry.get("logpk")), new Exception(errorMsg), 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setOneTransUpValue(out, entryInfo, "errorMsg", errorMsg);
            }
            this.setOneTransUpValue(out, entryInfo, "state", retEntry.getProperty("updateStatus"));
        }
        return out;
    }

    public Map updateTransDownState2EBS(Context ctx, BankTransDownBillInfo info, BankTransDownBillEntryCollection entryCol, BankPayingBillStateEnum state) {
        BusinessResponse response;
        EBGServiceUtil service;
        Map out = ConvertUtils.JSMAP((Object[])new Object[0]);
        for (int i = 0; i < entryCol.size(); ++i) {
            BankTransDownBillEntryInfo entryInfo = entryCol.get(i);
            ConvertUtils.JSMAP((Map)out, (Object[])new Object[]{ConvertUtils.STR((Object)entryInfo.getId()), ConvertUtils.JSMAP((Object[])new Object[]{"logpk", null, "submit2EBS", false, "errorMsg", "", "result", "FAIL", "state", entryInfo.getState()})});
        }
        try {
            service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, info.getCompany().getId().toString());
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return this.setOneTransDownValue2All(out, entryCol, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        catch (BOSException e) {
            e.printStackTrace();
            return this.setOneTransDownValue2All(out, entryCol, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return this.setOneTransDownValue2All(out, entryCol, "errorMsg", "\u6784\u9020EBGService\u51fa\u9519");
        }
        IBankLogFacade iLogBiz = null;
        BusinessRequest request = null;
        try {
            iLogBiz = BankLogFacadeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return this.setOneTransDownValue2All(out, entryCol, "errorMsg", "\u83b7\u53d6BankLogFacade\u4e1a\u52a1\u63a5\u53e3\u51fa\u9519");
        }
        List detialEntrys = ConvertUtils.JSLIST((Object[])new Object[0]);
        Map logBatchMap = ConvertUtils.JSMAP((Object[])new Object[0]);
        for (int i = 0; i < entryCol.size(); ++i) {
            BankTransDownBillEntryInfo entryInfo = entryCol.get(i);
            try {
                DataObject detailObj = this.getOneUpdateTransDownStateDetail(ctx, info, entryInfo, state);
                request = this.getUpdatePayStateRequest(ctx);
                DataPacker packer = new DataPacker();
                packer.setDataObject("paystates", detailObj);
                request.getBody().setDatas(packer.pack());
                String[] payAcnt = new String[]{info.getMotherAcctBank().getBankAccountNumber()};
                String[] payeeAcnt = new String[]{entryInfo.getUnitAcctBank().getBankAccountNumber()};
                BankLogTypeEnum bankType = BankLogTypeEnum.fundTransferState;
                BankLogBuildInfo build = new BankLogBuildInfo();
                build.setPayAcnt(payAcnt);
                build.setPayeeAcnt(payeeAcnt);
                build.setLogType(bankType);
                build.setCompany(info.getCompany());
                build.setBankInterFaceID(info.getMotherAcctBank().getBankInterFaceID());
                build.setBankInterFace(info.getMotherAcctBank().getBankInterFace());
                build.setPayBillId(ConvertUtils.IDSTR((Object)entryInfo));
                build.setSourceBillId(ConvertUtils.IDSTR((Object)entryInfo));
                IObjectPK logpk = iLogBiz.buildBaseMessage(build);
                iLogBiz.buildRequest(logpk, request);
                this.setOneTransDownValue(out, entryInfo, "logpk", logpk);
                detialEntrys.add(detailObj);
                logBatchMap.put(entryInfo.getSerialNumber(), logpk);
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                this.setOneTransDownValue(out, entryInfo, "errMsg", "\u6784\u9020\u5355\u6761\u6570\u636e\u7684\u62a5\u6587\u8bb0\u5f55\u548c\u65e5\u5fd7\u51fa\u9519");
            }
        }
        if (CheckUtils.isEmpty((Object)detialEntrys)) {
            return out;
        }
        try {
            request = this.getUpdatePayStateRequest(ctx);
            DataObject[] details = (DataObject[])ConvertUtils.ARRAY((Object)detialEntrys, DataObject.class);
            DataPacker packer = new DataPacker();
            packer.setDataObjects("paystates", details);
            request.getBody().setDatas(packer.pack());
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, e, 0);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return this.setOneTransDownValue2All(out, entryCol, "errorMsg", "\u6784\u9020\u66f4\u65b0\u62a5\u6587\u4f53\u51fa\u9519");
        }
        try {
            response = service.business(request);
            this.setOneTransDownValue2All(out, entryCol, "submit2EBS", true);
            try {
                iLogBiz.buildResponseBatch(logBatchMap, response);
            }
            catch (Exception e1) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, e, 1);
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (e.getCause() instanceof ConnectException) {
                return this.setOneTransDownValue2All(out, entryCol, "errorMsg", "\u94fe\u63a5EBS\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5EBS\u914d\u7f6e\uff0cEBS\u662f\u5426\u5f00\u542f");
            }
            return this.setOneTransDownValue2All(out, entryCol, "errorMsg", "\u8c03\u7528EBS-[\u4fee\u6539\u5355\u636e\u72b6\u6001UpdatePayState]\u6307\u4ee4\u51fa\u9519,\u8bf7\u624b\u5de5\u6267\u884c\u4e00\u6b21\u3010\u540c\u6b65\u72b6\u6001\u3011");
        }
        String errorMsg = "";
        if (CheckUtils.exist((Object)response.getException())) {
            errorMsg = "EBS\u6267\u884c\u6307\u4ee4UpdatePayState\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a" + response.getException().getMessage();
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, new Exception(errorMsg), 1);
            }
            catch (Exception e2) {
                // empty catch block
            }
            return this.setOneTransDownValue2All(out, entryCol, "errorMsg", errorMsg);
        }
        BusinessResponseBody body = response.getBody();
        DataObject[] retDetails = null;
        if (body == null || body.getDatas() == null || CheckUtils.isEmpty((Object)(retDetails = DataParser.getInstance(body.getDatas()).getDataObjects("paystates")))) {
            errorMsg = "EBS\u8fd4\u56de\u4fe1\u606f\u4f53\u6570\u636ebody-datas-NameValuePair\u4e0d\u6b63\u786e";
            try {
                iLogBiz.buildExceptionBatch(logBatchMap, new Exception(errorMsg), 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.setOneTransDownValue2All(out, entryCol, "errorMsg", errorMsg);
        }
        for (DataObject retEntry : retDetails) {
            String retID = retEntry.getProperty("reserved1");
            BankTransDownBillEntryInfo entryInfo = (BankTransDownBillEntryInfo)CheckUtils.find((Object)((Object)entryCol), (Object)retID);
            if (CheckUtils.same((Object)"SUCCESS", (Object)retEntry.getProperty("updateStatus"))) {
                this.setOneTransDownValue(out, entryInfo, "result", "SUCCESS");
            } else if (retEntry.getProperty("updateStatusMsg").startsWith("\u94f6\u4f01\u5e73\u53f0\u4e2d\u4e0d\u5305\u542b\u6279\u6b21\u53f7")) {
                this.setOneTransDownValue(out, entryInfo, "result", "SUCCESS");
            } else {
                errorMsg = "EBS\u8fd4\u56de\u4fe1\u606f\u4e3a:" + retEntry.getProperty("updateStatusMsg") + ",\u8bf7\u624b\u5de5\u6267\u884c\u4e00\u6b21\u3010\u540c\u6b65\u72b6\u6001\u3011";
                try {
                    Map entry = (Map)out.get(ConvertUtils.IDSTR((Object)entryInfo));
                    iLogBiz.buildException(ConvertUtils.PK(entry.get("logpk")), new Exception(errorMsg), 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setOneTransDownValue(out, entryInfo, "errorMsg", errorMsg);
            }
            this.setOneTransDownValue(out, entryInfo, "state", retEntry.getProperty("updateStatus"));
        }
        return out;
    }

    private Exception EBException2Exception(EBException e) {
        Exception ne = new Exception(e.getMessage());
        return ne;
    }

    public Map getArea(Context ctx, String cityCode) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            EBGServiceUtil service = new EBGServiceUtil(ctx);
            NameValuePair[] pair = new NameValuePair[]{new NameValuePair("type", "city")};
            DataParser parserParam = DataParser.getInstance(pair);
            DataObject cnapsObjectParam = new DataObject();
            cnapsObjectParam.setProperty("areaCode", cityCode);
            BusinessResponse response = service.business(this.getAreaCodeRequest(ctx, parserParam, cnapsObjectParam));
            EBException ex = response.getException();
            if (ex != null) {
                throw new Exception(ex.getMessage());
            }
            BusinessResponseBody body = response.getBody();
            NameValuePair[] pairs = body.getDatas();
            DataParser parser = DataParser.getInstance(pairs);
            DataObject[] cnapsResults = parser.getDataObjects("areaCodeResult");
            if ("area".equalsIgnoreCase(parser.getProperty("type")) && cnapsResults != null) {
                for (int i = 0; i < cnapsResults.length; ++i) {
                    DataObject cnapsObject = cnapsResults[i];
                    if (EmptyUtil.isEmpty((String)cnapsObject.getProperty("areaCode")) || map.containsKey(cnapsObject.getProperty("areaCode"))) continue;
                    map.put(cnapsObject.getProperty("areaCode"), cnapsObject.getProperty("areaName"));
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return map;
    }

    private void doGetAreaCodeByProvince(Context ctx, DataParser parserParam, DataObject cnapsObjectParam, Map map, String province, String city) {
        try {
            EBGServiceUtil service = new EBGServiceUtil(ctx);
            BusinessResponse response = service.business(this.getAreaCodeRequest(ctx, parserParam, cnapsObjectParam));
            EBException ex = response.getException();
            if (ex != null) {
                throw new Exception(ex.getMessage());
            }
            BusinessResponseBody body = response.getBody();
            NameValuePair[] pairs = body.getDatas();
            DataParser parser = DataParser.getInstance(pairs);
            DataObject[] cnapsResults = parser.getDataObjects("areaCodeResult");
            if ("area".equalsIgnoreCase(parser.getProperty("type"))) {
                if (cnapsResults != null) {
                    for (int i = 0; i < cnapsResults.length; ++i) {
                        DataObject cnapsObject = cnapsResults[i];
                        if (EmptyUtil.isEmpty((String)cnapsObject.getProperty("areaCode")) || map.containsKey(cnapsObject.getProperty("areaCode"))) continue;
                        BeOpenAreaData data = new BeOpenAreaData();
                        data.setAreaCode(cnapsObject.getProperty("areaCode"));
                        data.setProvince(province);
                        data.setCity(city);
                        data.setAreaCodeName(cnapsObject.getProperty("areaName"));
                        map.put(cnapsObject.getProperty("areaCode"), data);
                    }
                }
            } else if ("city".equalsIgnoreCase(parser.getProperty("type")) && cnapsResults != null) {
                for (int i = 0; i < cnapsResults.length; ++i) {
                    DataObject cnapsObject = cnapsResults[i];
                    this.doGetAreaCodeByProvince(ctx, parser, cnapsObject, map, province, cnapsObject.getProperty("areaName"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doGetAreaCode(Context ctx, DataParser parserParam, DataObject cnapsObjectParam, Map map) {
        try {
            EBGServiceUtil service = new EBGServiceUtil(ctx);
            BusinessResponse response = service.business(this.getAreaCodeRequest(ctx, parserParam, cnapsObjectParam));
            EBException ex = response.getException();
            if (ex != null) {
                throw new Exception(ex.getMessage());
            }
            BusinessResponseBody body = response.getBody();
            NameValuePair[] pairs = body.getDatas();
            DataParser parser = DataParser.getInstance(pairs);
            DataObject[] cnapsResults = parser.getDataObjects("areaCodeResult");
            if ("area".equalsIgnoreCase(parser.getProperty("type"))) {
                if (cnapsResults != null) {
                    for (int i = 0; i < cnapsResults.length; ++i) {
                        DataObject cnapsObject = cnapsResults[i];
                        if (EmptyUtil.isEmpty((String)cnapsObject.getProperty("areaCode")) || map.containsKey(cnapsObject.getProperty("areaCode"))) continue;
                        map.put(cnapsObject.getProperty("areaCode"), cnapsObject.getProperty("areaName"));
                    }
                }
            } else if (cnapsResults != null) {
                for (int i = 0; i < cnapsResults.length; ++i) {
                    DataObject cnapsObject = cnapsResults[i];
                    this.doGetAreaCode(ctx, parser, cnapsObject, map);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BusinessRequest getAreaCodeRequest(Context ctx, DataParser parser, DataObject cnapsObject) {
        BusinessRequest request = new BusinessRequest();
        request.setHeader(this.parseAreaCodeHeader(ctx));
        request.setBody(this.parseAreaCodeBody(parser, cnapsObject));
        return request;
    }

    private BusinessRequestBody parseAreaCodeBody(DataParser parser, DataObject cnapsObject) {
        BusinessRequestBody body = new BusinessRequestBody();
        DataPacker packer = new DataPacker();
        if (!EmptyUtil.isEmpty((Object)parser) && !EmptyUtil.isEmpty((Object)cnapsObject)) {
            packer.setProperty("parentType", parser.getProperty("type"));
            packer.setProperty("parentId", cnapsObject.getProperty("areaCode"));
        }
        body.setDatas(packer.pack());
        return body;
    }

    protected EBHeader parseAreaCodeHeader(Context ctx) {
        EBHeader header = super.parseHeader(ctx);
        header.setAccNo("areaCode");
        header.setBizType("areaCode");
        header.setSubBizType("default");
        header.setOperationName("business");
        return header;
    }

    public Map getBankCode(Context ctx) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            EBGServiceUtil service = new EBGServiceUtil(ctx);
            BusinessResponse response = service.business(this.getBankCodeRequest(ctx));
            EBException ex = response.getException();
            if (ex != null) {
                throw new Exception(ex.getMessage());
            }
            BusinessResponseBody body = response.getBody();
            NameValuePair[] pairs = body.getDatas();
            DataParser parser = DataParser.getInstance(pairs);
            DataObject[] cnapsResults = parser.getDataObjects("bankCodeResult");
            if (cnapsResults != null) {
                for (int i = 0; i < cnapsResults.length; ++i) {
                    DataObject cnapsObject = cnapsResults[i];
                    if (EmptyUtil.isEmpty((String)cnapsObject.getProperty("bankCode")) || map.containsKey(cnapsObject.getProperty("bankCode"))) continue;
                    map.put(cnapsObject.getProperty("bankCode"), cnapsObject.getProperty("bankName"));
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private BusinessRequest getBankCodeRequest(Context ctx) {
        BusinessRequest request = new BusinessRequest();
        request.setHeader(this.parseBankCodeHeader(ctx));
        request.setBody(this.parseBankCodeBody());
        return request;
    }

    private BusinessRequestBody parseBankCodeBody() {
        BusinessRequestBody body = new BusinessRequestBody();
        return body;
    }

    private EBHeader parseBankCodeHeader(Context ctx) {
        EBHeader header = super.parseHeader(ctx);
        header.setAccNo("bankCode");
        header.setBizType("bankCode");
        header.setSubBizType("default");
        header.setOperationName("business");
        return header;
    }

    public Map getCnaps(Context ctx, String areaCode, String bankCode) {
        HashMap<String, BECnapsData> map = new HashMap<String, BECnapsData>();
        try {
            EBGServiceUtil service = new EBGServiceUtil(ctx);
            BusinessResponse response = service.business(this.getCnapsCodeRequest(ctx, bankCode, areaCode));
            EBException ex = response.getException();
            if (ex != null) {
                throw new Exception(ex.getMessage());
            }
            BusinessResponseBody body = response.getBody();
            NameValuePair[] pairs = body.getDatas();
            DataParser parser = DataParser.getInstance(pairs);
            DataObject[] cnapsResults = parser.getDataObjects("cnapsResult");
            if (cnapsResults != null) {
                for (int i = 0; i < cnapsResults.length; ++i) {
                    DataObject cnapsObject = cnapsResults[i];
                    if (EmptyUtil.isEmpty((String)cnapsObject.getProperty("bankCnaps")) || map.containsKey(cnapsObject.getProperty("bankCnaps"))) continue;
                    BECnapsData cnpsData = new BECnapsData();
                    cnpsData.setBankCnaps(cnapsObject.getProperty("bankCnaps"));
                    cnpsData.setBankName(cnapsObject.getProperty("bankName"));
                    cnpsData.setBankAddress(cnapsObject.getProperty("bankAddress"));
                    map.put(cnapsObject.getProperty("bankCnaps"), cnpsData);
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private BusinessRequest getCnapsCodeRequest(Context ctx, String bankCode, String areaCode) {
        BusinessRequest request = new BusinessRequest();
        request.setHeader(this.parseCnapsCodeHeader(ctx));
        request.setBody(this.parseCnapsCodeBody(bankCode, areaCode));
        return request;
    }

    private BusinessRequestBody parseCnapsCodeBody(String bankCode, String areaCode) {
        BusinessRequestBody body = new BusinessRequestBody();
        DataPacker packer = new DataPacker();
        packer.setProperty("bankCode", bankCode);
        packer.setProperty("areaCode", areaCode);
        body.setDatas(packer.pack());
        body.setDatas(packer.pack());
        return body;
    }

    private EBHeader parseCnapsCodeHeader(Context ctx) {
        EBHeader header = super.parseHeader(ctx);
        header.setAccNo("cnaps");
        header.setBizType("cnaps");
        header.setSubBizType("default");
        header.setOperationName("business");
        return header;
    }

    public Map getCnapsWeb(Context ctx, String areaCode, String bankCode, int pageNum) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            EBGServiceUtil service = new EBGServiceUtil(ctx);
            String pageNumber = Integer.toString(pageNum);
            BusinessResponse response = service.business(this.getCnapsCodeRequestWeb(ctx, bankCode, areaCode, pageNumber));
            EBException ex = response.getException();
            if (ex != null) {
                throw new Exception(ex.getMessage());
            }
            BusinessResponseBody body = response.getBody();
            NameValuePair[] pairs = body.getDatas();
            DataParser parser = DataParser.getInstance(pairs);
            DataObject[] cnapsResults = parser.getDataObjects("cnapsResult");
            String hasNext = parser.getProperty("hasNext");
            map.put("hasNext", hasNext);
            if (cnapsResults != null) {
                for (int i = 0; i < cnapsResults.length; ++i) {
                    DataObject cnapsObject = cnapsResults[i];
                    if (EmptyUtil.isEmpty((String)cnapsObject.getProperty("bankCnaps")) || map.containsKey(cnapsObject.getProperty("bankCnaps"))) continue;
                    BECnapsDataWeb cnpsData = new BECnapsDataWeb();
                    cnpsData.setBankCnaps(cnapsObject.getProperty("bankCnaps"));
                    cnpsData.setBankName(cnapsObject.getProperty("bankName"));
                    cnpsData.setBankAddress(cnapsObject.getProperty("bankAddress"));
                    cnpsData.setAreaCode(cnapsObject.getProperty("areaCode"));
                    cnpsData.setAreaName(cnapsObject.getProperty("areaName"));
                    cnpsData.setBankCode(cnapsObject.getProperty("bankCode"));
                    cnpsData.setCityName(cnapsObject.getProperty("cityName"));
                    cnpsData.setProvinceName(cnapsObject.getProperty("provinceName"));
                    map.put(cnapsObject.getProperty("bankCnaps"), cnpsData);
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private BusinessRequest getCnapsCodeRequestWeb(Context ctx, String bankCode, String areaCode, String pageNum) {
        BusinessRequest request = new BusinessRequest();
        request.setHeader(this.parseCnapsCodeHeader(ctx));
        request.setBody(this.parseCnapsCodeBodyWeb(bankCode, areaCode, pageNum));
        return request;
    }

    private BusinessRequestBody parseCnapsCodeBodyWeb(String bankCode, String areaCode, String pageNum) {
        BusinessRequestBody body = new BusinessRequestBody();
        DataPacker packer = new DataPacker();
        packer.setProperty("bankCode", bankCode);
        packer.setProperty("areaCode", areaCode);
        packer.setProperty("pageNum", pageNum);
        body.setDatas(packer.pack());
        body.setDatas(packer.pack());
        return body;
    }
}

