/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.OverseaPayBody;
import com.kingdee.bos.ebservice.OverseaPayDetail;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.ebservice.QueryOverseaPayRequestBody;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryInfo;
import com.kingdee.eas.fm.be.BankAgentPayBillFactory;
import com.kingdee.eas.fm.be.BankAgentPayBillInfo;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.BankLogTypeEnum;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.EBPayOverseaPayOpUtil;
import com.kingdee.eas.fm.be.app.service.OverSeaBizInfo;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.bean.BankLogBuildInfo;
import com.kingdee.eas.fm.cbs.CBPaymentInfo;
import com.kingdee.eas.fm.cbs.MessageToBankEnum;
import com.kingdee.eas.fm.cbs.TransTypeEnum;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class CBBankAgentPayUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cbs.app.service.CBBankAgentPayUtil");

    private String getBEAutoGenerateResource(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)resName, (Locale)ctx.getLocale());
    }

    public OverseaPayDetail[] pay(Context ctx, IObjectPK billId) throws EASBizException, BOSException, RemoteException, ServiceException {
        BankAgentPayBillInfo info = BankAgentPayBillFactory.getLocalInstance(ctx).getBankAgentPayBillInfo(billId, this.getSelector());
        OverSeaBizInfo bizInfo = new OverSeaBizInfo();
        bizInfo.setTransType("pay_for_salary");
        bizInfo.setBankAcct(info.getPayAccountBank().getBankAccountNumber());
        bizInfo.setBillType(BillTypeEnum.AgencySalary);
        bizInfo.setCurrency(info.getCurrency().getIsoCode());
        OverseaPayBody body = this.parseAgentPayBody(ctx, info);
        EBPayOverseaPayOpUtil opUtil = new EBPayOverseaPayOpUtil();
        String[] payAcnt = new String[]{info.getPayAccountBank().getName()};
        String[] payeeAcnt = this.getPayeeAcnt(info);
        BankLogBuildInfo build = new BankLogBuildInfo();
        build.setPayAcnt(payAcnt);
        build.setPayeeAcnt(payeeAcnt);
        build.setLogType(BankLogTypeEnum.agentPayBill);
        build.setCompany(info.getCompany());
        build.setBankInterFaceID(info.getPayAccountBank().getBankInterFaceID());
        build.setBankInterFace(info.getPayAccountBank().getBankInterFace());
        build.setSourceBillId(ConvertUtils.IDSTR((Object)info));
        build.setPayBillId(ConvertUtils.IDSTR((Object)info));
        IObjectPK logpk = BankLogFacadeFactory.getLocalInstance(ctx).buildBaseMessage(build);
        opUtil.setPk(logpk);
        OverseaPayDetail[] details = opUtil.overseaPay(ctx, bizInfo, body);
        return details;
    }

    private OverseaPayBody parseAgentPayBody(Context ctx, BankAgentPayBillInfo info) {
        OverseaPayBody body = new OverseaPayBody();
        body.setBatchSeqID(info.getSerialNumber());
        body.setTotalAmount("0.00");
        body.setTotalCount(String.valueOf(info.getCount()));
        body.setVerifyField("false");
        body.setDetails(this.parseAgentPayDetail(ctx, info));
        return body;
    }

    private OverseaPayDetail[] parseAgentPayDetail(Context ctx, BankAgentPayBillInfo info) {
        OverseaPayDetail[] details = new OverseaPayDetail[info.getEntrys().size()];
        CBPaymentInfo cbPayInfo = info.getCbPayInfo();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            BankAgentPayBillEntryInfo entryInfo = info.getEntrys().get(i);
            OverseaPayDetail detail = new OverseaPayDetail();
            detail.setDetailSeqID(entryInfo.getSerialNumber());
            detail.setDetailBizNo(entryInfo.getSerialNumber());
            detail.setPayeeAccName(entryInfo.getRecName());
            detail.setPayeeAccNo(entryInfo.getRecBankAccount());
            detail.setPayeeBankName(entryInfo.getRecBankName());
            detail.setPayeeType("individual");
            detail.setAmount("0.00");
            detail.setActualAmount(String.valueOf(entryInfo.getAmount().setScale(2, 4)));
            detail.setPayCurrency(cbPayInfo.getPayeeCurrency().getIsoCode());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)entryInfo.getPayeeCountry())) {
                detail.setPayeeCountry(entryInfo.getPayeeCountry().getISOCode());
            }
            if (cbPayInfo.getTransactionType() == TransTypeEnum.BRP) {
                detail.setUrgent("true");
            } else {
                detail.setUrgent("false");
            }
            if (cbPayInfo.isIsFeeByPayAmount()) {
                detail.setPayerFeeType("01");
            } else {
                detail.setPayerFeeType("02");
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)cbPayInfo.getFeeAccountBank())) {
                detail.setPayerFeeAccNo(cbPayInfo.getFeeAccountBank().getBankAccountNumber());
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)cbPayInfo.getFeeCurrency())) {
                detail.setPayerFeeCurrency(cbPayInfo.getFeeCurrency().getIsoCode());
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)cbPayInfo.getPayTransaction())) {
                detail.setTransactionRemarks(cbPayInfo.getPayTransaction().getNumber());
            }
            if (cbPayInfo.isIsByAgentBank()) {
                detail.setProxyBankSwiftCode(cbPayInfo.getAgentSwift());
                detail.setProxyBankName(cbPayInfo.getAgentAcctBank());
                if (cbPayInfo.getAgentCountry() != null) {
                    detail.setProxyBankCountry(cbPayInfo.getAgentCountry().getISOCode());
                }
            }
            detail.setUseCode("-1");
            if (cbPayInfo.getTransactionType() == TransTypeEnum.TRF) {
                detail.setUse("\u53c2\u4e0e\u884c\u8f6c\u8d26");
            } else if (cbPayInfo.getTransactionType() == TransTypeEnum.ETF) {
                detail.setUse("\u672c\u5730\u94f6\u884c\u8f6c\u8d26");
            } else if (cbPayInfo.getTransactionType() == TransTypeEnum.BRP) {
                detail.setUse("\u4e2d\u94f6\u5feb\u6c47");
            } else if (cbPayInfo.getTransactionType() == TransTypeEnum.CBFT) {
                detail.setUse("CBFT");
            } else if (cbPayInfo.getTransactionType() == TransTypeEnum.DFT) {
                detail.setUse("DFT");
            } else {
                detail.setUse("\u7535\u6c47");
            }
            detail.setVerifyField("false");
            detail.setDesc(info.getUsage());
            if (cbPayInfo.getTransactionType() == TransTypeEnum.CBFT || cbPayInfo.getTransactionType() == TransTypeEnum.DFT) {
                if (!EmptyUtil.isEmpty((Object)entryInfo.getServiceLevel())) {
                    detail.setServiceLevel(entryInfo.getServiceLevel().getName());
                }
                if (!EmptyUtil.isEmpty((Object)entryInfo.getCBSPayType())) {
                    detail.setPaymentMethod(entryInfo.getCBSPayType().getName());
                }
            }
            detail.setExContract(cbPayInfo.getForContractNo());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            if (!EmptyUtil.isEmpty((Object)cbPayInfo.getExpectDealDate())) {
                String bookDate = sdf.format(cbPayInfo.getExpectDealDate());
                detail.setBookingDate(bookDate);
            } else {
                Timestamp time = new Timestamp(Calendar.getInstance().getTimeInMillis());
                String bookDate = sdf.format(time);
                detail.setBookingDate(bookDate);
            }
            detail.setPayeeCnapsCode(cbPayInfo.getCNAPSNum());
            if (cbPayInfo.getTransactionType() == TransTypeEnum.TTF) {
                String clearReqParam = cbPayInfo.getClearReqParam() == null ? "" : cbPayInfo.getClearReqParam();
                String messageToBank = cbPayInfo.getMessageToBank() == MessageToBankEnum.Double ? "BOCHKM2B=1" : "BOCHKM2B=2";
                String[] reserds = new String[]{messageToBank, "BBCCodeWords=" + clearReqParam};
                detail.setReserveds(reserds);
            }
            detail.setPayeeBankCode(entryInfo.getPayeeBankNumber());
            detail.setPayeeAreaCode(entryInfo.getPayeeBankBranch());
            if (cbPayInfo.getTransactionType() == TransTypeEnum.TRF || cbPayInfo.getTransactionType() == TransTypeEnum.ETF) {
                detail.setPayeeBankName(entryInfo.getRecBankName());
                detail.setPayeeBankAddr(entryInfo.getPayeeBankAddr());
            } else if (entryInfo.getPayeeSwiftCode() != null) {
                detail.setPayeeSwiftCode(entryInfo.getPayeeSwiftCode());
                detail.setPayeeBankName(entryInfo.getRecBankName());
                detail.setPayeeBankAddr(entryInfo.getPayeeBankAddr());
            } else {
                detail.setPayeeBankName(entryInfo.getRecBankName());
                detail.setPayeeBankAddr(entryInfo.getPayeeBankAddr());
            }
            details[i] = detail;
        }
        return details;
    }

    private String[] getPayeeAcnt(BankAgentPayBillInfo info) {
        String[] result = new String[info.getEntrys().size()];
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            result[i] = info.getEntrys().get(i).getRecBankAccount();
        }
        return result;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        sic.add(new SelectorItemInfo("PayAccountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.payeeCountry.ISOCode"));
        sic.add(new SelectorItemInfo("cbPayInfo.*"));
        sic.add(new SelectorItemInfo("cbPayInfo.payeeCurrency.isoCode"));
        sic.add(new SelectorItemInfo("cbPayInfo.feeAccountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("cbPayInfo.feeCurrency.isoCode"));
        sic.add(new SelectorItemInfo("cbPayInfo.PayTransaction.number"));
        sic.add(new SelectorItemInfo("cbPayInfo.agentCountry.ISOCode"));
        return sic;
    }

    public PaymentDetail[] queryOverseaPay(Context ctx, IObjectPK logpk, OverSeaBizInfo bizInfo, BankAgentPayBillInfo bill) throws RemoteException, ServiceException, EASBizException, BOSException {
        PaymentDetail[] PayStateColl = null;
        EBPayOverseaPayOpUtil opUtil = new EBPayOverseaPayOpUtil();
        opUtil.setPk(logpk);
        QueryOverseaPayRequestBody body = new QueryOverseaPayRequestBody();
        body.setBatchSeqID(bizInfo.getSerialNumber());
        PayStateColl = opUtil.queryOverseaPay(ctx, bizInfo, body);
        if (PayStateColl != null) {
            String currencyId = bill.getCurrency().getId().toString();
            String payeeCurrencyId = bill.getCbPayInfo().getPayeeCurrency().getId().toString();
            boolean isSameCurr = currencyId.equals(payeeCurrencyId);
            HashSet<String> succSet = new HashSet<String>();
            String batchNo = null;
            int configureCount = 0;
            boolean isTransSuccess = false;
            BigDecimal configurAmount = Constants.ZERO;
            String agentBillId = bill.getSourceBillId();
            for (int index = 0; index < PayStateColl.length; ++index) {
                batchNo = PayStateColl[index].getBankBatchSeqID();
                String SerialNumber = PayStateColl[index].getDetailSeqID();
                BankPayingBillStateEnum state = beServiceHelper.transferState(PayStateColl[index].getEbStatus());
                if (state.equals((Object)BankPayingBillStateEnum.TS)) {
                    isTransSuccess = true;
                }
                StringBuffer sb = new StringBuffer();
                String bankTitle = this.getBEAutoGenerateResource(ctx, "bankReturnMsg");
                String ebTitle = this.getBEAutoGenerateResource(ctx, "ebReturnMsg");
                if (!EmptyUtil.isEmpty((String)PayStateColl[index].getBankStatusMsg())) {
                    sb.append(PayStateColl[index].getBankStatusMsg()).append(";");
                } else {
                    sb.append(bankTitle).append(";");
                }
                if (!EmptyUtil.isEmpty((String)PayStateColl[index].getEbStatusMsg())) {
                    sb.append(PayStateColl[index].getEbStatusMsg());
                } else {
                    sb.append(ebTitle);
                }
                String returnMsg = sb.toString();
                returnMsg = FmBeHelper.cutString(returnMsg, 510);
                for (int k = 0; k < bill.getEntrys().size(); ++k) {
                    BankAgentPayBillEntryInfo entry = bill.getEntrys().get(k);
                    if (!entry.getSerialNumber().equals(SerialNumber)) continue;
                    entry.setState(state);
                    entry.setBankReturnInfo(returnMsg);
                    if (!state.equals((Object)BankPayingBillStateEnum.TS)) continue;
                    if (isSameCurr) {
                        configurAmount = configurAmount.add(entry.getAmount());
                    } else {
                        String actualAmount = PayStateColl[index].getAmount() != null ? PayStateColl[index].getAmount() : "99";
                        configurAmount = configurAmount.add(new BigDecimal(actualAmount));
                    }
                    ++configureCount;
                    succSet.add(entry.getSrcBillID());
                }
                bill.setConfigurAmount(configurAmount);
                bill.setConfigureCount(configureCount);
            }
            BankAgentPayBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(bill.getId().toString()), (CoreBaseInfo)bill);
            String sql = "Update T_CAS_AgentPayBill set FActualAmount= ?,FActualCount= ? where fid  = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{configurAmount, configureCount, agentBillId});
            if (succSet.size() > 0) {
                sql = "Update T_CAS_AgentPayBillEntry set FIsSuccess = ? where fid in " + FMHelper.setTran2String(succSet);
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Boolean(true)});
            }
            sql = "Update T_CAS_Journal set FBankCheckFlag = ? Where FBillId = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{batchNo == null ? "" : batchNo, agentBillId});
            sql = "update T_CAS_AgentPayBill set FBankCheckFlag = ? where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{batchNo == null ? "" : batchNo, agentBillId});
            AgentPayBillFactory.getLocalInstance((Context)ctx).notifyBankAgentPayStateChange((IObjectPK)new ObjectUuidPK(agentBillId));
        }
        return PayStateColl;
    }
}

