/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.OverseaPayBody;
import com.kingdee.bos.ebservice.OverseaPayDetail;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.ebservice.QueryOverseaPayRequestBody;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.PaymentBillBookNotifyBuilder;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fm.be.BEPayInterfaceCostInfo;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.bankpay.BankPayingBillSateUtil;
import com.kingdee.eas.fm.be.app.service.BePayInterfaceCostUtil;
import com.kingdee.eas.fm.be.app.service.EBPayOverseaPayOpUtil;
import com.kingdee.eas.fm.be.app.service.OverSeaBizInfo;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.util.ThreadLocalTimeUtil;
import com.kingdee.eas.fm.cbs.BeneficiaryTypeEnum;
import com.kingdee.eas.fm.cbs.CBPaymentCollection;
import com.kingdee.eas.fm.cbs.CBPaymentFactory;
import com.kingdee.eas.fm.cbs.CBPaymentInfo;
import com.kingdee.eas.fm.cbs.FeeModeEnum;
import com.kingdee.eas.fm.cbs.MessageToBankEnum;
import com.kingdee.eas.fm.cbs.TransactionsTypeFactory;
import com.kingdee.eas.fm.cbs.TransactionsTypeInfo;
import com.kingdee.eas.fm.cbs.TransferMethodEnum;
import com.kingdee.eas.fm.cbs.paymentPurposeEnum;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.app.SQL;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class CBPaymentPayUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cbs.app.service.CBPaymentPayUtil");
    private static final String EAS_PAY_INSERT_TIME = "EAS_PAY_INSERT_TIME";
    private static final String EAS_PAY_START_TIME = "EAS_PAY_START_TIME";
    private static final String EAS_PAY_END_TIME = "EAS_PAY_END_TIME";

    private String getBEAutoGenerateResource(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)resName, (Locale)ctx.getLocale());
    }

    public boolean queryOverseaPay(Context ctx, IObjectPK logpk, BankPayingBillCollection billColl, AccountBankInfo accountBankInfo, String serial, BankPayingBillInfo bankPayingBillInfo) throws Exception {
        EBPayOverseaPayOpUtil opUtil = new EBPayOverseaPayOpUtil();
        opUtil.setPk(logpk);
        String accNo = bankPayingBillInfo.getPayAccountBank().getBankAccountNumber();
        String currency = FmBeHelper.getCurrencyISO(ctx, bankPayingBillInfo.getCurrency());
        QueryOverseaPayRequestBody body = new QueryOverseaPayRequestBody();
        body.setBatchSeqID(serial);
        OverSeaBizInfo bizInfo = new OverSeaBizInfo();
        bizInfo.setBankAcct(accNo);
        bizInfo.setCurrency(currency);
        bizInfo.setTransType("overseaPay");
        OverseaPayDetail[] PayStateColl = opUtil.queryOverseaPay(ctx, bizInfo, body);
        if (PayStateColl == null) {
            return false;
        }
        BankPayingBillSateUtil payingBillSateUtil = new BankPayingBillSateUtil();
        for (OverseaPayDetail info : PayStateColl) {
            String paymentCurrencyIso;
            String payeeCurrencyIso;
            if (info == null || EmptyUtil.isEmpty((String)info.getDetailSeqID())) continue;
            String serialNumber = info.getDetailSeqID();
            BankPayingBillInfo bill = null;
            bill = EmptyUtil.isEmpty((String)bankPayingBillInfo.getBatchSeqID()) ? bankPayingBillInfo : this.getBankPayingBillInfo(billColl, serialNumber);
            if (EmptyUtil.isEmpty((CoreBaseInfo)bill)) continue;
            BePayInterfaceCostUtil bePayInterfaceCostUtil = new BePayInterfaceCostUtil();
            bePayInterfaceCostUtil.saveDataForPayBillQueryOverseaPay(ctx, info, bill);
            BankPayingBillStateEnum state = beServiceHelper.transferState(info.getEbStatus());
            Object[] reserveds = info.getReserveds();
            boolean isRefund = false;
            if (!EmptyUtil.isEmpty((Object[])reserveds)) {
                for (int i = 0; i < reserveds.length; ++i) {
                    String returnValue = ((String)reserveds[i]).trim();
                    if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("refund=".toUpperCase(Locale.ENGLISH)) || EmptyUtil.isEmpty((String)returnValue.substring("refund=".length()))) continue;
                    isRefund = true;
                }
            }
            StringBuffer sb = new StringBuffer();
            String bankTitle = this.getBEAutoGenerateResource(ctx, "bankReturnMsg");
            String ebTitle = this.getBEAutoGenerateResource(ctx, "ebReturnMsg");
            if (!EmptyUtil.isEmpty((String)info.getBankStatusMsg())) {
                sb.append(info.getBankStatusMsg()).append(";");
            } else {
                sb.append(bankTitle).append(";");
            }
            if (!EmptyUtil.isEmpty((String)info.getEbStatusMsg())) {
                sb.append(info.getEbStatusMsg());
            } else {
                sb.append(ebTitle);
            }
            String bankReturnMsg = sb.toString();
            if (!EmptyUtil.isEmpty((String)bankReturnMsg)) {
                bankReturnMsg = (bankReturnMsg = bankReturnMsg.replaceAll(" ", "")).length() > 510 ? bankReturnMsg.substring(0, 510) : bankReturnMsg;
            }
            payingBillSateUtil.updateBankPayingBillInfo(ctx, bill, state.getValue(), bill.getHandler(), bill.getSubmitTime(), bankReturnMsg, info.getBankBatchSeqID(), info.getRqstSerialNo(), isRefund);
            if (EmptyUtil.isEmpty((String)bill.getSourceBillId())) continue;
            String batchNo = info.getBankBatchSeqID();
            if (CheckUtils.existAll((Object[])new Object[]{batchNo, bill}) && !CheckUtils.exist((Object)bill.isIsAgencyPersonPay())) {
                batchNo = null;
            }
            String bankDetailSeqId = info.getRqstSerialNo();
            if (!EmptyUtil.isEmpty((String)bill.getSourceBillId())) {
                payingBillSateUtil.updateSourceBillState(ctx, bill.getSourceBillId(), state.getValue(), bankReturnMsg, bill.getSubmitTime(), batchNo, bankDetailSeqId, isRefund, false);
            }
            if ((payeeCurrencyIso = bill.getCbPayInfo().getPayeeCurrency().getIsoCode()).equals(paymentCurrencyIso = bill.getCbPayInfo().getPaymentCurrency().getIsoCode()) || state != BankPayingBillStateEnum.TS) continue;
            logger.error((Object)"-------payeeCurrency is not same as paymentCurrency and state is success----");
            logger.error((Object)("-------the value of actualAmount is:----" + info.getActualAmount()));
            this.updateActualAmountAndBook(ctx, bill.getSourceBillId().toString(), bill.getId().toString(), info.getAmount());
        }
        return true;
    }

    public boolean queryOverseaPay(Context ctx, IObjectPK logpk, BankPayingBillCollection billColl, AccountBankInfo accountBankInfo, String serial, BankPayingBillInfo bankPayingBillInfo, boolean isUrgent) throws Exception {
        EBPayOverseaPayOpUtil opUtil = new EBPayOverseaPayOpUtil();
        opUtil.setPk(logpk);
        String accNo = bankPayingBillInfo.getPayAccountBank().getBankAccountNumber();
        String currency = FmBeHelper.getCurrencyISO(ctx, bankPayingBillInfo.getCurrency());
        QueryOverseaPayRequestBody body = new QueryOverseaPayRequestBody();
        if (isUrgent) {
            body.setReserved1("enforcequery");
        }
        body.setBatchSeqID(serial);
        OverSeaBizInfo bizInfo = new OverSeaBizInfo();
        bizInfo.setBankAcct(accNo);
        bizInfo.setCurrency(currency);
        bizInfo.setTransType("overseaPay");
        OverseaPayDetail[] PayStateColl = opUtil.queryOverseaPay(ctx, bizInfo, body);
        if (PayStateColl == null) {
            return false;
        }
        BankPayingBillSateUtil payingBillSateUtil = new BankPayingBillSateUtil();
        for (OverseaPayDetail info : PayStateColl) {
            String paymentCurrencyIso;
            String payeeCurrencyIso;
            if (info == null || EmptyUtil.isEmpty((String)info.getDetailSeqID())) continue;
            String serialNumber = info.getDetailSeqID();
            BankPayingBillInfo bill = null;
            bill = EmptyUtil.isEmpty((String)bankPayingBillInfo.getBatchSeqID()) ? bankPayingBillInfo : this.getBankPayingBillInfo(billColl, serialNumber);
            if (EmptyUtil.isEmpty((CoreBaseInfo)bill)) continue;
            BePayInterfaceCostUtil bePayInterfaceCostUtil = new BePayInterfaceCostUtil();
            bePayInterfaceCostUtil.saveDataForPayBillQueryOverseaPay(ctx, info, bill);
            BankPayingBillStateEnum state = beServiceHelper.transferState(info.getEbStatus());
            Object[] reserveds = info.getReserveds();
            boolean isRefund = false;
            if (!EmptyUtil.isEmpty((Object[])reserveds)) {
                for (int i = 0; i < reserveds.length; ++i) {
                    String returnValue = ((String)reserveds[i]).trim();
                    if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("refund=".toUpperCase(Locale.ENGLISH)) || EmptyUtil.isEmpty((String)returnValue.substring("refund=".length()))) continue;
                    isRefund = true;
                }
            }
            payingBillSateUtil.updateBankPayingBillInfo(ctx, bill, state.getValue(), bill.getHandler(), bill.getSubmitTime(), info.getBankStatusMsg(), info.getBankBatchSeqID(), info.getRqstSerialNo(), isRefund);
            if (EmptyUtil.isEmpty((String)bill.getSourceBillId())) continue;
            String batchNo = info.getBankBatchSeqID();
            if (CheckUtils.existAll((Object[])new Object[]{batchNo, bill}) && !CheckUtils.exist((Object)bill.isIsAgencyPersonPay())) {
                batchNo = null;
            }
            String bankDetailSeqId = info.getRqstSerialNo();
            if (!EmptyUtil.isEmpty((String)bill.getSourceBillId())) {
                payingBillSateUtil.updateSourceBillState(ctx, bill.getSourceBillId(), state.getValue(), info.getBankStatusMsg(), bill.getSubmitTime(), batchNo, bankDetailSeqId, isRefund, false);
            }
            if ((payeeCurrencyIso = bill.getCbPayInfo().getPayeeCurrency().getIsoCode()).equals(paymentCurrencyIso = bill.getCbPayInfo().getPaymentCurrency().getIsoCode()) || state != BankPayingBillStateEnum.TS) continue;
            logger.error((Object)"-------payeeCurrency is not same as paymentCurrency and state is success----");
            logger.error((Object)("-------the value of actualAmount is:----" + info.getActualAmount()));
            this.updateActualAmountAndBook(ctx, bill.getSourceBillId().toString(), bill.getId().toString(), info.getAmount());
        }
        return true;
    }

    private BankPayingBillInfo getBankPayingBillInfo(BankPayingBillCollection billColl, String serialNumber) {
        BankPayingBillInfo info = null;
        if (billColl != null) {
            int size = billColl.size();
            for (int i = 0; i < size; ++i) {
                if (!serialNumber.equals(billColl.get(i).getSerialNumber())) continue;
                info = billColl.get(i);
                break;
            }
        }
        return info;
    }

    private void updateActualAmountAndBook(Context ctx, String paymentId, String bankPayId, String actualAmount) throws BOSException, EASBizException {
        String string = actualAmount = actualAmount == null ? "0" : actualAmount;
        if (!JournalFactory.getLocalInstance((Context)ctx).exists("where billId='" + paymentId + "'")) {
            BigDecimal bd = new BigDecimal(actualAmount);
            String sql1 = "update T_CAS_PaymentBill set FActualPayAmount =" + bd.toString() + ", FActPayLocAmt = FExchangeRate*" + bd.toString() + " where FId='" + paymentId + "';\n";
            String sql2 = "update T_CBS_CBPayment set FPaymentAmount =" + bd.toString() + " where FPaymentBillID='" + paymentId + "';\n";
            String sql3 = "update T_BE_BankPayingBill set FPayAmount =" + bd.toString() + " where FId='" + bankPayId + "';\n";
            SQL sql = new SQL(ctx);
            sql.add(sql1);
            sql.add(sql2);
            sql.add(sql3);
            sql.execute();
            RecPayHelper helper = new RecPayHelper();
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(paymentId);
            helper.bookPaymentBill(ctx, PaymentBillBookNotifyBuilder.class.getName(), idSet);
        }
    }

    public BankPayResult[] overseaPayDetailsPayResult(Context ctx, OverseaPayDetail[] details) {
        if (EmptyUtil.isEmpty((Object[])details)) {
            return new BankPayResult[0];
        }
        int length = details.length;
        BankPayResult[] bankPayResults = new BankPayResult[length];
        for (int i = 0; i < length; ++i) {
            OverseaPayDetail overseapayDetail = details[i];
            BankPayingBillStateEnum state = beServiceHelper.transferState(overseapayDetail.getEbStatus());
            String returnMsg = overseapayDetail.getBankStatusMsg();
            String detailSeqID = overseapayDetail.getDetailSeqID();
            BankPayResult bankPayResult = new BankPayResult(null, detailSeqID, state, returnMsg);
            if (CheckUtils.isEmpty((Object)returnMsg) && CheckUtils.same((Object)((Object)state), (Object)((Object)BankPayingBillStateEnum.OF))) {
                returnMsg = overseapayDetail.getEbStatusMsg();
                bankPayResult.setErrorDetail(overseapayDetail.getEbStatusMsg());
            }
            bankPayResult.setSubmitToBe(true);
            bankPayResults[i] = bankPayResult;
        }
        return bankPayResults;
    }

    public OverseaPayDetail[] batchBankPay(Context ctx, BankPayingBillCollection collection, Map<String, IObjectPK> bankPayBillLog) throws EASBizException, BOSException, RemoteException, ServiceException {
        EBPayOverseaPayOpUtil opUtil = new EBPayOverseaPayOpUtil();
        CBPaymentCollection cbPaymentColl = this.getCBPaymentColl(ctx, collection);
        OverseaPayBody body = this.parsebatchBankPayBody(ctx, collection, cbPaymentColl);
        CBPaymentInfo cbPaymentInfo = cbPaymentColl.get(0);
        String accNo = collection.get(0).getPayAccountBank().getBankAccountNumber();
        String currency = FmBeHelper.getCurrencyISO(ctx, collection.get(0).getCurrency());
        String subBizType = "overseaPay";
        if (cbPaymentInfo.getTransType().getValue() == 1 || cbPaymentInfo.getTransType().getValue() == 2) {
            subBizType = "foreignPay";
        }
        OverSeaBizInfo bizInfo = new OverSeaBizInfo();
        bizInfo.setBankAcct(accNo);
        bizInfo.setCurrency(currency);
        bizInfo.setTransType(subBizType);
        opUtil.setBatchPK(bankPayBillLog);
        return opUtil.overseaPay(ctx, bizInfo, body);
    }

    private OverseaPayBody parsebatchBankPayBody(Context ctx, BankPayingBillCollection collection, CBPaymentCollection cbPaymentColl) throws BOSException, EASBizException {
        int size = collection.size();
        BigDecimal amount = BigDecimal.ZERO;
        OverseaPayDetail[] details = new OverseaPayDetail[size];
        for (int i = 0; i < collection.size(); ++i) {
            BankPayingBillInfo billInfo = collection.get(i);
            CBPaymentInfo cbPayInfo = cbPaymentColl.get((Object)billInfo.getCbPayInfo().getId());
            amount = amount.add(cbPayInfo.getPayeeAmount());
            details[i] = this.parseOverseaPayDetail(ctx, billInfo, cbPayInfo);
        }
        OverseaPayBody body = new OverseaPayBody();
        body.setBatchSeqID(collection.get(0).getSerialNumber());
        body.setBatchBizNo(collection.get(0).getBatchNo());
        body.setTotalCount(String.valueOf(size));
        body.setTotalAmount("0.00");
        body.setVerifyField("false");
        body.setDetails(details);
        return body;
    }

    private CBPaymentCollection getCBPaymentColl(Context ctx, BankPayingBillCollection collection) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            idSet.add(collection.get(i).getSourceBillId());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = this.getselector();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("paymentBillId", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        CBPaymentCollection paymentCollection = CBPaymentFactory.getLocalInstance((Context)ctx).getCBPaymentCollection(view);
        return paymentCollection;
    }

    private SelectorItemCollection getselector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payTransaction.number"));
        sic.add(new SelectorItemInfo("paymentCurrency.isoCode"));
        sic.add(new SelectorItemInfo("agentCountry.ISOCode"));
        sic.add(new SelectorItemInfo("payeeCurrency.isoCode"));
        sic.add(new SelectorItemInfo("feeAccountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("feeCurrency.isoCode"));
        sic.add(new SelectorItemInfo("payeeBankCountry.ISOCode"));
        sic.add(new SelectorItemInfo("transType.id"));
        sic.add(new SelectorItemInfo("transType.name"));
        sic.add(new SelectorItemInfo("transType.number"));
        sic.add(new SelectorItemInfo("transType.value"));
        return sic;
    }

    private OverseaPayDetail parseOverseaPayDetail(Context ctx, BankPayingBillInfo info, CBPaymentInfo cbPaymentInfo) throws EASBizException, BOSException {
        String[] reserds;
        String paymentPurpose;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("FRecCountry.ISOCode"));
        PaymentBillInfo paymentBillInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()), sic);
        OverseaPayDetail detail = new OverseaPayDetail();
        detail.setDetailSeqID(info.getSerialNumber());
        detail.setDetailBizNo(info.getSourceBillId());
        detail.setPayeeAccNo(info.getRecAccountBank());
        detail.setPayeeAccName(info.getRecCompany());
        detail.setPayeeType(info.isIsPersonPay() ? "individual" : "company");
        if (cbPaymentInfo.getTransType().getValue() == 1 || cbPaymentInfo.getTransType().getValue() == 2) {
            detail.setPayeeBankName(info.getRecBank());
            detail.setPayeeBankAddr(cbPaymentInfo.getPayeeBankAddr());
        } else if (cbPaymentInfo.getPayeeSwiftCode() != null) {
            detail.setPayeeSwiftCode(cbPaymentInfo.getPayeeSwiftCode());
            String ISOCode = "";
            if (info.getFRecCountry() != null) {
                ISOCode = info.getFRecCountry().getISOCode();
            }
            detail.setPayeeBankName(info.getRecBank() != null ? info.getRecBank() : ISOCode);
            detail.setPayeeBankAddr(cbPaymentInfo.getPayeeBankAddr() != null ? cbPaymentInfo.getPayeeBankAddr() : ISOCode);
        } else {
            detail.setPayeeBankName(info.getRecBank());
            detail.setPayeeBankAddr(cbPaymentInfo.getPayeeBankAddr());
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getFRecCountry())) {
            detail.setPayeeCountry(info.getFRecCountry().getISOCode());
        }
        detail.setMobile(cbPaymentInfo.getPayeePhone());
        detail.setPayeeProvince(info.getRecProvinceStr());
        detail.setPayeeCity(info.getRecCityStr());
        detail.setEmail(info.getEmail());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getRecOpenArea())) {
            detail.setPayeeAreaCode(info.getRecOpenArea().getNumber());
        }
        if (paymentBillInfo.getFRecCountry() != null && "CHN".equals(paymentBillInfo.getFRecCountry().getISOCode())) {
            detail.setPayeeCnapsCode(cbPaymentInfo.getCNAPSNum());
        }
        detail.setAmount("0.00");
        detail.setActualAmount(String.valueOf(cbPaymentInfo.getPayeeAmount().setScale(2, 4)));
        detail.setPayCurrency(cbPaymentInfo.getPayeeCurrency().getIsoCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        if (!EmptyUtil.isEmpty((Object)info.getExpectTransTime())) {
            String bookDate = sdf.format(info.getExpectTransTime());
            detail.setBookingDate(bookDate);
        } else {
            Timestamp time = new Timestamp(Calendar.getInstance().getTimeInMillis());
            String bookDate = sdf.format(time);
            detail.setBookingDate(bookDate);
        }
        if (cbPaymentInfo.getTransType().getValue() == 4) {
            detail.setUrgent("true");
        } else {
            detail.setUrgent("false");
        }
        if (cbPaymentInfo.isIsFeeByPayAmount()) {
            detail.setPayerFeeType("01");
        } else {
            detail.setPayerFeeType("02");
        }
        if (cbPaymentInfo.getPaymentterms() != null) {
            if (cbPaymentInfo.getPaymentterms().getValue() == 1) {
                detail.setPayerFeeType("01");
            } else if (cbPaymentInfo.getPaymentterms().getValue() == 2) {
                detail.setPayerFeeType("02");
            } else if (cbPaymentInfo.getPaymentterms().getValue() == 3) {
                detail.setPayerFeeType("03");
            } else if (cbPaymentInfo.getPaymentterms().getValue() == 4) {
                detail.setPayerFeeType("04");
            } else {
                detail.setPayerFeeType("01");
            }
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)cbPaymentInfo.getFeeAccountBank())) {
            detail.setPayerFeeAccNo(cbPaymentInfo.getFeeAccountBank().getBankAccountNumber());
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)cbPaymentInfo.getFeeCurrency())) {
            detail.setPayerFeeCurrency(FmBeHelper.getCurrencyISO(ctx, cbPaymentInfo.getFeeCurrency()));
        }
        detail.setExchangeRate(paymentBillInfo.getExchangeRate().setScale(5, 4).toString());
        detail.setPayeeBankCode(null);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)cbPaymentInfo.getPayTransaction())) {
            if (cbPaymentInfo.getTransType().getValue() == 2 || cbPaymentInfo.getTransType().getValue() == 4 || cbPaymentInfo.getTransType().getValue() == 3 || cbPaymentInfo.getTransType().getValue() == 5 || cbPaymentInfo.getTransType().getValue() == 11 || cbPaymentInfo.getTransType().getValue() == 1 || cbPaymentInfo.getTransType().getValue() == 8 || cbPaymentInfo.getTransType().getValue() == 15 || cbPaymentInfo.getTransType().getValue() == 9 || cbPaymentInfo.getTransType().getValue() == 12 || cbPaymentInfo.getTransType().getValue() == 13 || cbPaymentInfo.getTransType().getValue() == 17 || cbPaymentInfo.getTransType().getValue() == 20 || cbPaymentInfo.getTransType().getValue() == 18 || cbPaymentInfo.getTransType().getValue() == 19 || cbPaymentInfo.getTransType().getValue() == 21 || cbPaymentInfo.getTransType().getValue() == 22 || cbPaymentInfo.getTransType().getValue() == 14 || cbPaymentInfo.getTransType().getValue() == 27) {
                if (cbPaymentInfo.getPayTransaction() != null) {
                    TransactionsTypeInfo info1 = TransactionsTypeFactory.getLocalInstance((Context)ctx).getTransactionsTypeInfo((IObjectPK)new ObjectUuidPK(cbPaymentInfo.getPayTransaction().getId()));
                    if (info1.isIsforRmb()) {
                        detail.setTransactionRemarks(info1.getDescription() == null ? "" : info1.getDescription());
                    } else {
                        detail.setTransactionRemarks(cbPaymentInfo.getPayTransaction().getNumber() == null ? "" : cbPaymentInfo.getPayTransaction().getNumber());
                    }
                }
            } else if (cbPaymentInfo.getPayTransaction() != null) {
                detail.setTransactionRemarks(cbPaymentInfo.getPayTransaction().getNumber() == null ? "" : cbPaymentInfo.getPayTransaction().getNumber());
            }
        } else if ("CNY".equals(cbPaymentInfo.getPayeeCurrency().getIsoCode())) {
            detail.setTransactionRemarks("A");
        }
        if (detail.getTransactionRemarks() != null && "A".equals(detail.getTransactionRemarks()) && !EmptyUtil.isEmpty((CoreBaseInfo)cbPaymentInfo.getTransType()) && (cbPaymentInfo.getTransType().getValue() == 9 || cbPaymentInfo.getTransType().getValue() == 5 || cbPaymentInfo.getTransType().getValue() == 6 || cbPaymentInfo.getTransType().getValue() == 7 || cbPaymentInfo.getTransType().getValue() == 8 || cbPaymentInfo.getTransType().getValue() == 9 || cbPaymentInfo.getTransType().getValue() == 12 || cbPaymentInfo.getTransType().getValue() == 13 || cbPaymentInfo.getTransType().getValue() == 14 || cbPaymentInfo.getTransType().getValue() == 15 || cbPaymentInfo.getTransType().getValue() == 17 || cbPaymentInfo.getTransType().getValue() == 20 || cbPaymentInfo.getTransType().getValue() == 18 || cbPaymentInfo.getTransType().getValue() == 19 || cbPaymentInfo.getTransType().getValue() == 21 || cbPaymentInfo.getTransType().getValue() == 22) || cbPaymentInfo.getTransType().getValue() == 27) {
            detail.setTransactionRemarks(null);
        }
        if (cbPaymentInfo.isIsByAgentBank()) {
            detail.setProxyBankSwiftCode(cbPaymentInfo.getAgentSwift());
            detail.setProxyBankName(cbPaymentInfo.getAgentAcctBank());
            if (cbPaymentInfo.getAgentCountry() != null) {
                detail.setProxyBankCountry(cbPaymentInfo.getAgentCountry().getISOCode());
            }
        }
        detail.setUseCode("-1");
        if (cbPaymentInfo.getTransType().getValue() == 1) {
            detail.setUse("\u53c2\u4e0e\u884c\u8f6c\u8d26");
        } else if (cbPaymentInfo.getTransType().getValue() == 2) {
            detail.setUse("\u672c\u5730\u94f6\u884c\u8f6c\u8d26");
        } else if (cbPaymentInfo.getTransType().getValue() == 4) {
            detail.setUse("\u4e2d\u94f6\u5feb\u6c47");
        } else if (cbPaymentInfo.getTransType().getValue() == 3) {
            detail.setUse("\u7535\u6c47");
        } else if (cbPaymentInfo.getTransType().getValue() == 5) {
            detail.setUse("\u6c47\u4e30PP");
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getServiceLevel())) {
                detail.setServiceLevel(cbPaymentInfo.getServiceLevel().getName());
            }
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getCBSPayType())) {
                detail.setPaymentMethod(cbPaymentInfo.getCBSPayType().getName());
            }
            detail.setPayeeBankLocalClearingCode(cbPaymentInfo.getBLClearCode());
        } else if (cbPaymentInfo.getTransType().getValue() == 6) {
            detail.setUse("\u6c47\u4e30ACH");
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getServiceLevel())) {
                detail.setServiceLevel(cbPaymentInfo.getServiceLevel().getName());
            }
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getCBSPayType())) {
                detail.setPaymentMethod(cbPaymentInfo.getCBSPayType().getName());
            }
            String paymentPurpose2 = "";
            if (!EmptyUtil.isEmpty((String)cbPaymentInfo.getOtherPaymentPurpose())) {
                paymentPurpose2 = cbPaymentInfo.getOtherPaymentPurpose();
            }
            String[] reserds2 = new String[]{"payPurpose=" + paymentPurpose2};
            detail.setReserveds(reserds2);
            detail.setPayeeBankLocalClearingCode(cbPaymentInfo.getBLClearCode());
        } else if (cbPaymentInfo.getTransType().getValue() == 7) {
            detail.setUse("\u6c47\u4e30\u652f\u7968");
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getCBSPayType())) {
                detail.setPaymentMethod(cbPaymentInfo.getCBSPayType().getName());
            }
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getCheckType())) {
                detail.setChequeType(cbPaymentInfo.getCheckType().getName());
            }
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getCheckUsage())) {
                detail.setChequeUsage(cbPaymentInfo.getCheckUsage().getName());
            }
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getSendMethod())) {
                detail.setDeliveryMethod(cbPaymentInfo.getSendMethod().getName());
            }
        } else if (cbPaymentInfo.getTransType().getValue() == 11) {
            detail.setUse("\u8f6c\u6570\u5feb");
            String isNotify = "false";
            if (cbPaymentInfo.isIsNoticePayee()) {
                isNotify = "true";
            }
            String noticePayeeEmails = cbPaymentInfo.getNoticePayeeEmails() == null ? "" : cbPaymentInfo.getNoticePayeeEmails();
            String payeeFPSNum = cbPaymentInfo.getPayeeFPSNum() == null ? "" : cbPaymentInfo.getPayeeFPSNum();
            String beneCountryCode = cbPaymentInfo.getPayeePhoneCode() == null ? "" : cbPaymentInfo.getPayeePhoneCode();
            String paymentPurpose3 = "";
            if (!EmptyUtil.isEmpty((String)cbPaymentInfo.getOtherPaymentPurpose())) {
                paymentPurpose3 = cbPaymentInfo.getOtherPaymentPurpose();
            }
            String[] reserds3 = new String[]{"beneEmail=" + noticePayeeEmails, "payPurpose=" + paymentPurpose3, "beneFPSId=" + payeeFPSNum, "isNotify=" + isNotify, "beneCountryCode=" + beneCountryCode};
            detail.setReserveds(reserds3);
        } else if (cbPaymentInfo.getTransType().getValue() == 8 || cbPaymentInfo.getTransType().getValue() == 9 || cbPaymentInfo.getTransType().getValue() == 15 || cbPaymentInfo.getTransType().getValue() == 17 || cbPaymentInfo.getTransType().getValue() == 20 || cbPaymentInfo.getTransType().getValue() == 18 || cbPaymentInfo.getTransType().getValue() == 19 || cbPaymentInfo.getTransType().getValue() == 21 || cbPaymentInfo.getTransType().getValue() == 22 || cbPaymentInfo.getTransType().getValue() == 27) {
            switch (cbPaymentInfo.getTransType().getValue()) {
                case 8: {
                    detail.setUse("CBFT");
                    break;
                }
                case 9: {
                    detail.setUse("DFT");
                    break;
                }
                case 15: {
                    detail.setUse("ACH");
                    break;
                }
                case 17: {
                    detail.setUse("RTGS");
                    break;
                }
                case 18: {
                    detail.setUse("FPS");
                    break;
                }
                case 19: {
                    detail.setUse("ACH");
                    break;
                }
                case 20: {
                    detail.setUse("CBFT");
                    break;
                }
                case 21: {
                    detail.setUse("NPP");
                    break;
                }
                case 22: {
                    detail.setUse("BPAY");
                    break;
                }
                case 27: {
                    detail.setUse("FASTPAYMENT");
                }
            }
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getServiceLevel())) {
                detail.setServiceLevel(cbPaymentInfo.getServiceLevel().getName());
            }
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getCBSPayType())) {
                detail.setPaymentMethod(cbPaymentInfo.getCBSPayType().getName());
            }
            if (cbPaymentInfo.getTransType().getValue() == 15 || cbPaymentInfo.getTransType().getValue() == 17 || cbPaymentInfo.getTransType().getValue() == 20 || cbPaymentInfo.getTransType().getValue() == 18 || cbPaymentInfo.getTransType().getValue() == 19 || cbPaymentInfo.getTransType().getValue() == 21 || cbPaymentInfo.getTransType().getValue() == 22 || cbPaymentInfo.getTransType().getValue() == 27) {
                String[] reserds4;
                detail.setPayeeBankLocalClearingCode(cbPaymentInfo.getBLClearCode());
                String tocity = cbPaymentInfo.getTocity() == null ? "" : cbPaymentInfo.getTocity();
                paymentPurpose = "";
                if (!(cbPaymentInfo.getTransType().getValue() != 18 && cbPaymentInfo.getTransType().getValue() != 19 && cbPaymentInfo.getTransType().getValue() != 21 || EmptyUtil.isEmpty((Object)cbPaymentInfo.getPaymentPurpose()) || cbPaymentInfo.getPaymentPurpose().equals((Object)paymentPurposeEnum.Empty))) {
                    paymentPurpose = cbPaymentInfo.getPaymentPurpose().getName();
                }
                if (EmptyUtil.isEmpty((String)paymentPurpose)) {
                    reserds4 = new String[]{"tocity=" + tocity};
                    detail.setReserveds(reserds4);
                } else {
                    reserds4 = new String[]{"tocity=" + tocity, "payPurpose=" + paymentPurpose};
                    detail.setReserveds(reserds4);
                }
            }
        } else if (cbPaymentInfo.getTransType().getValue() == 12 || cbPaymentInfo.getTransType().getValue() == 13 || cbPaymentInfo.getTransType().getValue() == 14) {
            switch (cbPaymentInfo.getTransType().getValue()) {
                case 12: {
                    detail.setUse("TT");
                    break;
                }
                case 13: {
                    detail.setUse("ACH");
                    break;
                }
                case 14: {
                    detail.setUse("RTGS");
                }
            }
            detail.setPayeeBankLocalClearingCode(cbPaymentInfo.getBLClearCode());
            detail.setPayeeBankLocalClearingBranchCode(cbPaymentInfo.getBLClearBranchCode());
            detail.setPayeeBankLocalClearingBranchsubCode(cbPaymentInfo.getPayeeBankBranch());
            String clearReqParam = cbPaymentInfo.getClearReqParam() == null ? "" : cbPaymentInfo.getClearReqParam();
            paymentPurpose = "";
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getPaymentPurpose()) && !cbPaymentInfo.getPaymentPurpose().equals((Object)paymentPurposeEnum.Empty)) {
                paymentPurpose = cbPaymentInfo.getPaymentPurpose().getAlias();
            }
            String beneficiaryType = "";
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getBeneficiaryType()) && !cbPaymentInfo.getBeneficiaryType().equals((Object)BeneficiaryTypeEnum.Empty)) {
                beneficiaryType = Integer.toString(cbPaymentInfo.getBeneficiaryType().getValue());
            }
            reserds = new String[]{"BBCCodeWords=" + clearReqParam, "payPurpose=" + paymentPurpose, "beneficiaryType=" + beneficiaryType};
            detail.setReserveds(reserds);
        } else if (cbPaymentInfo.getTransType().getValue() == 16) {
            detail.setUse("1");
            detail.setUrgent(info.isIsEmergency() ? "TRUE" : "FALSE");
            detail.setPayeeBankLocalClearingBranchCode(cbPaymentInfo.getBLClearBranchCode());
            String payeephone = cbPaymentInfo.getPayeePhone() == null ? "" : cbPaymentInfo.getPayeePhone();
            String tocity = cbPaymentInfo.getTocity() == null ? "" : cbPaymentInfo.getTocity();
            String cltype = cbPaymentInfo.getCltype() == null ? "" : cbPaymentInfo.getCltype();
            String tocnaps = cbPaymentInfo.getTocnaps() == null ? "" : cbPaymentInfo.getTocnaps();
            String feemode = "";
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getFeeMode()) && !cbPaymentInfo.getFeeMode().equals((Object)FeeModeEnum.Empty)) {
                feemode = cbPaymentInfo.getFeeMode().getAlias();
            }
            String paymentPurpose4 = "";
            if (!EmptyUtil.isEmpty((String)cbPaymentInfo.getOtherPaymentPurpose())) {
                paymentPurpose4 = cbPaymentInfo.getOtherPaymentPurpose();
            }
            String transferMethod = "";
            if (!EmptyUtil.isEmpty((Object)cbPaymentInfo.getTransferMethod()) && !cbPaymentInfo.getTransferMethod().equals((Object)TransferMethodEnum.Empty)) {
                transferMethod = String.valueOf(cbPaymentInfo.getTransferMethod().getValue());
            }
            String[] reserds5 = new String[]{"payeephone=" + payeephone, "tocity=" + tocity, "cltype=" + cltype, "tocnaps=" + tocnaps, "feemode=" + feemode, "remittanceuse=" + paymentPurpose4, "transfermethod=" + transferMethod};
            detail.setReserveds(reserds5);
        }
        detail.setPayeeAddress(cbPaymentInfo.getPayeeAddress());
        detail.setVerifyField("false");
        detail.setDesc(info.getDescription());
        detail.setExContract(cbPaymentInfo.getForContractNo());
        detail.setPayeeCnapsCode(cbPaymentInfo.getCNAPSNum());
        if (cbPaymentInfo.getTransType().getValue() == 3) {
            String clearReqParam = cbPaymentInfo.getClearReqParam() == null ? "" : cbPaymentInfo.getClearReqParam();
            String messageToBank = cbPaymentInfo.getMessageToBank() == MessageToBankEnum.Double ? "BOCHKM2B=1" : "BOCHKM2B=2";
            String paymentPurpose5 = "";
            if (!EmptyUtil.isEmpty((String)cbPaymentInfo.getOtherPaymentPurpose())) {
                paymentPurpose5 = cbPaymentInfo.getOtherPaymentPurpose();
            }
            if (info.isPriorityPay()) {
                reserds = new String[]{messageToBank, "BBCCodeWords=" + clearReqParam, "priorityPay", "payPurpose=" + paymentPurpose5};
                detail.setReserveds(reserds);
            } else {
                reserds = new String[]{messageToBank, "BBCCodeWords=" + clearReqParam, "payPurpose=" + paymentPurpose5};
                detail.setReserveds(reserds);
            }
        }
        detail.setPayeeBankCode(cbPaymentInfo.getPayeeBankNumber());
        detail.setPayeeAreaCode(cbPaymentInfo.getPayeeBankBranch());
        return detail;
    }

    private void buildBeTimeInfo(PaymentDetail info, BEPayInterfaceCostInfo bePayInterfaceCostInfo) throws ParseException {
        if (null != info.getReserveds() && info.getReserveds().length > 0) {
            for (int i = 0; i < info.getReserveds().length; ++i) {
                Timestamp timestamp;
                long tempTime;
                String[] timeArr;
                String timeString = info.getReserveds()[i];
                if (!timeString.contains("=") || (timeArr = timeString.split("=")).length <= 1) continue;
                if (timeArr[0].equals(EAS_PAY_INSERT_TIME)) {
                    Date commitDateTime = ThreadLocalTimeUtil.parse(timeArr[1]);
                    tempTime = commitDateTime.getTime();
                    timestamp = new Timestamp(tempTime);
                    bePayInterfaceCostInfo.setResponseBETime(timestamp);
                }
                if (timeArr[0].equals(EAS_PAY_START_TIME)) {
                    Date sendTime = ThreadLocalTimeUtil.parse(timeArr[1]);
                    tempTime = sendTime.getTime();
                    timestamp = new Timestamp(tempTime);
                    bePayInterfaceCostInfo.setBESendTime(timestamp);
                }
                if (!timeArr[0].equals(EAS_PAY_END_TIME)) continue;
                Date receiveTime = ThreadLocalTimeUtil.parse(timeArr[1]);
                tempTime = receiveTime.getTime();
                timestamp = new Timestamp(tempTime);
                bePayInterfaceCostInfo.setBERecieveTime(timestamp);
            }
        }
    }
}

