/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ebservice.BalanceRequest;
import com.kingdee.bos.ebservice.BalanceRequestExt;
import com.kingdee.bos.ebservice.BalanceResponse;
import com.kingdee.bos.ebservice.BalanceResponseExt;
import com.kingdee.bos.ebservice.BatchBalanceRequest;
import com.kingdee.bos.ebservice.BatchQueryPayRequest;
import com.kingdee.bos.ebservice.BatchQueryPayResponse;
import com.kingdee.bos.ebservice.BusinessRequest;
import com.kingdee.bos.ebservice.BusinessResponse;
import com.kingdee.bos.ebservice.CurrentToFixedRequest;
import com.kingdee.bos.ebservice.CurrentToFixedResponse;
import com.kingdee.bos.ebservice.DelAccountsRequest;
import com.kingdee.bos.ebservice.DelAccountsRequestExt;
import com.kingdee.bos.ebservice.DelAccountsResponse;
import com.kingdee.bos.ebservice.DelAccountsResponseExt;
import com.kingdee.bos.ebservice.DetailRequest;
import com.kingdee.bos.ebservice.DetailRequestExt;
import com.kingdee.bos.ebservice.DetailResponse;
import com.kingdee.bos.ebservice.DetailResponseExt;
import com.kingdee.bos.ebservice.EBExt;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;
import com.kingdee.bos.ebservice.EBService;
import com.kingdee.bos.ebservice.EBServiceServiceLocator;
import com.kingdee.bos.ebservice.EBVersionRequest;
import com.kingdee.bos.ebservice.EBVersionResponse;
import com.kingdee.bos.ebservice.EBVersionResponseBody;
import com.kingdee.bos.ebservice.FixedToCurrentRequest;
import com.kingdee.bos.ebservice.FixedToCurrentResponse;
import com.kingdee.bos.ebservice.LinkPayRequest;
import com.kingdee.bos.ebservice.LinkPayRequestExt;
import com.kingdee.bos.ebservice.LinkPayResponse;
import com.kingdee.bos.ebservice.LinkPayResponseExt;
import com.kingdee.bos.ebservice.ListLoginsRequest;
import com.kingdee.bos.ebservice.ListLoginsResponse;
import com.kingdee.bos.ebservice.PayRequest;
import com.kingdee.bos.ebservice.PayRequestExt;
import com.kingdee.bos.ebservice.PayResponse;
import com.kingdee.bos.ebservice.PayResponseExt;
import com.kingdee.bos.ebservice.PingRequest;
import com.kingdee.bos.ebservice.PingResponse;
import com.kingdee.bos.ebservice.PingResponseBody;
import com.kingdee.bos.ebservice.PositionRequest;
import com.kingdee.bos.ebservice.PositionResponse;
import com.kingdee.bos.ebservice.QueryFixedRequest;
import com.kingdee.bos.ebservice.QueryFixedResponse;
import com.kingdee.bos.ebservice.QueryLinkPayRequest;
import com.kingdee.bos.ebservice.QueryLinkPayRequestExt;
import com.kingdee.bos.ebservice.QueryLinkPayResponse;
import com.kingdee.bos.ebservice.QueryLinkPayResponseExt;
import com.kingdee.bos.ebservice.QueryPayRequest;
import com.kingdee.bos.ebservice.QueryPayRequestExt;
import com.kingdee.bos.ebservice.QueryPayResponse;
import com.kingdee.bos.ebservice.QueryPayResponseExt;
import com.kingdee.bos.ebservice.QueryReceiptRequest;
import com.kingdee.bos.ebservice.QueryReceiptResponse;
import com.kingdee.bos.ebservice.QueryReconciliateRequest;
import com.kingdee.bos.ebservice.QueryReconciliateResponse;
import com.kingdee.bos.ebservice.ReconciliateRequest;
import com.kingdee.bos.ebservice.ReconciliateResponse;
import com.kingdee.bos.ebservice.SyncAccountsRequest;
import com.kingdee.bos.ebservice.SyncAccountsRequestExt;
import com.kingdee.bos.ebservice.SyncAccountsResponse;
import com.kingdee.bos.ebservice.SyncAccountsResponseExt;
import com.kingdee.bos.ebservice.publish.message.balanceext.BatchBalanceRequestExt;
import com.kingdee.bos.ebservice.publish.message.balanceext.BatchBalanceResponseExt;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.app.bankpay.BankPayingBillPayUtil;
import com.kingdee.eas.fm.be.app.service.EBServiceConfig;
import com.kingdee.eas.fm.be.app.service.EBWSAbstractLocator;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.ws.ca.EBExtUtils;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class EBGServiceUtil
extends EBWSAbstractLocator {
    private static final Logger logger = Logger.getLogger(BankPayingBillPayUtil.class);
    private EBServiceServiceLocator service;
    private EBService proxy;
    private Context ctx;
    private static final String resource = "com.kingdee.eas.fm.be.FmbeResource";

    public EBGServiceUtil(Context ctx) throws ServiceException {
        this.wsName = "/services/EBService";
        this.ServiceLocator = "com.kingdee.bos.ebservice.EBServiceServiceLocator";
        this.setHostAndPortAndUser(ctx);
        this.ctx = ctx;
        try {
            this.proxy = this.getProxy();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public EBGServiceUtil(Context ctx, BankBizInfo bizInfo) throws ServiceException {
        this.wsName = "/services/EBService";
        this.ServiceLocator = "com.kingdee.bos.ebservice.EBServiceServiceLocator";
        this.setHostAndPortAndUser(ctx, bizInfo);
        this.ctx = ctx;
        try {
            this.proxy = this.getProxy();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public EBGServiceUtil(Context ctx, IObjectValue beServiceAddInfo) throws ServiceException {
        this.wsName = "/services/EBService";
        this.ServiceLocator = "com.kingdee.bos.ebservice.EBServiceServiceLocator";
        this.setHostAndPortAndUser(ctx, beServiceAddInfo);
        this.ctx = ctx;
        try {
            this.proxy = this.getProxy();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public EBGServiceUtil(Context ctx, String companyId) throws ServiceException {
        this.wsName = "/services/EBService";
        this.ServiceLocator = "com.kingdee.bos.ebservice.EBServiceServiceLocator";
        this.setHostAndPortAndUser(ctx, companyId);
        this.ctx = ctx;
        try {
            this.proxy = this.getProxy();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    private boolean isUseIturs() throws BEException {
        try {
            return EBServiceConfig.getInstance().isUseItrus();
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6EAS\u670d\u52a1\u5668\u53c2\u6570\uff0c\u662f\u5426\u542f\u7528CA\u65f6\u62a5\u9519", (Throwable)e);
            throw new BEException(BEException.COMMON, new Object[]{EASResource.getString((String)resource, (String)"001_CA_PARAM_ERROR")});
        }
    }

    private EBService getProxy() throws ServiceException {
        try {
            this.service = (EBServiceServiceLocator)this.createService();
            this.service.setEndpointAddress("EBService", this.getBankServiceConfig_address());
            return this.service.getEBService();
        }
        catch (Exception e) {
            logger.error((Object)("getEBService\u65f6\u62a5\u9519\uff1a" + e));
            throw new ServiceException((Throwable)e);
        }
    }

    public BalanceResponse getBatchBalance(BatchBalanceRequest request) throws RemoteException, BEException, FMException {
        if (this.isUseIturs()) {
            BatchBalanceRequestExt rqst = this.parseBatchBalanceRequestExt(request);
            this.sginAndEncrypt(rqst);
            BatchBalanceResponseExt rsp = this.proxy.batchBalanceExt(rqst);
            this.decryptAndVerify(rsp);
            return rsp;
        }
        return this.proxy.batchBalance(request);
    }

    private BatchBalanceRequestExt parseBatchBalanceRequestExt(BatchBalanceRequest request) {
        BatchBalanceRequestExt rqst = new BatchBalanceRequestExt();
        rqst.setHeader(request.getHeader());
        rqst.getHeader().setOperationName(request.getHeader().getOperationName() + "Ext");
        rqst.setBody(request.getBody());
        rqst.setEbExt(new EBExt());
        return rqst;
    }

    public BalanceResponse getBalance(BalanceRequest request) throws RemoteException, BEException, FMException {
        if (this.isUseIturs()) {
            BalanceRequestExt rqst = this.parseBalanceRequestExt(request);
            this.sginAndEncrypt(rqst);
            BalanceResponseExt rsp = this.proxy.balanceExt(rqst);
            this.decryptAndVerify(rsp);
            return rsp;
        }
        return this.proxy.balance(request);
    }

    private BalanceRequestExt parseBalanceRequestExt(BalanceRequest request) {
        BalanceRequestExt rqst = new BalanceRequestExt();
        rqst.setHeader(request.getHeader());
        rqst.getHeader().setOperationName(request.getHeader().getOperationName() + "Ext");
        rqst.setBody(request.getBody());
        rqst.setEbExt(new EBExt());
        return rqst;
    }

    public EBVersionResponse getVersion(EBVersionRequest request) throws RemoteException, BEException, FMException {
        if (this.isUseIturs()) {
            EBVersionResponse response = this.proxy.version(request);
            EBVersionResponseBody body = response.getBody();
            if (!EmptyUtil.isEmpty((Object)body) && body.getReserved1() != null && body.getReserved1().indexOf("isCAActived=true") == -1) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{EASResource.getString((String)resource, (String)"002_CA_CONFIG_DIFFERENT")});
            }
            return response;
        }
        return this.proxy.version(request);
    }

    public PingResponse getPing(PingRequest request) throws RemoteException, BEException, FMException {
        if (this.isUseIturs()) {
            PingResponse response = this.proxy.ping(request);
            PingResponseBody body = response.getBody();
            return response;
        }
        return this.proxy.ping(request);
    }

    public DetailResponse getDetail(DetailRequest request) throws RemoteException, BEException, FMException {
        if (this.isUseIturs()) {
            DetailRequestExt rqst = this.parseDetailRequestExt(request);
            this.sginAndEncrypt(rqst);
            DetailResponseExt rsp = this.proxy.detailExt(rqst);
            this.decryptAndVerify(rsp);
            return rsp;
        }
        return this.proxy.detail(request);
    }

    private DetailRequestExt parseDetailRequestExt(DetailRequest request) {
        DetailRequestExt rqst = new DetailRequestExt();
        rqst.setHeader(request.getHeader());
        rqst.getHeader().setOperationName(request.getHeader().getOperationName() + "Ext");
        rqst.setBody(request.getBody());
        rqst.setEbExt(new EBExt());
        return rqst;
    }

    public PayResponse pay(PayRequest request) throws RemoteException, BEException, FMException {
        if (this.isUseIturs()) {
            PayRequestExt rqst = this.parsePayRequestExt(request);
            this.sginAndEncrypt(rqst);
            PayResponseExt rsp = this.proxy.payExt(rqst);
            this.decryptAndVerify(rsp);
            return rsp;
        }
        return this.proxy.pay(request);
    }

    private PayRequestExt parsePayRequestExt(PayRequest request) {
        PayRequestExt rqst = new PayRequestExt();
        rqst.setHeader(request.getHeader());
        rqst.getHeader().setOperationName(request.getHeader().getOperationName() + "Ext");
        rqst.setBody(request.getBody());
        rqst.setEbExt(new EBExt());
        return rqst;
    }

    public QueryPayResponse queryPay(QueryPayRequest request) throws RemoteException, BEException, FMException {
        if (this.isUseIturs()) {
            QueryPayRequestExt rqst = this.parseQueryPayRequestExt(request);
            this.sginAndEncrypt(rqst);
            QueryPayResponseExt rsp = this.proxy.queryPayExt(rqst);
            this.decryptAndVerify(rsp);
            return rsp;
        }
        return this.proxy.queryPay(request);
    }

    private QueryPayRequestExt parseQueryPayRequestExt(QueryPayRequest request) {
        QueryPayRequestExt rqst = new QueryPayRequestExt();
        rqst.setHeader(request.getHeader());
        rqst.getHeader().setOperationName(request.getHeader().getOperationName() + "Ext");
        rqst.setBody(request.getBody());
        rqst.setEbExt(new EBExt());
        return rqst;
    }

    public BatchQueryPayResponse queryBatchPay(BatchQueryPayRequest request) throws RemoteException {
        return this.proxy.batchQueryPay(request);
    }

    public SyncAccountsResponse syncAccounts(SyncAccountsRequest request) throws RemoteException, BEException, FMException {
        if (this.isUseIturs()) {
            SyncAccountsRequestExt rqst = this.parseSysAccountRequestExt(request);
            this.sginAndEncrypt(rqst);
            SyncAccountsResponseExt rsp = this.proxy.syncAccountsExt(rqst);
            this.decryptAndVerify(rsp);
            return rsp;
        }
        return this.proxy.syncAccounts(request);
    }

    private SyncAccountsRequestExt parseSysAccountRequestExt(SyncAccountsRequest request) {
        SyncAccountsRequestExt rqst = new SyncAccountsRequestExt();
        rqst.setHeader(request.getHeader());
        rqst.getHeader().setOperationName(request.getHeader().getOperationName() + "Ext");
        rqst.setBody(request.getBody());
        rqst.setEbExt(new EBExt());
        return rqst;
    }

    public SyncAccountsResponse autoSyncAccounts(SyncAccountsRequest request) throws RemoteException {
        return this.proxy.autoSyncAccounts(request);
    }

    public DelAccountsResponse delAccounts(DelAccountsRequest request) throws RemoteException, BEException, FMException {
        if (this.isUseIturs()) {
            DelAccountsRequestExt rqst = this.parseDelAccountsRequestExt(request);
            this.sginAndEncrypt(rqst);
            DelAccountsResponseExt rsp = this.proxy.delAccountsExt(rqst);
            this.decryptAndVerify(rsp);
            return rsp;
        }
        return this.proxy.delAccounts(request);
    }

    private DelAccountsRequestExt parseDelAccountsRequestExt(DelAccountsRequest request) {
        DelAccountsRequestExt rqst = new DelAccountsRequestExt();
        rqst.setHeader(request.getHeader());
        rqst.getHeader().setOperationName(request.getHeader().getOperationName() + "Ext");
        rqst.setBody(request.getBody());
        rqst.setEbExt(new EBExt());
        return rqst;
    }

    public ListLoginsResponse ListLogins(ListLoginsRequest request) throws RemoteException {
        return this.proxy.listLogins(request);
    }

    public QueryFixedResponse queryFixed(QueryFixedRequest request) throws RemoteException {
        return this.proxy.queryFixed(request);
    }

    public FixedToCurrentResponse fixedToCurrent(FixedToCurrentRequest request) throws RemoteException {
        return this.proxy.fixedToCurrent(request);
    }

    public CurrentToFixedResponse currentToFixed(CurrentToFixedRequest request) throws RemoteException {
        return this.proxy.currentToFixed(request);
    }

    public PositionResponse position(PositionRequest request) throws RemoteException {
        return this.proxy.position(request);
    }

    public LinkPayResponse linkPay(LinkPayRequest request) throws RemoteException, BEException, FMException {
        if (this.isUseIturs()) {
            LinkPayRequestExt rqst = this.parseLinkPayRequestExt(request);
            this.sginAndEncrypt(rqst);
            LinkPayResponseExt rsp = this.proxy.linkPayExt(rqst);
            this.decryptAndVerify(rsp);
            return rsp;
        }
        return this.proxy.linkPay(request);
    }

    private LinkPayRequestExt parseLinkPayRequestExt(LinkPayRequest request) {
        LinkPayRequestExt rqst = new LinkPayRequestExt();
        rqst.setHeader(request.getHeader());
        rqst.getHeader().setOperationName(request.getHeader().getOperationName() + "Ext");
        rqst.setBody(request.getBody());
        rqst.setEbExt(new EBExt());
        return rqst;
    }

    public QueryLinkPayResponse queryLinkPay(QueryLinkPayRequest request) throws RemoteException, BEException, FMException {
        if (this.isUseIturs()) {
            QueryLinkPayRequestExt rqst = this.parseQueryLinkPayRequestExt(request);
            this.sginAndEncrypt(rqst);
            QueryLinkPayResponseExt rsp = this.proxy.queryLinkPayExt(rqst);
            this.decryptAndVerify(rsp);
            return rsp;
        }
        return this.proxy.queryLinkPay(request);
    }

    private QueryLinkPayRequestExt parseQueryLinkPayRequestExt(QueryLinkPayRequest request) {
        QueryLinkPayRequestExt rqst = new QueryLinkPayRequestExt();
        rqst.setHeader(request.getHeader());
        rqst.getHeader().setOperationName(request.getHeader().getOperationName() + "Ext");
        rqst.setBody(request.getBody());
        rqst.setEbExt(new EBExt());
        return rqst;
    }

    public BusinessResponse business(BusinessRequest request) throws RemoteException {
        return this.proxy.business(request);
    }

    private void decryptAndVerify(EBResponse rsp) throws FMException {
        try {
            if (!EBExtUtils.decryptAndVerify((EBResponse)rsp)) {
                logger.error((Object)"CA\u89e3\u5bc6\u6216\u9a8c\u7b7e\u5931\u8d25");
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{EASResource.getString((String)resource, (String)"003_CA_DECRYPT_FAIL")});
            }
        }
        catch (Exception e) {
            logger.error((Object)"CA\u89e3\u5bc6\u6216\u9a8c\u7b7e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{MessageFormat.format(EASResource.getString((String)resource, (String)"004_CA_DECRYPT_EXCEPTION"), e.getMessage())});
        }
    }

    private void sginAndEncrypt(EBRequest rqst) throws BEException {
        try {
            EBExtUtils.signAndEncrypt((EBRequest)rqst);
        }
        catch (Exception e1) {
            logger.error((Object)"CA\u52a0\u5bc6\u6216\u8005\u7b7e\u540d\u65f6\u51fa\u9519", (Throwable)e1);
            throw new BEException(BEException.COMMON, new Object[]{EASResource.getString((String)resource, (String)"005_CA_ENCRYPT_FAIL")});
        }
    }

    public QueryReceiptResponse queryReceipt(QueryReceiptRequest request) throws RemoteException {
        return this.proxy.queryReceipt(request);
    }

    public QueryReconciliateResponse getReconciliate(QueryReconciliateRequest request) throws RemoteException {
        return this.proxy.queryReconciliate(request);
    }

    public ReconciliateResponse reconciliate(ReconciliateRequest request) throws RemoteException {
        return this.proxy.reconciliate(request);
    }
}

